/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.util.I18N;
import ice.util.SimpleMailer;
import java.text.MessageFormat;
import javax.mail.MessagingException;

public class BugEmailer {
    private static BugEmailer reference = null;
    private static final int HEADLINE_INDEX = 0;
    private static final int SUBMITTER_EMAIL_INDEX = 1;
    private static final int INSTRUMENT_OBSERVED_INDEX = 2;
    private static final int INSTRUMENT_SELECTED_INDEX = 3;
    private static final int SUMBISSION_TYPE_INDEX = 4;
    private static final int DESCRIPTION_INDEX = 5;
    private static final String MESSAGE_TO_KEY = "ice.utilBugEmailer.sentBugTo";
    private static final String MESSAGE_FROM_KEY = "ice.utilBugEmailer.bugFrom";
    private static final String MESSAGE_SUBJECT_KEY = "ice.utilBugEmailer.subject";
    private static final String MESSAGE_KEY = "ice.utilBugEmailer.message";
    String sentBugTo = null;
    String bugFrom = null;
    String subject = null;

    private BugEmailer() {
        this.init();
    }

    private void init() {
        this.sentBugTo = I18N.getString(MESSAGE_TO_KEY);
        this.bugFrom = I18N.getString(MESSAGE_FROM_KEY);
        this.subject = I18N.getString(MESSAGE_SUBJECT_KEY);
    }

    public static BugEmailer getReference() {
        if (reference == null) {
            reference = new BugEmailer();
        }
        return reference;
    }

    private String isEnhancementAsString(boolean isEnhancement) {
        int enhancementAsInt = isEnhancement ? 1 : 0;
        return Integer.toString(enhancementAsInt);
    }

    public void emailBug(String headline, String submitterEmail, boolean isEnhancement, String observedInstrument, String affectedInstrument, String description) throws MessagingException {
        String body = null;
        String[] messageArgs = new String[6];
        SimpleMailer simpleMailer = null;
        MessageFormat messageFormat = null;
        messageArgs[0] = headline;
        messageArgs[1] = submitterEmail;
        messageArgs[2] = observedInstrument;
        messageArgs[3] = affectedInstrument;
        messageArgs[4] = this.isEnhancementAsString(isEnhancement);
        messageArgs[5] = description;
        body = I18N.getString(MESSAGE_KEY);
        messageFormat = new MessageFormat(body);
        body = messageFormat.format(messageArgs);
        simpleMailer = SimpleMailer.getReference();
        simpleMailer.mail(this.sentBugTo, this.bugFrom, this.subject, body);
    }
}

