/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import ice.data.IceFile;
import ice.event.IceFileEvent;
import ice.event.IceFileListener;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class IceFileTableModel
extends AbstractTableModel
implements IceFileListener {
    private static Logger logger = Logger.getLogger("IceFileLogger.TableModelLogger");
    public static String nameColumn = "Name";
    public static String typeColumn = "Type";
    public static String commentsColumn = "Comments";
    private ArrayList<IceFile> files = new ArrayList();
    private ArrayList<String> displayedColumns = new ArrayList();
    private IceFile root;

    public IceFileTableModel(IceFile root) {
        this.displayedColumns.add(nameColumn);
        this.displayedColumns.add(typeColumn);
        this.displayedColumns.add(commentsColumn);
        this.setRoot(root);
    }

    @Override
    public int getColumnCount() {
        return this.displayedColumns.size();
    }

    @Override
    public int getRowCount() {
        return this.files.size();
    }

    @Override
    public String getColumnName(int c) {
        return this.displayedColumns.get(c);
    }

    public Class getColumnClass(int c) {
        if (this.displayedColumns.get(c).equals(nameColumn)) {
            return IceFile.class;
        }
        return this.displayedColumns.get(c).getClass();
    }

    @Override
    public int findColumn(String columnName) {
        return this.files.indexOf(columnName);
    }

    @Override
    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        try {
            IceFile file = this.files.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return file;
                }
                case 1: {
                    return file.getFileType().toString();
                }
                case 2: {
                    return this.root.getName();
                }
            }
            return "N/A";
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    private synchronized void addFile(IceFile file) {
        this.files.add(file);
    }

    public synchronized void insertFile(IceFile file, int rowIndex) {
        this.files.add(rowIndex, file);
    }

    public synchronized void setRoot(IceFile rootFile) {
        logger.debug("set root: " + rootFile.getName());
        if (this.root != null) {
            this.root.removeIceFileListener(this);
            logger.debug("root listener removed");
        }
        this.root = rootFile;
        this.files.clear();
        ArrayList<IceFile> children = rootFile.getChildren();
        for (IceFile file : children) {
            this.addFile(file);
        }
        try {
            this.root.addIceFileListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("IceFileTableModel.setRoot " + e);
        }
    }

    public synchronized void childrenAdded(IceFileEvent ife) {
        if (ife.getSource() != this.root) {
            return;
        }
        logger.debug("children added");
        int[] indices = (int[])ife.getIndices().clone();
        indices.clone();
        Arrays.sort(indices);
        IceFile parent = ife.getParent();
        int i = 0;
        while (i < indices.length) {
            IceFile child = parent.getChildAt(indices[i]);
            logger.debug("adding child: " + child.getName() + " to " + this.root.getName());
            if (indices[i] >= this.files.size()) {
                this.files.add(child);
            } else {
                this.files.add(indices[i], child);
            }
            ++i;
        }
        if (indices.length > 1) {
            int firstNum = indices[0];
            int secondNum = -1;
            int i2 = 1;
            while (i2 < indices.length) {
                if (indices[i2] == firstNum + 1) {
                    secondNum = indices[i2];
                } else {
                    if (secondNum != -1) {
                        this.fireTableRowsInserted(firstNum, secondNum);
                    } else {
                        this.fireTableRowsInserted(firstNum, firstNum);
                    }
                    firstNum = indices[i2];
                    secondNum = -1;
                }
                ++i2;
            }
            if (secondNum != -1) {
                this.fireTableRowsInserted(firstNum, secondNum);
            } else {
                this.fireTableRowsInserted(firstNum, firstNum);
            }
        } else if (indices.length > 0) {
            this.fireTableRowsInserted(indices[0], indices[0]);
        }
    }

    public synchronized void childrenRemoved(IceFileEvent ife) {
        if (ife.getSource() != this.root) {
            return;
        }
        IceFile[] childrenRemoved = ife.getRemovedChildren();
        int[] removeIndices = new int[childrenRemoved.length];
        int i = 0;
        while (i < childrenRemoved.length) {
            removeIndices[i] = this.files.indexOf(childrenRemoved[i]);
            this.files.remove(childrenRemoved[i]);
            logger.debug(String.valueOf(childrenRemoved[i].getName()) + " removed.");
            ++i;
        }
        Arrays.sort(removeIndices);
        if (removeIndices.length > 1) {
            int firstNum = removeIndices[0];
            int secondNum = -1;
            int i2 = 1;
            while (i2 < removeIndices.length) {
                if (removeIndices[i2] == firstNum + 1) {
                    secondNum = removeIndices[i2];
                } else {
                    if (secondNum != -1) {
                        this.fireTableRowsDeleted(firstNum, secondNum);
                    } else {
                        this.fireTableRowsDeleted(firstNum, firstNum);
                    }
                    firstNum = removeIndices[i2];
                    secondNum = -1;
                }
                ++i2;
            }
            if (secondNum != -1) {
                this.fireTableRowsDeleted(firstNum, secondNum);
            } else {
                this.fireTableRowsDeleted(firstNum, firstNum);
            }
        } else if (removeIndices.length > 0) {
            logger.debug("one element removed");
            this.fireTableRowsDeleted(removeIndices[0], removeIndices[0]);
        }
    }

    public void propertyChanged(IceFileEvent ife) {
    }

    @Override
    public void actionPerformed(IceFileEvent ife) {
        IceFileEvent.Type theType = ife.getType();
        switch (theType) {
            case ADDED: {
                this.childrenAdded(ife);
                break;
            }
            case REMOVED: {
                this.childrenRemoved(ife);
                break;
            }
            default: {
                logger.error("IceFileTableModel.actionPerformed(ICEFileEvent) illegal event sent should be of type ADDED or REMOVED");
            }
        }
    }

    public IceFile getRoot() {
        return this.root;
    }
}

