/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas;

import ice.Global;
import ice.IconManager;
import ice.exceptions.IcePanelException;
import ice.gui.tas.TASBaseSampleAlignmentPanel;
import ice.gui.tas.bt7.sampleAlignment.nonUbMatrix.SampleAlignmentPanel;
import ice.swing.Bag;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class SampleAlignmentWizardPanel
extends TASBaseSampleAlignmentPanel {
    private static final String STEP1_PANEL = "step1";
    private static final String STEP2_PANEL = "step2";
    private static final String STEP3_PANEL = "step3";
    private static final String STEP4_PANEL = "step4";
    private static final String STEP5_PANEL = "step5";
    private String currPanel;
    private JLabel step1NavLabel;
    private JLabel step2NavLabel;
    private JLabel step3NavLabel;
    private JLabel step4NavLabel;
    private JLabel step5NavLabel;
    private ImageIcon arrowIcon;
    private ImageIcon blankIcon;
    private JLabel step1ArrowLabel;
    private JLabel step2ArrowLabel;
    private JLabel step3ArrowLabel;
    private JLabel step4ArrowLabel;
    private JLabel step5ArrowLabel;
    private NavListener navListener;
    private JLabel stdModeLink;
    private String h2;
    private String k2;
    private String l2;
    private String h3;
    private String k3;
    private String l3;
    private String h4;
    private String k4;
    private String l4;
    private String a3Calc2;
    private String a4Calc2;
    private String a3Calc3;
    private String a4Calc3;
    private String a3Calc4;
    private String a4Calc4;
    private JButton backBtn;
    private JButton nextBtn;
    private JButton closeBtn;
    private JPanel contentPanel;
    private CardLayout cardLayout;
    private String instructions2;
    private String instructions3;
    private String instructions4;
    private JLabel instructionsLabel;
    private JPanel alignPanel;
    private String title2;
    private String title3;
    private String title4;

    @Override
    protected void init() {
        super.initBT7BaseSampleAlignmentPanel();
        this.step1NavLabel = new JLabel("Set Up Sample Parameters");
        this.step2NavLabel = new JLabel("First Reflection");
        this.step3NavLabel = new JLabel("Second Reflection");
        this.step4NavLabel = new JLabel("Third Reflection (optional)");
        this.step5NavLabel = new JLabel("Done");
        this.step1NavLabel.setOpaque(true);
        this.step2NavLabel.setOpaque(true);
        this.step3NavLabel.setOpaque(true);
        this.step4NavLabel.setOpaque(true);
        this.step5NavLabel.setOpaque(true);
        this.step1NavLabel.setBackground(Color.WHITE);
        this.step2NavLabel.setBackground(Color.WHITE);
        this.step3NavLabel.setBackground(Color.WHITE);
        this.step4NavLabel.setBackground(Color.WHITE);
        this.step5NavLabel.setBackground(Color.WHITE);
        this.arrowIcon = IconManager.getIcon("arrow.right");
        this.blankIcon = IconManager.getIcon("blank16x16");
        this.step1ArrowLabel = new JLabel(this.arrowIcon);
        this.step2ArrowLabel = new JLabel(this.blankIcon);
        this.step3ArrowLabel = new JLabel(this.blankIcon);
        this.step4ArrowLabel = new JLabel(this.blankIcon);
        this.step5ArrowLabel = new JLabel(this.blankIcon);
        this.step1ArrowLabel.setOpaque(true);
        this.step2ArrowLabel.setOpaque(true);
        this.step3ArrowLabel.setOpaque(true);
        this.step4ArrowLabel.setOpaque(true);
        this.step5ArrowLabel.setOpaque(true);
        this.step1ArrowLabel.setBackground(Color.WHITE);
        this.step2ArrowLabel.setBackground(Color.WHITE);
        this.step3ArrowLabel.setBackground(Color.WHITE);
        this.step4ArrowLabel.setBackground(Color.WHITE);
        this.step5ArrowLabel.setBackground(Color.WHITE);
        this.navListener = new NavListener();
        this.stdModeLink = new JLabel(" Return to Standard Mode ");
        this.stdModeLink.setForeground(Color.BLUE);
        this.stdModeLink.setCursor(new Cursor(12));
        this.a3Calc2 = new String("");
        this.a3Calc3 = new String("");
        this.a3Calc4 = new String("");
        this.a4Calc2 = new String("");
        this.a4Calc3 = new String("");
        this.a4Calc4 = new String("");
        this.backBtn = new JButton(new BackAction());
        this.nextBtn = new JButton(new NextAction());
        this.closeBtn = new JButton(new CloseAction());
        this.contentPanel = new JPanel(new CardLayout());
        this.cardLayout = (CardLayout)this.contentPanel.getLayout();
        this.instructions2 = "<html>Input the indices corresponding to a lattice reflection for the sample.<br>  Click on \u201cDrive A4\u201d to drive to that position.  Optimize the position of the <br> angular positions (such as " + new Character('\u04e8') + " or 2" + new Character('\u04e8') + ") by running a Peak Scan for the <br>corresponding motor " + "devices.</html>";
        this.instructions3 = "<html>Input the indices and click on \u201cDrive A4\u201d to drive to that position. Optimize <br>the position of the angular positions (such as " + new Character('\u04e8') + " or 2" + new Character('\u04e8') + ") by running a <br>Peak Scan for the corresponding motor " + "devices.</html>";
        this.instructions4 = "<html>Input the indices corresponding to any reflection for the sample.<br>  Click on \u201cDrive A4\u201d to drive to that position.  Optimize the position of the <br>angular positions (such as " + new Character('\u04e8') + " or 2" + new Character('\u04e8') + ") " + "by running a Peak <br>Scan for the corresponding motor devices. ";
        this.instructionsLabel = new JLabel(this.instructions2);
        this.title2 = "Step Two: Align Sample at First Reflection";
        this.title3 = "Step Three: Align Sample at Second Reflection";
        this.title4 = "Step Four: Align Sample at an Additional Reflection";
    }

    public void setModeSwitcher(SampleAlignmentPanel.ModeSwitcher ms) {
        this.stdModeLink.addMouseListener(ms);
    }

    @Override
    protected void buildGUI() {
        super.buildBT7BaseSampleAlignmentPanel();
        this.setLayout(new GridBagLayout());
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        int maxCols = 2;
        int maxRows = 2;
        this.buildContentPanel();
        this.add((Component)this.createNavigationPanel(), constraints.cell(x, y).filly());
        this.add((Component)this.createStdLinkPanel(), constraints.cell(x, ++y));
        this.add((Component)this.contentPanel, constraints.cell(++x, --y));
        this.add((Component)this.createBtnPanel(), constraints.cell(x, ++y));
        this.initState();
    }

    private void initState() {
        this.step1NavLabel.setBackground(Global.HIGHLIGHT);
        this.step1NavLabel.setForeground(Color.WHITE);
        this.step1ArrowLabel.setBackground(Global.HIGHLIGHT);
        this.addNavListener(this.step1ArrowLabel, this.step1NavLabel);
        this.backBtn.setEnabled(false);
    }

    private void buildContentPanel() {
        JPanel step1Panel = this.createSetupPanel();
        this.alignPanel = this.createAlignPanel(this.instructionsLabel, this.title2);
        this.contentPanel.add((Component)step1Panel, STEP1_PANEL);
        this.contentPanel.add((Component)this.alignPanel, STEP2_PANEL);
        this.contentPanel.add((Component)this.createFinishedPanel(), STEP5_PANEL);
        this.currPanel = STEP1_PANEL;
    }

    private JPanel createNavigationPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.WHITE);
        panel.setBorder(BorderFactory.createBevelBorder(1));
        Bag col1 = new Bag();
        Bag col2 = new Bag();
        col1.inset(0, 0, 0, 0);
        col2.inset(0, 0, 0, 0);
        col1.ipadx = 5;
        col2.ipadx = 5;
        col1.ipady = 5;
        col2.ipady = 5;
        int x = 0;
        int y = 0;
        int maxCols = 2;
        int maxRows = 6;
        panel.add((Component)this.step1ArrowLabel, col1.cell(x, y));
        panel.add((Component)this.step2ArrowLabel, col1.cell(x, ++y));
        panel.add((Component)this.step3ArrowLabel, col1.cell(x, ++y));
        panel.add((Component)this.step4ArrowLabel, col1.cell(x, ++y));
        panel.add((Component)this.step5ArrowLabel, col1.cell(x, ++y));
        panel.add((Component)this.step1NavLabel, col2.cell(++x, y -= 4).fillboth(1.0, 0.0));
        panel.add((Component)this.step2NavLabel, col2.cell(x, ++y).fillboth(1.0, 0.0));
        panel.add((Component)this.step3NavLabel, col2.cell(x, ++y).fillboth(1.0, 0.0));
        panel.add((Component)this.step4NavLabel, col2.cell(x, ++y).fillboth(1.0, 0.0));
        panel.add((Component)this.step5NavLabel, col2.cell(x, ++y).fillboth(1.0, 0.0));
        x = maxCols - 1;
        y = maxRows - 1;
        panel.add((Component)new JLabel(""), col1.cell(x, y).filly());
        return panel;
    }

    private JPanel createStdLinkPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        int maxCols = 3;
        boolean maxRows = true;
        panel.add((Component)new JLabel(""), constraints.cell(x, y).fillx());
        panel.add((Component)this.stdModeLink, constraints.cell(++x, y));
        panel.add((Component)new JLabel(""), constraints.cell(++x, y).fillx());
        return panel;
    }

    private JPanel createBtnPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        int maxCols = 5;
        boolean maxRows = true;
        panel.add((Component)new JLabel(""), constraints.cell(x, y).fillx());
        panel.add((Component)this.backBtn, constraints.cell(++x, y));
        panel.add((Component)this.nextBtn, constraints.cell(++x, y));
        panel.add((Component)this.closeBtn, constraints.cell(++x, y));
        return panel;
    }

    private JPanel createFinishedPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("Done"));
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        boolean maxCols = true;
        int maxRows = 2;
        panel.add((Component)new JLabel("<html>You have completed the sample alignment process.  If you're happy with <br>your results, close this window.  Otherwise, go back to a previous step.</html>"), constraints.cell(x, y));
        panel.add((Component)new JLabel(""), constraints.cell(x, ++y).filly());
        return panel;
    }

    protected JPanel createAlignPanel(JLabel instructionsLabel, String title) {
        JLabel hLabel = new JLabel("h:");
        JLabel kLabel = new JLabel("k:");
        JLabel lLabel = new JLabel("l:");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(title));
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        int maxCols = 11;
        int maxRows = 11;
        Insets insets = constraints.insets;
        Insets labelInsets = new Insets(insets.top, insets.left, insets.bottom, 0);
        Insets fieldInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right * 2);
        panel.add((Component)instructionsLabel, constraints.cell(x, y).colspan(maxCols));
        panel.add((Component)new JLabel("   "), constraints.cell(x, ++y));
        panel.add((Component)hLabel, constraints.cell(++x, y).inset(labelInsets));
        panel.add((Component)this.targetHField, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)kLabel, constraints.cell(++x, y).inset(labelInsets));
        panel.add((Component)this.targetKField, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)lLabel, constraints.cell(++x, y).inset(labelInsets));
        panel.add((Component)this.targetLField, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)new JLabel(""), constraints.cell(++x, y).fillx(1.0));
        panel.add((Component)this.driveA4Btn, constraints.cell(++x, y).inset(fieldInsets));
        panel.add((Component)new JLabel(""), constraints.cell(++x, y).fillx(0.5));
        x = 0;
        panel.add((Component)this.createCalcPanelRow(), constraints.cell(x, ++y).colspan(maxCols));
        panel.add((Component)this.createLinkPanel(), constraints.cell(x, ++y).colspan(maxCols));
        y = maxRows - 1;
        panel.add((Component)new JLabel(""), constraints.cell(x, y).filly());
        return panel;
    }

    private void resetNav(JLabel currArrowLabel, JLabel currNavLabel, JLabel pastArrowLabel, JLabel pastNavLabel) {
        pastArrowLabel.setBackground(Color.WHITE);
        pastArrowLabel.setIcon(this.blankIcon);
        pastNavLabel.setBackground(Color.WHITE);
        pastNavLabel.setForeground(Color.BLACK);
        currArrowLabel.setBackground(Global.HIGHLIGHT);
        currArrowLabel.setIcon(this.arrowIcon);
        currNavLabel.setBackground(Global.HIGHLIGHT);
        currNavLabel.setForeground(Color.WHITE);
    }

    private void addNavListener(JLabel arrowLabel, JLabel navLabel) {
        arrowLabel.setCursor(new Cursor(12));
        navLabel.setCursor(new Cursor(12));
        arrowLabel.addMouseListener(this.navListener);
        navLabel.addMouseListener(this.navListener);
    }

    private void resetFields(String h, String k, String l, String a3, String a4) {
        logger.debug("a3: " + a3);
        logger.debug("a4: " + a4);
        if (a3.equals("")) {
            a3 = "N/A";
        }
        if (a4.equals("")) {
            a4 = "N/A";
        }
        this.calculatedA3Label.setText(a3);
        this.calculatedA4Label.setText(a4);
        this.removeTargetListeners();
        this.targetHField.setText(h);
        this.targetKField.setText(k);
        this.targetLField.setText(l);
        this.addTargetListeners();
    }

    private void removeTargetListeners() {
        this.targetHField.getDocument().removeDocumentListener(this.ac);
        this.targetKField.getDocument().removeDocumentListener(this.ac);
        this.targetLField.getDocument().removeDocumentListener(this.ac);
    }

    private void addTargetListeners() {
        this.targetHField.getDocument().addDocumentListener(this.ac);
        this.targetKField.getDocument().addDocumentListener(this.ac);
        this.targetLField.getDocument().addDocumentListener(this.ac);
    }

    private class BackAction
    extends AbstractAction {
        public BackAction() {
            this.putValue("Name", "< Back");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (SampleAlignmentWizardPanel.this.currPanel.equals(SampleAlignmentWizardPanel.STEP2_PANEL)) {
                SampleAlignmentWizardPanel.this.cardLayout.previous(SampleAlignmentWizardPanel.this.contentPanel);
                SampleAlignmentWizardPanel.this.currPanel = SampleAlignmentWizardPanel.STEP1_PANEL;
                SampleAlignmentWizardPanel.this.backBtn.setEnabled(false);
                SampleAlignmentWizardPanel.this.resetNav(SampleAlignmentWizardPanel.this.step1ArrowLabel, SampleAlignmentWizardPanel.this.step1NavLabel, SampleAlignmentWizardPanel.this.step2ArrowLabel, SampleAlignmentWizardPanel.this.step2NavLabel);
            } else if (SampleAlignmentWizardPanel.this.currPanel.equals(SampleAlignmentWizardPanel.STEP3_PANEL)) {
                SampleAlignmentWizardPanel.this.instructionsLabel.setText(SampleAlignmentWizardPanel.this.instructions2);
                SampleAlignmentWizardPanel.this.alignPanel.setBorder(new TitledBorder(SampleAlignmentWizardPanel.this.title2));
                SampleAlignmentWizardPanel.this.currPanel = SampleAlignmentWizardPanel.STEP2_PANEL;
                SampleAlignmentWizardPanel.this.driveA4Btn.setAction(SampleAlignmentWizardPanel.this.driveA4Action);
                SampleAlignmentWizardPanel.this.h3 = SampleAlignmentWizardPanel.this.targetHField.getText();
                SampleAlignmentWizardPanel.this.k3 = SampleAlignmentWizardPanel.this.targetKField.getText();
                SampleAlignmentWizardPanel.this.l3 = SampleAlignmentWizardPanel.this.targetLField.getText();
                SampleAlignmentWizardPanel.this.a3Calc3 = SampleAlignmentWizardPanel.this.calculatedA3Label.getText();
                SampleAlignmentWizardPanel.this.a4Calc3 = SampleAlignmentWizardPanel.this.calculatedA4Label.getText();
                SampleAlignmentWizardPanel.this.resetFields(SampleAlignmentWizardPanel.this.h2, SampleAlignmentWizardPanel.this.k2, SampleAlignmentWizardPanel.this.l2, SampleAlignmentWizardPanel.this.a3Calc2, SampleAlignmentWizardPanel.this.a4Calc2);
                SampleAlignmentWizardPanel.this.resetNav(SampleAlignmentWizardPanel.this.step2ArrowLabel, SampleAlignmentWizardPanel.this.step2NavLabel, SampleAlignmentWizardPanel.this.step3ArrowLabel, SampleAlignmentWizardPanel.this.step3NavLabel);
            } else if (SampleAlignmentWizardPanel.this.currPanel.equals(SampleAlignmentWizardPanel.STEP4_PANEL)) {
                SampleAlignmentWizardPanel.this.instructionsLabel.setText(SampleAlignmentWizardPanel.this.instructions3);
                SampleAlignmentWizardPanel.this.alignPanel.setBorder(new TitledBorder(SampleAlignmentWizardPanel.this.title3));
                SampleAlignmentWizardPanel.this.currPanel = SampleAlignmentWizardPanel.STEP3_PANEL;
                SampleAlignmentWizardPanel.this.h4 = SampleAlignmentWizardPanel.this.targetHField.getText();
                SampleAlignmentWizardPanel.this.k4 = SampleAlignmentWizardPanel.this.targetKField.getText();
                SampleAlignmentWizardPanel.this.l4 = SampleAlignmentWizardPanel.this.targetLField.getText();
                SampleAlignmentWizardPanel.this.a3Calc4 = SampleAlignmentWizardPanel.this.calculatedA3Label.getText();
                SampleAlignmentWizardPanel.this.a4Calc4 = SampleAlignmentWizardPanel.this.calculatedA4Label.getText();
                SampleAlignmentWizardPanel.this.resetFields(SampleAlignmentWizardPanel.this.h3, SampleAlignmentWizardPanel.this.k3, SampleAlignmentWizardPanel.this.l3, SampleAlignmentWizardPanel.this.a3Calc3, SampleAlignmentWizardPanel.this.a4Calc3);
                SampleAlignmentWizardPanel.this.resetNav(SampleAlignmentWizardPanel.this.step3ArrowLabel, SampleAlignmentWizardPanel.this.step3NavLabel, SampleAlignmentWizardPanel.this.step4ArrowLabel, SampleAlignmentWizardPanel.this.step4NavLabel);
            } else if (SampleAlignmentWizardPanel.this.currPanel.equals(SampleAlignmentWizardPanel.STEP5_PANEL)) {
                SampleAlignmentWizardPanel.this.cardLayout.previous(SampleAlignmentWizardPanel.this.contentPanel);
                SampleAlignmentWizardPanel.this.currPanel = SampleAlignmentWizardPanel.STEP4_PANEL;
                SampleAlignmentWizardPanel.this.nextBtn.setEnabled(true);
                SampleAlignmentWizardPanel.this.resetNav(SampleAlignmentWizardPanel.this.step4ArrowLabel, SampleAlignmentWizardPanel.this.step4NavLabel, SampleAlignmentWizardPanel.this.step5ArrowLabel, SampleAlignmentWizardPanel.this.step5NavLabel);
                SampleAlignmentWizardPanel.this.addNavListener(SampleAlignmentWizardPanel.this.step5ArrowLabel, SampleAlignmentWizardPanel.this.step5NavLabel);
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            this.putValue("Name", "Close");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            System.out.println("need to close this panel");
        }
    }

    private class NavListener
    extends MouseAdapter {
        private NavListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            logger.debug("mouse clicked");
            try {
                JLabel pastArrowLabel = null;
                JLabel pastNavLabel = null;
                JLabel label = (JLabel)me.getSource();
                if (SampleAlignmentWizardPanel.this.currPanel.equals(SampleAlignmentWizardPanel.STEP1_PANEL)) {
                    pastArrowLabel = SampleAlignmentWizardPanel.this.step1ArrowLabel;
                    pastNavLabel = SampleAlignmentWizardPanel.this.step1NavLabel;
                } else if (SampleAlignmentWizardPanel.this.currPanel.equals(SampleAlignmentWizardPanel.STEP2_PANEL)) {
                    pastArrowLabel = SampleAlignmentWizardPanel.this.step2ArrowLabel;
                    pastNavLabel = SampleAlignmentWizardPanel.this.step2NavLabel;
                    SampleAlignmentWizardPanel.this.h2 = SampleAlignmentWizardPanel.this.targetHField.getText();
                    SampleAlignmentWizardPanel.this.k2 = SampleAlignmentWizardPanel.this.targetKField.getText();
                    SampleAlignmentWizardPanel.this.l2 = SampleAlignmentWizardPanel.this.targetLField.getText();
                    SampleAlignmentWizardPanel.this.a3Calc2 = SampleAlignmentWizardPanel.this.calculatedA3Label.getText();
                    SampleAlignmentWizardPanel.this.a4Calc2 = SampleAlignmentWizardPanel.this.calculatedA4Label.getText();
                } else if (SampleAlignmentWizardPanel.this.currPanel.equals(SampleAlignmentWizardPanel.STEP3_PANEL)) {
                    pastArrowLabel = SampleAlignmentWizardPanel.this.step3ArrowLabel;
                    pastNavLabel = SampleAlignmentWizardPanel.this.step3NavLabel;
                    SampleAlignmentWizardPanel.this.h3 = SampleAlignmentWizardPanel.this.targetHField.getText();
                    SampleAlignmentWizardPanel.this.k3 = SampleAlignmentWizardPanel.this.targetKField.getText();
                    SampleAlignmentWizardPanel.this.l3 = SampleAlignmentWizardPanel.this.targetLField.getText();
                    SampleAlignmentWizardPanel.this.a3Calc3 = SampleAlignmentWizardPanel.this.calculatedA3Label.getText();
                    SampleAlignmentWizardPanel.this.a4Calc3 = SampleAlignmentWizardPanel.this.calculatedA4Label.getText();
                } else if (SampleAlignmentWizardPanel.this.currPanel.equals(SampleAlignmentWizardPanel.STEP4_PANEL)) {
                    pastArrowLabel = SampleAlignmentWizardPanel.this.step4ArrowLabel;
                    pastNavLabel = SampleAlignmentWizardPanel.this.step4NavLabel;
                    SampleAlignmentWizardPanel.this.h4 = SampleAlignmentWizardPanel.this.targetHField.getText();
                    SampleAlignmentWizardPanel.this.k4 = SampleAlignmentWizardPanel.this.targetKField.getText();
                    SampleAlignmentWizardPanel.this.l4 = SampleAlignmentWizardPanel.this.targetLField.getText();
                    SampleAlignmentWizardPanel.this.a3Calc4 = SampleAlignmentWizardPanel.this.calculatedA3Label.getText();
                    SampleAlignmentWizardPanel.this.a4Calc4 = SampleAlignmentWizardPanel.this.calculatedA4Label.getText();
                } else if (SampleAlignmentWizardPanel.this.currPanel.equals(SampleAlignmentWizardPanel.STEP5_PANEL)) {
                    pastArrowLabel = SampleAlignmentWizardPanel.this.step5ArrowLabel;
                    pastNavLabel = SampleAlignmentWizardPanel.this.step5NavLabel;
                }
                if (label == SampleAlignmentWizardPanel.this.step1ArrowLabel || label == SampleAlignmentWizardPanel.this.step1NavLabel) {
                    SampleAlignmentWizardPanel.this.currPanel = SampleAlignmentWizardPanel.STEP1_PANEL;
                    SampleAlignmentWizardPanel.this.cardLayout.show(SampleAlignmentWizardPanel.this.contentPanel, SampleAlignmentWizardPanel.STEP1_PANEL);
                    SampleAlignmentWizardPanel.this.resetNav(SampleAlignmentWizardPanel.this.step1ArrowLabel, SampleAlignmentWizardPanel.this.step1NavLabel, pastArrowLabel, pastNavLabel);
                    SampleAlignmentWizardPanel.this.backBtn.setEnabled(false);
                    SampleAlignmentWizardPanel.this.nextBtn.setEnabled(true);
                } else if (label == SampleAlignmentWizardPanel.this.step2ArrowLabel || label == SampleAlignmentWizardPanel.this.step2NavLabel) {
                    SampleAlignmentWizardPanel.this.currPanel = SampleAlignmentWizardPanel.STEP2_PANEL;
                    SampleAlignmentWizardPanel.this.alignPanel.setBorder(new TitledBorder(SampleAlignmentWizardPanel.this.title2));
                    SampleAlignmentWizardPanel.this.resetFields(SampleAlignmentWizardPanel.this.h2, SampleAlignmentWizardPanel.this.k2, SampleAlignmentWizardPanel.this.l2, SampleAlignmentWizardPanel.this.a3Calc2, SampleAlignmentWizardPanel.this.a4Calc2);
                    SampleAlignmentWizardPanel.this.cardLayout.show(SampleAlignmentWizardPanel.this.contentPanel, SampleAlignmentWizardPanel.STEP2_PANEL);
                    SampleAlignmentWizardPanel.this.resetNav(SampleAlignmentWizardPanel.this.step2ArrowLabel, SampleAlignmentWizardPanel.this.step2NavLabel, pastArrowLabel, pastNavLabel);
                    SampleAlignmentWizardPanel.this.backBtn.setEnabled(true);
                    SampleAlignmentWizardPanel.this.nextBtn.setEnabled(true);
                } else if (label == SampleAlignmentWizardPanel.this.step3ArrowLabel || label == SampleAlignmentWizardPanel.this.step3NavLabel) {
                    SampleAlignmentWizardPanel.this.currPanel = SampleAlignmentWizardPanel.STEP3_PANEL;
                    SampleAlignmentWizardPanel.this.alignPanel.setBorder(new TitledBorder(SampleAlignmentWizardPanel.this.title3));
                    SampleAlignmentWizardPanel.this.resetFields(SampleAlignmentWizardPanel.this.h3, SampleAlignmentWizardPanel.this.k3, SampleAlignmentWizardPanel.this.l3, SampleAlignmentWizardPanel.this.a3Calc3, SampleAlignmentWizardPanel.this.a4Calc3);
                    SampleAlignmentWizardPanel.this.cardLayout.show(SampleAlignmentWizardPanel.this.contentPanel, SampleAlignmentWizardPanel.STEP2_PANEL);
                    SampleAlignmentWizardPanel.this.resetNav(SampleAlignmentWizardPanel.this.step3ArrowLabel, SampleAlignmentWizardPanel.this.step3NavLabel, pastArrowLabel, pastNavLabel);
                    SampleAlignmentWizardPanel.this.backBtn.setEnabled(true);
                    SampleAlignmentWizardPanel.this.nextBtn.setEnabled(true);
                } else if (label == SampleAlignmentWizardPanel.this.step4ArrowLabel || label == SampleAlignmentWizardPanel.this.step4NavLabel) {
                    SampleAlignmentWizardPanel.this.currPanel = SampleAlignmentWizardPanel.STEP4_PANEL;
                    SampleAlignmentWizardPanel.this.alignPanel.setBorder(new TitledBorder(SampleAlignmentWizardPanel.this.title4));
                    SampleAlignmentWizardPanel.this.resetFields(SampleAlignmentWizardPanel.this.h4, SampleAlignmentWizardPanel.this.k4, SampleAlignmentWizardPanel.this.l4, SampleAlignmentWizardPanel.this.a3Calc4, SampleAlignmentWizardPanel.this.a4Calc4);
                    SampleAlignmentWizardPanel.this.cardLayout.show(SampleAlignmentWizardPanel.this.contentPanel, SampleAlignmentWizardPanel.STEP2_PANEL);
                    SampleAlignmentWizardPanel.this.resetNav(SampleAlignmentWizardPanel.this.step4ArrowLabel, SampleAlignmentWizardPanel.this.step4NavLabel, pastArrowLabel, pastNavLabel);
                    SampleAlignmentWizardPanel.this.backBtn.setEnabled(true);
                    SampleAlignmentWizardPanel.this.nextBtn.setEnabled(true);
                } else if (label == SampleAlignmentWizardPanel.this.step5ArrowLabel || label == SampleAlignmentWizardPanel.this.step5NavLabel) {
                    SampleAlignmentWizardPanel.this.currPanel = SampleAlignmentWizardPanel.STEP5_PANEL;
                    SampleAlignmentWizardPanel.this.cardLayout.show(SampleAlignmentWizardPanel.this.contentPanel, SampleAlignmentWizardPanel.STEP5_PANEL);
                    SampleAlignmentWizardPanel.this.resetNav(SampleAlignmentWizardPanel.this.step5ArrowLabel, SampleAlignmentWizardPanel.this.step5NavLabel, pastArrowLabel, pastNavLabel);
                    SampleAlignmentWizardPanel.this.backBtn.setEnabled(true);
                    SampleAlignmentWizardPanel.this.nextBtn.setEnabled(false);
                }
            }
            catch (ClassCastException cce) {
                logger.error("Invalid source for mouse event.  Ignoring event.", cce);
            }
        }
    }

    private class NextAction
    extends AbstractAction {
        public NextAction() {
            this.putValue("Name", "Next >");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (SampleAlignmentWizardPanel.this.currPanel.equals(SampleAlignmentWizardPanel.STEP1_PANEL)) {
                SampleAlignmentWizardPanel.this.cardLayout.next(SampleAlignmentWizardPanel.this.contentPanel);
                SampleAlignmentWizardPanel.this.currPanel = SampleAlignmentWizardPanel.STEP2_PANEL;
                SampleAlignmentWizardPanel.this.backBtn.setEnabled(true);
                SampleAlignmentWizardPanel.this.resetNav(SampleAlignmentWizardPanel.this.step2ArrowLabel, SampleAlignmentWizardPanel.this.step2NavLabel, SampleAlignmentWizardPanel.this.step1ArrowLabel, SampleAlignmentWizardPanel.this.step1NavLabel);
                SampleAlignmentWizardPanel.this.addNavListener(SampleAlignmentWizardPanel.this.step2ArrowLabel, SampleAlignmentWizardPanel.this.step2NavLabel);
            } else if (SampleAlignmentWizardPanel.this.currPanel.equals(SampleAlignmentWizardPanel.STEP2_PANEL)) {
                SampleAlignmentWizardPanel.this.instructionsLabel.setText(SampleAlignmentWizardPanel.this.instructions3);
                SampleAlignmentWizardPanel.this.alignPanel.setBorder(new TitledBorder(SampleAlignmentWizardPanel.this.title3));
                SampleAlignmentWizardPanel.this.currPanel = SampleAlignmentWizardPanel.STEP3_PANEL;
                SampleAlignmentWizardPanel.this.driveA4Btn.setAction(SampleAlignmentWizardPanel.this.driveQAction);
                SampleAlignmentWizardPanel.this.h2 = SampleAlignmentWizardPanel.this.targetHField.getText();
                SampleAlignmentWizardPanel.this.k2 = SampleAlignmentWizardPanel.this.targetKField.getText();
                SampleAlignmentWizardPanel.this.l2 = SampleAlignmentWizardPanel.this.targetLField.getText();
                SampleAlignmentWizardPanel.this.a3Calc2 = SampleAlignmentWizardPanel.this.calculatedA3Label.getText();
                SampleAlignmentWizardPanel.this.a4Calc2 = SampleAlignmentWizardPanel.this.calculatedA4Label.getText();
                SampleAlignmentWizardPanel.this.resetFields(SampleAlignmentWizardPanel.this.h3, SampleAlignmentWizardPanel.this.k3, SampleAlignmentWizardPanel.this.l3, SampleAlignmentWizardPanel.this.a3Calc3, SampleAlignmentWizardPanel.this.a4Calc3);
                SampleAlignmentWizardPanel.this.resetNav(SampleAlignmentWizardPanel.this.step3ArrowLabel, SampleAlignmentWizardPanel.this.step3NavLabel, SampleAlignmentWizardPanel.this.step2ArrowLabel, SampleAlignmentWizardPanel.this.step2NavLabel);
                SampleAlignmentWizardPanel.this.addNavListener(SampleAlignmentWizardPanel.this.step3ArrowLabel, SampleAlignmentWizardPanel.this.step3NavLabel);
            } else if (SampleAlignmentWizardPanel.this.currPanel.equals(SampleAlignmentWizardPanel.STEP3_PANEL)) {
                SampleAlignmentWizardPanel.this.instructionsLabel.setText(SampleAlignmentWizardPanel.this.instructions4);
                SampleAlignmentWizardPanel.this.alignPanel.setBorder(new TitledBorder(SampleAlignmentWizardPanel.this.title4));
                SampleAlignmentWizardPanel.this.currPanel = SampleAlignmentWizardPanel.STEP4_PANEL;
                SampleAlignmentWizardPanel.this.h3 = SampleAlignmentWizardPanel.this.targetHField.getText();
                SampleAlignmentWizardPanel.this.k3 = SampleAlignmentWizardPanel.this.targetKField.getText();
                SampleAlignmentWizardPanel.this.l3 = SampleAlignmentWizardPanel.this.targetLField.getText();
                SampleAlignmentWizardPanel.this.a3Calc3 = SampleAlignmentWizardPanel.this.calculatedA3Label.getText();
                SampleAlignmentWizardPanel.this.a4Calc3 = SampleAlignmentWizardPanel.this.calculatedA4Label.getText();
                SampleAlignmentWizardPanel.this.resetFields(SampleAlignmentWizardPanel.this.h4, SampleAlignmentWizardPanel.this.k4, SampleAlignmentWizardPanel.this.l4, SampleAlignmentWizardPanel.this.a3Calc4, SampleAlignmentWizardPanel.this.a4Calc4);
                SampleAlignmentWizardPanel.this.resetNav(SampleAlignmentWizardPanel.this.step4ArrowLabel, SampleAlignmentWizardPanel.this.step4NavLabel, SampleAlignmentWizardPanel.this.step3ArrowLabel, SampleAlignmentWizardPanel.this.step3NavLabel);
                SampleAlignmentWizardPanel.this.addNavListener(SampleAlignmentWizardPanel.this.step4ArrowLabel, SampleAlignmentWizardPanel.this.step4NavLabel);
            } else if (SampleAlignmentWizardPanel.this.currPanel.equals(SampleAlignmentWizardPanel.STEP4_PANEL)) {
                SampleAlignmentWizardPanel.this.cardLayout.next(SampleAlignmentWizardPanel.this.contentPanel);
                SampleAlignmentWizardPanel.this.currPanel = SampleAlignmentWizardPanel.STEP5_PANEL;
                SampleAlignmentWizardPanel.this.nextBtn.setEnabled(false);
                SampleAlignmentWizardPanel.this.resetNav(SampleAlignmentWizardPanel.this.step5ArrowLabel, SampleAlignmentWizardPanel.this.step5NavLabel, SampleAlignmentWizardPanel.this.step4ArrowLabel, SampleAlignmentWizardPanel.this.step4NavLabel);
                SampleAlignmentWizardPanel.this.addNavListener(SampleAlignmentWizardPanel.this.step5ArrowLabel, SampleAlignmentWizardPanel.this.step5NavLabel);
            }
        }
    }
}

