/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels.autodata;

import ice.Controller;
import ice.data.BaseScan;
import ice.data.InstalledDevice;
import ice.data.Sample;
import ice.data.ScanList;
import ice.gui.panel.sans.data.SansScan;
import ice.gui.panel.sans.data.SansScanComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class SansTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -444400496501558568L;
    private static Logger logger = Logger.getLogger("ErrorLogger.SansTableModel");
    private ArrayList<String> columnNames;
    private Vector<Object[]> scanData;
    private ArrayList<SansScan> scanList;
    private ArrayList<String> controls;
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final String DEFAULT_FONT_NAME = "Serif";

    public SansTableModel() {
        this.init();
    }

    private void init() {
        this.columnNames = new ArrayList();
        this.columnNames.add(0, "Stp");
        this.columnNames.add(1, "No ");
        this.columnNames.add(2, "Sample Label        ");
        this.columnNames.add(3, "FPrfx");
        this.columnNames.add(4, "CtTime");
        this.columnNames.add(5, "Int");
        this.columnNames.add(6, "SamplPos");
        this.columnNames.add(7, "HbrPos");
        this.columnNames.add(8, "DetDist");
        this.columnNames.add(9, "DetOff");
        this.columnNames.add(10, "TmpSetPt");
        this.columnNames.add(11, "MagField");
        this.columnNames.add(12, "RhPulses");
        this.columnNames.add(13, "SamplRot");
        this.columnNames.add(14, "HbrRot");
        this.columnNames.add(15, "WvLgth");
        this.columnNames.add(16, "WvLgthSprd");
        this.columnNames.add(17, "Gds");
        this.columnNames.add(18, "Atten");
        this.columnNames.add(19, "SrcAper");
        this.columnNames.add(20, "SampAper");
        this.columnNames.add(21, "BmStp");
        this.columnNames.add(22, "BmStpX");
        this.columnNames.add(23, "BmStpY");
        this.columnNames.add(24, "BmCntrX");
        this.columnNames.add(25, "BmCntrY");
        this.columnNames.add(26, "SamplThck");
        this.columnNames.add(27, "Trans");
        this.columnNames.add(28, "Status");
        this.controls = new ArrayList();
        this.controls.add(0, "");
        this.controls.add(1, "");
        this.controls.add(2, "");
        this.controls.add(3, "");
        this.controls.add(4, "");
        this.controls.add(5, "");
        this.controls.add(6, "SamplePosition");
        this.controls.add(7, "HuberTranslation");
        this.controls.add(8, "DetectorPos");
        this.controls.add(9, "DetectorOffset");
        this.controls.add(10, "Temp");
        this.controls.add(11, "MagField");
        this.controls.add(12, "RheoPulses");
        this.controls.add(13, "SampleRotation");
        this.controls.add(14, "HuberRotation");
        this.controls.add(15, "Wavelength");
        this.controls.add(16, "WavelengthSpread");
        this.controls.add(17, "GuideTable");
        this.controls.add(18, "Attenuator");
        this.controls.add(19, "APERT");
        this.controls.add(20, "apert");
        this.controls.add(21, "BeamStop");
        this.controls.add(22, "BeamStopX");
        this.controls.add(23, "BeamStopY");
        this.controls.add(24, "BeamCenterX");
        this.controls.add(25, "BeamCenterY");
        this.controls.add(26, "Thk");
        this.controls.add(27, "Trans");
        this.controls.add(28, "status");
        this.scanData = new Vector();
        this.scanList = new ArrayList();
        Controller controller = Controller.getReference();
        ScanList scanListController = controller.getServerScanList();
        ArrayList<BaseScan> scans = scanListController.getScanList();
        this.updateNewScanData(scans);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public int getRowCount() {
        return this.scanData.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames.get(col);
    }

    public Object[] getColumnNames() {
        return this.columnNames.toArray();
    }

    public ArrayList<String> getHeaderNames() {
        return this.columnNames;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object[] scanRow = null;
        Object value = null;
        try {
            scanRow = this.scanData.get(row);
            value = scanRow[col];
        }
        catch (Exception e) {
            logger.error("error updating table", e);
        }
        return value;
    }

    public Class getColumnClass(int index) {
        Object value = this.getValueAt(0, index);
        if (value != null) {
            return value.getClass();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col < 1;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int colIndex) {
        Object[] row = this.scanData.get(rowIndex);
        row[colIndex] = value;
        this.fireTableCellUpdated(rowIndex, colIndex);
    }

    public SansScan getSansScan(int row) {
        SansScan scan = null;
        if (row != -1) {
            scan = this.scanList.get(row);
        }
        return scan;
    }

    public Object[] getRow(int index) {
        int size = this.scanData.size();
        if (index >= 0 && index < size) {
            return this.scanData.get(index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateNewScanData(ArrayList<BaseScan> scans) {
        int i = 0;
        ArrayList<BaseScan> arrayList = scans;
        synchronized (arrayList) {
            Collections.sort(scans, new SansScanComparator());
        }
        for (BaseScan scan : scans) {
            BaseScan.ScanType scanType = scan.getScanType();
            if (!scanType.getName().equals(BaseScan.ScanType.sansScan.getName())) continue;
            SansScan sansScan = (SansScan)scan;
            this.addRow(i, sansScan);
            this.scanList.add(i++, sansScan);
        }
    }

    public synchronized void updateScanData(ArrayList<BaseScan> scans, int[] indeces) {
        Arrays.sort(indeces);
        int[] nArray = indeces;
        int n = indeces.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            BaseScan scan = scans.get(index);
            BaseScan.ScanType scanType = scan.getScanType();
            if (scanType.getName().equals(BaseScan.ScanType.sansScan.getName())) {
                SansScan sansScan = (SansScan)scan;
                int loc = this.scanList.indexOf(scan);
                if (loc != -1) {
                    this.updateRow(loc, sansScan);
                    this.scanList.set(loc, sansScan);
                }
            }
            ++n2;
        }
    }

    public synchronized void addScanData(ArrayList<BaseScan> scans, int[] indeces) {
        TreeMap<Integer, SansScan> scansToAdd = new TreeMap<Integer, SansScan>();
        int[] nArray = indeces;
        int n = indeces.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            BaseScan scan = scans.get(index);
            BaseScan.ScanType scanType = scan.getScanType();
            if (scanType.getName().equals(BaseScan.ScanType.sansScan.getName())) {
                int scanIndex = Integer.valueOf(scan.getName());
                scansToAdd.put(scanIndex, (SansScan)scan);
            }
            ++n2;
        }
        Set set = scansToAdd.keySet();
        for (Integer key : set) {
            try {
                SansScan sansScan = (SansScan)scansToAdd.get(key);
                this.addRow(key - 1, sansScan);
                this.scanList.add(key - 1, sansScan);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(int rowIndex, SansScan scan) {
        Object[] row = new Object[30];
        String stop = scan.getScanValue("sansstop");
        boolean stopCheck = false;
        if (stop == null) {
            stopCheck = true;
        } else if (stop.equals("1")) {
            stopCheck = true;
        }
        if (stopCheck) {
            row[0] = stopCheck;
            row[1] = scan.getName();
            row[2] = "STOP";
            int i = 3;
            while (i < row.length - 1) {
                row[i] = "";
                ++i;
            }
            row[28] = scan.getScanValue("status");
            Vector<Object[]> vector = this.scanData;
            synchronized (vector) {
                this.scanData.add(rowIndex, row);
                this.fireTableRowsInserted(rowIndex, rowIndex);
            }
        } else {
            this.addFullRow(rowIndex, stopCheck, scan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow(int rowIndex, SansScan scan) {
        Object[] row = new Object[30];
        String stop = scan.getScanValue("sansstop");
        boolean stopCheck = false;
        if (stop == null) {
            stopCheck = true;
        } else if (stop.equals("1")) {
            stopCheck = true;
        }
        if (stopCheck) {
            row[0] = stopCheck;
            row[1] = scan.getName();
            row[2] = "STOP";
            int i = 3;
            while (i < row.length - 1) {
                row[i] = "";
                ++i;
            }
            row[28] = scan.getScanValue("status");
            Vector<Object[]> vector = this.scanData;
            synchronized (vector) {
                this.scanData.set(rowIndex, row);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        } else {
            this.updateFullRow(rowIndex, stopCheck, scan);
        }
    }

    private Object[] createFullRow(SansScan sansScan, boolean stop) {
        Object[] newRow = new Object[30];
        newRow[0] = stop;
        newRow[1] = sansScan.getName();
        newRow[2] = sansScan.getComments();
        newRow[3] = sansScan.getPrefix();
        newRow[4] = sansScan.getBaseCount();
        newRow[5] = sansScan.getPrefactor();
        newRow[6] = sansScan.getAngleValue("SamplePosition");
        newRow[7] = sansScan.getAngleValue("HuberTranslation");
        newRow[8] = sansScan.getAngleValue("DetectorPos");
        newRow[9] = sansScan.getAngleValue("DetectorOffset");
        newRow[10] = sansScan.getAngleValue("Temp");
        newRow[11] = sansScan.getAngleValue("MagField");
        newRow[12] = sansScan.getScanValue("SANSRHEOPULSES");
        newRow[13] = sansScan.getAngleValue("SampleRotation");
        newRow[14] = sansScan.getAngleValue("HuberRotation");
        newRow[15] = sansScan.getAngleValue("Wavelength");
        newRow[16] = SansTableModel.getDeviceCurrentValue("WavelengthSpread");
        newRow[17] = sansScan.getAngleValue("GuideTable");
        newRow[18] = sansScan.getAngleValue("Attenuator");
        newRow[19] = sansScan.getPresetDevicePropertyValue("GuideTable", "APERT");
        newRow[20] = this.updateSampleApertureValue();
        newRow[21] = sansScan.getAngleValue("BeamStop");
        newRow[22] = sansScan.getAngleValue("BeamStopX");
        newRow[23] = sansScan.getAngleValue("BeamStopY");
        newRow[24] = sansScan.getAngleValue("BeamCenterX");
        newRow[25] = sansScan.getAngleValue("BeamCenterY");
        newRow[26] = sansScan.getSampleValue("Thk");
        newRow[27] = sansScan.getSampleValue("Trans");
        newRow[28] = sansScan.getScanValue("status");
        return newRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFullRow(int rowIndex, boolean stop, SansScan sansScan) {
        Object[] newRow = this.createFullRow(sansScan, stop);
        Vector<Object[]> vector = this.scanData;
        synchronized (vector) {
            this.scanData.add(rowIndex, newRow);
            this.fireTableRowsInserted(rowIndex, rowIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFullRow(int rowIndex, boolean stop, SansScan sansScan) {
        Object[] newRow = this.createFullRow(sansScan, stop);
        Vector<Object[]> vector = this.scanData;
        synchronized (vector) {
            this.scanData.set(rowIndex, newRow);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    public synchronized void removeScanData(BaseScan[] scans, int[] indeces) {
        try {
            this.removeRows(scans);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRows(BaseScan[] scans) {
        Vector<Object[]> vector = this.scanData;
        synchronized (vector) {
            BaseScan[] baseScanArray = scans;
            int n = scans.length;
            int n2 = 0;
            while (n2 < n) {
                BaseScan scan = baseScanArray[n2];
                if (this.scanList.contains(scan)) {
                    int index = this.scanList.indexOf(scan);
                    this.scanData.remove(index);
                    this.fireTableRowsDeleted(index, index);
                    this.scanList.remove(scan);
                    if (this.scanData.size() == 0) {
                        logger.debug("no runs in the table");
                    }
                }
                ++n2;
            }
        }
    }

    public ArrayList<String> getControlNames() {
        return this.controls;
    }

    public void printTableData(int start, int end) {
        int numRows = this.getRowCount();
        int numCols = this.getColumnCount();
        int i = start;
        while (i <= end) {
            Object[] row = this.getRow(i);
            logger.debug(Arrays.toString(row));
            ++i;
        }
    }

    public static String getDeviceCurrentValue(String deviceName) {
        String value = "";
        Controller controller = Controller.getReference();
        InstalledDevice device = controller.getFirstDevice(deviceName);
        if (device != null) {
            value = device.getCurrValue();
        }
        return value;
    }

    private String updateSampleApertureValue() {
        double value = -1.0;
        Controller controller = Controller.getReference();
        Sample sample = controller.getSample();
        if (sample != null) {
            value = sample.getApert();
        }
        return String.valueOf(value);
    }

    public static String getDevicePropertyValue(String deviceName, String propertyName) {
        String value = "";
        Controller controller = Controller.getReference();
        InstalledDevice device = controller.getFirstDevice(deviceName);
        if (device != null) {
            value = device.getAdditionalPropertyValue(propertyName);
        }
        return value;
    }
}

