/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.Controller;
import ice.data.InstalledDevice;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.communication.EmptyDocumentListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.communication.SansCommandResponseEvent;
import ice.gui.panel.sans.communication.SansCommandResponseListener;
import ice.gui.panel.sans.controls.HelpPanel;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.VSTiltControlPanel;
import ice.gui.panel.sans.controls.WaveLengthControlPanel;
import ice.gui.panel.sans.controls.buttons.WavelengthButtonControlPanel;
import ice.gui.panel.sans.subpanels.SansCommandManager;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.swing.textFields.ICEFormattedTextFieldBase;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class WavelengthPanel
extends SansIcePanel
implements DeviceListListener,
ActionListener,
SansCommandResponseListener {
    protected static final String WAVELENGTH_NAME = "Wavelength";
    private static Logger logger = Logger.getLogger("ErrorLogger");
    public static final String wavelength = "Wavelength";
    public static final String vsTilt = "VSTilt";
    public static final String wavelengthSpread = "WavelengthSpread";
    public static final String velSelector = "SansVelSel";
    private static final String title = "Neutron Wavelength";
    private WaveLengthControlPanel wavelengthPanel;
    private VSTiltControlPanel tiltPanel;
    private WavelengthButtonControlPanel buttonPanel;
    private static final String wavelengthMessage = "New Wavelength will be     ";
    private ArrayList<InstalledDevice> allDevices;
    private Controller controller;
    protected Hashtable<JTextField, Boolean> targetsEmpty;

    public WavelengthPanel() throws IcePanelException {
        super("Wavelength", title);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints mainBagConstraints = new GridBagConstraints();
        int y = 0;
        mainBagConstraints.anchor = 10;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.titleLbl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.anchor = 17;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.wavelengthPanel, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.tiltPanel, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.buttonPanel, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.helpPanel, mainBagConstraints);
        this.updateDeviceControls();
        this.writeKeysToHelpPreferenceFile();
        this.buttonPanel.writeKeysToHelpPreferenceFile(this);
        this.readControlKeysFromHelpPreferenceFile(this);
    }

    @Override
    protected void init() {
        this.initSansIcePanel();
        this.targetsEmpty = new Hashtable();
        this.wavelengthPanel = new WaveLengthControlPanel("Wavelength", "Wavelength", velSelector, "RPM");
        this.wavelengthPanel.listenToTargetsEmptyDocumentEvents(this);
        this.tiltPanel = new VSTiltControlPanel();
        this.tiltPanel.listenToTargetComboBoxActions(this);
        SansCommandManager.executeDevicePositionsCommand(vsTilt, vsTilt, this);
        this.buttonPanel = new WavelengthButtonControlPanel(this);
        this.helpPanel = new HelpPanel();
        this.controller = Controller.getReference();
        ArrayList<InstalledDevice> devices = this.controller.getDeviceList();
        this.allDevices = new ArrayList<InstalledDevice>(devices);
        this.controller.getDeviceListeners().add(this);
    }

    @Override
    public void documentChanged(EmptyDocumentListener.EmptyDocumentEvent e) {
        super.documentChanged(e);
        ICEFormattedTextFieldBase textField = (ICEFormattedTextFieldBase)e.getSource();
        SansDeviceControlPanel parent = (SansDeviceControlPanel)textField.getParent();
        String name = parent.getControlName();
        EmptyDocumentListener.EmptyDocumentState state = e.getState();
        if (state == EmptyDocumentListener.EmptyDocumentState.FORMATTING) {
            return;
        }
        if (name != null && name.equals("Wavelength")) {
            boolean buttonOn = this.wavelengthPanel.inRange(state);
            this.buttonPanel.enableMoveToTargetWaveLengthBtn(buttonOn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JComboBox) {
            String selectedItem = (String)((JComboBox)source).getSelectedItem();
            boolean buttonOn = selectedItem != null && !selectedItem.trim().equals("");
            this.buttonPanel.enableMoveToTargetTiltBtn(buttonOn);
        }
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        for (InstalledDevice device : this.allDevices) {
            if (device.getName() == null) continue;
            if (device.getName().equalsIgnoreCase("Wavelength")) {
                device.removeValueChangeListener(this.wavelengthPanel);
                continue;
            }
            if (device.getName().equalsIgnoreCase(wavelengthSpread)) {
                device.removeValueChangeListener(this.tiltPanel);
                continue;
            }
            if (device.getName().equalsIgnoreCase(vsTilt)) {
                device.removeValueChangeListener(this.tiltPanel);
                continue;
            }
            if (!device.getName().equalsIgnoreCase(velSelector)) continue;
            device.removeValueChangeListener(this.wavelengthPanel);
        }
        this.allDevices = dle.getNewList();
        this.updateDeviceControls();
    }

    @Override
    public void updateDeviceControls() {
        for (InstalledDevice device : this.allDevices) {
            if (device.getName() == null) continue;
            try {
                String currentValue;
                Double min = Double.MIN_VALUE;
                Double max = Double.MAX_VALUE;
                if (device.getName().equalsIgnoreCase("Wavelength")) {
                    device.addValueChangeListener(this.wavelengthPanel);
                    currentValue = device.getCurrValue().toString();
                    this.wavelengthPanel.setCurrentValue(currentValue);
                    this.wavelengthPanel.setFixed(device.isFixed());
                    min = device.getLowerLimit();
                    max = device.getUpperLimit();
                    this.wavelengthPanel.setTargetMinMax(min, max);
                    continue;
                }
                if (device.getName().equalsIgnoreCase(wavelengthSpread)) {
                    device.addValueChangeListener(this.tiltPanel);
                    currentValue = device.getCurrValue().toString();
                    this.tiltPanel.setCurrentTranslationValue(currentValue);
                    continue;
                }
                if (device.getName().equalsIgnoreCase(vsTilt)) {
                    device.addValueChangeListener(this.tiltPanel);
                    currentValue = device.getCurrValue().toString();
                    this.tiltPanel.setCurrentValue(currentValue);
                    continue;
                }
                if (!device.getName().equalsIgnoreCase(velSelector)) continue;
                device.addValueChangeListener(this.wavelengthPanel);
                currentValue = device.getCurrValue().toString();
                this.wavelengthPanel.setCurrentTranslationValue(currentValue);
                min = device.getLowerLimit();
                max = device.getUpperLimit();
                if (min == null) {
                    min = Double.longBitsToDouble(Long.MAX_VALUE);
                }
                if (max == null) {
                    max = Double.longBitsToDouble(Long.MIN_VALUE);
                }
                this.wavelengthPanel.setTargetTranMinMax(min.longValue(), max.longValue());
            }
            catch (ICEListenerListExceptionBase e) {
                Logger.getLogger("ErrorLogger").error("WavelengthPanel.updateDeviceControls " + e);
            }
        }
    }

    public SansDeviceControlPanel getWavelengthControl() {
        return this.wavelengthPanel;
    }

    public SansDeviceControlPanel getTiltControlPanel() {
        return this.tiltPanel;
    }

    @Override
    public void actionPerformed(SansCommandResponseEvent e) {
        String tag = e.getTag();
        if (tag.equals(vsTilt)) {
            try {
                String[] values = (String[])e.getSource();
                this.tiltPanel.addItems(values);
            }
            catch (Exception ex) {
                logger.error("error getting response" + e);
            }
        }
    }
}

