/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.Global;
import ice.IcePanelManager;
import ice.event.IceClientErrorEvent;
import ice.gui.panel.sans.communication.SansCommandResponseEvent;
import ice.gui.panel.sans.communication.SansCommandResponseListener;
import ice.gui.panel.sans.events.SansPanelErrorEvent;
import ice.gui.panel.sans.events.SansPanelErrorListener;
import ice.gui.panel.sans.subpanels.AttenuationPanel;
import ice.gui.panel.sans.subpanels.AutoDataCollectionPanel;
import ice.gui.panel.sans.subpanels.BeamStopPanel;
import ice.gui.panel.sans.subpanels.CollimationPanel;
import ice.gui.panel.sans.subpanels.DetectorPanel;
import ice.gui.panel.sans.subpanels.FlipperPanel;
import ice.gui.panel.sans.subpanels.HuberTablePanel;
import ice.gui.panel.sans.subpanels.MainMenuPanel;
import ice.gui.panel.sans.subpanels.ManualOperationsPanel;
import ice.gui.panel.sans.subpanels.RheoSansPanel;
import ice.gui.panel.sans.subpanels.SampleChangerPanel;
import ice.gui.panel.sans.subpanels.SampleMagneticField;
import ice.gui.panel.sans.subpanels.SampleTemperature;
import ice.gui.panel.sans.subpanels.SansCommandManager;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.subpanels.SingleRunPanel;
import ice.gui.panel.sans.subpanels.WavelengthPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class SansPanelController
extends JPanel
implements SansCommandResponseListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("ErrorLogger.SansPanelController");
    public static boolean writeHelpKeys = false;
    private static SansPanelController reference;
    private SingleRunPanel singleRunPanel;
    private ManualOperationsPanel manualOpPanel;
    private AutoDataCollectionPanel autoDataPanel;
    private MainMenuPanel menuPanel;
    private SampleChangerPanel changerPanel;
    private HuberTablePanel tablePanel;
    private BeamStopPanel beamstopPanel;
    private RheoSansPanel rheoPanel;
    private DetectorPanel detectorPanel;
    private WavelengthPanel wavelengthPanel;
    private AttenuationPanel attenuationPanel;
    private CollimationPanel collimationPanel;
    private SampleTemperature sampleTemperature;
    private SampleMagneticField sampleMagneticField;
    private FlipperPanel flipperPanel;
    private HashMap<String, SansIcePanel> panels;
    private CardLayout cardLayout = new CardLayout();
    private ArrayList<SansPanelErrorListener> errorListeners;

    public static SansPanelController getReference() {
        if (reference == null) {
            reference = new SansPanelController();
        }
        return reference;
    }

    private SansPanelController() {
        this.setLayout(this.cardLayout);
        try {
            this.singleRunPanel = new SingleRunPanel();
            this.manualOpPanel = new ManualOperationsPanel();
            this.add((Component)this.manualOpPanel, this.manualOpPanel.getName());
            this.autoDataPanel = new AutoDataCollectionPanel();
            this.menuPanel = new MainMenuPanel();
            this.changerPanel = new SampleChangerPanel();
            this.beamstopPanel = new BeamStopPanel();
            this.tablePanel = new HuberTablePanel();
            this.rheoPanel = new RheoSansPanel();
            this.detectorPanel = new DetectorPanel();
            this.wavelengthPanel = new WavelengthPanel();
            this.attenuationPanel = new AttenuationPanel();
            this.collimationPanel = new CollimationPanel();
            this.sampleTemperature = new SampleTemperature();
            this.sampleMagneticField = new SampleMagneticField();
            this.flipperPanel = new FlipperPanel();
        }
        catch (Exception e) {
            IcePanelManager panelManager = IcePanelManager.getReference();
            IceClientErrorEvent event = new IceClientErrorEvent(this, e);
            panelManager.notifyIceClientErrorListeners(event);
            logger.error("Error loading sans panels", e.getCause());
        }
        this.panels = new HashMap();
        this.panels.put(this.singleRunPanel.getName(), this.singleRunPanel);
        this.panels.put(this.manualOpPanel.getName(), this.manualOpPanel);
        this.panels.put(this.autoDataPanel.getName(), this.autoDataPanel);
        this.panels.put(this.menuPanel.getName(), this.menuPanel);
        this.panels.put(this.changerPanel.getName(), this.changerPanel);
        this.panels.put(this.beamstopPanel.getName(), this.beamstopPanel);
        this.panels.put(this.tablePanel.getName(), this.tablePanel);
        this.panels.put(this.rheoPanel.getName(), this.rheoPanel);
        this.panels.put(this.detectorPanel.getName(), this.detectorPanel);
        this.panels.put(this.wavelengthPanel.getName(), this.wavelengthPanel);
        this.panels.put(this.attenuationPanel.getName(), this.attenuationPanel);
        this.panels.put(this.sampleTemperature.getName(), this.sampleTemperature);
        this.panels.put(this.sampleMagneticField.getName(), this.sampleMagneticField);
        this.panels.put(this.flipperPanel.getName(), this.flipperPanel);
    }

    public void showPanel(SansIcePanel panel) {
        if (panel != null) {
            int zorder = this.getComponentZOrder(panel);
            if (zorder == -1) {
                this.add((Component)panel, panel.getName());
            }
            this.cardLayout.show(this, panel.getName());
            panel.restoreDefaults();
            panel.requestFocusInIceWindow();
        } else {
            logger.error("SansPanelController: panel is null");
        }
    }

    public void showSampleMagneticField() {
        this.showPanel(this.sampleMagneticField);
    }

    public void showSingleRunPanel() {
        this.showPanel(this.singleRunPanel);
    }

    public void showManualOperationsPanel() {
        this.showPanel(this.manualOpPanel);
    }

    public void showAutoDataCollectionPanel() {
        this.showPanel(this.autoDataPanel);
    }

    public void showBeamstopPanel() {
        this.showPanel(this.beamstopPanel);
    }

    public void showRheoSANSPanel() {
        this.showPanel(this.rheoPanel);
    }

    public void showStartupPanel() {
        this.showPanel(this.menuPanel);
    }

    public void showDetectorPanel() {
        this.showPanel(this.detectorPanel);
    }

    public void showSampleTableRotaionPanel() {
        this.showPanel(this.tablePanel);
    }

    public void showWavelenthPanel() {
        this.showPanel(this.wavelengthPanel);
    }

    public void showCollimationPanel() {
        this.showPanel(this.collimationPanel);
    }

    public SampleChangerPanel getSampleChangerPanel() {
        return this.changerPanel;
    }

    public void showSampleChangerOrHuberTablePanel() {
        String command = "device getproperty SamplePosition inchamber";
        SansCommandManager.takeImmediateAction(command, "SamplePosition", this);
    }

    public void showSampleChangerPanel() {
        this.showPanel(this.changerPanel);
    }

    public void showAttenuationPanel() {
        this.showPanel(this.attenuationPanel);
    }

    public void showSampleTemperature() {
        this.showPanel(this.sampleTemperature);
    }

    public void showFlipperPanel() {
        String instrumentName = Global.getInstrumentName();
        if (instrumentName.equalsIgnoreCase("ng3")) {
            this.showPanel(this.flipperPanel);
        }
    }

    public void showPanel(String swapPanelName) {
        this.cardLayout.show(this, swapPanelName);
    }

    public void addErrorListener(SansPanelErrorListener sl) {
        this.errorListeners.add(sl);
    }

    public void removeErrorListener(SansPanelErrorListener sl) {
        this.errorListeners.remove(sl);
    }

    public void notifyErrorListeners(SansPanelErrorEvent event) {
        for (SansPanelErrorListener listener : this.errorListeners) {
            listener.errorOccured(event);
        }
    }

    public boolean requestFocusInIceWindow() {
        Component c = this.getComponentShowing();
        ((SansIcePanel)c).requestFocusInIceWindow();
        return true;
    }

    Component getComponentShowing() {
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length && !comps[i].isVisible()) {
            ++i;
        }
        return i == comps.length ? null : comps[i];
    }

    @Override
    public void actionPerformed(SansCommandResponseEvent event) {
        String inchamber = "False";
        String response = (String)event.getSource();
        String tag = event.getTag();
        if (tag.equals("SamplePosition")) {
            try {
                String[] temp = response.split("=");
                inchamber = temp[1];
                inchamber = inchamber.trim();
            }
            catch (Exception e) {
                logger.error("respose is wrong", e);
            }
            if (inchamber.equalsIgnoreCase("False")) {
                this.showPanel(this.tablePanel);
            } else {
                this.showPanel(this.changerPanel);
            }
        }
    }
}

