/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.Controller;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.actions.SansMoveDeviceAction;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.basic.SansDeviceAddRemoveButton;
import ice.gui.panel.sans.controls.buttons.FlipperButtonControlPanel;
import ice.gui.panel.sans.controls.composite.SansDeviceComboBoxPropertyControl;
import ice.gui.panel.sans.controls.composite.SansDeviceFTFDisplayOnlyPropertyControl;
import ice.gui.panel.sans.controls.composite.SansDeviceFTFPropertyControl;
import ice.gui.panel.sans.controls.composite.SansDeviceWithPropertiesControl;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class FlipperPanel
extends SansIcePanel
implements DeviceListListener,
ActionListener {
    private static final long serialVersionUID = -5406777963758021659L;
    public static final String flipper = "Flipper";
    public static final String title = "Flipper Power Supply";
    public static final String horizontalCoilCurrent = "FlipperHorizCurrent";
    public static final String horizontalCoilVoltage = "Voltage";
    public static final String verticalCoilCurrent = "FlipperVertCurrent";
    public static final String verticalCoilVoltage = "Voltage";
    public static final String activateString = "Flipper Coil Current";
    private static Logger logger = Logger.getLogger("ErrorLogger.Flipper");
    private FlipperButtonControlPanel buttonPanel;
    private SansDeviceWithPropertiesControl flipperControl;
    private SansDeviceWithPropertiesControl horizontalCoilControl;
    private SansDeviceWithPropertiesControl verticalCoilControl;
    private SansDeviceAddRemoveButton activateButton;

    public FlipperPanel() throws IcePanelException {
        super(flipper, title);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(new Color(153, 153, 255), 1, true));
        GridBagConstraints mainBagConstraints = new GridBagConstraints();
        int y = 0;
        mainBagConstraints.anchor = 10;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.titleLbl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, mainBagConstraints);
        mainBagConstraints.anchor = 10;
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.flipperControl, mainBagConstraints);
        mainBagConstraints.anchor = 10;
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.activateButton, mainBagConstraints);
        mainBagConstraints.anchor = 10;
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.horizontalCoilControl, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.verticalCoilControl, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.buttonPanel, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.helpPanel, mainBagConstraints);
        this.verticalCoilControl.readHintsFromPreferenceFile();
        this.horizontalCoilControl.readHintsFromPreferenceFile();
        this.flipperControl.readHintsFromPreferenceFile();
    }

    @Override
    protected void init() {
        this.initSansIcePanel();
        this.flipperControl = new SansDeviceWithPropertiesControl(flipper, flipper, true);
        SansDeviceComboBoxPropertyControl flipperProp = new SansDeviceComboBoxPropertyControl(flipper);
        SansMoveDeviceAction updateAction = new SansMoveDeviceAction(flipperProp);
        flipperProp.addActionListener(updateAction);
        this.flipperControl.addDeviceProperty(flipperProp);
        this.horizontalCoilControl = new SansDeviceWithPropertiesControl(horizontalCoilCurrent, horizontalCoilCurrent, true);
        SansDeviceFTFPropertyControl horCurrProp = new SansDeviceFTFPropertyControl(horizontalCoilCurrent);
        SansMoveDeviceAction updateHorCurAction = new SansMoveDeviceAction(horCurrProp);
        horCurrProp.addActionListener(updateHorCurAction);
        this.horizontalCoilControl.addDeviceProperty(horCurrProp);
        this.verticalCoilControl = new SansDeviceWithPropertiesControl(verticalCoilCurrent, verticalCoilCurrent, true);
        SansDeviceFTFPropertyControl vertCurrProp = new SansDeviceFTFPropertyControl(verticalCoilCurrent);
        SansMoveDeviceAction updateVertCurAction = new SansMoveDeviceAction(vertCurrProp);
        vertCurrProp.addActionListener(updateVertCurAction);
        this.verticalCoilControl.addDeviceProperty(vertCurrProp);
        SansDeviceFTFDisplayOnlyPropertyControl horizVoltage = new SansDeviceFTFDisplayOnlyPropertyControl(horizontalCoilCurrent, "Voltage", "extras");
        this.horizontalCoilControl.addDeviceProperty(horizVoltage);
        SansDeviceFTFDisplayOnlyPropertyControl vertVoltage = new SansDeviceFTFDisplayOnlyPropertyControl(verticalCoilCurrent, "Voltage", "extras");
        this.verticalCoilControl.addDeviceProperty(vertVoltage);
        this.activateButton = new SansDeviceAddRemoveButton(activateString, horizontalCoilCurrent);
        this.activateButton.addDeviceName(verticalCoilCurrent);
        this.buttonPanel = new FlipperButtonControlPanel(this);
        Controller controller = Controller.getReference();
        controller.getDeviceListeners().add(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JComboBox) {
            String selectedItem = (String)((JComboBox)source).getSelectedItem();
            boolean buttonOn = selectedItem != null && !selectedItem.trim().equals("");
            this.buttonPanel.enableMoveAttenuatorBtn(buttonOn);
        }
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        this.updateDeviceControls();
    }

    public SansDeviceControlPanel getHorizontalCoilControl() {
        return this.flipperControl;
    }

    @Override
    public void updateDeviceControls() {
    }
}

