/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.composite;

import ice.Controller;
import ice.data.InstalledDevice;
import ice.event.communication.DeviceValueChangedEvent;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import org.apache.log4j.Logger;

public class SansDevicePropertyControl
extends SansDeviceControlPanel {
    protected static final long serialVersionUID = -6516715059331257377L;
    protected static final String defaultType = "currValue";

    public SansDevicePropertyControl(String deviceName) {
        super(deviceName, deviceName);
    }

    public SansDevicePropertyControl(String deviceName, String propertyName, String propertyType) {
        super(deviceName, deviceName, propertyName, propertyType, "");
    }

    @Override
    public String getCurrentValue() {
        return null;
    }

    @Override
    public String getTargetValue() {
        return null;
    }

    @Override
    public void setCurrentValue(String value) {
    }

    @Override
    public void setTargetValue(String value) {
    }

    public String getPropertyName() {
        return "";
    }

    public void setCurrentValue(InstalledDevice device) {
    }

    public void addDeviceProperties() {
        Controller controller = Controller.getReference();
        InstalledDevice device = controller.getFirstDevice(this.deviceName);
        if (device != null) {
            try {
                device.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                Logger.getLogger("ErrorLogger").error("FlipperPanel.updateDeviceControls " + e);
            }
            String currentValue = device.getPropertyValue(this.propertyType, this.propertyName);
            if (currentValue == null) {
                this.setEnabled(false);
            } else {
                this.setCurrentValue(currentValue);
            }
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            Component comp = components[i];
            comp.setEnabled(enabled);
            ++i;
        }
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent evt) {
        Object source = evt.getSource();
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        if (changedDevice.getRealName().equalsIgnoreCase(this.deviceName) && this.propertyName != null && evt.getPropertyName().equals(this.propertyType)) {
            if (evt.getPropertyName().equalsIgnoreCase(defaultType)) {
                this.doDeviceCurrentValuePropertyChanged(evt);
            } else if (evt.getPropertyName().equalsIgnoreCase("upperLimit")) {
                this.doDeviceUpperLimitPropertyChanged(evt);
            } else if (evt.getPropertyName().equalsIgnoreCase("lowerLimit")) {
                this.doDeviceLowerLimitPropertyChanged(evt);
            } else if (evt.getPropertyName().equalsIgnoreCase("extras")) {
                this.doDeviceAdditionalPropertiesFieldNameChanged(evt);
            }
        }
    }

    @Override
    public void doDeviceAdditionalPropertiesFieldNameChanged(DeviceValueChangedEvent evt) {
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        String propValue = changedDevice.getAdditionalPropertyValue(this.propertyName);
        if (propValue != null) {
            this.setCurrentValue(propValue);
        }
    }

    @Override
    protected void buildGUI() {
    }

    public void readButtonHintsFromPreferenceFile() {
    }
}

