/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.composite;

import ice.data.InstalledDevice;
import ice.gui.panel.sans.controls.basic.SansButton;
import ice.gui.panel.sans.controls.basic.SansDevicePopupMenu;
import ice.gui.panel.sans.controls.basic.SansDevicePopupMenuAction;
import ice.gui.panel.sans.controls.basic.SansDevicePopupMouseListener;
import ice.gui.panel.sans.controls.composite.SansDevicePropertyControl;
import ice.gui.panel.sans.controls.composite.SansDeviceWithPropertiesControl;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTextField;

public class SansDeviceDefaultPropertyControl
extends SansDevicePropertyControl {
    public static final String currentLabelString = "current";
    public static final String targetLabelString = "target";
    public static final String buttonNameString = "Update";
    private static final long serialVersionUID = -8623760404401073686L;
    protected JComponent currentValueComponent;
    protected JComponent targetValueComponent;
    protected JLabel targetLabel;
    protected JLabel currentLabel;
    protected SansButton updateButton;
    protected SansDevicePopupMenu popup;
    protected String propertyAlias;

    protected JComponent instantiateCurrentPropertyField() {
        JTextField field = new JTextField();
        return field;
    }

    protected JComponent instantiateTargetPropertyField() {
        return new JTextField();
    }

    public SansDeviceDefaultPropertyControl(String deviceName, String propertyName, String propertyType) {
        super(deviceName, propertyName, propertyType);
    }

    public SansDeviceDefaultPropertyControl(String deviceName) {
        super(deviceName);
    }

    @Override
    protected void init() {
        super.init();
        this.setLayout(new GridBagLayout());
        this.setBackground(SansDeviceWithPropertiesControl.deviceBackgroundColor);
        this.currentLabel = new JLabel(this.propertyName);
        this.currentLabel.setPreferredSize(new Dimension(120, 14));
        this.currentLabel.setHorizontalAlignment(4);
        this.targetLabel = new JLabel(targetLabelString);
        this.currentValueComponent = this.instantiateCurrentPropertyField();
        this.targetValueComponent = this.instantiateTargetPropertyField();
        ((JTextField)this.currentValueComponent).setDisabledTextColor(new Color(51, 0, 102));
        this.currentValueComponent.setEnabled(false);
        this.updateButton = new SansButton(buttonNameString);
        this.updateButton.setEnabled(false);
    }

    @Override
    public void setCurrentValue(String value) {
        ((JTextField)this.currentValueComponent).setText(value);
    }

    @Override
    public void setCurrentValue(InstalledDevice device) {
        String value = device.getAdditionalPropertyValue(this.propertyName);
        this.setCurrentValue(value);
    }

    @Override
    public String getCurrentValue() {
        String currentValue = ((JTextField)this.currentValueComponent).getText();
        return currentValue;
    }

    @Override
    public String getTargetValue() {
        String targetValue = ((JTextField)this.targetValueComponent).getText();
        return targetValue;
    }

    @Override
    public void setTargetValue(String value) {
        ((JTextField)this.targetValueComponent).setText(value);
    }

    @Override
    protected void buildGUI() {
        int y = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 5, 5);
        this.add((Component)this.currentLabel, gridBagConstraints);
        this.currentValueComponent.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = y;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.add((Component)this.currentValueComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = y;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.targetLabel, gridBagConstraints);
        this.targetValueComponent.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = y;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.add((Component)this.targetValueComponent, gridBagConstraints);
        this.updateButton.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = y;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.updateButton, gridBagConstraints);
        this.addDeviceProperties();
        this.buildPopupMenu();
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public void addActionListener(ActionListener updateAction) {
        this.updateButton.addActionListener(updateAction);
    }

    @Override
    public SansIcePanel getSansIcePanelParent() {
        SansIcePanel returnValue = null;
        Container parent = null;
        parent = this.currentValueComponent;
        while (!((parent = parent.getParent()) instanceof SansIcePanel) && parent != null) {
        }
        returnValue = (SansIcePanel)parent;
        return returnValue;
    }

    @Override
    public void clearTargetValue() {
        ((JTextField)this.targetValueComponent).setText("");
    }

    public void clearCurrentValue() {
        ((JTextField)this.currentValueComponent).setText("");
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.targetValueComponent.setEnabled(enabled);
        this.targetLabel.setEnabled(enabled);
        this.currentLabel.setEnabled(enabled);
        if (!enabled) {
            this.clearCurrentValue();
            this.clearTargetValue();
        }
    }

    private void buildPopupMenu() {
        this.popup = new SansDevicePopupMenu();
        JMenuItem menuItem = new JMenuItem();
        menuItem.setActionCommand("Add Hint");
        menuItem.setAction(new SansDevicePopupMenuAction("Add Hint"));
        this.popup.add(menuItem);
        menuItem = new JMenuItem();
        menuItem.setActionCommand("Customize");
        menuItem.setAction(new SansDevicePopupMenuAction("Customize"));
        this.popup.add(menuItem);
        SansDevicePopupMouseListener popupAction = new SansDevicePopupMouseListener(this.popup);
        this.updateButton.addMouseListener(popupAction);
        this.currentValueComponent.addMouseListener(popupAction);
    }

    @Override
    public void readButtonHintsFromPreferenceFile() {
        Component[] components;
        Component[] componentArray = components = this.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof SansButton) {
                ((SansButton)comp).readButtonHintsFromPreferenceFile();
            }
            ++n2;
        }
    }
}

