/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.composite;

import ice.gui.panel.sans.controls.composite.SansDeviceDefaultPropertyControl;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SansDeviceComboBoxPropertyControl
extends SansDeviceDefaultPropertyControl
implements ActionListener {
    private static final long serialVersionUID = -8623798604044073686L;
    private static Logger logger = Logger.getLogger("ErrorLogger.SansDeviceComboBoxPropertyControl");
    private static final String emptyString = "";

    public SansDeviceComboBoxPropertyControl(String deviceName) {
        super(deviceName, "currValue", "currValue");
    }

    @Override
    protected JComponent instantiateTargetPropertyField() {
        JComboBox field = new JComboBox();
        String[] values = new String[]{emptyString, "ON", "OFF"};
        this.addItems(values, field);
        field.addActionListener(this);
        return field;
    }

    @Override
    public void setCurrentValue(String value) {
        ((JTextField)this.currentValueComponent).setText(value);
    }

    @Override
    public String getCurrentValue() {
        String currentValue = ((JTextField)this.currentValueComponent).getText();
        return currentValue;
    }

    @Override
    public String getTargetValue() {
        String targetValue = (String)((JComboBox)this.targetValueComponent).getSelectedItem();
        return targetValue;
    }

    @Override
    public void setTargetValue(String value) {
        ((JComboBox)this.targetValueComponent).setSelectedItem(value);
    }

    public void addItems(String[] items, JComboBox field) {
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            field.addItem(item);
            ++n2;
        }
    }

    @Override
    public void clearTargetValue() {
        ((JComboBox)this.targetValueComponent).setSelectedItem(emptyString);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.targetValueComponent) {
            String selectedItem = (String)((JComboBox)source).getSelectedItem();
            boolean buttonOn = selectedItem != null && !selectedItem.trim().equals(emptyString);
            this.updateButton.setEnabled(buttonOn);
        }
    }
}

