/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.basic;

import ice.gui.panel.sans.controls.composite.SansDeviceWithPropertiesControl;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.util.HelpPropertiesManager;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class SansButton
extends JButton {
    private static final long serialVersionUID = 305405989865078420L;
    private SansIcePanel sansPanel;
    private SansDeviceWithPropertiesControl propControl;

    public SansButton() {
    }

    public SansButton(Action a) {
        super(a);
    }

    public SansButton(Icon icon) {
        super(icon);
    }

    public SansButton(String text, Icon icon) {
        super(text, icon);
    }

    public SansButton(String text) {
        super(text);
    }

    public void readButtonHintsFromPreferenceFile() {
        String hint;
        String buttonName = this.getText().replace(" ", "");
        buttonName = buttonName.replace(":", "");
        SansIcePanel parentPanel = this.getSansPanelAsParent();
        SansDeviceWithPropertiesControl parentControl = this.getSansDeviceWithPropertiesControlAsParent();
        String key = "none";
        if (parentPanel != null && parentControl != null) {
            key = String.valueOf(parentPanel.getClass().getName()) + "." + parentControl.getClass().getSimpleName() + "." + parentControl.getDeviceName() + "." + this.getClass().getSimpleName() + "." + buttonName + ".hint";
        }
        if (!(hint = HelpPropertiesManager.getPreferenceString(key)).equals("undefined")) {
            this.setToolTipText(hint);
        }
    }

    public void writeKeysToHelpPreferenceFile(String message) {
        String buttonName = this.getText().replace(" ", "");
        buttonName = buttonName.replace(":", "");
        SansIcePanel parentPanel = this.getSansPanelAsParent();
        SansDeviceWithPropertiesControl parentControl = this.getSansDeviceWithPropertiesControlAsParent();
        String key = "none";
        if (parentPanel != null & parentControl != null) {
            key = String.valueOf(parentPanel.getClass().getName()) + "." + parentControl.getClass().getSimpleName() + "." + parentControl.getDeviceName() + "." + this.getClass().getSimpleName() + "." + buttonName + ".hint";
            try {
                HelpPropertiesManager.initPreferenceString(key, message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private SansIcePanel getSansPanelAsParent() {
        if (this.sansPanel != null) {
            return this.sansPanel;
        }
        if (this instanceof Component) {
            Container parent = this;
            while (!((parent = parent.getParent()) instanceof SansIcePanel) && parent != null) {
            }
            this.sansPanel = (SansIcePanel)parent;
        }
        return this.sansPanel;
    }

    private SansDeviceWithPropertiesControl getSansDeviceWithPropertiesControlAsParent() {
        if (this.propControl != null) {
            return this.propControl;
        }
        if (this instanceof Component) {
            Container parent = this;
            while (!((parent = parent.getParent()) instanceof SansDeviceWithPropertiesControl) && parent != null) {
            }
            this.propControl = (SansDeviceWithPropertiesControl)parent;
        }
        return this.propControl;
    }
}

