/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.ClientAPI;
import ice.Controller;
import ice.commands.DevicePositionsCommand;
import ice.data.InstalledDevice;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.SansScanDeviceComboBoxControlPanel;
import ice.gui.panel.sans.data.SansScan;
import ice.gui.panel.sans.subpanels.CollimationPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Logger;

public class SansScanDeviceGuideControl {
    private SansScanDeviceComboBoxControlPanel collimationControl;
    private SansScanDeviceComboBoxControlPanel apertureControl;
    private SansScanDeviceComboBoxControlPanel lensesControl;
    private String[] guide01ApertValues;
    private String[] guide08ApertValues;
    private static Logger logger = Logger.getLogger("ErrorLogger.GuidesPanel");

    public SansScanDeviceGuideControl() {
        this.init();
    }

    private void init() {
        String[] values;
        DevicePositionsCommand iCommand;
        ClientAPI messageSender;
        this.collimationControl = new SansScanDeviceComboBoxControlPanel("Guides", "GuideTable", SansScan.DeviceType.angle);
        this.apertureControl = new SansScanDeviceComboBoxControlPanel("Apertures", "Guide01", SansScan.DeviceType.angle);
        this.lensesControl = new SansScanDeviceComboBoxControlPanel("Lenses", "Guide10", SansScan.DeviceType.angle);
        this.collimationControl.addActionListener(new CollimationComboBoxActionListener());
        Controller controller = Controller.getReference();
        InstalledDevice device = controller.getFirstDevice("GuideTable");
        try {
            messageSender = ClientAPI.getInstance();
            iCommand = new DevicePositionsCommand("GuideTable", messageSender);
            iCommand.runSynchronous();
            values = iCommand.getParsedResponse();
            this.collimationControl.addItems(values);
        }
        catch (Exception e) {
            logger.error("Error while sending a command...", e.getCause());
        }
        try {
            messageSender = ClientAPI.getInstance();
            iCommand = new DevicePositionsCommand("Guide01 apert", messageSender);
            iCommand.runSynchronous();
            this.guide01ApertValues = iCommand.getParsedResponse();
        }
        catch (Exception e) {
            logger.error("Error while sending a command...", e.getCause());
        }
        try {
            messageSender = ClientAPI.getInstance();
            iCommand = new DevicePositionsCommand("Guide08 apert", messageSender);
            iCommand.runSynchronous();
            this.guide08ApertValues = iCommand.getParsedResponse();
        }
        catch (Exception e) {
            logger.error("Error while sending a command...", e.getCause());
        }
        try {
            messageSender = ClientAPI.getInstance();
            iCommand = new DevicePositionsCommand("Guide10", messageSender);
            iCommand.runSynchronous();
            values = iCommand.getParsedResponse();
            this.lensesControl.addItems(values);
        }
        catch (Exception e) {
            logger.error("Error while sending a command...", e.getCause());
        }
        String colValue = "";
        if (device.isFixed()) {
            colValue = device.getCurrValue();
            this.configureApertureControl(colValue, false);
        } else {
            colValue = this.collimationControl.getCurrentValue();
            this.configureApertureControl(colValue, true);
        }
    }

    public SansDeviceControlPanel getCollimationControl() {
        return this.collimationControl;
    }

    public SansDeviceControlPanel getApertureControl() {
        return this.apertureControl;
    }

    public SansDeviceControlPanel getLensesControl() {
        return this.lensesControl;
    }

    public void configureApertureControl(String guideState, Boolean updateScan) {
        boolean ng3Guide7State = CollimationPanel.determineGuideState("ng3", "7", guideState);
        if (guideState.equals("POLBEAM") || ng3Guide7State) {
            this.apertureControl.updateDeviceName("Guide08");
            if (this.guide08ApertValues != null) {
                this.apertureControl.replaceItems(this.guide08ApertValues);
            }
            if (updateScan.booleanValue()) {
                this.apertureControl.setScanName("Guide08");
            }
        } else if (!guideState.equals("N/A")) {
            this.apertureControl.updateDeviceName("Guide01");
            if (this.guide01ApertValues != null) {
                this.apertureControl.replaceItems(this.guide01ApertValues);
            }
            if (updateScan.booleanValue()) {
                this.apertureControl.setScanName("Guide01");
            }
        }
    }

    public class CollimationComboBoxActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller controller = Controller.getReference();
            InstalledDevice device = controller.getFirstDevice(SansScanDeviceGuideControl.this.collimationControl.getDeviceName());
            String guideTable = SansScanDeviceGuideControl.this.collimationControl.getCurrentValue();
            if (device != null && device.isFixed()) {
                return;
            }
            boolean ng3Guide7State = CollimationPanel.determineGuideState("ng3", "7", guideTable);
            if (guideTable.equals("0")) {
                SansScanDeviceGuideControl.this.apertureControl.setDisabled(false);
                SansScanDeviceGuideControl.this.lensesControl.setDisabled(false);
                SansScanDeviceGuideControl.this.apertureControl.setSaveToScan(true);
                SansScanDeviceGuideControl.this.lensesControl.setSaveToScan(true);
            } else if (guideTable.equals("POLBEAM") || ng3Guide7State) {
                SansScanDeviceGuideControl.this.lensesControl.setDisabled(true);
                SansScanDeviceGuideControl.this.apertureControl.setDisabled(false);
                SansScanDeviceGuideControl.this.apertureControl.setSaveToScan(true);
                SansScanDeviceGuideControl.this.lensesControl.setSaveToScan(false);
            } else {
                SansScanDeviceGuideControl.this.apertureControl.setSaveToScan(false);
                SansScanDeviceGuideControl.this.lensesControl.setSaveToScan(false);
                SansScanDeviceGuideControl.this.apertureControl.setDisabled(true);
                SansScanDeviceGuideControl.this.lensesControl.setDisabled(true);
            }
            SansScanDeviceGuideControl.this.configureApertureControl(guideTable, true);
        }
    }
}

