/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.Controller;
import ice.data.InstalledDevice;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.data.SansScan;
import ice.gui.panel.sans.events.SansInputControlFocusListener;
import ice.gui.panel.sans.swing.SansDeviceNameLabel;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SansScanDeviceControlPanel
extends SansDeviceControlPanel
implements DeviceValueChangedListener {
    protected SansDeviceNameLabel deviceNameLabel;
    protected JTextField deviceValueTextField;
    protected JLabel unitsLabel;
    protected InstalledDevice.Type deviceType;
    protected String scanName;
    protected final Color defaultColorDisabled = Color.LIGHT_GRAY;
    protected final Color defaultColorFixed = new Color(246, 168, 182);
    protected boolean saveToScan;
    protected boolean neverEdit;

    public SansScanDeviceControlPanel(String name, String deviceName) {
        super(name, deviceName);
    }

    public SansScanDeviceControlPanel(String name, String deviceName, String units) {
        super(name, deviceName, units);
    }

    public SansScanDeviceControlPanel(String name, String deviceName, SansScan.DeviceType type) {
        super(name, deviceName, type);
    }

    public SansScanDeviceControlPanel(String labelName, String deviceName, String propertyName, String units) {
        super(labelName, deviceName, propertyName, units);
    }

    @Override
    protected void init() {
        super.init();
        this.deviceNameLabel = new SansDeviceNameLabel();
        this.deviceValueTextField = this.instantiateDeviceValueTextField();
        this.unitsLabel = new JLabel();
        this.saveToScan = true;
        this.neverEdit = false;
        this.setScanName(this.deviceName);
        this.deviceValueTextField.addFocusListener(new SansInputControlFocusListener());
        this.deviceType = InstalledDevice.Type.motor;
    }

    protected JTextField instantiateDeviceValueTextField() {
        return new JTextField();
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.deviceNameLabel.setText(this.controlName);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.deviceNameLabel, gridBagConstraints);
        this.deviceValueTextField.setText("");
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.deviceValueTextField, gridBagConstraints);
        this.unitsLabel.setText(this.units);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.unitsLabel, gridBagConstraints);
        this.addToDoNotEnableDisableOnIdleOrBusy(this.getComponents());
    }

    @Override
    public void setCurrentValue(String value) {
        this.deviceValueTextField.setText(value);
    }

    @Override
    public void setTargetValue(String value) {
    }

    @Override
    public String getTargetValue() {
        String currentValue = this.deviceValueTextField.getText();
        return currentValue;
    }

    @Override
    public String getCurrentValue() {
        String currentValue = this.deviceValueTextField.getText();
        return currentValue;
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent evt) {
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        if (changedDevice.getName().equalsIgnoreCase(this.deviceName)) {
            String currentValue;
            if (evt.getPropertyName().equalsIgnoreCase("currValue") && this.isFixed()) {
                currentValue = changedDevice.getCurrValue();
                this.setCurrentValue(currentValue);
            }
            if (evt.getPropertyName().equalsIgnoreCase("fixed")) {
                if (changedDevice.isFixed()) {
                    currentValue = changedDevice.getCurrValue();
                    this.setFixed(true);
                    this.setCurrentValue(currentValue);
                } else {
                    this.setCurrentValue(this.scanValue);
                    this.setFixed(false);
                }
            }
        }
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (!this.neverEdit) {
            this.deviceValueTextField.setEditable(!disabled);
            this.deviceValueTextField.setFocusable(!disabled);
            this.deviceNameLabel.setEnabled(!disabled);
        }
        if (disabled) {
            this.deviceValueTextField.setBackground(this.defaultColorDisabled);
        } else {
            this.deviceValueTextField.setBackground(Color.WHITE);
        }
    }

    public void setNeverEdit(boolean never) {
        this.neverEdit = never;
        this.deviceValueTextField.setEditable(!never);
        this.deviceValueTextField.setFocusable(!never);
        if (never) {
            this.deviceValueTextField.setBackground(this.defaultColorDisabled);
        } else {
            this.deviceValueTextField.setBackground(Color.WHITE);
        }
    }

    @Override
    public void setFixed(boolean fixed) {
        this.fixed = fixed;
        if (!this.neverEdit) {
            this.deviceValueTextField.setEditable(!fixed);
            this.deviceValueTextField.setFocusable(!fixed);
        }
        if (fixed) {
            this.deviceValueTextField.setBackground(this.defaultColorDisabled);
        } else {
            this.deviceValueTextField.setBackground(Color.WHITE);
        }
    }

    public void setLabelPrefferedSize(int width, int height) {
        this.deviceNameLabel.setPreferredSize(new Dimension(width, height));
    }

    public void setTextPrefferedSize(int width, int height) {
        this.deviceValueTextField.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void addFocusListener(FocusListener focus) {
        this.deviceValueTextField.addFocusListener(focus);
    }

    public boolean isSaveToScan() {
        return this.saveToScan;
    }

    public void setSaveToScan(boolean saveToScan) {
        this.saveToScan = saveToScan;
    }

    public void setScanName(String scanName) {
        this.scanName = scanName;
    }

    public String getScanName() {
        return this.scanName;
    }

    public JTextField getTextControl() {
        return this.deviceValueTextField;
    }

    public boolean isEditable() {
        return this.deviceValueTextField.isEditable();
    }

    public void setControlBackground(Color color) {
        this.deviceValueTextField.setBackground(color);
    }

    @Override
    public void setControlName(String name) {
        super.setControlName(name);
        this.deviceNameLabel.setText(name);
    }

    public void setDevice(InstalledDevice device) {
        this.deviceNameLabel.setDevice(device);
    }

    public SansDeviceNameLabel getDeviceLabel() {
        return this.deviceNameLabel;
    }

    public void updateDeviceName(String deviceName) {
        String oldDeviceName = this.deviceName;
        Controller controller = Controller.getReference();
        InstalledDevice device = controller.getFirstDevice(deviceName);
        InstalledDevice oldDevice = controller.getFirstDevice(oldDeviceName);
        this.deviceNameLabel.setDevice(device);
        this.deviceName = deviceName;
        if (oldDevice != null) {
            oldDevice.removeValueChangeListener(this);
        }
        if (device != null) {
            try {
                device.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                e.printStackTrace();
            }
        }
    }
}

