/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.gui.panel.sans.controls.SansScanDeviceControlPanel;
import ice.gui.panel.sans.data.SansScan;
import ice.gui.panel.sans.swing.SansDeviceNameLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SansScanDeviceComboBoxControlPanel
extends SansScanDeviceControlPanel {
    private JComboBox deviceComboBox;
    private DefaultComboBoxModel deviceBoxModel;

    public SansScanDeviceComboBoxControlPanel(String name, String deviceName) {
        super(name, deviceName);
    }

    public SansScanDeviceComboBoxControlPanel(String labelName, String deviceName, String units) {
        super(labelName, deviceName, units);
    }

    public SansScanDeviceComboBoxControlPanel(String labelName, String deviceName, String propertyName, String units) {
        super(labelName, deviceName, propertyName, units);
    }

    public SansScanDeviceComboBoxControlPanel(String name, String deviceName, SansScan.DeviceType type) {
        super(name, deviceName, type);
    }

    @Override
    protected void init() {
        super.init();
        this.deviceNameLabel = new SansDeviceNameLabel();
        this.deviceComboBox = new JComboBox();
        this.unitsLabel = new JLabel();
        this.deviceBoxModel = new DefaultComboBoxModel();
        this.deviceComboBox.setModel(this.deviceBoxModel);
        this.addToDoNotEnableDisableOnIdleOrBusy(this.deviceComboBox);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.deviceNameLabel.setText(this.controlName);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.deviceNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.deviceComboBox, gridBagConstraints);
        this.unitsLabel.setText(this.units);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.unitsLabel, gridBagConstraints);
    }

    @Override
    public void setCurrentValue(String value) {
        this.deviceComboBox.setSelectedItem(value);
    }

    @Override
    public String getCurrentValue() {
        String currentValue = (String)this.deviceComboBox.getSelectedItem();
        return currentValue;
    }

    @Override
    public String getTargetValue() {
        return "";
    }

    @Override
    public void setTargetValue(String value) {
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.setEnabled(!disabled);
    }

    public void addItems(String[] items) {
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.deviceBoxModel.addElement(item);
            ++n2;
        }
    }

    public void replaceItems(String[] items) {
        this.deviceBoxModel.removeAllElements();
        this.addItems(items);
    }

    @Override
    public void setFixed(boolean fixed) {
        this.fixed = fixed;
        this.deviceComboBox.setEnabled(!fixed);
        if (fixed) {
            this.deviceComboBox.setBackground(this.defaultColorDisabled);
        } else {
            this.deviceComboBox.setBackground(Color.WHITE);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.deviceComboBox.addActionListener(listener);
    }

    @Override
    public void setTextPrefferedSize(int width, int height) {
        this.deviceComboBox.setPreferredSize(new Dimension(width, height));
    }

    public void addItem(String item) {
        this.deviceBoxModel.insertElementAt(item, 0);
    }
}

