/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.communication;

import ice.ClientAPI;
import ice.IcePanelManager;
import ice.commands.QueuedCommand;
import ice.event.IceClientErrorEvent;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.SansDeviceWithScaleControlPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class MoveDeviceActionListener
implements ActionListener {
    private static Logger logger = Logger.getLogger("ErrorLogger");
    SansDeviceControlPanel devicePanel1;
    SansDeviceControlPanel devicePanel2;
    IcePanelManager panelManager;

    public MoveDeviceActionListener(SansDeviceControlPanel panel) {
        this.devicePanel1 = panel;
        this.devicePanel2 = null;
        this.panelManager = IcePanelManager.getReference();
    }

    public MoveDeviceActionListener(SansDeviceControlPanel panel1, SansDeviceControlPanel panel2) {
        this.devicePanel1 = panel1;
        this.devicePanel2 = panel2;
        this.panelManager = IcePanelManager.getReference();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!(event.getSource() instanceof JButton)) {
            return;
        }
        this.executeCommand(this.devicePanel1);
        if (this.devicePanel2 == null) {
            return;
        }
        this.executeCommand(this.devicePanel2);
    }

    private void executeCommand(SansDeviceControlPanel devicePanel) {
        try {
            ClientAPI messageSender = ClientAPI.getInstance();
            String value = devicePanel.getTargetValue();
            String trimmedValue = value.trim();
            if (trimmedValue.equals("")) {
                return;
            }
            String deviceName = devicePanel.getDeviceName();
            devicePanel.setTargetValue("");
            if (devicePanel instanceof SansDeviceWithScaleControlPanel) {
                ((SansDeviceWithScaleControlPanel)devicePanel).setTargetTranslationValue("");
            }
            double doubleValue = Double.parseDouble(value);
            QueuedCommand command = new QueuedCommand("move " + deviceName + " " + value, messageSender);
            command.runAsynchronous();
        }
        catch (NumberFormatException ne) {
            IcePanelException ipe = new IcePanelException("Incorrect value format, please insert numeric value");
            IceClientErrorEvent errorEvent = new IceClientErrorEvent(this.devicePanel1, ipe);
            this.panelManager.notifyIceClientErrorListeners(errorEvent);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("client api error", e.getCause());
        }
    }
}

