/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.actions;

import ice.ClientAPI;
import ice.IcePanelManager;
import ice.commands.ImmediateCommand;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.gui.core.GenericIcePanel;
import ice.gui.core.IceWindow;
import ice.gui.core.controls.serverFileView.ServerFileSelectionDialog;
import ice.gui.core.controls.serverFileView.ServerFolderView;
import ice.gui.panel.sans.DataAcquisitionPanel;
import ice.gui.panel.sans.actions.SansButtonAction;
import java.awt.event.ActionEvent;
import javax.swing.JTable;
import org.apache.log4j.Logger;

public class LoadRunConfigAction
extends SansButtonAction {
    private static Logger logger = Logger.getLogger("ErrorLogger");
    private JTable table;

    public LoadRunConfigAction(String name, JTable table) {
        super(name);
        this.table = table;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.executeCommand();
    }

    private void executeCommand() {
        String fileName;
        GenericIcePanel panel;
        String start = this.rangePanel.getLowRangeValue();
        String end = this.rangePanel.getHighRangeValue();
        IcePanelManager panelManager = IcePanelManager.getReference();
        IceWindow window = panelManager.getIceWindow(panel = panelManager.findOpenPanelByName(DataAcquisitionPanel.title));
        Object fileResultObject = ServerFileSelectionDialog.selectIceFileFromServer(window, IceFileType.sansConfig, ServerFolderView.ValidServerFolders.USER);
        if (fileResultObject instanceof IceFile) {
            String parentName;
            IceFile parent = null;
            fileName = ((IceFile)fileResultObject).getName();
            parent = ((IceFile)fileResultObject).getParent();
            if (parent != null && parent.isMagicWord() && (parentName = parent.getName()) != null && !parentName.equals("")) {
                fileName = String.valueOf(parentName) + ":" + fileName;
            }
        } else {
            if (fileResultObject == null) {
                return;
            }
            logger.error("User selected a scan instead of a file.");
            return;
        }
        String message = "Scan LoadConfig " + fileName + " " + start + " " + end;
        try {
            ClientAPI messageSender = ClientAPI.getInstance();
            ImmediateCommand command = new ImmediateCommand(message, messageSender);
            command.runAsynchronous();
        }
        catch (Exception e) {
            logger.error("client api error", e.getCause());
        }
    }
}

