/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel;

import ice.data.BaseScan;
import ice.data.IceFileType;
import ice.data.Resource;
import ice.exceptions.IcePanelException;
import ice.gui.tas.bt7.scan.BaseScanPanel;
import ice.swing.Bag;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VectorScanPanel
extends BaseScanPanel {
    private JTextField eFixedField;
    private JComboBox eFixedCB;
    protected static final String HTEXT = "h";
    protected static final String KTEXT = "k";
    protected static final String LTEXT = "l";
    protected static final String ETEXT = "Et=(Ei-Ef)";
    private int hPosition;
    private int kPosition;
    private int lPosition;
    private int ePosition;

    public VectorScanPanel(Resource resource) throws IcePanelException {
        super((BaseScan)resource);
        logger.debug("Editing vector scan");
    }

    @Override
    protected void init() {
        this.eFixedField = new JTextField(6);
        this.eFixedField.getDocument().addDocumentListener(this);
        String[] fixedE = new String[]{"Fixed Ef", "Fixed Ei"};
        this.eFixedCB = new JComboBox<String>(fixedE);
        this.eFixedCB.addItemListener(this);
        this.createDeviceFields();
        this.createPanels();
    }

    @Override
    public void loadResource() {
        if (this.resource != null && this.resource instanceof BaseScan) {
            this.loadPanels((BaseScan)this.resource);
        }
    }

    @Override
    public void buildGUI() {
        this.setLayout(new GridBagLayout());
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        JLabel instructionsLabel = new JLabel("<html>Setup for a scan through a lattice reflection <br>(or other position in reciprocal space) along a vector direction.</html>");
        this.add((Component)instructionsLabel, constraints.cell(x, y));
        this.add((Component)this.instrumentPanel, constraints.cell(x, ++y));
        this.add((Component)this.envPanel, constraints.cell(x, ++y));
        constraints.fill = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        this.add((Component)this.descrPanel, constraints.cellWithoutReset(x, ++y));
        this.add((Component)this.btnPanel, constraints.cell(x, ++y));
    }

    public static IceFileType[] getSupportedFileTypes() {
        IceFileType[] fileTypes = new IceFileType[]{IceFileType.vectorScan};
        return fileTypes;
    }

    @Override
    public void updateAdditionalDevices() {
    }

    protected void createDeviceFields() {
        this.addSingleDevice(HTEXT, "rlu");
        this.hPosition = 0;
        this.addSingleDevice(KTEXT, "rlu");
        this.kPosition = 1;
        this.addSingleDevice(LTEXT, "rlu");
        this.lPosition = 2;
        this.addSingleDevice(ETEXT, "meV");
        this.ePosition = 3;
    }

    @Override
    protected JPanel createInstrumentPanel() {
        int size = 4;
        JLabel leftSpacer = new JLabel("");
        JLabel rightSpacer = new JLabel("");
        int x = 0;
        int y = 0;
        JPanel instrumentPanel = new JPanel(new GridBagLayout());
        instrumentPanel.setBorder(BorderFactory.createTitledBorder("Instrument"));
        Bag instrumentConstraints = new Bag();
        int maxCols = 7;
        instrumentPanel.add((Component)leftSpacer, instrumentConstraints.cell(x, y).fillx(1.0));
        instrumentPanel.add((Component)this.createLabel("Fixed Energy ", 2), instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)this.eFixedCB, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)this.eFixedField, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)this.createLabel("meV", 2), instrumentConstraints.cell(++x, y));
        x = 0;
        instrumentPanel.add((Component)leftSpacer, instrumentConstraints.cell(x, ++y).fillx(1.0));
        instrumentPanel.add((Component)this.modePanel, instrumentConstraints.cell(++x, y).colspan(maxCols));
        instrumentPanel.add((Component)rightSpacer, instrumentConstraints.cell(x += maxCols, y).fillx(1.0));
        x = 2;
        instrumentPanel.add((Component)this.column1Label, instrumentConstraints.cell(x, ++y));
        instrumentPanel.add((Component)this.column2Label, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)this.column3Label, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)this.column4Label, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)new JLabel("Units  "), instrumentConstraints.cell(++x, y));
        x = 1;
        ++y;
        Insets defaultInsets = new Insets(instrumentConstraints.insets.top, instrumentConstraints.insets.left, instrumentConstraints.insets.bottom, instrumentConstraints.insets.right);
        for (BaseScanPanel.ScanEntry entry : this.scanEntries) {
            instrumentPanel.add((Component)entry.getNameLabel(), instrumentConstraints.cell(x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getFirstField(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getSecondField(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getInfoLabel1(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getInfoLabel2(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getUnitLabel(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            ++x;
            ++y;
            x = 1;
        }
        instrumentConstraints.inset(defaultInsets);
        x = 0;
        instrumentPanel.add((Component)this.parameterPanel, instrumentConstraints.cell(x, ++y).colspan(maxCols + 2));
        return instrumentPanel;
    }

    @Override
    protected void loadInstrumentPanel(BaseScan input) {
        HashMap<String, BaseScan.Range> devHash = input.getDeviceRanges();
        Set<String> ranges = devHash.keySet();
        BaseScan.FixedEnergy efixed = input.getFixedEnergyDevice();
        if (efixed == BaseScan.FixedEnergy.analyzer) {
            this.eFixedCB.setSelectedItem("Fixed Ef");
        } else if (efixed == BaseScan.FixedEnergy.monochromator) {
            this.eFixedCB.setSelectedItem("Fixed Ei");
        }
        this.eFixedField.setText(new Double(input.getFixedEnergy()).toString());
        Iterator<String> riter = ranges.iterator();
        while (riter.hasNext()) {
            boolean skipit = false;
            String dev = riter.next();
            for (BaseScanPanel.ScanEntry entry : this.scanEntries) {
                if (dev.compareToIgnoreCase(entry.getNameLabel().getText()) != 0) continue;
                entry.getFirstField().setText(new Double(devHash.get(dev).getFirstValue()).toString());
                entry.getSecondField().setText(new Double(devHash.get(dev).getSecondValue()).toString());
                skipit = true;
            }
            if (dev.compareToIgnoreCase("H") == 0) {
                ((BaseScanPanel.ScanEntry)this.scanEntries.get(this.hPosition)).getFirstField().setText(new Double(devHash.get(dev).getFirstValue()).toString());
                ((BaseScanPanel.ScanEntry)this.scanEntries.get(this.hPosition)).getSecondField().setText(new Double(devHash.get(dev).getSecondValue()).toString());
                continue;
            }
            if (dev.compareToIgnoreCase("K") == 0) {
                ((BaseScanPanel.ScanEntry)this.scanEntries.get(this.kPosition)).getFirstField().setText(new Double(devHash.get(dev).getFirstValue()).toString());
                ((BaseScanPanel.ScanEntry)this.scanEntries.get(this.kPosition)).getSecondField().setText(new Double(devHash.get(dev).getSecondValue()).toString());
                continue;
            }
            if (dev.compareToIgnoreCase("L") == 0) {
                ((BaseScanPanel.ScanEntry)this.scanEntries.get(this.lPosition)).getFirstField().setText(new Double(devHash.get(dev).getFirstValue()).toString());
                ((BaseScanPanel.ScanEntry)this.scanEntries.get(this.lPosition)).getSecondField().setText(new Double(devHash.get(dev).getSecondValue()).toString());
                continue;
            }
            if (dev.compareToIgnoreCase("E") != 0) continue;
            ((BaseScanPanel.ScanEntry)this.scanEntries.get(this.ePosition)).getFirstField().setText(new Double(devHash.get(dev).getFirstValue()).toString());
            ((BaseScanPanel.ScanEntry)this.scanEntries.get(this.ePosition)).getSecondField().setText(new Double(devHash.get(dev).getSecondValue()).toString());
        }
    }

    @Override
    protected void clearFields() {
        this.eFixedField.setText("");
        this.clearScanDescriptionPanel();
        this.clearParameterPanel();
        this.clearEnvironmentPanel();
        for (BaseScanPanel.ScanEntry entry : this.scanEntries) {
            entry.getFirstField().setText("");
            entry.getSecondField().setText("");
            entry.getInfoLabel1().setText("N/A");
            entry.getInfoLabel2().setText("N/A");
        }
    }

    @Override
    protected String getDescr() {
        String envProperties = this.getEnvironmentDescr();
        String scanName = this.scanNameField.getText().trim();
        if (scanName.length() == 0) {
            logger.debug("No scan name entered.  Save cancelled.");
            this.throwErrorDialog("Incomplete Description", "Please specify a scan name.");
            return "";
        }
        String comments = this.commentsTextArea.getText();
        String prefix = this.prefixField.getText();
        String params = this.getParamDescr();
        if (params == null) {
            return "";
        }
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<Double> firstList = new ArrayList<Double>();
        ArrayList<Double> secondList = new ArrayList<Double>();
        int i = 0;
        while (i < this.scanEntries.size()) {
            try {
                nameList.add(((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getNameLabel().getText());
                firstList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getFirstField().getText().trim()));
                secondList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getSecondField().getText().trim()));
            }
            catch (NumberFormatException nfe) {
                logger.debug("Invalid number in device range " + ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getNameLabel().getText() + ".  Save cancelled: ");
                logger.debug(String.valueOf(i) + " " + ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getFirstField().getText() + " " + ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getSecondField().getText());
                logger.debug(nfe.getMessage());
                this.throwErrorDialog("Input Error", "Please specify valid numbers for device range " + ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getNameLabel().getText() + ".");
                return "";
            }
            ++i;
        }
        Double fixedEnergy = new Double(0.0);
        Integer fixedFlag = 0;
        String fixedString = this.eFixedCB.getSelectedItem().toString();
        if (fixedString.equalsIgnoreCase("Fixed Ef")) {
            fixedFlag = 1;
        } else if (fixedString.equalsIgnoreCase("Fixed Ei")) {
            fixedFlag = 0;
        } else {
            logger.debug("Internal error with eFixedCB.  Save cancelled:");
            this.throwErrorDialog("Error", "Internal error selecting fixed energy.");
            return "";
        }
        try {
            fixedEnergy = Double.valueOf(this.eFixedField.getText().trim());
        }
        catch (NumberFormatException nfe) {
            logger.debug("Blank or invalid number for fixed energy.  Save cancelled:");
            logger.debug(nfe.getMessage());
            this.throwErrorDialog("Input Error", "Please specify a valid value for fixed energy.");
            return "";
        }
        String scanDescr = "Scan:SubID=" + this.exptID + ":JType=VECTOR";
        scanDescr = scanDescr.concat(":Fixed=" + fixedFlag);
        scanDescr = scanDescr.concat(":FixedE=" + fixedEnergy);
        scanDescr = scanDescr.concat(params);
        if (prefix.length() > 0) {
            scanDescr = scanDescr.concat(":Filename=" + prefix);
        }
        String tag = "";
        if (this.mode == 0) {
            tag = " s";
        } else if (this.mode == 1) {
            tag = " i";
        }
        if (envProperties.equals("")) {
            return "";
        }
        if (!envProperties.equals("noSetPoint")) {
            scanDescr = scanDescr.concat(envProperties);
        }
        Double hValue1 = new Double(0.0);
        Double kValue1 = new Double(0.0);
        Double lValue1 = new Double(0.0);
        Double hValue2 = new Double(0.0);
        Double kValue2 = new Double(0.0);
        Double lValue2 = new Double(0.0);
        Double eValue1 = new Double(0.0);
        Double eValue2 = new Double(0.0);
        Integer QandEItemsFound = 0;
        int i2 = 0;
        while (i2 < nameList.size()) {
            if (((String)nameList.get(i2)).equalsIgnoreCase(HTEXT)) {
                hValue1 = (Double)firstList.get(i2);
                hValue2 = (Double)secondList.get(i2);
                QandEItemsFound = QandEItemsFound + 1;
            } else if (((String)nameList.get(i2)).equalsIgnoreCase(KTEXT)) {
                kValue1 = (Double)firstList.get(i2);
                kValue2 = (Double)secondList.get(i2);
                QandEItemsFound = QandEItemsFound + 1;
            } else if (((String)nameList.get(i2)).equalsIgnoreCase(LTEXT)) {
                lValue1 = (Double)firstList.get(i2);
                lValue2 = (Double)secondList.get(i2);
                QandEItemsFound = QandEItemsFound + 1;
            } else if (((String)nameList.get(i2)).equalsIgnoreCase(ETEXT)) {
                eValue1 = (Double)firstList.get(i2);
                eValue2 = (Double)secondList.get(i2);
                QandEItemsFound = QandEItemsFound + 1;
            } else {
                scanDescr = scanDescr.concat(":Range=" + (String)nameList.get(i2) + "=" + firstList.get(i2) + " " + secondList.get(i2) + tag);
                logger.debug(firstList.get(i2) + " " + secondList.get(i2) + tag);
            }
            ++i2;
        }
        if (QandEItemsFound != 4) {
            logger.debug("Incomplete scan description.  Save cancelled:");
            this.throwErrorDialog("Error", "Incomplete scan description.");
            return "";
        }
        scanDescr = scanDescr.concat(":Range=Q=" + hValue1 + "~" + kValue1 + "~" + lValue1 + " " + hValue2 + "~" + kValue2 + "~" + lValue2 + tag);
        scanDescr = scanDescr.concat(":Range=E=" + eValue1 + " " + eValue2 + tag);
        if (comments.length() != 0) {
            scanDescr = scanDescr.concat(":Comment=" + this.getComments(comments));
        }
        return scanDescr;
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }
}

