/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel;

import ice.data.BaseScan;
import ice.data.IceFileType;
import ice.data.InstalledDevice;
import ice.data.InstalledMagnetDevice;
import ice.data.InstalledMiscDevice;
import ice.data.InstalledPressureDevice;
import ice.data.InstalledTempDevice;
import ice.data.Resource;
import ice.event.DeviceListEvent;
import ice.exceptions.IcePanelException;
import ice.gui.tas.bt7.scan.BaseScanPanel;
import ice.swing.Bag;
import ice.util.I18N;
import ice.util.PreferencesManager;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EnvScanPanel
extends BaseScanPanel {
    protected static final boolean deviceFilterFlag = true;
    protected JPanel envPropertiesPanel;
    protected JComboBox envControllerTypeBox;
    protected EnvTemperatureScanPropertiesPanel envTempProperties;
    protected EnvMagnetScanPropertiesPanel envMagnetProperties;
    protected EnvPressureScanPropertiesPanel envPressureProperties;
    protected EnvOtherScanPropertiesPanel envOtherProperties;
    protected Vector<String> envControllerBoxItems;
    protected Vector<InstalledTempDevice> envInstalledTempDevices;
    protected Vector<InstalledMagnetDevice> envInstalledMagnetDevices;
    JTextField a3TextField;
    JTextField a4TextField;
    protected JPanel fixedDevicesPanel;

    public EnvScanPanel(Resource resource) throws IcePanelException {
        super((BaseScan)resource);
        logger.debug("Editing env scan");
        this.setEnvControllerBoxItems();
    }

    @Override
    protected void init() {
        this.eTransferField = new JTextField(6);
        this.eTransferField.getDocument().addDocumentListener(this);
        this.eFixedField = new JTextField(6);
        this.eFixedField.getDocument().addDocumentListener(this);
        String[] fixedE = new String[]{"Fixed Ef", "Fixed Ei"};
        this.eFixedCB = new JComboBox<String>(fixedE);
        this.eFixedCB.addItemListener(this);
        this.hField = new JTextField(6);
        this.hField.getDocument().addDocumentListener(this);
        this.kField = new JTextField(6);
        this.kField.getDocument().addDocumentListener(this);
        this.lField = new JTextField(6);
        this.lField.getDocument().addDocumentListener(this);
        this.a3TextField = new JTextField(6);
        this.a3TextField.getDocument().addDocumentListener(this);
        this.a4TextField = new JTextField(6);
        this.a4TextField.getDocument().addDocumentListener(this);
        this.fixedDevicesPanel = this.createFixedDevicesPanel();
        this.skipDevices = new ArrayList();
        this.skipDevices.add("H");
        this.skipDevices.add("K");
        this.skipDevices.add("L");
        this.skipDevices.add("Ei");
        this.skipDevices.add("Ef");
        this.skipDevices.add("E");
        this.envInstalledTempDevices = new Vector();
        this.envInstalledMagnetDevices = new Vector();
        this.envControllerBoxItems = new Vector();
        this.envControllerTypeBox = new JComboBox<String>(this.envControllerBoxItems);
        this.envTempProperties = new EnvTemperatureScanPropertiesPanel();
        this.envMagnetProperties = new EnvMagnetScanPropertiesPanel();
        this.envPressureProperties = new EnvPressureScanPropertiesPanel();
        this.envOtherProperties = new EnvOtherScanPropertiesPanel();
        this.envPropertiesPanel = new JPanel(new CardLayout());
        this.envControllerTypeBox.addItemListener(new EnvControllerTypeItemListener());
        this.envTempProperties.resetValuesButton.addActionListener(new EnvResetTempDefaultValuesActionListener());
        this.envMagnetProperties.resetValuesButton.addActionListener(new EnvResetMagnetDefaultValuesActionListener());
        this.envPropertiesPanel.setBorder(BorderFactory.createTitledBorder("Properties"));
        this.fillControllers();
        this.createPanels();
    }

    @Override
    public void loadResource() {
        if (this.resource != null && this.resource instanceof BaseScan) {
            this.loadPanels((BaseScan)this.resource);
        }
    }

    private void fillControllers() {
        this.envInstalledTempDevices.clear();
        this.envInstalledMagnetDevices.clear();
        for (InstalledDevice device : this.allDevices) {
            if (device.getType() != InstalledDevice.Type.environment) continue;
            this.addSingleDevice(device.getName(), device.getUnits());
            if (device instanceof InstalledTempDevice) {
                this.envInstalledTempDevices.add((InstalledTempDevice)device);
                continue;
            }
            if (device instanceof InstalledMagnetDevice) {
                this.envInstalledMagnetDevices.add((InstalledMagnetDevice)device);
                continue;
            }
            if (device instanceof InstalledPressureDevice) continue;
            boolean cfr_ignored_0 = device instanceof InstalledMiscDevice;
        }
    }

    private void initLists() {
        this.scanEntries = new ArrayList();
        this.scanEntries_add = new ArrayList();
    }

    @Override
    public void buildGUI() {
        this.setLayout(new GridBagLayout());
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        JLabel instructionsLabel = new JLabel("<html>Setup for a scan of a sample environment parameter, such as <br>temperature, with the sample position held in a fixed position.</html>");
        this.add((Component)instructionsLabel, constraints.cell(x, y));
        this.add((Component)this.instrumentPanel, constraints.cell(x, ++y));
        this.add((Component)this.fixedDevicesPanel, constraints.cell(x, ++y));
        constraints.fill = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        this.add((Component)this.descrPanel, constraints.cellWithoutReset(x, ++y));
        this.add((Component)this.btnPanel, constraints.cell(x, ++y));
    }

    public static IceFileType[] getSupportedFileTypes() {
        IceFileType[] fileTypes = new IceFileType[]{IceFileType.environmentScan};
        return fileTypes;
    }

    @Override
    public void updateAdditionalDevices() {
        this.fixedDevicesPanel = this.createFixedDevicesPanel(this.fixedDevicesPanel);
        this.removeAll();
        this.buildGUI();
        this.validate();
    }

    @Override
    protected JPanel createInstrumentPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        return this.createInstrumentPanel(panel);
    }

    protected JPanel createInstrumentPanel(JPanel instrumentPanel) {
        instrumentPanel.removeAll();
        JLabel leftSpacer = new JLabel("");
        JLabel rightSpacer = new JLabel("");
        int x = 0;
        int y = 0;
        instrumentPanel.setBorder(BorderFactory.createTitledBorder("Environment"));
        Bag instrumentConstraints = new Bag();
        int maxCols = 7;
        instrumentPanel.add((Component)leftSpacer, instrumentConstraints.cell(x, y).fillx(1.0));
        instrumentPanel.add((Component)this.modePanel, instrumentConstraints.cell(++x, y).colspan(maxCols));
        instrumentPanel.add((Component)rightSpacer, instrumentConstraints.cell(x += maxCols, y).fillx(1.0));
        x = 2;
        instrumentPanel.add((Component)this.column1Label, instrumentConstraints.cell(x, ++y));
        instrumentPanel.add((Component)this.column2Label, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)this.column3Label, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)this.column4Label, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)this.createLabel("Units    ", 2), instrumentConstraints.cell(++x, y));
        x = 1;
        ++y;
        Insets defaultInsets = new Insets(instrumentConstraints.insets.top, instrumentConstraints.insets.left, instrumentConstraints.insets.bottom, instrumentConstraints.insets.right);
        Insets unitInsets = new Insets(defaultInsets.top, 0, defaultInsets.bottom, defaultInsets.right);
        int size = this.scanEntries.size();
        int i = 1;
        while (i <= size) {
            instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(i - 1)).getNameLabel(), instrumentConstraints.cell(x, y).inset(defaultInsets));
            instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(i - 1)).getFirstField(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(i - 1)).getSecondField(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(i - 1)).getInfoLabel1(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(i - 1)).getInfoLabel2(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(i - 1)).getUnitLabel(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            ++x;
            ++y;
            x = 1;
            ++i;
        }
        instrumentConstraints.inset(defaultInsets);
        JPanel subPanel = new JPanel();
        Bag subConstraints = new Bag();
        JLabel controllerTypeLabel = new JLabel("Controller Type:");
        JLabel emptyLabel = new JLabel();
        int subX = 0;
        int subY = 0;
        subPanel.setLayout(new GridBagLayout());
        subPanel.add((Component)controllerTypeLabel, subConstraints.cell(subX, subY));
        subPanel.add((Component)this.envControllerTypeBox, subConstraints.cell(++subX, subY));
        subPanel.add((Component)emptyLabel, subConstraints.cell(++subX, subY).fillx());
        x = 0;
        instrumentPanel.add((Component)subPanel, instrumentConstraints.cell(x, y).colspan(maxCols + 2));
        x = 0;
        instrumentPanel.add((Component)this.envPropertiesPanel, instrumentConstraints.cell(x, ++y).colspan(maxCols + 2));
        x = 0;
        instrumentPanel.add((Component)this.parameterPanel, instrumentConstraints.cell(x, ++y).colspan(maxCols + 2));
        if (this.envTempProperties.toleranceField.getText().trim().length() == 0) {
            this.EnvDefaultTemperatureEnvironment();
        }
        if (this.envMagnetProperties.toleranceField.getText().trim().length() == 0) {
            this.EnvDefaultMagnetEnvironment();
        }
        return instrumentPanel;
    }

    protected void setEnvControllerBoxItems() {
        String addTolerance;
        String addController;
        this.envControllerBoxItems.clear();
        this.envControllerBoxItems.add("Please Select Device...");
        this.envPropertiesPanel.add((Component)this.envOtherProperties, "Please Select Device...");
        if (this.envInstalledTempDevices.size() != 0) {
            addController = "Temp (" + this.envInstalledTempDevices.get(0).getRealName() + ")";
            addTolerance = "Tolerance(" + this.envInstalledTempDevices.get(0).getUnits() + "):";
            String addTempName = "Temp (" + this.envInstalledTempDevices.get(0).getRealName() + ")";
            this.envControllerBoxItems.add(addController);
            this.envTempProperties.toleranceLabel.setText(addTolerance);
            this.envPropertiesPanel.add((Component)this.envTempProperties, addTempName);
        }
        if (this.envInstalledMagnetDevices.size() != 0) {
            addController = "Magfield (" + this.envInstalledMagnetDevices.get(0).getRealName() + ")";
            addTolerance = "Tolerance(" + this.envInstalledMagnetDevices.get(0).getUnits() + "):";
            String addMagName = "Magfield (" + this.envInstalledMagnetDevices.get(0).getRealName() + ")";
            this.envControllerBoxItems.add(addController);
            this.envMagnetProperties.toleranceLabel.setText(addTolerance);
            this.envPropertiesPanel.add((Component)this.envMagnetProperties, addMagName);
        }
        if (this.envControllerBoxItems.size() > 1) {
            this.envControllerTypeBox.setSelectedIndex(1);
        } else {
            this.envControllerTypeBox.setSelectedIndex(0);
        }
        this.envControllerTypeBox.updateUI();
    }

    @Override
    public void deviceListUpdated(DeviceListEvent event) {
        String addController;
        this.allDevices = event.getNewList();
        logger.debug("Device list changed " + this.allDevices.size());
        int i = 0;
        while (i < this.scanEntries_add.size()) {
            SwingUtilities.invokeLater(new BaseScanPanel.UpdateDeviceComboBox(this, ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getComboBox(), ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getUnitLabel(), true));
            ++i;
        }
        this.initLists();
        this.fillControllers();
        this.createInstrumentPanel(this.instrumentPanel);
        this.recalculateAllRows();
        SwingUtilities.invokeLater(new BaseScanPanel.RebuildGUI(this));
        String selectedText = (String)this.envControllerTypeBox.getSelectedItem();
        this.envControllerTypeBox.removeAllItems();
        this.envControllerBoxItems.add("Please Select Device...");
        if (this.envInstalledTempDevices.size() != 0) {
            addController = "Temp (" + this.envInstalledTempDevices.get(0).getRealName() + ")";
            this.envControllerBoxItems.add(addController);
        }
        if (this.envInstalledMagnetDevices.size() != 0) {
            addController = "Magfield (" + this.envInstalledMagnetDevices.get(0).getRealName() + ")";
            this.envControllerBoxItems.add(addController);
        }
        if (this.envControllerBoxItems.contains(selectedText)) {
            this.envControllerTypeBox.setSelectedItem(selectedText);
        } else if (this.envControllerBoxItems.size() > 1) {
            this.envControllerTypeBox.setSelectedIndex(1);
        } else {
            this.envControllerTypeBox.setSelectedIndex(0);
        }
    }

    @Override
    protected void loadEnvironmentPanel(BaseScan input) {
        HashMap<String, BaseScan.Range> devHash = input.getDeviceRanges();
        if (input.gettempTolerance() != null) {
            this.envTempProperties.toleranceField.setText(new Double(input.gettempTolerance()).toString());
        }
        if (input.gettempToleranceBT() != null) {
            this.envTempProperties.toleranceBandTimeField.setText(new Double(input.gettempToleranceBT() / 60.0).toString());
        }
        if (input.gettempMaxWaitTime() != null) {
            this.envTempProperties.maxWaitTimeField.setText(new Double(input.gettempMaxWaitTime() / 60.0).toString());
        }
        if (input.getPreScanHold() != null) {
            this.envTempProperties.initialHoldTimeField.setText(new Double(input.getPreScanHold() / 60.0).toString());
        }
        if (input.getPointHold() != null) {
            this.envTempProperties.holdBetweenPointsField.setText(new Double(input.getPointHold() / 60.0).toString());
        }
        if (input.getmagTolerance() != null) {
            this.envMagnetProperties.toleranceField.setText(new Double(input.getmagTolerance()).toString());
        }
        if (input.getPreScanHold() != null) {
            this.envMagnetProperties.initialHoldTimeField.setText(new Double(input.getPreScanHold() / 60.0).toString());
        }
        if (input.getPointHold() != null) {
            this.envMagnetProperties.holdBetweenPointsField.setText(new Double(input.getPointHold() / 60.0).toString());
        }
    }

    @Override
    protected void loadInstrumentPanel(BaseScan input) {
        HashMap<String, BaseScan.Range> devHash = input.getDeviceRanges();
        Set<String> ranges = devHash.keySet();
        Iterator<String> riter = ranges.iterator();
        while (riter.hasNext()) {
            boolean skipit = false;
            String dev = riter.next();
            int i = 0;
            while (i < this.scanEntries.size()) {
                if (dev.compareToIgnoreCase(((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getNameLabel().getText()) == 0) {
                    ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getFirstField().setText(new Double(devHash.get(dev).getFirstValue()).toString());
                    ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getSecondField().setText(new Double(devHash.get(dev).getSecondValue()).toString());
                    skipit = true;
                }
                ++i;
            }
            if (dev.compareToIgnoreCase("H") == 0) {
                this.hField.setText(new Double(devHash.get(dev).getFirstValue()).toString());
            } else if (dev.compareToIgnoreCase("K") == 0) {
                this.kField.setText(new Double(devHash.get(dev).getFirstValue()).toString());
            } else if (dev.compareToIgnoreCase("L") == 0) {
                this.lField.setText(new Double(devHash.get(dev).getFirstValue()).toString());
            } else if (dev.compareToIgnoreCase("E") == 0) {
                this.eTransferField.setText(new Double(devHash.get(dev).getFirstValue()).toString());
            }
            if (skipit) continue;
            this.createAdditionalDevice(true);
            boolean found = false;
            int size = this.scanEntries_add.size();
            int j = 0;
            while (j < ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getComboBox().getItemCount()) {
                if (dev.compareToIgnoreCase(((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getComboBox().getItemAt(j).toString()) == 0) {
                    ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getComboBox().setSelectedIndex(j);
                    found = true;
                }
                ++j;
            }
            if (!found) {
                BaseScanPanel.RemoveAdditionalItem action = new BaseScanPanel.RemoveAdditionalItem(this, size - 1);
                action.run();
                continue;
            }
            ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getFirstField().setText(new Double(devHash.get(dev).getFirstValue()).toString());
            ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getSecondField().setText(new Double(devHash.get(dev).getSecondValue()).toString());
        }
        BaseScan.FixedEnergy efixed = input.getFixedEnergyDevice();
        if (efixed == BaseScan.FixedEnergy.analyzer) {
            this.eFixedCB.setSelectedItem("Fixed Ef");
        } else if (efixed == BaseScan.FixedEnergy.monochromator) {
            this.eFixedCB.setSelectedItem("Fixed Ei");
        }
        Double fixede = input.getFixedEnergy();
        if (fixede != null) {
            this.eFixedField.setText(fixede.toString());
        }
        if (input.gettempTolerance() != null) {
            this.envTempProperties.toleranceField.setText(new Double(input.gettempTolerance()).toString());
        }
        if (input.gettempToleranceBT() != null) {
            this.envTempProperties.toleranceBandTimeField.setText(new Double(input.gettempToleranceBT() / 60.0).toString());
        }
        if (input.gettempMaxWaitTime() != null) {
            this.envTempProperties.maxWaitTimeField.setText(new Double(input.gettempMaxWaitTime() / 60.0).toString());
        }
        if (input.getPreScanHold() != null) {
            this.envTempProperties.initialHoldTimeField.setText(new Double(input.getPreScanHold() / 60.0).toString());
        }
        if (input.getPointHold() != null) {
            this.envTempProperties.holdBetweenPointsField.setText(new Double(input.getPointHold() / 60.0).toString());
        }
        if (input.getmagTolerance() != null) {
            this.envMagnetProperties.toleranceField.setText(new Double(input.getmagTolerance()).toString());
        }
        if (input.getPreScanHold() != null) {
            this.envMagnetProperties.initialHoldTimeField.setText(new Double(input.getPreScanHold() / 60.0).toString());
        }
        if (input.getPointHold() != null) {
            this.envMagnetProperties.holdBetweenPointsField.setText(new Double(input.getPointHold() / 60.0).toString());
        }
        this.fixedDevicesPanel = this.createFixedDevicesPanel();
    }

    protected JPanel createFixedDevicesPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        return this.createFixedDevicesPanel(panel);
    }

    protected JPanel createFixedDevicesPanel(JPanel panel) {
        panel.removeAll();
        JLabel instructionsLabel = new JLabel("<html>Input stationary Q and E or device values for environment scan.<br>If any Q and E field is left blank, these values will be ignored.</html>");
        panel.setBorder(BorderFactory.createTitledBorder("Fixed Devices"));
        Bag constraints = new Bag();
        int numCols = 4;
        int x = 0;
        int y = 0;
        int mainX = 0;
        int mainY = 0;
        panel.add((Component)instructionsLabel, constraints.cell(mainX, mainY).colspan(numCols));
        ++mainY;
        JLabel energyLabel = new JLabel("Et=(Ei-Ef)");
        JLabel units1 = new JLabel("meV");
        JLabel units2 = new JLabel("meV");
        JLabel units3 = new JLabel("meV");
        units3.setForeground(this.getBackground());
        JLabel hklLabel = new JLabel("h, k, l");
        Bag panelConstraints = new Bag();
        JPanel topPanel = new JPanel(new GridBagLayout());
        Insets originalInsets = constraints.insets;
        Insets smallerInsets = new Insets(originalInsets.top, 0, originalInsets.bottom, originalInsets.right);
        Insets largerInsets = new Insets(originalInsets.top, 15, originalInsets.bottom, originalInsets.right);
        topPanel.add((Component)energyLabel, constraints.cell(x, y));
        ++x;
        topPanel.add((Component)this.eTransferField, constraints.cell(++x, y));
        constraints.insets = smallerInsets;
        topPanel.add((Component)units1, constraints.cell(++x, y));
        constraints.insets = largerInsets;
        topPanel.add((Component)this.eFixedCB, constraints.cell(++x, y));
        constraints.insets = originalInsets;
        topPanel.add((Component)this.eFixedField, constraints.cell(++x, y));
        constraints.insets = smallerInsets;
        topPanel.add((Component)units2, constraints.cell(++x, y));
        constraints.insets = originalInsets;
        topPanel.add((Component)new JLabel(""), constraints.cell(++x, y).fillx(1.0));
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        Bag bottom_constraints = new Bag();
        x = 0;
        y = 0;
        bottomPanel.add((Component)hklLabel, bottom_constraints.cell(x, y));
        bottomPanel.add((Component)this.hField, bottom_constraints.cell(++x, y));
        bottomPanel.add((Component)this.kField, bottom_constraints.cell(++x, y));
        bottomPanel.add((Component)this.lField, bottom_constraints.cell(++x, y));
        bottomPanel.add((Component)new JLabel(""), bottom_constraints.cell(++x, y).fillx(1.0));
        panel.add((Component)topPanel, panelConstraints.cell(mainX, mainY).colspan(1));
        panel.add((Component)bottomPanel, panelConstraints.cell(mainX, ++mainY).colspan(1));
        panel.add((Component)new JLabel(""), panelConstraints.cell(mainX, ++mainY).fillx(1.0));
        mainX = 0;
        int size = this.scanEntries_add.size();
        panel.add((Component)new JSeparator(), constraints.cell(mainX, mainY).colspan(numCols));
        ++mainY;
        JPanel addDevPanel = new JPanel(new GridBagLayout());
        Bag addDev_constraints = new Bag();
        int maxCol = 3;
        x = 0;
        y = 0;
        addDevPanel.add((Component)this.createLabel("Additional Devices", 2), addDev_constraints.cell(x, y).colspan(numCols));
        ++y;
        for (BaseScanPanel.ScanEntry entry : this.scanEntries_add) {
            x = 0;
            addDevPanel.add((Component)entry.getComboBox(), addDev_constraints.cell(x, y));
            addDevPanel.add((Component)entry.getFirstField(), addDev_constraints.cell(++x, y));
            addDevPanel.add((Component)entry.getUnitLabel(), addDev_constraints.cell(++x, y));
            addDevPanel.add((Component)entry.getDeleteButton(), addDev_constraints.cell(++x, y));
            addDevPanel.add((Component)new JLabel(""), addDev_constraints.cell(++x, y).fillx(1.0));
            ++y;
        }
        addDevPanel.add((Component)new JLabel(""), addDev_constraints.cell(++x, y).fillx(1.0));
        JPanel addSubPanel = new JPanel();
        addSubPanel.setLayout(new BoxLayout(addSubPanel, 2));
        addSubPanel.add(new JButton(new AddDeviceAction()));
        x = 0;
        addDevPanel.add((Component)addSubPanel, addDev_constraints.cell(x, y).colspan(maxCol));
        panel.add((Component)addDevPanel, constraints.cell(mainX, mainY).colspan(1).west());
        return panel;
    }

    @Override
    protected void clearFields() {
        this.clearScanDescriptionPanel();
        this.clearParameterPanel();
        this.clearEnvironmentPanel();
        int i = 0;
        while (i < this.scanEntries.size()) {
            ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getFirstField().setText("");
            ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getSecondField().setText("");
            ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getInfoLabel1().setText("N/A");
            ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getInfoLabel2().setText("N/A");
            ++i;
        }
        if (this.envInstalledTempDevices.size() != 0) {
            this.envTempProperties.toleranceField.setText("");
            this.envTempProperties.toleranceBandTimeField.setText("");
            this.envTempProperties.maxWaitTimeField.setText("");
            this.envTempProperties.initialHoldTimeField.setText("");
            this.envTempProperties.holdBetweenPointsField.setText("");
        }
        if (this.envInstalledMagnetDevices.size() != 0) {
            this.envMagnetProperties.toleranceField.setText("");
            this.envMagnetProperties.initialHoldTimeField.setText("");
            this.envMagnetProperties.holdBetweenPointsField.setText("");
        }
        this.a3TextField.setText("");
        this.a4TextField.setText("");
        i = 0;
        while (i < this.scanEntries_add.size()) {
            ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getFirstField().setText("");
            ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getSecondField().setText("");
            ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getInfoLabel1().setText("N/A");
            ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getInfoLabel2().setText("N/A");
            ++i;
        }
    }

    protected void EnvDefaultTemperatureEnvironment() {
        this.envTempProperties.toleranceField.setText("");
        this.envTempProperties.toleranceBandTimeField.setText(PreferencesManager.getPreferenceString("environment.temperatureToleranceBandTime"));
        this.envTempProperties.maxWaitTimeField.setText(PreferencesManager.getPreferenceString("environment.temperatureMaxWaitTime"));
        this.envTempProperties.initialHoldTimeField.setText(PreferencesManager.getPreferenceString("environment.temperatureInitialHoldTime"));
        this.envTempProperties.holdBetweenPointsField.setText(PreferencesManager.getPreferenceString("environment.temperatureHoldBetweenPoints"));
        this.envTempProperties.toleranceField.setEnabled(true);
        this.envTempProperties.toleranceBandTimeField.setEnabled(false);
        this.envTempProperties.maxWaitTimeField.setEnabled(false);
        this.envTempProperties.initialHoldTimeField.setEnabled(false);
        this.envTempProperties.holdBetweenPointsField.setEnabled(false);
    }

    protected void EnvDefaultMagnetEnvironment() {
        this.envMagnetProperties.toleranceField.setText("");
        this.envMagnetProperties.initialHoldTimeField.setText(PreferencesManager.getPreferenceString("environment.magnetInitialHoldTime"));
        this.envMagnetProperties.holdBetweenPointsField.setText(PreferencesManager.getPreferenceString("environment.magnetHoldBetweenPoints"));
        this.envMagnetProperties.toleranceField.setEnabled(true);
        this.envMagnetProperties.initialHoldTimeField.setEnabled(false);
        this.envMagnetProperties.holdBetweenPointsField.setEnabled(false);
    }

    protected String getEnvironmentDescription() {
        Double toleranceTemp = 0.0;
        Double toleranceBandTimeTemp = 0.0;
        Double maxWaitTimeTemp = 0.0;
        Double initialHoldTimeTemp = 0.0;
        Double perPointTemp = 0.0;
        Double toleranceMagnet = 0.0;
        Double initialHoldTimeMagnet = 0.0;
        Double perPointMagnet = 0.0;
        String scanDescr = "";
        String presetProperties = "";
        int toleranceTempLength = this.envTempProperties.toleranceField.getText().trim().length();
        if (this.envInstalledTempDevices.size() != 0 && toleranceTempLength != 0) {
            try {
                toleranceTemp = Double.valueOf(this.envTempProperties.toleranceField.getText().trim());
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.toleranceWarning"));
                return "";
            }
            try {
                toleranceBandTimeTemp = Double.valueOf(this.envTempProperties.toleranceBandTimeField.getText().trim()) * 60.0;
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.toleranceBandTimeWarning"));
                return "";
            }
            try {
                maxWaitTimeTemp = Double.valueOf(this.envTempProperties.maxWaitTimeField.getText().trim()) * 60.0;
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.maxWaitTimeWarning"));
                return "";
            }
            try {
                initialHoldTimeTemp = Double.valueOf(this.envTempProperties.initialHoldTimeField.getText().trim()) * 60.0;
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.initialHoldTimeWarning"));
                return "";
            }
            try {
                perPointTemp = Double.valueOf(this.envTempProperties.holdBetweenPointsField.getText().trim()) * 60.0;
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.holdBetweenPointsWarning"));
                return "";
            }
            String deviceName = this.envInstalledTempDevices.get(0).getRealName();
            presetProperties = ":presetdevicesproperties=" + deviceName + " tolerance " + toleranceTemp + ", toleranceDT " + toleranceBandTimeTemp + ", timeout " + maxWaitTimeTemp;
        }
        int toleranceMagLength = this.envMagnetProperties.toleranceField.getText().trim().length();
        if (this.envInstalledMagnetDevices.size() != 0 && toleranceMagLength != 0) {
            try {
                toleranceMagnet = Double.valueOf(this.envMagnetProperties.toleranceField.getText().trim());
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.toleranceWarning"));
                return "";
            }
            try {
                initialHoldTimeMagnet = Double.valueOf(this.envMagnetProperties.initialHoldTimeField.getText().trim()) * 60.0;
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.initialHoldTimeWarning"));
                return "";
            }
            try {
                perPointMagnet = Double.valueOf(this.envMagnetProperties.holdBetweenPointsField.getText().trim()) * 60.0;
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.holdBetweenPointsWarning"));
                return "";
            }
            String deviceName = ((InstalledMagnetDevice)this.installedMagnetDevices.get(0)).getRealName();
            presetProperties = presetProperties.equals("") ? ":presetdevicesproperties=" + deviceName + " tolerance " + toleranceMagnet : String.valueOf(presetProperties) + "|" + deviceName + " tolerance " + toleranceMagnet;
        }
        scanDescr = scanDescr.concat(presetProperties);
        scanDescr = initialHoldTimeTemp > initialHoldTimeMagnet ? scanDescr.concat(":HoldScan=" + initialHoldTimeTemp) : scanDescr.concat(":HoldScan=" + initialHoldTimeMagnet);
        scanDescr = perPointTemp > perPointMagnet ? scanDescr.concat(":HoldPoint=" + perPointTemp) : scanDescr.concat(":HoldPoint=" + perPointMagnet);
        if (this.envInstalledTempDevices.size() != 0 && toleranceTempLength == 0 && this.envInstalledMagnetDevices.size() != 0 && toleranceMagLength == 0) {
            scanDescr = "noTolerance";
        }
        return scanDescr;
    }

    @Override
    protected String getDescr() {
        String bragg;
        String scanName = this.scanNameField.getText().trim();
        if (scanName.length() == 0) {
            logger.debug("No scan name entered.  Save cancelled.");
            this.throwErrorDialog("Incomplete Description", "Please specify a scan name.");
            return "";
        }
        String comments = this.commentsTextArea.getText();
        String prefix = this.prefixField.getText();
        String params = this.getParamDescr();
        if (params == null) {
            return "";
        }
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<Double> firstList = new ArrayList<Double>();
        ArrayList<Double> secondList = new ArrayList<Double>();
        boolean filterFlag = false;
        try {
            int i = 0;
            while (i < this.scanEntries.size()) {
                if (((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getFirstField().getText().trim().length() != 0 || ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getSecondField().getText().trim().length() != 0) {
                    nameList.add(((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getNameLabel().getText());
                    firstList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getFirstField().getText().trim()));
                    secondList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getSecondField().getText().trim()));
                }
                ++i;
            }
            ArrayList<String> filtered = new ArrayList<String>();
            filtered.add("A1");
            filtered.add("A2");
            filtered.add("A3");
            filtered.add("A4");
            filtered.add("A5");
            filtered.add("A6");
            int i2 = 0;
            while (i2 < this.scanEntries_add.size()) {
                if (filtered.contains(((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i2)).getComboBox().getSelectedItem().toString())) {
                    filterFlag = true;
                }
                nameList.add(((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i2)).getComboBox().getSelectedItem().toString());
                firstList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i2)).getFirstField().getText().trim()));
                if (this.mode == 0) {
                    secondList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i2)).getFirstField().getText().trim()));
                } else {
                    secondList.add(new Double(0.0));
                }
                ++i2;
            }
        }
        catch (NumberFormatException nfe) {
            logger.debug("Invalid number in device ranges.  Save cancelled: ");
            logger.debug(nfe.getMessage());
            this.throwErrorDialog("Input Error", "Please specify valid numbers for device ranges.");
            return "";
        }
        String scanDescr = "Scan:SubID=" + this.exptID + ":JType=ENV";
        scanDescr = scanDescr.concat(params);
        if (prefix.length() > 0) {
            scanDescr = scanDescr.concat(":Filename=" + prefix);
        }
        String tag = "";
        if (this.mode == 0) {
            tag = " s";
        } else if (this.mode == 1) {
            tag = " i";
        }
        int i = 0;
        while (i < nameList.size()) {
            scanDescr = scanDescr.concat(":Range=" + (String)nameList.get(i) + "=" + firstList.get(i) + " " + secondList.get(i) + tag);
            logger.debug(String.valueOf((String)nameList.get(i)) + " " + firstList.get(i) + " " + secondList.get(i) + tag);
            ++i;
        }
        String envProperties = this.getEnvironmentDescription();
        if (envProperties.equals("")) {
            return "";
        }
        if (!envProperties.equals("noTolerance")) {
            scanDescr = scanDescr.concat(envProperties);
        }
        if ((bragg = this.getBraggDescr()) != null) {
            if (filterFlag) {
                this.throwErrorDialog("Over-defined scan", "A1 to A6 cannot be selected as additional devices when Q and E are defined.\nPlease resolve the problem and try again.");
                return "";
            }
            scanDescr = scanDescr.concat(bragg);
        } else {
            logger.debug("Empty Q and E info");
        }
        if (comments.length() != 0) {
            scanDescr = scanDescr.concat(":Comment=" + this.getComments(comments));
        }
        return scanDescr;
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    protected class AddDeviceAction
    extends AbstractAction {
        public AddDeviceAction() {
            this.putValue("Name", "Include Another Device in Scan");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            logger.debug("Trying to add a new device");
            EnvScanPanel.this.createAdditionalDevice(true);
            EnvScanPanel.this.fixedDevicesPanel = EnvScanPanel.this.createFixedDevicesPanel();
            EnvScanPanel.this.removeAll();
            EnvScanPanel.this.buildGUI();
            EnvScanPanel.this.invalidate();
        }
    }

    protected class EnvControllerTypeItemListener
    implements ItemListener {
        protected EnvControllerTypeItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            if (ie.getStateChange() == 1) {
                CardLayout cl = (CardLayout)EnvScanPanel.this.envPropertiesPanel.getLayout();
                String theItem = (String)ie.getItem();
                cl.show(EnvScanPanel.this.envPropertiesPanel, theItem);
                cl.invalidateLayout(EnvScanPanel.this.envPropertiesPanel);
            }
        }
    }

    protected class EnvMagnetScanPropertiesPanel
    extends JPanel {
        public JTextField toleranceField;
        public JTextField initialHoldTimeField;
        public JTextField holdBetweenPointsField;
        public JButton resetValuesButton;
        public JLabel toleranceLabel;

        public EnvMagnetScanPropertiesPanel() {
            this.setLayout(new GridBagLayout());
            JLabel initialHoldTimeLabel = new JLabel(I18N.getString("sampleEnvironment.initialHoldTime"));
            JLabel HoldBetweenPointsLabel = new JLabel(I18N.getString("sampleEnvironment.holdBetweenPoints"));
            Bag parameterConstraints = new Bag();
            this.toleranceLabel = new JLabel(I18N.getString("sampleEnvironment.tolerance"));
            this.toleranceField = new JTextField(5);
            this.initialHoldTimeField = new JTextField(5);
            this.holdBetweenPointsField = new JTextField(5);
            this.resetValuesButton = new JButton(I18N.getString("sampleEnvironment.resetValues"));
            this.toleranceField.getDocument().addDocumentListener(new ToleranceDocumentListener());
            this.toleranceField.getDocument().putProperty("name", "magnet");
            int x = 0;
            int y = 0;
            this.add((Component)this.toleranceLabel, parameterConstraints.cell(x, y));
            this.add((Component)this.toleranceField, parameterConstraints.cell(++x, y));
            this.add((Component)initialHoldTimeLabel, parameterConstraints.cell(++x, y));
            this.add((Component)this.initialHoldTimeField, parameterConstraints.cell(++x, y));
            x = 0;
            this.add((Component)HoldBetweenPointsLabel, parameterConstraints.cell(x, ++y));
            this.add((Component)this.holdBetweenPointsField, parameterConstraints.cell(++x, y));
            x = 0;
            this.add((Component)this.resetValuesButton, parameterConstraints.cell(x, ++y));
        }
    }

    protected class EnvOtherScanPropertiesPanel
    extends JPanel {
    }

    protected class EnvPressureScanPropertiesPanel
    extends JPanel {
        public JTextField setPointField;

        public EnvPressureScanPropertiesPanel() {
            this.setLayout(new GridBagLayout());
            JLabel setPointLabel = new JLabel(I18N.getString("sampleEnvironment.setPoint"));
            Bag parameterConstraints = new Bag();
            this.setPointField = new JTextField(5);
            int x = 0;
            int y = 0;
            this.add((Component)setPointLabel, parameterConstraints.cell(x, y));
            this.add((Component)this.setPointField, parameterConstraints.cell(++x, y));
        }
    }

    protected class EnvResetMagnetDefaultValuesActionListener
    implements ActionListener {
        protected EnvResetMagnetDefaultValuesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            EnvScanPanel.this.EnvDefaultMagnetEnvironment();
        }
    }

    protected class EnvResetTempDefaultValuesActionListener
    implements ActionListener {
        protected EnvResetTempDefaultValuesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            EnvScanPanel.this.EnvDefaultTemperatureEnvironment();
        }
    }

    protected class EnvTemperatureScanPropertiesPanel
    extends JPanel {
        public JTextField toleranceField;
        public JTextField toleranceBandTimeField;
        public JTextField maxWaitTimeField;
        public JTextField initialHoldTimeField;
        public JTextField holdBetweenPointsField;
        public JButton resetValuesButton;
        public JLabel toleranceLabel;

        public EnvTemperatureScanPropertiesPanel() {
            this.setLayout(new GridBagLayout());
            JLabel toleranceBandTimeLabel = new JLabel(I18N.getString("sampleEnvironment.toleranceBandTime"));
            JLabel maxWaitTimeLabel = new JLabel(I18N.getString("sampleEnvironment.maxWaitTime"));
            JLabel initialHoldTimeLabel = new JLabel(I18N.getString("sampleEnvironment.initialHoldTime"));
            JLabel HoldBetweenPointsLabel = new JLabel(I18N.getString("sampleEnvironment.holdBetweenPoints"));
            Bag parameterConstraints = new Bag();
            this.holdBetweenPointsField = new JTextField(5);
            this.toleranceField = new JTextField(5);
            this.toleranceBandTimeField = new JTextField(5);
            this.maxWaitTimeField = new JTextField(5);
            this.initialHoldTimeField = new JTextField(5);
            this.resetValuesButton = new JButton(I18N.getString("sampleEnvironment.resetValues"));
            this.toleranceLabel = new JLabel(I18N.getString("sampleEnvironment.tolerance"));
            this.toleranceField.getDocument().addDocumentListener(new ToleranceDocumentListener());
            this.toleranceField.getDocument().putProperty("name", "temperature");
            int x = 0;
            int y = 0;
            this.add((Component)this.toleranceLabel, parameterConstraints.cell(x, y));
            this.add((Component)this.toleranceField, parameterConstraints.cell(++x, y));
            this.add((Component)toleranceBandTimeLabel, parameterConstraints.cell(++x, y));
            this.add((Component)this.toleranceBandTimeField, parameterConstraints.cell(++x, y));
            x = 0;
            this.add((Component)maxWaitTimeLabel, parameterConstraints.cell(x, ++y));
            this.add((Component)this.maxWaitTimeField, parameterConstraints.cell(++x, y));
            this.add((Component)initialHoldTimeLabel, parameterConstraints.cell(++x, y));
            this.add((Component)this.initialHoldTimeField, parameterConstraints.cell(++x, y));
            x = 0;
            this.add((Component)HoldBetweenPointsLabel, parameterConstraints.cell(x, ++y));
            this.add((Component)this.holdBetweenPointsField, parameterConstraints.cell(++x, y));
            x = 0;
            this.add((Component)this.resetValuesButton, parameterConstraints.cell(x, ++y));
        }
    }

    protected class ToleranceDocumentListener
    implements DocumentListener {
        protected ToleranceDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            this.toleranceExists(de);
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            this.toleranceExists(de);
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
        }

        private void toleranceExists(DocumentEvent de) {
            if (de.getDocument().getProperty("name").equals("temperature")) {
                if (EnvScanPanel.this.envTempProperties.toleranceField.getText().length() == 0) {
                    EnvScanPanel.this.envTempProperties.toleranceBandTimeField.setEnabled(false);
                    EnvScanPanel.this.envTempProperties.maxWaitTimeField.setEnabled(false);
                    EnvScanPanel.this.envTempProperties.initialHoldTimeField.setEnabled(false);
                    EnvScanPanel.this.envTempProperties.holdBetweenPointsField.setEnabled(false);
                } else {
                    EnvScanPanel.this.envTempProperties.toleranceBandTimeField.setEnabled(true);
                    EnvScanPanel.this.envTempProperties.maxWaitTimeField.setEnabled(true);
                    EnvScanPanel.this.envTempProperties.initialHoldTimeField.setEnabled(true);
                    EnvScanPanel.this.envTempProperties.holdBetweenPointsField.setEnabled(true);
                }
            } else if (de.getDocument().getProperty("name").equals("magnet")) {
                if (EnvScanPanel.this.envMagnetProperties.toleranceField.getText().length() == 0) {
                    EnvScanPanel.this.envMagnetProperties.initialHoldTimeField.setEnabled(false);
                    EnvScanPanel.this.envMagnetProperties.holdBetweenPointsField.setEnabled(false);
                } else {
                    EnvScanPanel.this.envMagnetProperties.initialHoldTimeField.setEnabled(true);
                    EnvScanPanel.this.envMagnetProperties.holdBetweenPointsField.setEnabled(true);
                }
            }
        }
    }
}

