/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.rangeClasses;

import ice.IconManager;
import ice.data.InstalledDevice;
import ice.gui.core.rangeClasses.RangePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class RangeListPanel
extends JPanel {
    private Logger logger = Logger.getLogger("ScanOperation.RangeListPanel");
    protected JPanel rangeListContainer = new JPanel();
    protected BoxLayout boxLayout = new BoxLayout(this.rangeListContainer, 1);
    protected JScrollPane rangeListContainerScrollPane = new JScrollPane(this.rangeListContainer);
    protected JLabel deleteRangesLabel = new JLabel("Delete all existing scan ranges in the target scan(s)");
    protected JCheckBox deleteRangesCheckBox = new JCheckBox();
    protected JButton addRangeButton = new JButton("Add Range");
    public ArrayList<JPanel> rangePanelContainerList = new ArrayList();
    protected ArrayList<InstalledDevice> deviceList;

    public RangeListPanel(ArrayList<InstalledDevice> deviceList) {
        this.deviceList = this.setupDeviceList(deviceList);
        GridBagLayout gbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setBorder(new TitledBorder("Change Scan Ranges"));
        this.setLayout(gbag);
        gbc.ipady = 10;
        gbc.ipadx = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        BoxLayout boxLayout2 = new BoxLayout(this.rangeListContainer, 1);
        this.rangeListContainer.setLayout(boxLayout2);
        this.rangeListContainerScrollPane.setVerticalScrollBarPolicy(22);
        JPanel deleteCheckBoxContainer = new JPanel();
        deleteCheckBoxContainer.add(this.deleteRangesCheckBox);
        deleteCheckBoxContainer.add(this.deleteRangesLabel);
        this.add((Component)deleteCheckBoxContainer, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 30.0;
        gbc.fill = 1;
        this.add((Component)this.rangeListContainerScrollPane, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 15, 5, 5);
        gbc.fill = 0;
        this.addRangeButton.addActionListener(new addRangeAction());
        gbc.weighty = 0.0;
        this.add((Component)this.addRangeButton, gbc);
        this.addRangePanel();
        this.rangeListContainerScrollPane.updateUI();
    }

    public void addRangePanel() {
        JPanel panelContainer = new JPanel();
        panelContainer.setLayout(new GridBagLayout());
        GridBagConstraints panelConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        JButton deleteButton = new JButton("", IconManager.getIcon("remove21x21"));
        deleteButton.setToolTipText("Delete this item");
        deleteButton.addActionListener(new removeRangePanelAction(panelContainer));
        panelContainer.add((Component)deleteButton, panelConstraints);
        RangePanel rangePanel = new RangePanel(this.deviceList);
        panelConstraints.gridx = 1;
        panelContainer.add((Component)rangePanel, panelConstraints);
        this.rangeListContainer.add(panelContainer);
        this.rangePanelContainerList.add(panelContainer);
        this.rangeListContainer.validate();
        this.rangeListContainer.updateUI();
    }

    public void removeRangePanel(JPanel panel) {
        this.rangeListContainer.remove(panel);
        this.rangePanelContainerList.remove(panel);
        this.rangeListContainer.validate();
        this.rangeListContainer.repaint();
        this.rangeListContainer.updateUI();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.addRangeButton.setEnabled(enabled);
        this.deleteRangesCheckBox.setEnabled(enabled);
        for (JPanel rangePanelContainer : this.rangePanelContainerList) {
            Component[] comps;
            Component[] componentArray = comps = rangePanelContainer.getComponents();
            int n = comps.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                c.setEnabled(enabled);
                ++n2;
            }
            rangePanelContainer.setEnabled(enabled);
        }
    }

    public boolean validateData() {
        for (JPanel rangePanelContainer : this.rangePanelContainerList) {
            Component[] comps;
            Component[] componentArray = comps = rangePanelContainer.getComponents();
            int n = comps.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof RangePanel && !((RangePanel)c).validateData()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public String getErrorText() {
        if (this.validateData()) {
            return "";
        }
        String errorText = "Error in Range Settings: ";
        for (JPanel rangePanelContainer : this.rangePanelContainerList) {
            Component[] comps;
            Component[] componentArray = comps = rangePanelContainer.getComponents();
            int n = comps.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof RangePanel) {
                    errorText = String.valueOf(errorText) + ((RangePanel)c).getErrorText() + "  ";
                }
                ++n2;
            }
        }
        return errorText;
    }

    public String getRangeText() {
        String rangeText = "";
        for (JPanel rangePanelContainer : this.rangePanelContainerList) {
            Component[] comps;
            Component[] componentArray = comps = rangePanelContainer.getComponents();
            int n = comps.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof RangePanel) {
                    rangeText = String.valueOf(rangeText) + "," + ((RangePanel)c).getRangeText();
                }
                ++n2;
            }
        }
        if (this.deleteRangesCheckBox.isSelected()) {
            rangeText = "  -DELETERANGES " + rangeText.substring(1);
        }
        return rangeText;
    }

    protected ArrayList<InstalledDevice> setupDeviceList(ArrayList<InstalledDevice> deviceList) {
        ArrayList<InstalledDevice> newDeviceList = new ArrayList<InstalledDevice>(deviceList);
        for (InstalledDevice device : deviceList) {
            if (device.getType() == InstalledDevice.Type.counter) {
                newDeviceList.remove(device);
            }
            if (!device.getName().equals("HKL") && !device.getName().equals("H") && !device.getName().equals("K") && !device.getName().equals("L")) continue;
            newDeviceList.remove(device);
        }
        newDeviceList.add(0, new InstalledDevice("Qz", "", ""));
        newDeviceList.add(0, new InstalledDevice("Qy", "", ""));
        newDeviceList.add(0, new InstalledDevice("Qx", "", ""));
        newDeviceList.add(0, new InstalledDevice("Q", "", ""));
        return newDeviceList;
    }

    protected class addRangeAction
    implements ActionListener {
        protected addRangeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                RangeListPanel.this.addRangePanel();
            }
            catch (Exception e) {
                RangeListPanel.this.logger.error("Error performing action for add button");
            }
        }
    }

    protected class removeRangePanelAction
    implements ActionListener {
        public JPanel panelToRemove;

        public removeRangePanelAction(JPanel panel) {
            this.panelToRemove = panel;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                RangeListPanel.this.removeRangePanel(this.panelToRemove);
            }
            catch (Exception e) {
                RangeListPanel.this.logger.error("Error performing action for add button");
            }
        }
    }
}

