/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.controls.serverFileView;

import ice.Controller;
import ice.communication.SendQueueManager;
import ice.data.IceFile;
import ice.data.ScanList;
import ice.gui.core.controls.serverFileView.data.ScanFolder;
import ice.swing.IceFileTableModel;
import ice.swing.IceFileTree;
import ice.swing.IceFileTreeCellRenderer;
import ice.swing.ResourceMgrTreeModel;
import ice.swing.datatransfer.IceFileTreeTransferHandler;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ServerFolderView
extends JPanel
implements TreeSelectionListener,
MouseListener {
    public static final ValidServerFolders default_selection_folder = ValidServerFolders.EXPT;
    private SendQueueManager sendManager = null;
    private IceFileTree fileTree = null;
    private ResourceMgrTreeModel fileTreeModel = null;
    private IceFileTableModel iceFileTableModel = null;
    private ViewTypes viewType = null;
    protected static final String FOLDER_LABEL = "Folder";

    public ServerFolderView(ViewTypes viewType) {
        this.init(viewType, default_selection_folder);
    }

    public ServerFolderView(ViewTypes viewType, ValidServerFolders defaultFolder) {
        this.init(viewType, defaultFolder);
    }

    private ServerFolderView(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.init(ViewTypes.BOTH, default_selection_folder);
    }

    private ServerFolderView(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.init(ViewTypes.BOTH, default_selection_folder);
    }

    private ServerFolderView(LayoutManager layout) {
        super(layout);
        this.init(ViewTypes.BOTH, default_selection_folder);
    }

    protected void init(ViewTypes viewType, ValidServerFolders defaultFolder) {
        this.viewType = viewType;
        this.buildGUI(defaultFolder);
    }

    protected void buildGUI(ValidServerFolders defaultFolder) {
        Controller controller = null;
        IceFile rootFile = null;
        ScanList scanList = null;
        JPanel foldersContainerPanel = null;
        GridBagConstraints foldersConstraints = null;
        GridBagConstraints gridBagConstraints = null;
        JLabel folderLabel = null;
        GridBagLayout gridBagLayout = null;
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        controller = Controller.getReference();
        this.sendManager = controller.getSendManager();
        rootFile = controller.getRootFile();
        scanList = controller.getServerScanList();
        switch (this.viewType) {
            case SCAN_ONLY: {
                ScanFolder scanFolder = new ScanFolder();
                this.fileTreeModel = new ResourceMgrTreeModel(scanFolder, scanList);
                break;
            }
            case NO_SCAN: {
                this.fileTreeModel = new ResourceMgrTreeModel(rootFile, scanList, true);
                break;
            }
            case BOTH: {
                this.fileTreeModel = new ResourceMgrTreeModel(rootFile, scanList);
                break;
            }
        }
        this.fileTree = new IceFileTree(this.fileTreeModel, this.sendManager);
        this.fileTree.setCellRenderer(new IceFileTreeCellRenderer());
        this.fileTree.setTransferHandler(new IceFileTreeTransferHandler(this.sendManager));
        this.fileTree.addTreeSelectionListener(this);
        this.fileTree.addMouseListener(this);
        foldersContainerPanel = new JPanel();
        gridBagLayout = new GridBagLayout();
        foldersContainerPanel.setLayout(gridBagLayout);
        foldersConstraints = new GridBagConstraints();
        folderLabel = new JLabel(FOLDER_LABEL);
        folderLabel.setBorder(new BevelBorder(0));
        foldersConstraints.anchor = 18;
        foldersConstraints.weightx = 1.0;
        foldersConstraints.weighty = 0.0;
        foldersConstraints.insets = new Insets(0, 0, 0, 0);
        foldersConstraints.gridx = 0;
        foldersConstraints.gridy = 0;
        foldersConstraints.fill = 2;
        foldersContainerPanel.add((Component)folderLabel, foldersConstraints);
        foldersConstraints.gridy = 1;
        foldersConstraints.fill = 1;
        foldersConstraints.weighty = 1.0;
        foldersConstraints.gridheight = 3;
        foldersContainerPanel.add((Component)this.fileTree, foldersConstraints);
        JScrollPane scrollPanel = new JScrollPane(foldersContainerPanel, 20, 30);
        scrollPanel.getVerticalScrollBar().setUnitIncrement(7);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)scrollPanel, gridBagConstraints);
        this.setDefaultSelectedFolder(defaultFolder);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
    }

    protected IceFile getSelectedFolder() {
        IceFile returnValue = null;
        TreePath selectionPath = this.fileTree.getSelectionPath();
        if (selectionPath != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            Object object = node.getUserObject();
            if (object instanceof IceFile) {
                returnValue = (IceFile)object;
            } else if (object instanceof String && object.equals("Server Scan List")) {
                returnValue = new ScanFolder();
            }
        }
        return returnValue;
    }

    protected void setDefaultSelectedFolder(ValidServerFolders defaultFolder) {
        String folderName = defaultFolder.getTextValue();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.fileTreeModel.getRoot();
        DefaultMutableTreeNode expFolder = this.findNodeByName(root, folderName);
        if (expFolder != null) {
            TreePath treePath = this.getTreePath(expFolder);
            this.fileTree.setSelectionPath(treePath);
        }
    }

    public TreePath getTreePath(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        while (node != null) {
            list.add(node);
            node = node.getParent();
        }
        Collections.reverse(list);
        return new TreePath(list.toArray());
    }

    private DefaultMutableTreeNode findNodeByName(TreeNode root, String dirName) {
        DefaultMutableTreeNode defaultFolder = null;
        if (root == null) {
            return null;
        }
        int index = this.fileTreeModel.getChildCount(root);
        if (index == 0) {
            return null;
        }
        int i = 0;
        while (i < index) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.fileTreeModel.getChild(root, i);
            IceFile iceFile = (IceFile)node.getUserObject();
            String folderName = iceFile.getName();
            if (folderName.equals(dirName)) {
                defaultFolder = node;
            }
            ++i;
        }
        return defaultFolder;
    }

    public void addTreeSelectionListener(TreeSelectionListener tel) {
        this.fileTree.addTreeSelectionListener(tel);
    }

    public static enum ValidServerFolders {
        EXPT("EXPT"),
        USER("USER"),
        SCAN("SCAN"),
        COMM("COMM");

        private String textValue;

        private ValidServerFolders(String textValue) {
            this.textValue = textValue;
        }

        public String getTextValue() {
            return this.textValue;
        }
    }

    public static enum ViewTypes {
        SCAN_ONLY,
        NO_SCAN,
        BOTH;

    }
}

