/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.controls.serverFileView;

import ice.Controller;
import ice.communication.SendQueueManager;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.data.ScanList;
import ice.gui.core.controls.serverFileView.communication.FileSelectionChangedListener;
import ice.gui.core.controls.serverFileView.communication.FileSelectionDoubleClickListener;
import ice.gui.core.controls.serverFileView.data.ScanFolder;
import ice.swing.IceFileTableModel;
import ice.swing.IceFileTree;
import ice.swing.ResourceMgrTreeModel;
import ice.swing.ScanTableModel;
import ice.swing.datatransfer.ResourceTableTransferHandler;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.PatternFilter;

public class ServerFileView
extends JPanel
implements MouseListener {
    private SendQueueManager sendManager = null;
    private IceFileTree fileTree = null;
    private ResourceMgrTreeModel fileTreeModel = null;
    private JXTable fileTable = null;
    private IceFileTableModel iceFileTableModel = null;
    private ArrayList<FileSelectionDoubleClickListener> fileSelectionDoubleClickListeners = null;
    private ArrayList<FileSelectionChangedListener> fileSelectionChangedListeners = null;
    private ScanTableModel scanTableModel;
    protected String regex;

    public ServerFileView() {
        this.init();
    }

    public ServerFileView(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.init();
    }

    public ServerFileView(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.init();
    }

    public ServerFileView(LayoutManager layout) {
        super(layout);
        this.init();
    }

    protected void init() {
        this.fileSelectionDoubleClickListeners = new ArrayList();
        this.fileSelectionChangedListeners = new ArrayList();
        this.buildGUI();
    }

    protected void buildGUI() {
        GridBagConstraints fileTableConstraints = null;
        GridBagLayout gridBagLayout = null;
        JScrollPane scrollPane = null;
        Controller controller = null;
        IceFile rootFile = null;
        ScanList scanList = null;
        this.fileTable = new JXTable();
        this.fileTable.setShowGrid(false);
        this.setFilter(null);
        controller = Controller.getReference();
        this.sendManager = controller.getSendManager();
        rootFile = controller.getRootFile();
        scanList = controller.getServerScanList();
        this.scanTableModel = new ScanTableModel(scanList);
        this.iceFileTableModel = new IceFileTableModel(rootFile);
        this.fileTable.setTransferHandler(new ResourceTableTransferHandler(this.sendManager));
        this.fileTable.addMouseListener(this);
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        fileTableConstraints = new GridBagConstraints();
        fileTableConstraints.anchor = 18;
        fileTableConstraints.weightx = 1.0;
        fileTableConstraints.weighty = 1.0;
        fileTableConstraints.gridx = 0;
        fileTableConstraints.gridy = 0;
        fileTableConstraints.fill = 1;
        scrollPane = new JScrollPane(this.fileTable);
        this.add((Component)scrollPane, fileTableConstraints);
        this.setSelectionMode(0);
        this.setDragEnabled(false);
    }

    public void setFilter(String regex) {
        if (regex != null) {
            this.regex = regex;
            this.fileTable.setFilters(null);
            Filter[] filters = new Filter[]{new PatternFilter(regex, 0, 0)};
            FilterPipeline filterPipeline = new FilterPipeline(filters);
            this.fileTable.setFilters(filterPipeline);
        } else {
            this.fileTable.setFilters(null);
        }
    }

    public void addFileSelectionChangedListener(FileSelectionChangedListener theListener) {
        if (theListener != null) {
            this.fileSelectionChangedListeners.add(theListener);
        }
    }

    public void removeFileSelectionChangedListener(FileSelectionChangedListener theListener) {
        if (theListener != null) {
            this.fileSelectionChangedListeners.remove(theListener);
        }
    }

    public void addFileSelectionDoubleClickListener(FileSelectionDoubleClickListener theListener) {
        if (theListener != null) {
            this.fileSelectionDoubleClickListeners.add(theListener);
        }
    }

    public void removeFileSelectionDoubleClickListener(FileSelectionDoubleClickListener theListener) {
        if (theListener != null) {
            this.fileSelectionDoubleClickListeners.remove(theListener);
        }
    }

    protected void notifyFileSelectionDoubleClickListener(Object theFile) {
        for (FileSelectionDoubleClickListener theListener : this.fileSelectionDoubleClickListeners) {
            theListener.fileSelectionDoubleClick(theFile);
        }
    }

    protected void notifyFileSelectionChangedListeners(Object theFile) {
        for (FileSelectionChangedListener theListener : this.fileSelectionChangedListeners) {
            theListener.fileSelectionChanged(theFile);
        }
    }

    public void setSelectionMode(int selectionMode) {
        this.fileTable.setSelectionMode(selectionMode);
    }

    public void setDragEnabled(boolean dragEnabled) {
        this.fileTable.setDragEnabled(dragEnabled);
    }

    public void setIceFolderToView(IceFile iceFolder) {
        boolean magicWord = false;
        String name = iceFolder.getName();
        boolean isRoot = name.equals("/");
        magicWord = iceFolder.isMagicWord();
        if (iceFolder instanceof ScanFolder) {
            this.fileTable.setModel(this.scanTableModel);
        } else if (magicWord) {
            this.setFilter(null);
            this.iceFileTableModel.setRoot(iceFolder);
            this.fileTable.setModel(this.iceFileTableModel);
            this.setFilter(this.regex);
        } else if (isRoot) {
            this.setFilter(null);
            this.fileTable.setModel(new IceFileTableModel(new IceFile("/", IceFileType.directory)));
        }
        this.fileTable.setSortable(false);
        this.fileTable.setSortable(true);
        this.fileTable.updateUI();
    }

    public Object getSelectedIceItem() {
        Object iceFile = null;
        int selectedRow = -1;
        Object object = null;
        selectedRow = this.fileTable.getSelectedRow();
        if (selectedRow > -1 && (object = this.fileTable.getValueAt(selectedRow, 0)) != null) {
            iceFile = object;
        }
        return iceFile;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int clickCount = -1;
        Object sourceOfEvent = null;
        sourceOfEvent = e.getSource();
        if (sourceOfEvent == this.fileTable) {
            Object selectedIceFile = null;
            selectedIceFile = this.getSelectedIceItem();
            if (selectedIceFile != null) {
                this.notifyFileSelectionChangedListeners(selectedIceFile);
                clickCount = e.getClickCount();
                if (e.getButton() == 1 && clickCount == 2) {
                    this.notifyFileSelectionDoubleClickListener(selectedIceFile);
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public class FilteredJXTable
    extends JXTable {
        protected String fileExtensionFilter = null;

        public String getFileExtensionFilter() {
            return this.fileExtensionFilter;
        }

        public void setFileExtensionFilter(String fileExtensionFilter) {
            this.fileExtensionFilter = fileExtensionFilter;
        }

        @Override
        public void setModel(TableModel arg0) {
            super.setModel(arg0);
        }
    }
}

