/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.controlPanel;

import ice.data.tas.bt7.Instrument;
import ice.gui.core.controlPanel.ControlPanelFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InstrumentStatusPanel
extends JPanel {
    public static String defaultValue = "N/A      ";
    private TreeMap<String, String> displayMap;
    Instrument instrument;

    public InstrumentStatusPanel(Instrument inst) {
        this.instrument = inst;
        this.displayMap = ControlPanelFactory.getPropertyMap(inst);
        if (this.displayMap != null) {
            this.BuildGUI(this.displayMap);
        }
    }

    public InstrumentStatusPanel(Instrument inst, TreeMap<String, String> displayMap) {
        this.instrument = inst;
        this.displayMap = displayMap;
        this.BuildGUI(displayMap);
    }

    private void BuildGUI(TreeMap<String, String> dispayMap) {
        this.setLayout(new GridBagLayout());
        int y = 0;
        for (Map.Entry<String, String> entry : this.displayMap.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            this.AddPropertyLabel(name, value, y++);
        }
    }

    public JLabel getPropertyLabel(String name) {
        Component[] components;
        Component[] componentArray = components = this.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JLabel && c.getName().equals(name)) {
                return (JLabel)c;
            }
            ++n2;
        }
        return null;
    }

    public void setPropertyLabel(String name, String value) {
        Component[] components;
        Component[] componentArray = components = this.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JLabel && c.getName().equals(name)) {
                ((JLabel)c).setText(value);
            }
            ++n2;
        }
    }

    public void AddPropertyLabel(String name, String value, int y) {
        JLabel nameLabel = new JLabel(name);
        nameLabel.setName("label");
        nameLabel.setHorizontalAlignment(2);
        JLabel valueLabel = new JLabel(value);
        valueLabel.setName(name);
        valueLabel.setBackground(new Color(230, 230, 250));
        valueLabel.setOpaque(true);
        valueLabel.setPreferredSize(new Dimension(50, 15));
        valueLabel.setBorder(BorderFactory.createLineBorder(Color.gray));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.insets = new Insets(1, 1, 1, 1);
        int x = 0;
        if (y == -1) {
            y = this.getComponentCount() / 2;
        }
        constraints.gridx = x++;
        constraints.gridy = y;
        this.add((Component)nameLabel, constraints);
        constraints.gridx = x;
        constraints.weightx = 1.0;
        constraints.ipadx = 40;
        constraints.gridy = y;
        this.add((Component)valueLabel, constraints);
    }
}

