/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core;

import ice.Controller;
import ice.communication.SendQueueManager;
import ice.data.BaseScan;
import ice.data.InstalledDevice;
import ice.gui.core.rangeClasses.RangeListPanel;
import ice.util.I18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DefaultStyledDocument;

public class EditMultipleScansDialog
extends JDialog
implements ItemListener {
    private ArrayList<BaseScan> scans;
    private SendQueueManager sendManager;
    private HashMap<JCheckBox, JComponent> enableMap;
    private JCheckBox numPointsCheckBox;
    private JTextField numPointsField;
    private JCheckBox baseCountCheckBox;
    private JTextField baseCountField;
    private JCheckBox prefactorCheckBox;
    private JTextField prefactorField;
    private JCheckBox dataOfInterestCheckBox;
    private JComboBox dataOfInterestComboBox;
    private JCheckBox countTypeCheckBox;
    private JComboBox countTypeComboBox;
    protected ArrayList<InstalledDevice> deviceList;
    protected RangeListPanel rangeListPanel;
    protected JCheckBox enableRangeCheckbox = new JCheckBox();

    public EditMultipleScansDialog(JFrame parent, ArrayList<BaseScan> scans) {
        super((Frame)parent, true);
        Controller controller = Controller.getReference();
        this.sendManager = controller.getSendManager();
        this.scans = scans;
        this.deviceList = controller.getDeviceList();
        String[] dataOfInterest = new String[]{"Detector", "Monitor"};
        String[] countType = new String[]{"Monitor", "Time"};
        this.numPointsCheckBox = new JCheckBox(I18N.getString("numPoints.label"));
        this.baseCountCheckBox = new JCheckBox(I18N.getString("baseCount.label"));
        this.prefactorCheckBox = new JCheckBox(I18N.getString("prefactor.label"));
        this.dataOfInterestCheckBox = new JCheckBox(I18N.getString("dataOfInterest.label"));
        this.countTypeCheckBox = new JCheckBox(I18N.getString("countType.label"));
        this.numPointsField = new JTextField(6);
        this.baseCountField = new JTextField(6);
        this.prefactorField = new JTextField(6);
        this.dataOfInterestComboBox = new JComboBox<String>(dataOfInterest);
        this.countTypeComboBox = new JComboBox<String>(countType);
        this.enableMap = new HashMap();
        this.numPointsCheckBox.addItemListener(this);
        this.baseCountCheckBox.addItemListener(this);
        this.prefactorCheckBox.addItemListener(this);
        this.dataOfInterestCheckBox.addItemListener(this);
        this.countTypeCheckBox.addItemListener(this);
        this.numPointsField.setName("npts");
        this.baseCountField.setName("counts");
        this.prefactorField.setName("prefac");
        this.dataOfInterestComboBox.setName("detector");
        this.countTypeComboBox.setName("counttype");
        this.buildEnableMap();
        this.buildInterface();
        this.initialize();
    }

    private void buildEnableMap() {
        this.enableMap.put(this.numPointsCheckBox, this.numPointsField);
        this.enableMap.put(this.baseCountCheckBox, this.baseCountField);
        this.enableMap.put(this.prefactorCheckBox, this.prefactorField);
        this.enableMap.put(this.dataOfInterestCheckBox, this.dataOfInterestComboBox);
        this.enableMap.put(this.countTypeCheckBox, this.countTypeComboBox);
    }

    private void buildInterface() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 10, 0, 10);
        constraints.weightx = 1.0;
        constraints.weighty = 10.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        contentPane.add((Component)this.buildHeaderPanel(), constraints);
        constraints.gridy = 1;
        constraints.gridx = 0;
        constraints.weighty = 30.0;
        contentPane.add((Component)this.buildRangePanel(), constraints);
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        contentPane.add((Component)this.buildInputPanel(), constraints);
        constraints.gridy = 3;
        constraints.anchor = 14;
        constraints.fill = 2;
        contentPane.add((Component)this.buildButtonPanel(), constraints);
        this.setTitle("Scan Operation: Change parameters of scan(s)");
        this.pack();
        contentPane.validate();
        contentPane.updateUI();
    }

    private JPanel buildHeaderPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(new GridBagLayout());
        headerPanel.add((Component)new JLabel("<html><h2>Scan Operation</h2></html>"), constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(10, 10, 10, 10);
        headerPanel.add((Component)new JLabel(" "), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.anchor = 13;
        headerPanel.add((Component)new JLabel("Target scans: "), constraints);
        constraints.anchor = 17;
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        JList<BaseScan> targetScans = new JList<BaseScan>(new Vector<BaseScan>(this.scans));
        targetScans.setEnabled(false);
        JScrollPane targetScansScroll = new JScrollPane(targetScans);
        headerPanel.add((Component)targetScansScroll, constraints);
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.insets = new Insets(10, 10, 0, 0);
        constraints.gridwidth = 3;
        String instructionsString = "Set changes below to make to the target scans.  Your changes will not be fully checked for correctness, so be careful to avoid errors which may break your scans.";
        JTextArea instructionsText = new JTextArea();
        instructionsText.setBackground(headerPanel.getBackground());
        instructionsText.setRows(2);
        instructionsText.setColumns(30);
        instructionsText.setEditable(false);
        instructionsText.setWrapStyleWord(true);
        instructionsText.setLineWrap(true);
        instructionsText.setDocument(new DefaultStyledDocument());
        instructionsText.setText(instructionsString);
        instructionsText.setForeground(Color.BLACK);
        headerPanel.add((Component)instructionsText, constraints);
        constraints.insets = new Insets(0, 10, 0, 0);
        this.pack();
        headerPanel.updateUI();
        headerPanel.validate();
        return headerPanel;
    }

    private JPanel buildRangePanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        JPanel rangePanel = new JPanel();
        rangePanel.setLayout(gridbag);
        constraints.anchor = 18;
        constraints.fill = 1;
        GridBagConstraints enabledConstraints = new GridBagConstraints();
        enabledConstraints.anchor = 18;
        this.rangeListPanel = new RangeListPanel(this.deviceList);
        this.rangeListPanel.setEnabled(this.enableRangeCheckbox.isSelected());
        this.enableRangeCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                EditMultipleScansDialog.this.rangeListPanel.setEnabled(EditMultipleScansDialog.this.enableRangeCheckbox.isSelected());
            }
        });
        JLabel enableRangeLabel = new JLabel("<html><h3>Change range(s)</h3></html>");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weighty = 0.0;
        rangePanel.add((Component)this.enableRangeCheckbox, constraints);
        ++constraints.gridx;
        constraints.weightx = 10.0;
        rangePanel.add((Component)enableRangeLabel, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weighty = 10.0;
        rangePanel.add((Component)this.rangeListPanel, constraints);
        return rangePanel;
    }

    private JPanel buildInputPanel() {
        JPanel panel = new JPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 18;
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Change Scan Properties"));
        panel.add((Component)this.numPointsCheckBox, constraints);
        ++constraints.gridy;
        panel.add((Component)this.baseCountCheckBox, constraints);
        ++constraints.gridy;
        panel.add((Component)this.prefactorCheckBox, constraints);
        ++constraints.gridx;
        constraints.gridy = 0;
        panel.add((Component)this.numPointsField, constraints);
        ++constraints.gridy;
        panel.add((Component)this.baseCountField, constraints);
        ++constraints.gridy;
        panel.add((Component)this.prefactorField, constraints);
        ++constraints.gridx;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        panel.add((Component)new JLabel(), constraints);
        constraints.insets = new Insets(10, 40, 0, 0);
        constraints.gridwidth = 1;
        ++constraints.gridx;
        constraints.gridy = 0;
        panel.add((Component)this.dataOfInterestCheckBox, constraints);
        ++constraints.gridy;
        panel.add((Component)this.countTypeCheckBox, constraints);
        constraints.insets = new Insets(0, 0, 0, 0);
        ++constraints.gridx;
        constraints.gridy = 0;
        panel.add((Component)this.dataOfInterestComboBox, constraints);
        ++constraints.gridy;
        panel.add((Component)this.countTypeComboBox, constraints);
        return panel;
    }

    private JPanel buildButtonPanel() {
        FlowLayout flayout = new FlowLayout(2);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(flayout);
        JButton okBtn = new JButton(new SaveAction());
        JButton cancelBtn = new JButton(new CancelAction());
        btnPanel.add(okBtn);
        btnPanel.add(cancelBtn);
        return btnPanel;
    }

    private void initialize() {
        this.numPointsField.setEnabled(false);
        this.baseCountField.setEnabled(false);
        this.prefactorField.setEnabled(false);
        this.dataOfInterestComboBox.setEnabled(false);
        this.countTypeComboBox.setEnabled(false);
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        boolean enable = false;
        if (1 == ie.getStateChange()) {
            enable = true;
        }
        try {
            this.enableMap.get(ie.getItem()).setEnabled(enable);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            EditMultipleScansDialog.this.dispose();
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("OK");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                if (EditMultipleScansDialog.this.enableRangeCheckbox.isSelected() && !EditMultipleScansDialog.this.rangeListPanel.validateData()) {
                    String errorText = EditMultipleScansDialog.this.rangeListPanel.getErrorText();
                    if (errorText.length() > 150) {
                        errorText = String.valueOf(errorText.substring(0, 149)) + "...";
                    }
                    JOptionPane.showMessageDialog(EditMultipleScansDialog.this, "<html><p>" + errorText + "</p></html>", "Error in Scan Operation", 0);
                    return;
                }
                String parameterSettings = this.buildParameterString();
                String scansToModify = this.buildScanString();
                if (parameterSettings.length() > 0 && scansToModify.length() > 0) {
                    parameterSettings = parameterSettings.substring(1);
                    scansToModify = scansToModify.substring(1);
                    String command = "scan operation \"" + scansToModify + "\" " + parameterSettings;
                    EditMultipleScansDialog.this.sendManager.addMessage(command);
                    EditMultipleScansDialog.this.dispose();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private String buildParameterString() throws NumberFormatException {
            String parameterSettings = "";
            if (EditMultipleScansDialog.this.enableRangeCheckbox.isSelected()) {
                parameterSettings = String.valueOf(parameterSettings) + EditMultipleScansDialog.this.rangeListPanel.getRangeText();
            }
            for (JCheckBox checkbox : EditMultipleScansDialog.this.enableMap.keySet()) {
                if (!checkbox.isSelected()) continue;
                String value = null;
                String parameter = null;
                JComponent comp = (JComponent)EditMultipleScansDialog.this.enableMap.get(checkbox);
                if (comp instanceof JTextField) {
                    JTextField field = (JTextField)comp;
                    parameter = field.getName();
                    try {
                        value = Integer.valueOf(field.getText()).toString();
                    }
                    catch (NumberFormatException nfe) {
                        String title = "Invalid Value";
                        String message = "\"" + field.getText() + "\" is not a valid value.";
                        JOptionPane.showMessageDialog(EditMultipleScansDialog.this, message, title, 0);
                        throw nfe;
                    }
                    parameterSettings = String.valueOf(parameterSettings) + "," + parameter + "=" + value;
                    continue;
                }
                if (!(comp instanceof JComboBox)) continue;
                JComboBox combobox = (JComboBox)comp;
                parameter = combobox.getName();
                value = (String)combobox.getSelectedItem();
                parameterSettings = String.valueOf(parameterSettings) + "," + parameter + "=" + value;
            }
            return parameterSettings;
        }

        private String buildScanString() {
            String scansToModify = "";
            Iterator iterator = EditMultipleScansDialog.this.scans.iterator();
            while (iterator.hasNext()) {
                String scanName = ((BaseScan)iterator.next()).getName();
                scansToModify = String.valueOf(scansToModify) + "," + scanName;
            }
            return scansToModify;
        }
    }
}

