/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.ImmediateCommand;

public class StackAddCommand
extends ImmediateCommand {
    private String queueCommandString = null;
    private long commandID = 0L;
    private static final String responseIDLabel = "(commandID=";

    public StackAddCommand(String command) throws NoClientAPIInstanceException {
        super("STACK ADD " + command.replace("\"", "&quot;"));
        this.queueCommandString = command.replace("\"", "&quot;");
    }

    public StackAddCommand(String command, ClientAPI clientApiRef) {
        super("STACK ADD " + command.replace("\"", "&quot;"), clientApiRef);
        this.queueCommandString = command.replace("\"", "&quot;");
    }

    @Override
    public synchronized String generateCommandString() {
        String cmd = "STACK ADD \"" + this.queueCommandString.replace("\"", "&quot;") + "\"";
        this.setCommandString(cmd);
        return cmd;
    }

    @Override
    protected synchronized void parseSynchronousResponse() {
        if (this.getResponse().startsWith("Queued")) {
            this.setCommandID(Long.valueOf(this.getResponse().substring(this.getResponse().indexOf(responseIDLabel) + responseIDLabel.length(), this.getResponse().indexOf(")", this.getResponse().indexOf(responseIDLabel)))));
            this.setSuccess(this.getCommandID() > 0L);
            this.setError(false);
        } else {
            this.setSuccess(false);
            this.setError(true);
        }
    }

    public String getQueueCommandString() {
        return this.queueCommandString;
    }

    void setQueueCommandString(String queueCommandString) {
        this.queueCommandString = queueCommandString.replace("\"", "&quot;");
        this.generateCommandString();
    }

    protected void setCommandID(long id) {
        this.commandID = id;
    }

    public long getCommandID() {
        return this.commandID;
    }
}

