/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.QueuedCommand;

public class DeviceDestroyCommand
extends QueuedCommand {
    private static String command = "Device Destroy";
    protected ErrorType errorType = ErrorType.UNKNOWN;
    protected String deviceName;

    public DeviceDestroyCommand() throws NoClientAPIInstanceException {
    }

    public DeviceDestroyCommand(String deviceName, ClientAPI clientApiRef) {
        super("", clientApiRef);
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public DeviceDestroyCommand(String deviceName) throws NoClientAPIInstanceException {
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString(String.valueOf(command) + " " + this.deviceName);
        return this.getCommandString();
    }

    @Override
    protected void parseSynchronousResponse() {
        String expectedResponse;
        String response;
        if (this.parseOneLineResponse() && (response = this.getResponse()).compareToIgnoreCase(expectedResponse = "Called Destroy for device [" + this.deviceName + "]") != 0) {
            this.setError(true);
            this.setSuccess(false);
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    private static enum ErrorType {
        UNKNOWN;

    }
}

