/*
 * Decompiled with CFR 0.152.
 */
package ice.clientAPI;

import java.util.Date;

public class Message<k> {
    private k msg = null;
    private long commandId = 0L;
    private MessageType type = MessageType.UNKNOWN;
    private Date timestamp = null;
    private static final String commandIdMessageStart = "(commandId=";

    public Date getTimestamp() {
        return this.timestamp;
    }

    void setTimestamp(Date newTimestamp) {
        this.timestamp = newTimestamp;
    }

    public void setLastAccess() {
        this.timestamp = new Date();
    }

    public static int parseForCommandId(String message) {
        if (message.contains(commandIdMessageStart)) {
            String s = message.substring(message.indexOf(commandIdMessageStart) + commandIdMessageStart.length());
            try {
                return Integer.valueOf(s.substring(0, s.indexOf(")")));
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
        }
        return 0;
    }

    public Message(k msg) {
        this.msg = msg;
        this.commandId = Message.parseForCommandId(msg.toString());
    }

    public Message(k msg, int commandId) {
        this.msg = msg;
        this.commandId = commandId;
    }

    public Message(k msg, int commandId, MessageType type) {
        this.msg = msg;
        this.commandId = commandId;
        this.type = type;
    }

    public k getMessageContent() {
        return this.msg;
    }

    public long getCommandId() {
        return this.commandId;
    }

    public MessageType getMessageType() {
        return this.type;
    }

    public String getMessageString() {
        return this.msg.toString();
    }

    public String toString() {
        return this.getMessageString();
    }

    public void setCommandId(int commandId) {
        this.commandId = commandId;
    }

    public static enum MessageType {
        UNKNOWN,
        ERROR,
        DATA,
        STATUS,
        CLIENT,
        BROADCAST,
        OUTGOING;

    }
}

