/*
 * Decompiled with CFR 0.152.
 */
package ice;

import ice.event.IceClientErrorEvent;
import ice.event.IceClientErrorListener;
import ice.event.IceClientInfoEvent;
import ice.event.IceClientInfoListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class IceClientNotifier
implements IceClientErrorListener,
IceClientInfoListener {
    private static IceClientNotifier reference;
    private static final String ERROR_TITLE = "Ice Client Error";
    private static final String INFO_TITLE = "Ice Client Message";
    private JTextArea errorTextArea;
    private JTextArea infoTextArea;
    private JOptionPane optionPane;
    private JDialog errorDialog;
    private JDialog infoDialog;

    public static IceClientNotifier getReference() {
        if (reference == null) {
            reference = new IceClientNotifier();
        }
        return reference;
    }

    private IceClientNotifier() {
        this.init();
    }

    private void init() {
        this.errorTextArea = new JTextArea();
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setOpaque(true);
        this.errorTextArea.setBackground(Color.WHITE);
        this.errorTextArea.setLineWrap(true);
        this.errorTextArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(this.errorTextArea);
        scrollPane.setPreferredSize(new Dimension(400, 100));
        this.optionPane = new JOptionPane(scrollPane, 0);
        this.errorDialog = this.optionPane.createDialog(null, ERROR_TITLE);
        this.errorDialog.setModal(false);
        this.infoTextArea = new JTextArea();
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setOpaque(true);
        this.infoTextArea.setBackground(Color.WHITE);
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setWrapStyleWord(true);
        scrollPane = new JScrollPane(this.infoTextArea);
        scrollPane.setPreferredSize(new Dimension(400, 100));
        this.optionPane = new JOptionPane(scrollPane, 1);
        this.infoDialog = this.optionPane.createDialog(null, INFO_TITLE);
        this.infoDialog.setModal(false);
    }

    private void showErrorDialog(Component parent, String message) {
        SwingUtilities.invokeLater(new UpdateErrorDialog(parent, message));
    }

    private void showInfoDialog(Component parent, String message) {
        SwingUtilities.invokeLater(new UpdateInfoDialog(parent, message));
    }

    public void showIcePanelError(Component comp, Exception e) {
        String message = this.getException(e);
        this.showErrorDialog(comp, message);
    }

    public void showIcePanelError(Exception e) {
        String message = this.getException(e);
        this.showErrorDialog(null, message);
    }

    public void showIcePanelError(String error) {
        this.showErrorDialog(null, error);
    }

    public void showIcePanelError(Component parent, String error) {
        this.showErrorDialog(parent, error);
    }

    public void showIcePanelInfo(Component parent, String message) {
        this.showInfoDialog(parent, message);
    }

    private String getException(Exception e) {
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        return w.toString();
    }

    @Override
    public void messageOccured(IceClientInfoEvent ipe) {
        Component source = null;
        if (ipe.getSource() instanceof Component) {
            source = (Component)ipe.getSource();
        }
        String message = ipe.getMessage();
        this.showIcePanelInfo(source, message);
    }

    @Override
    public void errorOccured(IceClientErrorEvent ipe) {
        Component source = null;
        if (ipe.getSource() instanceof Component) {
            source = (Component)ipe.getSource();
        }
        Exception e = ipe.getException();
        this.showIcePanelError(source, e);
    }

    protected class UpdateErrorDialog
    implements Runnable {
        private String text;
        private Component parent;

        public UpdateErrorDialog(Component parent, String text) {
            this.text = text;
            this.parent = parent;
        }

        @Override
        public void run() {
            if (this.text != null) {
                IceClientNotifier.this.errorTextArea.setText(this.text);
                int position = IceClientNotifier.this.errorTextArea.getText().length() - 1;
                IceClientNotifier.this.errorTextArea.setCaretPosition(position);
                if (!IceClientNotifier.this.errorDialog.isVisible()) {
                    IceClientNotifier.this.errorDialog.setLocationRelativeTo(this.parent);
                    IceClientNotifier.this.errorDialog.setVisible(true);
                }
            }
        }
    }

    protected class UpdateInfoDialog
    implements Runnable {
        private String text;
        private Component parent;

        public UpdateInfoDialog(Component parent, String text) {
            this.text = text;
            this.parent = parent;
        }

        @Override
        public void run() {
            if (this.text != null) {
                IceClientNotifier.this.infoTextArea.setText(this.text);
                int position = IceClientNotifier.this.infoTextArea.getText().length() - 1;
                IceClientNotifier.this.infoTextArea.setCaretPosition(position);
                if (!IceClientNotifier.this.infoDialog.isVisible()) {
                    IceClientNotifier.this.infoDialog.setLocationRelativeTo(this.parent);
                    IceClientNotifier.this.infoDialog.setVisible(true);
                }
            }
        }
    }
}

