/*
 * Decompiled with CFR 0.152.
 */
package ice;

import ice.Global;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public class FileClassLoader
extends ClassLoader {
    private static final Logger logger = Logger.getLogger("ErrorLogger");
    private static final String path = Global.getConfigPath();
    private static final String separator = Global.separator;

    @Override
    public URL getResource(String name) {
        String prefix = Global.getInstrumentName();
        File file = new File(String.valueOf(path) + separator + prefix + name);
        if (file.exists()) {
            try {
                logger.error("File (" + file.getAbsolutePath() + ")  exists");
                return file.toURI().toURL();
            }
            catch (MalformedURLException mue) {
                logger.error("Unable to convert file to URL.  Returning null.", mue);
            }
        } else {
            logger.error("File (" + file.getAbsolutePath() + ") doesn't exist");
        }
        return null;
    }
}

