/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.DaemonInputStream;
import hep.io.root.daemon.xrootd.Session;
import hep.io.root.daemon.xrootd.XrootdInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;

public class XrootdURLConnection
extends URLConnection {
    private String username;
    private String password;
    private String auth;
    private int bufferSize = 0;
    private long date;
    private long fSize;
    private int flags;
    private static Logger logger = Logger.getLogger("hep.io.root.daemon.xrootd");
    public static final String XROOT_AUTHORIZATION_SCHEME = "scheme";
    public static final String XROOT_AUTHORIZATION_SCHEME_ANONYMOUS = "anonymous";
    public static final String XROOT_AUTHORIZATION_USER = "user";
    public static final String XROOT_AUTHORIZATION_PASSWORD = "password";
    public static final String XROOT_BUFFER_SIZE = "bufferSize";
    private Session session;
    private int openStreamCount;

    XrootdURLConnection(URL url) {
        super(url);
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        DaemonInputStream stream = this.session.openStream(this.url.getFile(), 0, 16);
        ((XrootdInputStream)stream).setConnection(this);
        ++this.openStreamCount;
        return stream;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.auth == null) {
            this.auth = System.getProperty("root.scheme");
        }
        if (this.auth != null && this.auth.equalsIgnoreCase(XROOT_AUTHORIZATION_SCHEME_ANONYMOUS)) {
            this.username = XROOT_AUTHORIZATION_SCHEME_ANONYMOUS;
            try {
                this.password = System.getProperty("user.name") + "@" + InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (SecurityException x) {
                this.password = "freehep-user@freehep.org";
            }
        }
        if (this.username == null) {
            this.username = System.getProperty("root.user");
        }
        if (this.password == null) {
            this.password = System.getProperty("root.password");
        }
        if ((this.password == null || this.username == null) && this.getAllowUserInteraction()) {
            PasswordAuthentication pa;
            int port = this.url.getPort();
            if (port == -1) {
                port = 1094;
            }
            if ((pa = Authenticator.requestPasswordAuthentication(this.url.getHost(), null, port, "root", "Username/Password required", this.auth)) != null) {
                this.username = pa.getUserName();
                this.password = new String(pa.getPassword());
            }
        }
        if (this.password == null || this.username == null) {
            throw new IOException("Authorization Required");
        }
        logger.fine("Opening rootd connection to: " + this.url);
        this.session = new Session(this.url.getHost(), this.url.getPort(), this.username);
        try {
            if (this.bufferSize != 0) {
                this.session.setBufferSize(this.bufferSize);
            }
            String[] fstat = this.session.stat(this.url.getFile());
            this.fSize = Long.parseLong(fstat[1]);
            this.flags = Integer.parseInt(fstat[2]);
            this.date = Long.parseLong(fstat[3]) * 1000L;
            this.connected = true;
        }
        catch (IOException t) {
            this.disconnect();
            throw t;
        }
    }

    public void disconnect() throws IOException {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        this.connected = false;
    }

    public int getContentLength() {
        if (this.session == null) {
            return -1;
        }
        return (int)this.fSize;
    }

    public long getLastModified() {
        if (this.session == null) {
            return 0L;
        }
        return this.date;
    }

    public long getDate() {
        return this.getLastModified();
    }

    public long getCheckSum() throws IOException {
        if (this.session == null) {
            return -1L;
        }
        String result = this.session.query(3, this.url.getFile());
        String[] split = result.split(" ");
        return Long.parseLong(split[1]);
    }

    public void setRequestProperty(String key, String value) {
        if (key.equalsIgnoreCase(XROOT_AUTHORIZATION_USER)) {
            this.username = value;
        } else if (key.equalsIgnoreCase(XROOT_AUTHORIZATION_PASSWORD)) {
            this.password = value;
        } else if (key.equalsIgnoreCase(XROOT_AUTHORIZATION_SCHEME)) {
            this.auth = value;
        } else if (key.equalsIgnoreCase(XROOT_BUFFER_SIZE)) {
            this.bufferSize = Integer.parseInt(value);
        }
    }

    void streamClosed() throws IOException {
        --this.openStreamCount;
        if (this.openStreamCount == 0) {
            this.disconnect();
        }
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }
}

