/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClass;
import hep.io.root.RootMember;
import hep.io.root.core.BasicRootClass;
import hep.io.root.core.ClassBuilder;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.NameMangler;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;

public class InterfaceBuilder
implements ClassBuilder,
Constants {
    private NameMangler nameMangler = NameMangler.instance();

    public String getStem() {
        return "hep.io.root.interfaces";
    }

    public JavaClass build(GenericRootClass klass) {
        int checkSum;
        RootClass[] superClasses = klass.getSuperClasses();
        String[] superClassNames = new String[superClasses.length + 1];
        superClassNames[0] = "hep.io.root.RootObject";
        for (int i = 0; i < superClasses.length; ++i) {
            superClassNames[i + 1] = this.nameMangler.mangleClass(superClasses[i].getClassName());
        }
        ClassGen cg = new ClassGen(this.nameMangler.mangleClass(klass.getClassName()), "java/lang/Object", "<generated>", 1537, superClassNames);
        ConstantPoolGen cp = cg.getConstantPool();
        RootMember[] members = klass.getMembers();
        for (int i = 0; i < members.length; ++i) {
            RootClass rootClass = members[i].getType();
            if (!(rootClass instanceof BasicRootClass)) continue;
            Type type = ((BasicRootClass)rootClass).getJavaType();
            MethodGen mg = new MethodGen(1025, type, null, null, this.nameMangler.mangleMember(members[i].getName()), null, null, cp);
            cg.addMethod(mg.getMethod());
        }
        int version = klass.getVersion();
        if (version > 0) {
            FieldGen fg = new FieldGen(25, Type.INT, "rootIOVersion", cp);
            fg.setInitValue(version);
            cg.addField(fg.getField());
        }
        if ((checkSum = klass.getCheckSum()) > 0) {
            FieldGen fg = new FieldGen(25, Type.INT, "rootCheckSum", cp);
            fg.setInitValue(checkSum);
            cg.addField(fg.getField());
        }
        return cg.getJavaClass();
    }
}

