/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IFitFactory;
import hep.aida.IFitResult;
import hep.aida.IFunction;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import hep.aida.test.AidaTestCase;
import java.util.Random;
import junit.framework.Assert;

public class TestFitter
extends AidaTestCase {
    public TestFitter(String testName) {
        super(testName);
    }

    public void testFitters() {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree temp = af.createTreeFactory().create();
        IFitFactory ff = af.createFitFactory();
        IHistogramFactory hf = af.createHistogramFactory(temp);
        IHistogram1D hist = hf.createHistogram1D("test", 100, -5.0, 5.0);
        Random r = this.getRandomNumberGenerator();
        for (int j = 0; j < 10000; ++j) {
            hist.fill(r.nextGaussian());
        }
        String[] fitterNames = ff.availableFitEngines();
        for (int i = 0; i < fitterNames.length; ++i) {
            String fitterName = fitterNames[i];
            double[] initPars = new double[]{hist.maxBinHeight(), hist.mean(), hist.rms()};
            IFitResult result = ff.createFitter("chi2", fitterName).fit((IBaseHistogram)hist, "g", initPars);
            IFunction fitted = result.fittedFunction();
            String str = "** " + fitterName + " : ";
            Assert.assertTrue(str, result.isValid());
            Assert.assertEquals(str, fitted.parameter("mean"), hist.mean(), 0.1);
            Assert.assertEquals(str, Math.abs(fitted.parameter("sigma")), hist.rms(), 0.1);
            Assert.assertEquals(str, fitted.parameter("amplitude"), hist.maxBinHeight(), 0.1 * hist.maxBinHeight());
        }
    }
}

