/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.client;

import hep.aida.IManagedObject;
import hep.aida.ref.remote.RemoteClient;
import hep.aida.ref.remote.RemoteManagedObject;
import hep.aida.ref.remote.RemoteMutableStore;
import hep.aida.ref.remote.rmi.client.RmiRemoteClient;
import hep.aida.ref.remote.rmi.converters.RmiConverter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.freehep.util.FreeHEPLookup;
import org.openide.util.Lookup;

public class RmiMutableStore
extends RemoteMutableStore {
    private Map converters;

    public RmiMutableStore() {
        this.init();
    }

    public void init() {
        super.init();
        this.converters = new Hashtable();
    }

    protected RemoteClient createClient(Map options) {
        RmiRemoteClient client = null;
        String rmiBindName = null;
        boolean duplex = true;
        if (options == null || options.isEmpty()) {
            throw new IllegalArgumentException("No information about AidaTreeServer, options empty");
        }
        Iterator it = options.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)options.get(key);
            this.remoteLogger.fine("RmiMutableStore.createClient: Key = " + key + " \tValue = " + value);
            if (key.equalsIgnoreCase("rmiBindName")) {
                rmiBindName = value;
                continue;
            }
            if (key.equalsIgnoreCase("duplex")) {
                if (value.equalsIgnoreCase("true")) {
                    duplex = true;
                    continue;
                }
                duplex = false;
                continue;
            }
            if (!key.equalsIgnoreCase("hurry")) continue;
            if (value.equalsIgnoreCase("true")) {
                this.setHurry(true);
                continue;
            }
            this.setHurry(false);
        }
        client = new RmiRemoteClient(this, duplex, options);
        return client;
    }

    public IManagedObject createObject(String name, String aidaType) throws IllegalArgumentException {
        this.remoteLogger.finest("RmiMutableStore.createObject:     path=" + name + ",   type=" + aidaType);
        RmiConverter converter = this.findConverter(aidaType);
        IManagedObject mo = (IManagedObject)converter.createAidaObject(name);
        if (mo instanceof RemoteManagedObject) {
            ((RemoteManagedObject)mo).setStore(this);
        }
        return mo;
    }

    public void updateData(String path, String aidaType) throws IllegalArgumentException {
        this.remoteLogger.finest("RmiMutableStore.updateData:     path=" + path + ",   type=" + aidaType);
        try {
            RmiConverter converter = this.findConverter(aidaType);
            IManagedObject mo = this.tree.find(path);
            Object data = this.client.find(path);
            converter.updateAidaObject(mo, data);
            this.remoteLogger.finest("RmiMutableStore.updateData:     path=" + path + ",   type=" + aidaType + ", data=" + data);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() throws IOException {
        super.close();
        this.converters.clear();
    }

    private RmiConverter findConverter(String aidaType) {
        RmiConverter converter = null;
        if (this.converters.containsKey(aidaType)) {
            converter = (RmiConverter)this.converters.get(aidaType);
        } else {
            Lookup.Template template = new Lookup.Template(RmiConverter.class, aidaType, null);
            Lookup.Item item = FreeHEPLookup.instance().lookupItem(template);
            if (item == null) {
                throw new IllegalArgumentException("No Converter for AIDA Type: " + aidaType);
            }
            converter = (RmiConverter)item.getInstance();
            this.converters.put(aidaType, converter);
        }
        return converter;
    }
}

