/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.corba;

import hep.aida.ref.remote.corba.CorbaTreeServantImpl;
import hep.aida.ref.remote.corba.converters.CorbaDataPointSetDConverter;
import hep.aida.ref.remote.corba.converters.CorbaHist1DConverter;
import hep.aida.ref.remote.corba.generated.TreeClient;
import hep.aida.ref.remote.corba.generated.TreeServant;
import hep.aida.ref.remote.corba.generated.TreeServantHelper;
import hep.aida.ref.remote.corba.generated.TreeServerPOA;
import hep.aida.ref.tree.Tree;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import org.freehep.util.FreeHEPLookup;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public class CorbaTreeServerImpl
extends TreeServerPOA
implements Runnable {
    private Tree tree;
    private String treeName;
    private ORB orb;
    private POA rootPOA;
    private Hashtable objectHash;
    private String iorFileName = "/afs/slac.stanford.edu/u/ey/serbo/public_html/jas3/TreeServer.ior";

    public CorbaTreeServerImpl(String treeName, Tree tree) {
        System.out.println("\tStarting CorbaTreeServer with Tree Name: " + treeName);
        this.tree = tree;
        this.treeName = treeName;
        this.objectHash = new Hashtable();
        FreeHEPLookup.instance().add((java.lang.Object)CorbaHist1DConverter.getInstance(), "IHistogram1D");
        FreeHEPLookup.instance().add((java.lang.Object)CorbaDataPointSetDConverter.getInstance(), "IDataPointSet");
        new Thread(this).start();
    }

    private TreeServant connect(java.lang.Object clientRef) {
        System.out.println("New connection from Client:  " + clientRef);
        TreeServant servantRef = null;
        CorbaTreeServantImpl servant = (CorbaTreeServantImpl)this.objectHash.get(clientRef);
        if (servant == null) {
            if (clientRef instanceof String) {
                servant = new CorbaTreeServantImpl(this.orb, this.tree);
            } else if (clientRef instanceof TreeClient) {
                servant = new CorbaTreeServantImpl(this.orb, this.tree, (TreeClient)clientRef);
            }
            try {
                Object obfRef = this.rootPOA.servant_to_reference((Servant)servant);
                servantRef = TreeServantHelper.narrow(obfRef);
            }
            catch (Exception t) {
                t.printStackTrace();
                return null;
            }
            this.objectHash.put(clientRef, servant);
        }
        return servantRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean disconnect(java.lang.Object clientRef) {
        System.out.println("\tDisconnecting Client: " + clientRef);
        Hashtable hashtable = this.objectHash;
        synchronized (hashtable) {
            if (this.objectHash.containsKey(clientRef)) {
                CorbaTreeServantImpl servant = (CorbaTreeServantImpl)this.objectHash.get(clientRef);
                try {
                    byte[] id = this.rootPOA.servant_to_id((Servant)servant);
                    this.rootPOA.deactivate_object(id);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                servant.close();
                this.objectHash.remove(clientRef);
                return true;
            }
        }
        return false;
    }

    public String treeName() {
        return this.treeName;
    }

    public boolean supportDuplexMode() {
        return true;
    }

    public TreeServant connectDuplex(TreeClient client) {
        return this.connect(client);
    }

    public TreeServant connectNonDuplex(String clientID) {
        return this.connect(clientID);
    }

    public boolean disconnectDuplex(TreeClient client) {
        return this.disconnect(client);
    }

    public boolean disconnectNonDuplex(String clientID) {
        return this.disconnect(clientID);
    }

    public void run() {
        System.out.println("\tStarting ORB");
        try {
            String[] orbArgs = new String[]{};
            this.orb = ORB.init((String[])orbArgs, null);
            Object objRef = this.orb.resolve_initial_references("RootPOA");
            this.rootPOA = POAHelper.narrow((Object)objRef);
            this.rootPOA.the_POAManager().activate();
            Object obfRef = this.rootPOA.servant_to_reference((Servant)this);
            String ref = this.orb.object_to_string(obfRef);
            File f = new File(this.iorFileName);
            PrintWriter out = new PrintWriter(new FileWriter(f));
            out.print(ref);
            out.close();
            System.out.println("Wrote TreeServer REF into file " + this.iorFileName);
            System.out.println("TreeServer is ready,  IOR Reference:");
            System.out.println("\n" + ref);
            this.orb.run();
        }
        catch (Exception t) {
            t.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        System.out.print("Shutting down TreeServer ... ");
        CorbaTreeServerImpl corbaTreeServerImpl = this;
        synchronized (corbaTreeServerImpl) {
            if (!this.objectHash.isEmpty()) {
                Iterator it = this.objectHash.values().iterator();
                while (it.hasNext()) {
                    CorbaTreeServantImpl servant = (CorbaTreeServantImpl)it.next();
                    servant.close();
                    try {
                        byte[] id = this.rootPOA.servant_to_id((Servant)servant);
                        this.rootPOA.deactivate_object(id);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.objectHash.clear();
            }
            this.objectHash = null;
            this.tree = null;
            this.treeName = null;
            this.orb.shutdown(true);
            this.orb.destroy();
            this.orb = null;
            this.rootPOA = null;
        }
        System.out.print(" Done!\n");
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

