/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.editor;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import hep.aida.IAnalysisFactory;
import hep.aida.IBaseStyle;
import hep.aida.IHistogram1D;
import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.BaseStyle;
import hep.aida.ref.plotter.style.editor.ConfigurePreviewPanel;
import hep.aida.ref.plotter.style.editor.StylePreviewCreator;
import hep.aida.ref.plotter.style.editor.StyleTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class StyleEditorPanel
extends JSplitPane
implements TreeSelectionListener,
PropertyChangeListener {
    private String title;
    private IPlotterStyle style;
    private JComboBox previewTypeBox;
    private Class previewType = IHistogram1D.class;
    private JTree styleTree;
    private DefaultTreeModel styleModel;
    private StylePreviewCreator stylePreviewCreator;
    private JSplitPane rightPanel;
    private boolean previewFitRegion = true;
    private JCheckBox showPreviewCheckBox;
    private JComponent previewPanel;
    private int previewDividerLocation = 250;
    private PropertySheetPanel currentStylePanel;

    static boolean isAnyParameterSet(BaseStyle style) {
        return StyleEditorPanel.isAnyParameterSet(style, true);
    }

    static boolean isAnyParameterSet(BaseStyle style, boolean recursive) {
        boolean isSet = false;
        if (style == null) {
            return false;
        }
        String[] parNames = style.availableParameters();
        if (parNames != null) {
            String name;
            for (int i = 0; i < parNames.length && ((name = parNames[i]).equals("plotterStyleName") || !(isSet = style.isParameterSet(name, recursive))); ++i) {
            }
        }
        if (!isSet && recursive) {
            IBaseStyle[] children = style.children();
            if (children == null) {
                return false;
            }
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof BaseStyle) || !StyleEditorPanel.isAnyParameterSet((BaseStyle)children[i], recursive)) continue;
                isSet = true;
                break;
            }
        }
        return isSet;
    }

    public StyleEditorPanel(IPlotterStyle style) {
        this("Plotter Style Editor", style, new ConfigurePreviewPanel(), StylePreviewCreator.getPossiblePreviewTypes()[0]);
    }

    public StyleEditorPanel(IPlotterStyle style, Class previewType) {
        this("Plotter Style Editor", style, new ConfigurePreviewPanel(), previewType);
    }

    public StyleEditorPanel(IPlotterStyle style, ConfigurePreviewPanel configurePanel) {
        this("Plotter Style Editor", style, configurePanel, StylePreviewCreator.getPossiblePreviewTypes()[0]);
    }

    public StyleEditorPanel(IPlotterStyle style, ConfigurePreviewPanel configurePanel, Class previewType) {
        this("Plotter Style Editor", style, configurePanel, previewType);
    }

    public StyleEditorPanel(String title, IPlotterStyle style, ConfigurePreviewPanel configurePanel, Class previewType) {
        super(1);
        this.title = title;
        this.init(style, configurePanel, previewType);
    }

    public IPlotterStyle getStyle() {
        return this.style;
    }

    public void setPreviewVisible(boolean b) {
        this.showPreviewCheckBox.setSelected(b);
    }

    public boolean isPreviewVisible() {
        return this.showPreviewCheckBox.isSelected();
    }

    public void setCurrentPreviewPanelDimension(Dimension d) {
        this.previewFitRegion = d.width < 0 && d.height < 0;
        this.stylePreviewCreator.setPreviewPanelDimension(d);
        this.updatePreview();
    }

    public Dimension getCurrentPreviewPanelDimension() {
        return this.previewPanel.getComponent(1).getSize();
    }

    public void setupEditorPanel(ConfigurePreviewPanel configurePanel) {
        this.stylePreviewCreator.setupPreviewCreator(configurePanel);
        Dimension d = null;
        if (configurePanel == null || configurePanel.previewFitRegion) {
            d = new Dimension(-1, -1);
            this.previewFitRegion = true;
        } else {
            d = new Dimension(configurePanel.previewWidth, configurePanel.previewHeight);
            this.previewFitRegion = false;
        }
        this.setCurrentPreviewPanelDimension(d);
    }

    public void clear() {
        if (this.styleTree != null) {
            this.styleTree.removeTreeSelectionListener(this);
        }
    }

    public void setPreviewType(Class previewType) {
        this.previewTypeBox.setSelectedItem(previewType.getName());
    }

    void executeSetPreviewType(Class previewType) {
        this.previewType = previewType;
        this.updatePreview();
    }

    public Class getPreviewType() {
        return this.previewType;
    }

    public void updatePreview() {
        Dimension d = null;
        if (this.showPreviewCheckBox.isSelected()) {
            JComponent newComponent = this.stylePreviewCreator.getPreviewPanel(this.style, this.previewType);
            newComponent.setMaximumSize(d);
            newComponent.setPreferredSize(d);
            if (this.rightPanel.getBottomComponent() != null) {
                this.previewDividerLocation = this.rightPanel.getDividerLocation();
            }
            this.rightPanel.setBottomComponent(newComponent);
            this.rightPanel.setDividerLocation(this.previewDividerLocation);
            this.previewPanel = newComponent;
        }
    }

    private void init(IPlotterStyle ps, ConfigurePreviewPanel configurePanel, Class previewType) {
        this.style = ps;
        this.previewType = previewType;
        this.showPreviewCheckBox = new JCheckBox("Show Preview ");
        this.showPreviewCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                boolean selected = ((JCheckBox)ev.getSource()).isSelected();
                StyleEditorPanel.this.setPreviewVisibleAction(selected);
            }
        });
        Class[] possibleTypes = StylePreviewCreator.getPossiblePreviewTypes();
        String[] possibleTypesString = new String[possibleTypes.length];
        for (int i = 0; i < possibleTypes.length; ++i) {
            possibleTypesString[i] = possibleTypes[i].getName();
        }
        this.previewTypeBox = new JComboBox<String>(possibleTypesString);
        this.previewTypeBox.setSelectedItem(previewType.getName());
        this.previewTypeBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    try {
                        Class<?> pt = Class.forName((String)evt.getItem());
                        StyleEditorPanel.this.executeSetPreviewType(pt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        Object d = null;
        JPanel toolsPanel = new JPanel(new FlowLayout(0));
        toolsPanel.setBorder(new EtchedBorder());
        toolsPanel.add(this.showPreviewCheckBox);
        toolsPanel.add(this.previewTypeBox);
        this.createStyleTree(ps);
        this.rightPanel = new JSplitPane(0);
        this.previewPanel = null;
        this.rightPanel.setBottomComponent(this.previewPanel);
        this.rightPanel.setDividerLocation(this.previewDividerLocation);
        JPanel superRightPanel = new JPanel();
        superRightPanel.setLayout(new BoxLayout(superRightPanel, 1));
        superRightPanel.add(toolsPanel);
        this.rightPanel.setTopComponent(superRightPanel);
        this.setBorder(new TitledBorder(new EtchedBorder(), this.title));
        this.setRightComponent(this.rightPanel);
        this.setDividerLocation(200);
        this.stylePreviewCreator = new StylePreviewCreator(configurePanel);
        this.previewFitRegion = configurePanel.previewFitRegion;
        this.styleTree.expandRow(0);
        this.styleTree.setSelectionRow(0);
        this.updatePreview();
        this.setPreviewVisible(false);
    }

    private void setPreviewVisibleAction(boolean showPreview) {
        if (showPreview) {
            if (this.rightPanel.getBottomComponent() != null) {
                return;
            }
            this.rightPanel.setBottomComponent(this.previewPanel);
            this.rightPanel.setDividerLocation(this.previewDividerLocation);
        } else {
            if (this.rightPanel.getBottomComponent() == null) {
                return;
            }
            this.previewDividerLocation = this.rightPanel.getDividerLocation();
            this.rightPanel.setBottomComponent(null);
        }
        this.updatePreview();
    }

    private void createStyleTree(IPlotterStyle plotterStyle) {
        StyleTreeNode rootNode = new StyleTreeNode(plotterStyle, false);
        TreePath rootPath = new TreePath(rootNode);
        this.styleModel = new DefaultTreeModel(rootNode);
        this.styleTree = new JTree(this.styleModel);
        this.styleTree.setCellRenderer(new StyleTreeCellRenderer());
        this.styleTree.getSelectionModel().setSelectionMode(1);
        this.styleTree.addTreeSelectionListener(this);
        this.setLeftComponent(new JScrollPane(this.styleTree));
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (e.getNewLeadSelectionPath() == null) {
            return;
        }
        Object obj = e.getNewLeadSelectionPath().getLastPathComponent();
        if (obj instanceof StyleTreeNode) {
            StyleTreeNode node = (StyleTreeNode)obj;
            JComponent panel = node.getStylePanel();
            int rdl = this.rightPanel.getDividerLocation();
            if (this.currentStylePanel != null) {
                this.currentStylePanel.removePropertySheetChangeListener(this);
            }
            if (((JComponent)this.rightPanel.getTopComponent()).getComponentCount() > 1) {
                ((JComponent)this.rightPanel.getTopComponent()).remove(1);
            }
            ((JComponent)this.rightPanel.getTopComponent()).add(panel);
            this.rightPanel.setDividerLocation(rdl);
            if (panel instanceof PropertySheetPanel) {
                this.currentStylePanel = (PropertySheetPanel)panel;
                this.currentStylePanel.addPropertySheetChangeListener(this);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Property prop = (Property)evt.getSource();
        this.updatePreview();
        this.styleTree.repaint();
        if (this.currentStylePanel != null) {
            this.currentStylePanel.repaint();
        }
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("PropertySheet");
        frame.getContentPane().setLayout(new BorderLayout());
        IPlotterStyle style = IAnalysisFactory.create().createPlotterFactory().createPlotterStyle();
        StyleEditorPanel sePanel = new StyleEditorPanel(style, new ConfigurePreviewPanel(), IHistogram1D.class);
        frame.getContentPane().add("Center", sePanel);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setSize(600, 500);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }

    class StyleTreeCellRenderer
    extends DefaultTreeCellRenderer {
        StyleTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
            Font font = c.getFont();
            if (font != null) {
                IBaseStyle st;
                boolean normal = !font.isItalic();
                String name = font.getName();
                int size = font.getSize();
                int style = 0;
                boolean isSet = false;
                boolean isSetHere = false;
                if (value instanceof StyleTreeNode && (st = ((StyleTreeNode)value).getStyle()) instanceof BaseStyle) {
                    BaseStyle bst = (BaseStyle)st;
                    isSet = StyleEditorPanel.isAnyParameterSet(bst, true);
                    isSetHere = StyleEditorPanel.isAnyParameterSet(bst, false);
                }
                if (isSetHere) {
                    style = 0;
                    if (isSelected) {
                        c.setForeground(Color.white);
                    } else {
                        c.setForeground(Color.black);
                    }
                } else if (isSet) {
                    style = 0;
                    if (isSelected) {
                        c.setForeground(Color.green);
                    } else {
                        c.setForeground(Color.blue);
                    }
                } else {
                    style = 2;
                    if (isSelected) {
                        c.setForeground(Color.yellow);
                    } else {
                        c.setForeground(Color.red);
                    }
                }
                Font newFont = new Font(name, style, size);
                c.setFont(newFont);
            }
            return c;
        }
    }
}

