/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.histogram.HistMath;
import hep.aida.ref.histogram.HistUtils;
import hep.aida.ref.histogram.Histogram;
import hep.aida.ref.histogram.UnfillableHistogramException;
import hep.aida.ref.histogram.binner.AbstractBinner1D;
import hep.aida.ref.histogram.binner.BasicBinner1D;
import hep.aida.ref.histogram.binner.Binner1D;
import hep.aida.ref.histogram.binner.BinnerMath;
import hep.aida.ref.histogram.binner.EfficiencyBinner1D;
import java.util.Map;

public class Histogram1D
extends Histogram
implements IHistogram1D,
IsObservable {
    private double mean = 0.0;
    private double rms = 0.0;
    private double center = 0.0;
    private IAxis xAxis;
    private AbstractBinner1D binner1D;

    public Histogram1D() {
        super("", "", 1, "");
    }

    public Histogram1D(String name, String title, IAxis axis) {
        this(name, title, axis, "");
    }

    protected Histogram1D(String name, String title, IAxis axis, String options) {
        super(name, title, 1, options);
        this.initHistogram1D(axis, options);
    }

    public void fill(double x) {
        this.fill(x, 1.0);
    }

    public void fill(double x, double weight) {
        if (!this.isFillable()) {
            throw new UnfillableHistogramException();
        }
        ++this.allEntries;
        if (!Double.isNaN(x) && !Double.isNaN(weight)) {
            int coordToIndex = this.xAxis.coordToIndex(x);
            int bin = this.mapBinNumber(coordToIndex, this.axis());
            this.binner1D.fill(bin, x, weight);
            if (coordToIndex >= 0 || this.useOutflows()) {
                double delata = x - this.center;
                ++this.validEntries;
                this.mean += delata * weight;
                this.rms += delata * delata * weight;
                this.sumOfWeights += weight;
                this.sumOfWeightsSquared += weight * weight;
            }
        }
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void reset() {
        this.binner1D.clear();
        this.setBinCenters();
        this.mean = 0.0;
        this.rms = 0.0;
        this.center = (this.xAxis.upperEdge() + this.xAxis.lowerEdge()) / 2.0;
        super.reset();
    }

    private void setBinCenters() {
        double x0 = 0.0;
        for (int i = 0; i < this.axis().bins() + 2; ++i) {
            if (i == 0) {
                x0 = this.axis().lowerEdge();
            } else if (i == this.axis().bins() + 1) {
                x0 = this.axis().upperEdge();
            } else {
                int mi = i - 1;
                x0 = this.axis().binCenter(mi);
            }
            this.binner1D.setBinCenter(i, x0);
        }
    }

    public int extraEntries() {
        return this.binEntries(-2) + this.binEntries(-1);
    }

    public double sumAllBinHeights() {
        double sum = 0.0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            sum += this.binHeight(i);
        }
        return sum;
    }

    public double sumExtraBinHeights() {
        return this.binHeight(-2) + this.binHeight(-1);
    }

    public double minBinHeight() {
        double min = Double.NaN;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            if (!Double.isNaN(min) && !(this.binHeight(i) <= min)) continue;
            min = this.binHeight(i);
        }
        return min;
    }

    public double maxBinHeight() {
        double max = Double.NaN;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            if (!Double.isNaN(max) && !(this.binHeight(i) >= max)) continue;
            max = this.binHeight(i);
        }
        return max;
    }

    public int binEntries(int index) {
        return this.binner1D.entries(this.mapBinNumber(index, this.axis()));
    }

    public double binHeight(int index) {
        return this.binner1D.height(this.mapBinNumber(index, this.axis()));
    }

    public double binError(int index) {
        return this.binner1D.plusError(this.mapBinNumber(index, this.axis()));
    }

    public double mean() {
        if (this.validEntries != 0) {
            return this.mean / this.sumOfWeights + this.center;
        }
        return 0.0;
    }

    public double rms() {
        if (this.validEntries != 0) {
            return Math.sqrt((this.rms - this.mean * this.mean / this.sumOfWeights) / this.sumOfWeights);
        }
        return 0.0;
    }

    public void setMeanAndRms(double otherMean, double otherRms) {
        this.meanAndRmsIsSet = true;
        this.mean = (otherMean - this.center) * this.sumOfWeights;
        this.rms = otherRms * otherRms * this.sumOfWeights + (otherMean - this.center) * (otherMean - this.center) * this.sumOfWeights;
    }

    public IAxis axis() {
        return this.xAxis;
    }

    public int coordToIndex(double coord) {
        return this.axis().coordToIndex(coord);
    }

    public void scale(double scaleFactor) throws IllegalArgumentException {
        if (scaleFactor <= 0.0) {
            throw new IllegalArgumentException("Illegal scale factor " + scaleFactor + " it has to be positive");
        }
        this.binner1D.scale(scaleFactor);
        this.mean *= scaleFactor;
        this.rms *= scaleFactor;
        this.sumOfWeights *= scaleFactor;
        this.sumOfWeightsSquared *= scaleFactor * scaleFactor;
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void add(IHistogram1D hist) throws IllegalArgumentException {
        boolean h1Aida;
        HistMath.checkCompatibility(this.axis(), hist.axis());
        int bins = this.axis().bins() + 2;
        boolean bl = h1Aida = !(hist instanceof Histogram1D);
        if (!h1Aida) {
            BinnerMath.add(this.binner1D, this.binner1D, ((Histogram1D)hist).binner());
            this.initHistogram1D(this.binner1D);
        } else {
            double[] newHeights = new double[bins];
            double[] newErrors = new double[bins];
            double[] newMeans = new double[bins];
            double[] newRmss = new double[bins];
            int[] newEntries = new int[bins];
            double rms2 = 0.0;
            for (int i = -2; i < bins - 2; ++i) {
                double height1 = this.binHeight(i);
                double height2 = hist.binHeight(i);
                double h = height1 + height2;
                double mean1 = this.binMean(i);
                double mean2 = hist.binMean(i);
                mean1 = HistUtils.isValidDouble(mean1) ? mean1 : 0.0;
                mean2 = HistUtils.isValidDouble(mean2) ? mean2 : 0.0;
                double m = 0.0;
                double rms1 = this.binRms(i);
                rms2 = h1Aida ? (hist.axis().binUpperEdge(i) - hist.axis().binLowerEdge(i)) / Math.sqrt(12.0) : ((Histogram1D)hist).binRms(i);
                double r = 0.0;
                if (h != 0.0) {
                    m = (mean1 * height1 + mean2 * height2) / (height1 + height2);
                    r = Math.sqrt((rms1 * rms1 * height1 + mean1 * mean1 * height1 + (rms2 * rms2 * height2 + mean2 * mean2 * height2)) / h - m * m);
                }
                int bin = this.mapBinNumber(i, this.axis());
                newHeights[bin] = h;
                newErrors[bin] = Math.sqrt(Math.pow(this.binError(i), 2.0) + Math.pow(hist.binError(i), 2.0));
                newEntries[bin] = this.binEntries(i) + hist.binEntries(i);
                newMeans[bin] = m;
                newRmss[bin] = r;
            }
            this.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
            this.setMeanAndRms(hist.mean(), hist.rms());
        }
    }

    public double binMean(int index) {
        int bin = this.mapBinNumber(index, this.axis());
        double m = this.binner1D.mean(bin);
        if (Double.isNaN(m)) {
            return this.binner1D.binCenter(bin);
        }
        return m + this.binner1D.binCenter(bin);
    }

    public double binRms(int index) {
        double r = this.binner1D.rms(this.mapBinNumber(index, this.axis()));
        return Double.isNaN(r) ? this.axis().binWidth(index) / Math.sqrt(12.0) : r;
    }

    public void setContents(double[] heights, double[] errors, int[] entries, double[] means, double[] rmss) {
        this.reset();
        double[] newCenters = null;
        for (int i = 0; i < this.axis().bins() + 2; ++i) {
            double r;
            double h = heights[i];
            double m = 0.0;
            if (means != null && !Double.isInfinite(means[i])) {
                means[i] = m = means[i] * h;
            }
            if (rmss == null) continue;
            rmss[i] = r = (rmss[i] * rmss[i] + m * m) * h;
        }
        this.setContents(newCenters, heights, errors, entries, null, means, rmss);
    }

    public void setContents(double[] binCenters, double[] heights, double[] errors, int[] entries, double[] sumWW, double[] sumXW, double[] sumXXW) {
        this.reset();
        for (int i = 0; i < this.axis().bins() + 2; ++i) {
            int mi = i == 0 ? -2 : (i == this.axis().bins() + 1 ? -1 : i - 1);
            double b = binCenters != null ? binCenters[i] : 0.0;
            double h = heights[i];
            int e = entries != null ? entries[i] : (int)h;
            double w = sumWW != null ? sumWW[i] : Double.NaN;
            double m = Double.NaN;
            if (sumXW != null) {
                m = sumXW[i];
            }
            if (!HistUtils.isValidDouble(m)) {
                m = this.binner1D.binCenter(i) * h;
            }
            double r = Double.NaN;
            if (sumXXW != null) {
                r = sumXXW[i];
            }
            if (!HistUtils.isValidDouble(r)) {
                r = (this.axis().binUpperEdge(mi) - this.axis().binLowerEdge(mi)) / Math.sqrt(12.0);
                r = r * r * h + m * m / h;
            }
            this.binner1D.setBinContent(i, b, e, h, errors[i], errors[i], w, m, r);
        }
        this.initHistogram1D(this.binner1D);
    }

    public void initHistogram1D(IAxis xAxis, String options) {
        this.initHist1D(xAxis, options);
    }

    void initHistogram1D(Binner1D b2) {
        this.mean = 0.0;
        this.rms = 0.0;
        this.center = (this.xAxis.upperEdge() + this.xAxis.lowerEdge()) / 2.0;
        super.reset();
        for (int i = 0; i < this.axis().bins() + 2; ++i) {
            int mi = i == 0 ? -2 : (i == this.axis().bins() + 1 ? -1 : i - 1);
            this.allEntries += b2.entries(i);
            double h = b2.height(i);
            double m = b2.sumXW(i);
            double r = b2.sumXXW(i);
            if (mi < 0 && (!this.useOutflows() || !HistUtils.isValidDouble(h))) continue;
            if (HistUtils.isValidDouble(m)) {
                double d = b2.binCenter(i) - this.center;
                this.mean += m + d * h;
                this.rms += r + d * (2.0 * m + d * h);
            }
            this.validEntries += b2.entries(i);
            this.sumOfWeights += h;
            this.sumOfWeightsSquared += h * h;
        }
    }

    void initHist1D(IAxis xAxis, String options) {
        this.xAxis = xAxis;
        Map optionMap = AidaUtils.parseOptions(options);
        String type = (String)optionMap.get("type");
        if (type == null || type.equals("default")) {
            this.binner1D = new BasicBinner1D(xAxis.bins() + 2);
        } else if (type.equals("efficiency")) {
            this.binner1D = new EfficiencyBinner1D(xAxis.bins() + 2);
        } else {
            throw new IllegalArgumentException("Wrong histogram type " + type);
        }
        String useOutflowsString = (String)optionMap.get("useOutflowsInStatistics");
        if (useOutflowsString != null) {
            this.setUseOutflows(Boolean.valueOf(useOutflowsString));
        }
        this.reset();
    }

    public AbstractBinner1D binner() {
        return this.binner1D;
    }
}

