/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IDataPoint;
import hep.aida.IMeasurement;
import hep.aida.ref.event.AIDAListener;
import hep.aida.ref.event.AIDAObservable;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.histogram.Measurement;
import java.util.EventObject;

public class DataPoint
extends AIDAObservable
implements IDataPoint,
IsObservable,
AIDAListener {
    private int dimension;
    private IMeasurement[] measurements;

    public DataPoint(int dim) {
        this.setIsValidAfterNotify(true);
        this.dimension = dim;
        this.measurements = new Measurement[dim];
        for (int i = 0; i < this.dimension; ++i) {
            Measurement meas = new Measurement();
            meas.addListener(this);
            this.measurements[i] = meas;
        }
    }

    public DataPoint(IDataPoint p) {
        this.setIsValidAfterNotify(true);
        this.dimension = p.dimension();
        this.measurements = new Measurement[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            Measurement meas = new Measurement(p.coordinate(i));
            meas.addListener(this);
            this.measurements[i] = meas;
        }
    }

    public DataPoint(IMeasurement[] meas) {
        this.setIsValidAfterNotify(true);
        this.dimension = meas.length;
        this.measurements = meas;
        for (int i = 0; i < meas.length; ++i) {
            if (!(this.measurements[i] instanceof IsObservable)) continue;
            ((IsObservable)((Object)this.measurements[i])).addListener(this);
        }
    }

    public DataPoint(double[] val) {
        this.setIsValidAfterNotify(true);
        this.dimension = val.length;
        this.measurements = new Measurement[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            Measurement meas = new Measurement(val[i]);
            meas.addListener(this);
            this.measurements[i] = meas;
        }
    }

    public DataPoint(double[] val, double[] err) {
        this.setIsValidAfterNotify(true);
        if (val.length != err.length) {
            throw new IllegalArgumentException("DataPoint Constructor: Value and Error arrays are not the same size");
        }
        this.dimension = val.length;
        this.measurements = new Measurement[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            Measurement meas = new Measurement(val[i], err[i]);
            meas.addListener(this);
            this.measurements[i] = meas;
        }
    }

    public DataPoint(double[] val, double[] errMinus, double[] errPlus) {
        this.setIsValidAfterNotify(true);
        if (val.length != errPlus.length) {
            throw new IllegalArgumentException("DataPoint Constructor: Value and Error arrays are not the same size");
        }
        if (val.length != errMinus.length) {
            throw new IllegalArgumentException("DataPoint Constructor: Value and Error arrays are not the same size");
        }
        this.dimension = val.length;
        this.measurements = new Measurement[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            Measurement meas = new Measurement(val[i], errMinus[i], errPlus[i]);
            meas.addListener(this);
            this.measurements[i] = meas;
        }
    }

    public int dimension() {
        return this.dimension;
    }

    public IMeasurement coordinate(int coord) {
        return this.measurements[coord];
    }

    public double lowerExtent(int coord) throws IllegalArgumentException {
        double le = this.measurements[coord].value();
        if (!Double.isNaN(this.measurements[coord].errorMinus())) {
            le -= this.measurements[coord].errorMinus();
        }
        return le;
    }

    public double upperExtent(int coord) throws IllegalArgumentException {
        double ue = this.measurements[coord].value();
        if (!Double.isNaN(this.measurements[coord].errorPlus())) {
            ue += this.measurements[coord].errorPlus();
        }
        return ue;
    }

    public void stateChanged(EventObject e) {
        this.fireStateChanged();
    }

    public void clear() {
        if (this.measurements != null && this.measurements.length > 0) {
            for (int i = 0; i < this.measurements.length; ++i) {
                if (!(this.measurements[i] instanceof IsObservable)) continue;
                ((IsObservable)((Object)this.measurements[i])).removeListener(this);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.clear();
    }
}

