/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.python;

import com.artenum.jyconsole.io.MultiStreamWriter;
import com.artenum.jyconsole.io.SimpleSingleStream;
import com.artenum.jyconsole.io.SingleStream;
import org.python.core.PyObject;
import org.python.util.InteractiveInterpreter;

public class JInteractiveInterpreter
extends InteractiveInterpreter {
    private static MultiStreamWriter mStdOut;
    private static MultiStreamWriter mStdErr;

    public JInteractiveInterpreter() {
        this(true);
    }

    public JInteractiveInterpreter(boolean addDefaultOutput) {
        this.initOutputStream(addDefaultOutput);
    }

    public JInteractiveInterpreter(PyObject obj) {
        this(obj, true);
    }

    public JInteractiveInterpreter(PyObject obj, boolean addDefaultOutput) {
        super(obj);
        this.initOutputStream(addDefaultOutput);
    }

    private void initOutputStream(boolean addDefaultStream) {
        if (mStdOut == null) {
            mStdOut = new MultiStreamWriter();
            this.setOut(mStdOut);
            if (addDefaultStream) {
                this.addOut(new SimpleSingleStream(System.out, true));
            }
        }
        if (mStdErr == null) {
            mStdErr = new MultiStreamWriter();
            this.setErr(mStdErr);
            if (addDefaultStream) {
                this.addErr(new SimpleSingleStream(System.err, true));
            }
        }
    }

    public void addOut(SingleStream ss) {
        mStdOut.addSingleStream(ss);
    }

    public void removeOut(SingleStream ss) {
        mStdOut.removeSingleStream(ss);
    }

    public void addErr(SingleStream ss) {
        mStdErr.addSingleStream(ss);
    }

    public void removeErr(SingleStream ss) {
        mStdErr.removeSingleStream(ss);
    }
}

