/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.gui.tk;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;

public class DesktopManager
extends JTabbedPane {
    private MoveInternalFramePopup moveToDesktopPopup;
    private PopupListener popupListener;
    private ArrayList desktopList = new ArrayList();

    public DesktopManager() {
        this.moveToDesktopPopup = new MoveInternalFramePopup();
        this.popupListener = new PopupListener();
    }

    public void addDesktop(String string) {
        this.addTab(string, new JScrollPane(new JDesktopPane()));
        this.desktopList.add(string);
    }

    public void removeDesktop(String string) {
        this.removeTabAt(this.indexOfTab(string));
        this.desktopList.remove(string);
    }

    public JDesktopPane getCurrentDesktop() {
        return this.getDesktopFromTabContent(this.getSelectedComponent());
    }

    public JDesktopPane getDesktop(String string) {
        return this.getDesktopFromTabContent(this.getComponentAt(this.indexOfTab(string)));
    }

    public JDesktopPane getDesktop(int n) {
        return this.getDesktopFromTabContent(this.getComponentAt(n));
    }

    public JInternalFrame createMultiDesktopInternalFrame(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        JInternalFrame jInternalFrame = new JInternalFrame(string, bl, bl2, bl3, bl4);
        jInternalFrame.addMouseListener(this.popupListener);
        return jInternalFrame;
    }

    public ArrayList getDesktopNameList() {
        return this.desktopList;
    }

    private JDesktopPane getDesktopFromTabContent(Component component) {
        return (JDesktopPane)((JViewport)((JScrollPane)component).getComponent(0)).getComponent(0);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                DesktopManager.this.moveToDesktopPopup.setInternalFrame((JInternalFrame)mouseEvent.getComponent());
                DesktopManager.this.moveToDesktopPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class MoveInternalFramePopup
    extends JPopupMenu
    implements ActionListener {
        private JInternalFrame currentFrame;
        private ArrayList desktopList;

        public MoveInternalFramePopup() {
            this.desktopList = (ArrayList)DesktopManager.this.getDesktopNameList().clone();
            this.loadDesktopList();
        }

        public void show(Component component, int n, int n2) {
            this.loadDesktopList();
            super.show(component, n, n2);
        }

        public void setInternalFrame(JInternalFrame jInternalFrame) {
            this.currentFrame = jInternalFrame;
        }

        private void loadDesktopList() {
            if (!this.desktopList.equals(DesktopManager.this.getDesktopNameList())) {
                this.desktopList = (ArrayList)DesktopManager.this.getDesktopNameList().clone();
                this.removeAll();
                Iterator iterator = DesktopManager.this.getDesktopNameList().iterator();
                while (iterator.hasNext()) {
                    JMenuItem jMenuItem = new JMenuItem((String)iterator.next());
                    jMenuItem.addActionListener(this);
                    this.add(jMenuItem);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DesktopManager.this.getDesktop(this.desktopList.indexOf(actionEvent.getActionCommand())).equals(this.currentFrame.getDesktopPane())) {
                return;
            }
            JDesktopPane jDesktopPane = this.currentFrame.getDesktopPane();
            DesktopManager.this.getDesktop(this.desktopList.indexOf(actionEvent.getActionCommand())).add(this.currentFrame);
            this.currentFrame.getDesktopPane().validate();
            this.currentFrame.getDesktopPane().repaint();
            try {
                this.currentFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            jDesktopPane.repaint();
        }
    }
}

