; $Id: recip_kikf.pro,v 1.2 2012/06/26 15:11:33 kneller Exp $


;Calculate ki,kf in x-y-z coordinates based on the given orientation vectors.


;###############################################################################
function recip_kikf,o1,o2,a,b,c,alpha,beta,gamma,Q,Efix,E,init=init,final=final,qobj=qobj

    nan = double('NaN')
    result = {Q:Q,ki:[nan,nan,nan],kf:[nan,nan,nan]}

    if final eq 1 then begin
        Ef = Efix
        Ei = E + Ef
    endif
    if init eq 1 then begin
        Ei = Efix
        Ef = Ei - E
    endif



;1) ;GET RECIPROCAL LATTICE VECTORS
    val = recip_lattice(a,b,c,alpha,beta,gamma)
    b1    = val.b123.b1
    b2    = val.b123.b2
    b3    = val.b123.b3

;2) ;GET Q IN 1/ang
    Qorig = Q   ;SAVE hkl VALUES FOR Q
    Q = Q[0]*b1 + Q[1]*b2 + Q[2]*b3

;3) ;GET o1vec,o2vec IN 1/ang
;THE FOLLOWING SETS THE AXES ALONG o1,o2
    o1vec = (o1[0]*b1 + o1[1]*b2 + o1[2]*b3)
    o2vec = (o2[0]*b1 + o2[1]*b2 + o2[2]*b3)
    mago1vec = sqrt(dotp(o1vec,o1vec))
    mago2vec = sqrt(dotp(o2vec,o2vec))

;4) ; GET UNIT VECTORS ALONG o1,o2
    ;CREATE UNIT VECTORS ALONG THE o1,o2 DIRECTIONS ---  THIS SHOULD NOT BE USED IN
    xhat_o1 = o1vec/mago1vec                            ;GENERAL SINCE THEY ARE ALONG
    yhat_o2 = o2vec/mago2vec                            ;THE ORIENTATION VECTOR DIRECTIONS
                                                        ;AND MAY NOT BE ORTHOGONAL.


;5) DEFINE  xhat,yhat, UNIT VECTORS IN THE SCATTERING PLANE
;           zhat       PERPENDICULAR TO THE SCATTERING PLANE
    xhat = xhat_o1
    xhat = xhat/sqrt(dotp(xhat,xhat))
    zhat = crossp(xhat_o1,yhat_o2)
    zhat = zhat/sqrt(dotp(zhat,zhat))
    yhat = crossp(zhat,xhat)
    yhat = yhat/sqrt(dotp(yhat,yhat))


;6) CHECK THAT THE INPUT Q IS IN THE SCATTERING PLANE
    ;NOTE: THERE IS NO REASON THAT I COULDN'T SIMPLY USE ALL 3 COMPONENTS
    testvol = clearjunk(dotp(Q,crossp(xhat,yhat)))
    if testvol ne 0.0 then begin
        print,'Q=',Q
        print,'o1vec=',o1vec
        print,'o2vec=',o2vec
        print,'Q IS NOT IN THE SCATTERING PLANE!!!!!!!'
        print,'QUITTING.'
        void = dialog_message('Q IS NOT IN THE SCATTERING PLANE.',/error)
        return,result
    endif


;Q
    Qxy = [dotp(Q,xhat),dotp(Q,yhat),0.0]   ;THIS ASSUMES THE SCATTERING PLANE CHECK IS DONE!!!

;;;;;
;;;;;;FINALLY TRANSFER kixy,kfxy TO hkl SPACE

;FIRST FIND yhat IN TERMS OF b1,b2,b3
;
;USE CRAMER'S RULE TO SOLVE:
;[[b1],[b2],[b3]]#[A1,A2,A3] = yhat  --- FIND A1,A2,A3 COEFFICIENTS

;7) GET THE hkl VALUES FOR xhat,yhat SO INDICES DESCRIBE THE UNIT VECTORS
    xhat_hkl = LK_cramer(b1,b2,b3,xhat)
    yhat_hkl = LK_cramer(b1,b2,b3,yhat)
    zhat_hkl = LK_cramer(b1,b2,b3,zhat)

;print,'yhat_hkl=',yhat_hkl
;print,'yhat=',yhat_hkl[0]*b1 + yhat_hkl[1]*b2 + yhat_hkl[2]*b3
;print,'o2=',o2

;THE NEXT CHECK WORKS:
;    print,'IN xyz  |b1| = ',sqrt(total([b1x,b1y,b1z]^2))
;    print,'IN b123 |b1| = ',sqrt(dotp(b1,b1))


;NOW ki,kf IN XY SPACE (Qxy SETS THE AXES.)

;NOTE THAT IMPLICITLY ki_z and kf_z are zero!!!!!!!
    ;GET ki,kf IN XY PLANE

;8) GET ki,kf IN X,Y,Z COORDINATES
    kikf = getkikf_from_efixed_etran(Efix,E,Qxy,init=init,final=final)
    ki = kikf.ki
    kf = kikf.kf




    ;VERIFY THAT SCATTERING TRIANGLE CLOSED
    nani = total(finite(ki,/nan))
    nanf = total(finite(kf,/nan))

    if total([nani,nanf]) ne 0 then begin
        void = dialog_message('SCATTERING TRIANGLE CANNOT CLOSE WITH ENTERED VALUES.',/error)
        return,result
    endif else begin

;9) GET ki,kf IN HKL VALUES
        kix_hkl = ki[0]*xhat_hkl
        kiy_hkl = ki[1]*yhat_hkl
        kiz_hkl = 0.0*zhat_hkl  ;NO z COMPONENT SINCE THERE WAS AN EARLIER CHECK TO SEE Q AND THUS
                                ;ki,kf ARE IN THE SCATTERING PLANE.

        ki_hkl = kix_hkl + kiy_hkl + kiz_hkl

        kfx_hkl = kf[0]*xhat_hkl
        kfy_hkl = kf[1]*yhat_hkl
        kfz_hkl = 0.0*zhat_hkl

        kf_hkl = kfx_hkl + kfy_hkl + kfz_hkl

        result.ki = ki_hkl
        result.kf = kf_hkl
        result.Q  = Qorig

;AT THIS POINT, CREATE, ki,kf, Q objects
;BUT WHICH VALUES DO I WANT TO PASS?  Qx,Qy,kix,kiy,kfx,kfy,Ei,Ef,E


;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;        qobj = obj_new('spurion2_q_data',$
;                            Qx = Qxy[0],Qy = Qxy[1],$
;                            kix= ki[0], kiy = ki[1],$
;                            kfx= kf[0], kfy = kf[1],$
;                            Energy=E)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;



        return,result
    endelse



end;recip_kikf_in_hkl
