; $Id: alewald.pro,v 1.2 2012/06/26 15:11:33 kneller Exp $

;Calculate the q magnitudes of scattering for Al, Cu, Mo sample holders.
;These are for producing the powder spheres. 
;####################################################################
pro alewald,g,hklal,cu=cu,mo=mo

    ;BOTH Al AND Cu ARE FCC, SO ALL OF THE CALCULATIONS BELOW APPLY.
    ;THE ONLY CHANGE IS THE LATTICE CONSTANT:
    ;
    ;www.webelements.com
    ;   Al  4.0495�
    ;   Cu  3.6149�
    ;   Mo  3.147�  Mo is BCC AND WILL RAISE THE APPROPRIATE SWITCH BELOW.

    ;g and hklal ARE CALCULATED BELOW AND PASSED BACK TO CALLING PROCEDURE
    ;VIA THE ARGUMENTS ABOVE.
    ;
    ;TRANSLATED DIRECTLY FROM FORTRAN BY LRK 01/06/06
    ;ADDED Cu AND Mo RINGS. 08/16/06
    ;

      n=13
      G = dblarr(n)

      if n_elements(cu) eq 0 then cu = 0
      if n_elements(mo) eq 0 then mo = 0

      if mo ne 0 then bcc = 1 else bcc = 0

;     lattice constant.
      if cu ne 0 then begin
        a = 3.6149      ;Cu
      endif else begin
        if mo ne 0 then begin
            a = 3.147   ;Mo
        endif else begin
            ;DEFAULT TO Al
            a = 4.04096 ;Al   FROM ORIGINAL alewald CODE
        endelse
      endelse

      pi = !PI
      magq = 0.0
      dum = 0.0
      qdiff = dblarr(n)
      i = 0
      h = intarr(3,n)
      hklal = intarr(3,n)
;  Read in the aluminum peaks to be considered.
;
          h[*,0]=[1,1,1]
          h[*,1]=[2,0,0]
          h[*,2]=[2,2,0]
          h[*,3]=[3,1,1]
          h[*,4]=[2,2,2]
          h[*,5]=[4,0,0]
          h[*,6]=[3,3,1]
          h[*,7]=[4,2,0]
          h[*,8]=[4,2,2]
          h[*,9]=[3,3,3]
          h[*,10]=[4,4,0]
          h[*,11]=[5,3,1]
          h[*,12]=[ 6,0,0]

          if bcc eq 1 then begin
              h[*,0]=[1,1,0]
              h[*,1]=[2,0,0]
              h[*,2]=[2,1,1]
              h[*,3]=[2,2,0]
              h[*,4]=[3,1,0]
              h[*,5]=[2,2,2]
              h[*,6]=[3,2,1]
              h[*,7]=[4,0,0]
              h[*,8]=[3,3,0]
              h[*,9]=[4,2,0]
              h[*,10]=[3,3,2]
              h[*,11]=[4,2,2]
              h[*,12]=[4,3,1]
          endif

      pi=!PI;4.0*atan(1.0)

;  Calculate the FCC G's.
      for i=0,n-1 do begin
         G[i]=(2*pi/a)*sqrt(float(h[0,i]^2 + h[1,i]^2 + h[2,i]^2))
         for j=0,2 do begin
            hklal[j,i]=h[j,i]
         endfor
      endfor

      return
end;alewald

