; $Id$
;###############################################################################
;
; NAME:
;   ui_launchModule
;
; PURPOSE:
;   Dave2 launcher for Data Reduction and other Self-contained modules.
;   It is implemented as a User Interface Service
;
; CATEGORY:
;   DAVE2
;
; AUTHOR:
;   Richard Tumanjong Azuah
;   NIST Center for Neutron Research
;   100 Bureau Drive, Gaithersburg, MD 20899
;   United States
;   azuah@nist.gov; (301) 9755604
;   April, 2008
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
function ui_launchModule, oUI, oRequester
compile_opt idl2

; Get group leader from main UI object
oUI->GetProperty, group_leader=group_leader

; Get requesting Tool object from main UI object
oDAVETool = oUI->GetTool()

; Retrrieve the current data and working directories from requesting tool
oDAVETool->GetProperty, data_directory=dataDir, working_directory=workDir


; Retrieve the procedure name to be executed
oRequester->GetProperty, IDENTIFIER=id
symbol = STRMID(id, STRPOS(id, '/', /REVERSE_SEARCH) + 1)

; Execute symbol, depending whether it is a procedure or a function
executed = 0
if (~executed) then begin
    procedures = routine_info()
    void = where(procedures eq strupcase(symbol), found)
    if (found) then begin
        call_procedure, symbol, group_leader=group_leader, workDir=workDir, dataDir=dataDir, DAVETool=oDAVETool
        executed = 1
    endif else begin
        oDaveTool->StatusMessage, "'"+symbol+"' procedure/function is either not available or is not yet compiled!"
    endelse
endif
if (~executed) then begin
    functions = routine_info(/functions)
    void = where(functions eq strupcase(symbol), found)
    if (found) then begin
        void = call_function(symbol, group_leader=group_leader, workDir=workDir, dataDir=dataDir, DAVETool=oDAVETool)
        executed = 1
    endif else begin
        oDaveTool->StatusMessage, "'"+symbol+"' procedure/function is either not available or is not yet compiled!"
    endelse
endif

return, executed
end