; $Id$
;###############################################################################
;+
; NAME:
;   ui_dataSlice
;
; PURPOSE:
;   User Interface Service for the Data Slice operation
;
; CATEGORY:
;   DAVE Widgets
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; Jan 2009
;-
;###############################################################################
function ui_dataSlice, oUI, oRequester
compile_opt idl2

if (~obj_valid(oUI)) then return, 0
if (~obj_valid(oRequester)) then return, 0

;; Retrieve widget ID of top-level base.
oUI->GetProperty, group_leader=gl

;; Set dimensions
xs = 230

; make the ysize for the property sheet equal the number of registered 
; properties + 2 (up to a max of 8)
ys1 = 4 > (n_elements(oRequester->QueryProperty())+2) < 8

ys2 = 230

;; 
oRequester->GetProperty, name=title
if (strtrim(title,2) eq '') then title='Data Slice'


return, wd_dataSlice(oUI,value=oRequester[0], group_leader=gl $
                        ,xsize1=xs,ysize1=ys1,xsize2=xs, ysize2=ys2)


end
