; $Id$
; Copyright (c) 2002-2004, Research Systems, Inc.  All rights reserved.
;       Unauthorized reproduction prohibited.
;+
; NAME:
;   DAVEvisManager
;
; PURPOSE:
;   This function implements the IT tree/property browser.
;
;   Note: This differs from the IDLitwdVisBrowser in that it doesn't
;         try to select the objects selected in the browser
;         tree. This simple widget just displays the items selected in
;         the property sheet, nothing else.
;
; CALLING SEQUENCE:
;   DAVEvisManager
;
; INPUTS:
;   oUI: (required) object reference for the tool user interface
;
; KEYWORD PARAMETERS:
;   GROUP_LEADER: widget ID of the group leader
;
;   TITLE: string title for the top level base
;
;   VALUE: object reference of the current selected item
;   IDENTIFIER: string identifier of the current selected item
;     Note: one of VALUE or IDENTIFIER must be supplied
;
;   TREETOP: string identifier of the position in the tool tree to be
;   the highest visible point in the tree browser
;
;   XSIZE: xsize of the two panes
;   YSIZE: ysize of the two panes
;
;   NAME: (required) string name of the browser
;
;   VISIBLE: initial visibility. 1-show left panel, 2-show right
;   panel, 3-show both panels (default)
;
;   MULTIPLE: allow multiple selections in the tree browser
;
; MODIFICATION HISTORY:
;   Written by:  CT, RSI, April 2002
;   Modified to use CW_PANES_DAVE browser templates:  AGEH, January 2003
;
;-


PRO dummy_CALLBACK, wProp, strID, messageIn, component
compile_opt idl2

cw_ittreeview_callback, wProp, strID, messageIn, component

end


;---------------------------------------------------------------------------
; Purpose:
;   Used to get selection changed messages from the tool
;
PRO cw_DAVEvisManager_Callback, wProp, strID, messageIn, component
compile_opt idl2

message = messageIn
case messageIn of
    'SELECTIONCHANGED': begin
        widget_control, wProp, get_uvalue=state, /no_copy
        ;; If we have an old non standard lying around, unselect it
        if(state.idSelNonVis ne '')then $
          cw_ittreeview_setSelect, state.wTree, state.idSelNonVis, /unselect
        state.idSelNonVis=''
        widget_control, wProp, set_uvalue=state, /no_copy

    end

    'ADDITEMS': begin
        ;; Get the state var and save it
        widget_control, wProp, get_uvalue=stateOrig
        ;; Locate the widget id of the component that generated this
        ;; message (perhaps this should be the component to be added!)
        ;; Starting from this, navigate up the widget hierarchy until
        ;; the Vis Tool main node is located (a widget whose parent
        ;; is wProp).
        wNode = widget_info(wProp,find_by_uname=strid)
        while ((wNode gt wProp) && (widget_info(wNode, /parent) ne wProp)) do $
          wNode = widget_info(wNode, /parent)

        ;; Use the state var from this widget to replace that of wProp
        ;; before cw_itTreeView_Callback is called
        if (widget_info(wNode,/valid)) then begin
            widget_control, wNode, get_uvalue=sPtr
            if (ptr_valid(sPtr)) then widget_control, wProp, set_uvalue=(*sPtr)
        endif

        ;; *** fudge
        ;; When the component is not specified, cw_itTreeView_Callback
        ;; (call below) does not add a new item to the tree so simply
        ;; force a rebuild of the entire tree specified by striID
        if (strtrim(component,2) eq '') then $
          cw_itTreeView_RebuildLevel, (*sPtr).wTree, strID
    end

    else:

endcase


cw_itTreeView_Callback, wProp, strID, message, component 


case messageIn of
    'ADDITEMS': begin
        ;; Revert to the original state var that was altered before
        ;; cw_itTreeView_Callback was called.
        widget_control, wProp, set_uvalue=stateOrig
    end

    else:

endcase


end


;----------------------------------------
;+
; NAME:
;   DAVEVISMANAGER_EVENT
;
; PURPOSE:
;       Event handler for the Vis Tree Widget
;
; INPUTS:
;   EVENT: (required) a widget_event structure
;
; KEYWORD PARAMETERS:
;       None
;
; OUTPUTS:
;       - Event structure for processing elsewhere
;       - 0L if event is completely dealt with
;-
function cw_DAVEvisManager_Event, event
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'CW_DAVEVISMANAGER: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return, 0
    endif
endif

if (event.id lt event.handler) then return, event ; id has to be handler or a sub-widget

widget_control,event.handler,get_uvalue=stateTreeRoot

;-----------------------------------------------------------
; - Perform some house keeping stuff 
; - Then call cw_ittreeview_event to handle this event 
; - Perform any additional task

;; Catch events generated by buttons from the wVMContext
;; context-sensitive menu.
case (widget_info(event.id, /uname))  of
    'VMTOGGLEVIEW': begin
        widget_control, event.id, get_uvalue=sPtr
        
        ;; Locate the TLB of the Vis Tool
        ((*sPtr).oUI)->GetProperty, group_leader=wVTTLB
        mapState = (*sPtr).visToolState ; Get visibility state
        mapState = 1 - mapState ; toggle it
        widget_control, wVTTLB, map=mapState ; apply the change 
        (*sPtr).VisToolState = mapState ; update state info
        return, 0
    end
    
    'VMDELETE': begin
        
        ;;; Get the state structure and get its ui, hence vis tool
        ;;; Get the shut down service from the tool
        ;widget_control, event.id, get_uvalue=sPtr
        ;oShutdown = (((*sPtr).oUI)->GetTool())->GetService('SHUTDOWN')
        ;if (~obj_valid(oShutdown)) then begin
        ;    oTool = (*sPtr).oUI->GetTool()
        ;    oTool->ErrorMessage, title=IDLitLangCatQuery('Error:InternalError:Title'), $
        ;                         [IDLitLangCatQuery('Error:Framework:CannotAccessShutdown'), $
        ;                          IDLitLangCatQuery('Error:Framework:ForceShutdown')], severity=2
        ;    return, 0
        ;endif
        ;
        ;;; Kill the Vis Tool. This should also trigger the removal of
        ;;; the node entry from the tree widget
        ;void = ((*sPtr).oUI)->DoAction(oShutdown->getFullIdentifier())
        ;
        ;;; Remove the Vis Node from the tree widget
        ;;widget_control, (*sPtr).wVisNode, /destroy

        ;; Delegate the delete to the Exit operation that is defined for this tool
        widget_control, event.id, get_uvalue=sPtr
        oTool = ((*sPtr).oUI)->GetTool()

        exitID = 'Operations/File/Exit'
        exitOpDesc = oTool->GetByIdentifier(exitID)
        if (obj_valid(exitOpDesc)) then exitOp = exitOpDesc->GetObjectInstance()
        if (obj_valid(exitOp)) then void = exitOp->DoAction(oTool)

        return, 0
    end

    else:
endcase

;; A top-level Vis Node was right-clicked ==> A context menu is requested
if (event.id eq event.handler) then begin
   if (tag_names(event,/struct) eq 'WIDGET_CONTEXT') then begin
      
      ;; Determine the widget that is currently selected. 
      wSelected = widget_info(event.id,/tree_select)
      if (~widget_info(wSelected[0],/valid)) then return, 0
      
      ;; If it is a top-level Vis Node then proceed with handling the
      ;; request completely here. 
      ;; NB: Don't handle it if more than one item was selected
      if ((size(wSelected,/n_dimensions) eq 0) && $
          (widget_info(wSelected,/parent) eq widget_info(wSelected,/tree_root))) then begin
         
         widget_control, wSelected, get_uvalue=sPtrSelected
         
         case (*sPtrSelected).VisToolState of
            0: begin            ; Vis Tool is currently hidden
               tooltip = 'Show Visualization Window'
               value = 'Show Viualization'
            end
            1: begin            ; Vis Tool is currently in view
               tooltip = 'Hide Visualization Window'
               value = 'Hide Viualization'
            end
         endcase
         ;; Retrieve the buttons and update them wrt the current Vis Tool
         wToggle = widget_info(stateTreeRoot.wVMContext,find_by_uname='VMTOGGLEVIEW')
         widget_control, wToggle, set_value=value, tooltip=tooltip, set_uvalue=sPtrSelected
         wDelete = widget_info(stateTreeRoot.wVMContext,find_by_uname='VMDELETE')
         widget_control, wDelete, set_uvalue=sPtrSelected
         
         ;; Display the context-sensitive menu
         widget_displaycontextmenu, event.id, event.x, event.y, stateTreeRoot.wVMContext
         
         return, 0
      endif else if (~widget_info(stateTreeRoot.wContext,/valid_id)) then return, 0
   endif

   return, 0                    ; no need to proceed further when event.id == event.handler
endif


; Starting from event.id, navigate upwards until the Vis Tool main
; node is located (its parent will be event.handler).
if (event.id gt event.handler) then begin ; change gt -> ge
    wNode = event.id
    while (widget_info(wNode, /parent) ne event.handler) do $
      wNode = widget_info(wNode, /parent)
    
    ;; wid should now be a valid top-level tree node of a Vis entry.
    widget_control, wNode, get_uvalue=sPtrVisNode
    if (~ptr_valid(sPtrVisNode)) then return, 0
    
    ;; Replace the state var of the Root widget with that of the node.
    widget_control, event.handler, set_uvalue = (*sPtrVisNode)
    
endif 


;; Call cw_ittreeview_event 
event_in = event
event = cw_ittreeview_event(event)

if ((size(event,/n_dimensions) eq 0) && (event eq 0)) then begin
    ;; If the event was completely handled by cw_ittreeview_event then
    ;; it would be assign a value of 0L implying no further
    ;; processing is necessary. So revert to original state var for
    ;; handler and then exit.
    widget_control, event_in.handler, set_uvalue=stateTreeRoot
    return, 0
endif

;if (event.id ne event.handler) then begin
   ;; Update state info for parent tree Node of widget that generated the
   ;; event so that it reflects changes made by call to cw_ittreeview_event()
   widget_control, event.handler, get_uvalue=state_Updated
   (*sPtrVisNode) = state_Updated
;end

;-----------------------------------------------------------
; Continue with remainder of event handler.
; - the event structure is now modified by cw_ittreeview_event()
; - the state var used below is from the parent tree node of the widget
;   that generated the event (not from the handler!)
CASE TAG_NAMES(event, /STRUCTURE_NAME) OF
    
    ;; Event generated by cw_ittreeview_event in response to a
    ;; WIDGET_TREE_SEL event.
    'CW_TREE_SEL': begin
        oTool = (*sPtrVisNode).oUI->GetTool()
        if (~OBJ_VALID(oTool)) then $
          break
        
        ;; For optimization, prepare two lists:
        ;;   1) items that are newly selected but were not previously.
        ;;   2) items that are no longer selected but were previously.
        ;;
        visSelected = oTool->GetSelectedItems(COUNT=nSelVis, /ALL)
        
        selStr = *event.value
        if ((selStr[0] ne '') || $
            (nSelVis gt 0)) then begin
            
            visStr = ['']
            if (OBJ_VALID(visSelected[0])) then begin
                for i=0,N_ELEMENTS(visSelected)-1 do begin
                    visStr = visStr[0] EQ '' ? $
                             visSelected[i]->GetFullIdentifier() : $
                             [visStr,visSelected[i]->GetFullIdentifier()]
                endfor
            endif
            for i=0,N_ELEMENTS(selStr)-1 do $
              if (WHERE(selStr[i] EQ visStr) EQ -1) then $
                newSelIDs = N_ELEMENTS(newSelIDs) EQ 0 ? $
              selStr[i] : [newSelIDs,selStr[i]]
            
            for i=0,N_ELEMENTS(visStr)-1 do $
              if (WHERE(visStr[i] EQ selStr) EQ -1) then $
                deSelIDs = N_ELEMENTS(deSelIDs) EQ 0 ? $
              visStr[i] : [deSelIDs,visStr[i]]
        endif
        
        ;; KDB 2/03
        ;; It may seem strange, but to minimize on data space
        ;; recalculations, selects should take place before
        ;; unselects. Due ot the nature of the selection model, the
        ;; data space will recalculate if the overall selection state of
        ;; it's children change (child selected to child not selected).
        ;;
        ;; So by deleting selections first and then enabling the new
        ;; selections, the child state of the data space changes.
        ;; But if you do selections first and the delesections, the data-
        ;; space state doesn't change. This can also minimize the amount
        ;; of drawing going on.
;        idNonVis='' ;; flag for any non vis related items (data, window)
;        oTool->DisableUpdates
;        FOR i=0,n_elements(*event.add)-1 DO BEGIN
;            oSelect = oTool->GetByIdentifier((*event.add)[i])
;            IF obj_valid(oSelect) THEN BEGIN
;                IF i EQ 0 THEN BEGIN  ;; update the status bar.
;                    oSelect->getProperty,desc=desc
;                    IF ~desc THEN desc='  '
;                    widget_control,(stateTreeRoot).wStatus,set_value=desc
;                ENDIF
;                ;; Check for Data
;                if(obj_isa(oSelect, "IDLitData") or $
;                   obj_isa(oSelect, "IDLitWindow"))then begin
;                    idNonVis=(*event.add)[i]
;                    break
;                endif else if (OBJ_ISA(oSelect, '_IDLitVisualization') or $
;                               obj_isa(oSelect, "IDLitgrView") or $
;                               obj_isa(oSelect, "IDLitgrLayer"))then begin
;                    IF ~oSelect->IsSelected() THEN oSelect->Select,/additive
;                ENDIF
;            endif
;        ENDFOR
;
;        ;; Now clear out items that are not selected any more.
;        FOR i=0,n_elements(*event.delete)-1 DO BEGIN
;            oSelect = oTool->GetByIdentifier((*event.delete)[i])
;            IF obj_valid(oSelect) THEN BEGIN
;                if(obj_isa(oSelect, "IDLitGrView"))then begin
;                    ;; Force a view to deselect
;                    oSelect->Select,/unselect
;                endif else if (OBJ_ISA(oSelect, '_IDLitVisualization') or $
;                               obj_isa(oSelect, "IDLitgrLayer"))then begin
;                    IF oSelect->IsSelected() THEN oSelect->Select,/unselect
;                endif
;            ENDIF
;        ENDFOR
;        IF (strpos(stateTreeRoot.name,'Visualization') ne -1) then begin
            idNonVis='' ;; flag for any non vis related items (data, window)
            oTool->DisableUpdates, PREVIOUSLY_DISABLED=previouslyDisabled
            FOR i=0,n_elements(newSelIDs)-1 DO BEGIN
                oSelect = oTool->GetByIdentifier(newSelIDs[i])
                IF obj_valid(oSelect) THEN BEGIN
                    IF i EQ 0 THEN BEGIN  ;; update the status bar.
                        oSelect->getProperty,desc=desc
                        IF ~desc THEN desc='  '
                        widget_control,stateTreeRoot.wStatus,set_value=desc
                    ENDIF
                    ;; Check for Data
                    if(obj_isa(oSelect, "IDLitData") or $
                   obj_isa(oSelect, "IDLitWindow"))then begin
                       idNonVis=newSelIDs[i]
;                    break
                   endif else if (OBJ_ISA(oSelect, '_IDLitVisualization') or $
                                  obj_isa(oSelect, "IDLitgrView") or $
                                  obj_isa(oSelect, "IDLitgrLayer"))then begin
                       IF ~oSelect->IsSelected() THEN oSelect->Select,/additive
                   ENDIF
               endif
            ENDFOR
            
            ;; Now clear out items that are not selected any more.
            FOR i=0,n_elements(deSelIDs)-1 DO BEGIN
                oSelect = oTool->GetByIdentifier(deSelIDs[i])
                IF obj_valid(oSelect) THEN BEGIN
                    if(obj_isa(oSelect, "IDLitGrView"))then begin
                        ;; Force a view to deselect
                        oSelect->Select,/unselect
                    endif else if (OBJ_ISA(oSelect, '_IDLitVisualization') or $
                                   obj_isa(oSelect, "IDLitgrLayer"))then begin
                        IF oSelect->IsSelected() THEN oSelect->Select,/unselect
                endif
                ENDIF
            ENDFOR
            
        
            ;; Was any data selected?
            if (keyword_set(idNonVis)) then begin
                cw_itTreeView_SetSelect, event.handler, idNonVis, /clear
                                ;widget_control, (*sPtr).wProp, set_value=idNonVis
            endif
            (*sPtrVisNode).idSelNonVis=idNonVis ;(*sPtr).idSelNonVis = idNonVis
            
            ;; Synchronize current active tool in the tree with the
            ;; appropriate Vis Tool by moving it to the foreground
            
            oCurrent = oTool->GetService("SET_AS_CURRENT_TOOL")
            void = oTool->DoAction(oCurrent->GetFullIdentifier()) ; set as current tool
            
            (*sPtrVisNode).oUI->GetProperty, group_leader=wTLB_current
            widget_control, wTLB_current, /show, get_uvalue=wNode ; bring it to the foreground
            widget_control, wNode, get_uvalue=sPtrNode
            widget_control, (*sPtrNode).wTLB_DAVETool, /show ; but then ensure DAVE Tool is on top!
;        oTool->EnableUpdates
            IF (~previouslyDisabled) THEN $
              oTool->EnableUpdates
;        endif
    END
    
     'WIDGET_BUTTON': begin      ; Close button
        WIDGET_CONTROL, event.id, GET_UVALUE=button
        case button of
            'Close': begin
                WIDGET_CONTROL, event.top, /DESTROY
                return, 0
            end
        endcase
    end

    'WIDGET_KILL_REQUEST' : BEGIN
        ;; We don't die, we hide
        widget_control, event.top, map=0
    END

    ELSE :

ENDCASE

; Revert to the original state var for the handler
widget_control, event.handler, set_uvalue=stateTreeRoot

case widget_info(event.handler, /uname) of

    'DAVEVISMANAGER': begin
        (stateTreeRoot).identifier = (*event.value)[0] ; event.selected
        (stateTreeRoot).wContext = (*sPtrVisNode).wContext
        widget_control, event.handler, set_uvalue=stateTreeRoot

        return, {CW_DAVEVISMANAGER $
                 ,ID:event.handler $
                 ,TOP:event.top $
                 ,HANDLER:0 $
                 ,clicks:event.clicks $
                 ,identifier:(*event.value)[0] $
                 ,oVisUI:(*sPtrVisNode).oUI $
                }
    end

    else:
endcase


return, 0

END
;----------------------------------------
;+
; NAME:
;   DAVEVISMANAGER_SET_EVENT
;
; PURPOSE:
;       Set the value of the browser
;
; INPUTS:
;       ID: (required) widget ID of the top level base
;
;       VALUE: (required) integer value to be set
;
; KEYWORD PARAMETERS:
;       None
;
; OUTPUTS:
;       None
;-
PRO cw_DAVEvisManager_Set_Event,id,value
compile_opt idl2

widget_control,id,get_uvalue=state
widget_control,state.wBase,set_value=value

END
;----------------------------------------
;+
; NAME:
;   CREATETREE
;
; PURPOSE:
;       Put the cw_ittreeview in the left panel
;
; INPUTS:
;       BASE: (required) widget ID of the left base
;
; KEYWORD PARAMETERS:
;       None
;
; OUTPUTS:
;       None
;-

;PRO cw_DAVEvisManager_CREATETREE, base
;
;compile_opt idl2, hidden
;
;topid = base
;
;WHILE ((widget_info(topid,/uname) ne 'VM_TLB')) DO topid=widget_info(topid,/parent);
;
;widget_control,topid,get_uvalue=state
;if (state.isVisBrowser) then begin
;    state.wTree = CW_ITTREEVIEW(base,state.oUI, $
;                                multiple=state.multiple, $
;                                xsize=state.left_xsize,ysize=state.left_ysize, $
;                                IDENTIFIER=state.treetop,uname=state.name, $
;                                context_menu="ContextMenu/DrawContext")
;endif else begin
;    oTool = state.oUI->GetTool()
;    oRoot = oTool->GetByIdentifier(state.identifier)
;    ;; Create a simple component tree widget
;    state.wTree = cw_itcomponenttree(base, state.oUI, oRoot, $
;                                     uname=state.name, $
;                                     xsize=state.left_xsize,ysize=state.left_ysize)
;endelse;
;
;widget_control,topid,set_uvalue=state
;end


;----------------------------------------
;+
; NAME:
;   CREATEPROPSHEET
;
; PURPOSE:
;       Put the cw_itpropertysheet in the right panel
;
; INPUTS:
;       BASE: (required) widget ID of the left base
;
; KEYWORD PARAMETERS:
;       None
;
; OUTPUTS:
;       None
;-

;PRO cw_DAVEvisManager_CREATEPROPSHEET, base
;  compile_opt idl2, hidden
;  topid = base
;  ;WHILE ((temp=widget_info(topid,/parent))) NE 0l DO topid=temp
;  
;  WHILE ((widget_info(topid,/uname) ne 'VM_TLB')) DO topid=widget_info(topid,/parent)
;
;  widget_control,topid,get_uvalue=state
;  state.wProp = CW_ITPROPERTYSHEET(base, state.oUI, $
;                                   scr_xsize=state.right_xsize, $
;                                   scr_ysize=state.right_ysize, $
;                                   type=state.type, $
;                                   COMMIT=state.commit, $
;                                   /STATUS, $
;                                   VALUE=(state.Identifier)[0])
;  widget_control,topid,set_uvalue=state
;END



;===============================================================================
; cw_daveVisManager_Realize
; 
; PURPOSE:
;   Called when the widget is realized - checks widget dimensions.
;
; PARAMETERS
;   widID (in)  - The id of the base widget to be realized
;
; KEYWORDS:
;
pro cw_daveVisManager_Realize, widID
compile_opt idl2

widget_control, widID, get_uvalue=sPtr

;; Make sure the geometry is all right.
sGeom = widget_info(widID, /geometry)
cw_daveVisManager_Resize, widID, sGeom.xsize, (*sPtr).ySize0

end


;===============================================================================
; cw_daveVisManager_Resize
; 
; PURPOSE:
;   Resize the specified widget to the specified dimension.
;
; PARAMETERS
;   widID (in)  - The id of the widget to be resized
;
;   newX (in)   - The new x size
;
;   newY (in)   - the new y size
;
; KEYWORDS:
;
pro cw_daveVisManager_Resize, widID, newX, newY
compile_opt idl2

WIDGET_CONTROL, widID, get_uvalue=sPtr

;; Retrieve the button size
;geomButs = Widget_Info((*sPtr).wButtons, /geometry)

geomCW = Widget_Info(widID, /geometry)

;; Change height of vm
;widget_control, (*sPtr).wVM, SCR_XSIZE=newX-12, $ ;; why -12? It just works
;                SCR_YSIZE= newY - geomButs.scr_ysize-16
widget_control, (*sPtr).wVM, scr_xsize=newX - 12 $ ;; why -12? It just works
                ,scr_ysize= newY - 12

end


;===============================================================================
; cw_daveVisManager_CleanupVisNode
; 
; PURPOSE:
;   Callback routine triggered when a node widget is being deleted
;   from the Vis Browser tree widget. Ensure the heap uvalue is cleaned.
;
; PARAMETERS
;   wNode (in)  - The node widget.
;
; KEYWORDS:
;
pro cw_daveVisManager_CleanupVisNode, wNode
compile_opt idl2

;print,'--------------------------------------------'
;print, 'Executed cw_davevismanager_removevisnode...'
;print,'wNode = ',wNode
;print,'--------------------------------------------'


;*** Why not delete sPtr too?????
widget_control, wNode, get_uvalue=sPtr
    event = (*sPtr).event
    ptr_free, event.value ;[event.add, event.delete, event.value]

end


;===============================================================================
; cw_daveVisManager_VisToolKilled
; 
; PURPOSE:
;   Callback routine triggered when a Visualization Tool is
;   killed. This routine takes care of removing the node entry from
;   the Vis Browser tree widget.
;
; PARAMETERS
;   wTLB (in)  - The tlb of the Vis Tool.
;
; KEYWORDS:
;
pro cw_daveVisManager_VisToolKilled, wTLB
compile_opt idl2

widget_control, wTLB, get_uvalue=wNode

; Don't proceed if wNode is not valid. This would be the case if the
; Main Tool is already killed.
if ((n_elements(wNode) le 0) || ~widget_info(wNode,/valid)) then return

;; Update vis tools record - remove the deleted vis tool obj ref.
widget_control, wNode, get_uvalue=sPtr
oVisTool = (*sPtr).oUI->GetTool()
wTLB_DAVETool = (*sPtr).wTLB_DAVETool
widget_control, widget_info(wTLB_DAVETool,/child), get_uvalue=sPtr_DAVETool
visToolArr = (*(*sPTR_DAVETool).visToolArrPtr)
index = where(visToolArr ne oVisTool,count)
(*(*sPTR_DAVETool).visToolArrPtr) = (count gt 0)?  visToolArr[index] : objarr(1)

; Send a kill signal to the node representing the vis tool in the vis
; browser tree widget.
widget_control, wNode, /destroy

end



;===============================================================================
; cw_daveVisManager_Cleanup
; 
; PURPOSE:
;   Widget cleanup procedure.
;
; PARAMETERS
;   widID (in)  - The id of the base widget to be destroyed
;
; KEYWORDS:
;
pro cw_daveVisManager_Cleanup, widID
compile_opt idl2

widget_control, widID, get_uvalue=sPtr
ptr_free,sPtr

end


;-------------------------------------------------------------------------
function cw_DAVEvisManager, wParent,oUI,oDAVETOOLUI $
  ,construct_base=construct_base,xsize=xSize,ysize=ySize,_extra=_extra
;  ,GROUP_LEADER=groupLeader $
;  ,TITLE=titleIn $
;  ,VALUE=oTree $
;  ,IDENTIFIER=identifier $
;  ,TREETOP=treetop $
;  ,XSIZE=xsizeIn $
;  ,YSIZE=ysizeIn $
;  ,NAME=name $
;  ,VISIBLE=visible $
;  ,MULTIPLE=multiple $
;  ,COMMIT_PROPERTIES=COMMIT_PROPERTIES $
;  ,VISUALIZATION=isVisBrowser

compile_opt idl2

;; Check arguments.
if (N_PARAMS() lt 2) then $
  MESSAGE, 'Incorrect number of arguments.'

if (keyword_set(construct_base)) then begin
    ;; When called from wd_DAVETool, simply do the following and exit:
    ;; 1) Create a base widget for this compund widget
    ;; 2) Create a root tree widget for visualizations
    ;; 3) Create a context widget (activated by visualization nodes -
    ;;    see below)
    ;; 4) Add a state variable to the base widget
    ;; 5) Return the tree widget (NOT THE BASE!).
    
    wBase = widget_base(wParent)

    ;; Create a tree widget to serve as a root node. This tree widget
    ;; would normally be created and managed by cw_ittreeview but
    ;; because, for the Vis Browser, we only need ONE root tree to be
    ;; created this needs to be done here. The remaining functionality
    ;; of the tree widget will be provided by func/pros in cw_ittreeview.pro.
    ;;
    ;; Note, however, that the event handler is set to
    ;; 'cw_davevismanager_event' which will perform house keeping duties
    ;; before calling 'cw_ittreeview_event'
    wTree = widget_tree(wBase $
                        ,uname='DAVEVISMANAGER' $
                        ,/multiple $
                        ,event_func='cw_davevismanager_event' $ ;'cw_ittreeview_event' $
                        ,kill_notify='cw_ittreeview_killnotify' $
                        ,pro_set_value= 'cw_ittreeview_setvalue' $
                        ,func_get_value= 'cw_ittreeview_getvalue' $
                        ,/context_events $
                        ,xsize=xsize,ysize=ysize $
                        ,_EXTRA=_extra $
                       )


    ;; Register the widget with the UI object (of DAVETool) and make
    ;; the ui adaptor an observer of the tool.
    oTool = oUI->getTool()
    strObserverIdentifier=oUI->RegisterWidget(wTree,'MyTree','cw_ittreeview_callback') ;,'dummy_callback') 
    oUI->AddOnNotifyObserver, strObserverIdentifier, oTool->GetFullIdentifier()


    ;; Normally, cw_ittreeview will contain a single context menu
    ;; constructed from the contents of the 'ContextMenu/DrawContext'
    ;; container that will be applied to all entries in the tree
    ;; widget. But because in the Vis Browser, items will be linked to
    ;; different tools (hence oUIs), a new context menu has to be
    ;; created per vis node and the widget id has to be tracked so
    ;; that the appropriate one is displayed as required. 

    ;; Create Context Sensitive menus for managing Vis Tools from
    ;; their tree widgets
    wVMCMBase = widget_base(wBase $
                            ,event_func='cw_davevismanager_event' $
                            ,/context_menu,uname='VMCONMENU')
    void = widget_button(wVMCMBase $
                         ,uvalue=1 $
                         ,value='Hide Visualization' $
                         ,uname='VMTOGGLEVIEW' $
                         ,tooltip='Hide/Show Visualization')
    void = widget_button(wVMCMBase $
                         ,value='Delete Visualization' $
                         ,uname='VMDELETE' $
                         ,tooltip='Delete Visualization')
    

;    event = {CW_TREE_SEL $
;             ,ID: 0L $
;             ,TOP: 0L $
;             ,HANDLER: 0L $
;             ,CLICKS: 0 $
;             ,VALUE: PTR_NEW() $ ; these will be allocated in the event handler
;             ,ADD: PTR_NEW() $
;             ,DELETE: PTR_NEW() $
;             ,SELECTED: '' $
;            }
    event = {CW_TREE_SEL $
             ,ID: 0L $
             ,TOP: 0L $
             ,HANDLER: 0L $
             ,CLICKS:0 $
             ,VALUE: PTR_NEW() $ ; these will be allocated in the event handler
             ,SELECTED: '' $
            }

    
    ;; Get the background color we will use.
    if (~IDLitGetResource("WINDOW_BK", background, /COLOR)) then $
      background = [255b,255b,255b]
    
    state ={ $
           idTop: (N_ELEMENTS(identifier) gt 0) ? identifier : '' $
           ,oUI: oUI $
           ,idSelf: strObserverIdentifier $
;           ,idNode:'' $
           ,wContext:0L $
           ,wVMContext:wVMCMBase $
           ,wVisNode:0L $
           ,isTool: obj_isa(oTool, "IDLitTool") $
           ,VisToolState:0B $
           ,wTree: wTree $
           ,event: event $
           ,background: background $
           ,wStatus:0L $
           ,ysize0:ysize $      ;initial Y size used in realize notify
           ,idSelNonVis: '' $   ; a selected, non-vis item (data, window)
           ,identifier:'' $     ; the identifier of the selected item (duplicate) - used by wd_davetool
           ,wTLB_DAVETool:0l $
           }
    
    widget_control, wTree, set_uvalue=state ; pointer not used for compatibility 
                                ; with cw_ittreeview which for some
                                ; stupid reason was implemented
                                ; without pointers
    

    return, wTree
    
endif


; Retrieve DAVETool TLB+State variable from DAVETool UI object
oDAVEToolUI->GetProperty,group_leader=wTLB_DAVETOOL
widget_control, widget_info(wTLB_DAVETOOL,/child), get_uvalue=sPtr_DAVETool

; Need the widget ID of the root folder in the Vis Manager tree widget.
; All subsequent nodes of the tree widget will be rooted from it.
;widget_control, (*sPtr_DAVETool).wVM, get_uvalue=sPtr_VM
;wTreeRoot = (*sPtr_VM).wTree
wTreeRoot = (*sPtr_DAVETool).wVM

; Use the identifier of the window object of the Vis tool that has
; just been created as the entry point of the new node that is to be
; added to the vis browser.

; First get the Vis Tool
oVisTool = oUI->GetTool()
visToolID = oVisTool->GetFullIdentifier()
res = oVisTool->FindIdentifiers('*WINDOW',count=nRes) ; Locate identifiers containing 'WINDOWS'
if (nRes lt 1) then return, 0L
found = 0
for i=0,nRes-1 do begin         ; required id should be that of an IDLitWindow object
    oItem = oVisTool->GetByIdentifier(res[i])
    if (obj_isa(oItem,'IDLitWindow')) then begin
        found = 1
        itemID = res[i]
        break
    endif
endfor
if (~found) then return, 0L

widget_control, wTreeRoot, get_uvalue=stateTreeRoot

; Insert Vis Tool entry_
if (obj_valid(oItem)) then begin
    ;; Register the tree widget with the Vis Tool. Note that
    ;; cw_davevismanager_callback will call cw_ittreeview_callback!
    ;; And Make this UI adaptor an observer for messages from the Vis Tool.
    strObserverID=oUI->RegisterWidget(wTreeRoot,'MyTree','cw_davevismanager_callback')    
    oUI->AddOnNotifyObserver, strObserverID, visToolID
;    oUI->AddOnNotifyObserver, strObserverID, 'Visualization'

    ;; Register the Prop Sheet with this Vis Tool UI
    ;; And make the adaptor observe Visualization messages
    PSIdent = oUI->RegisterWidget((*sPtr_DAVETool).wPS,'PropertySheet','cw_itpropertysheet_callback')
    oUI->AddOnNotifyObserver, PSIdent, visToolID
    oUI->AddOnNotifyObserver, PSIdent, 'Visualization'

    ;; Also register wTLB_DAVETOOL with the Vis Tool's oUI and make
    ;; the resulting UI Adaptor observe messages from the Vis Tool and
    ;; from 'Visualization'
    ;; NB: The reason for registering wTLB_DAVETOOL with the Vis
    ;; Tool's oUI is that the oUI is only capable of dispatching
    ;; messages for observers that it knows about. Hence if
    ;; (*sPtr_DAVETool).idSelf had been directly added as an observer
    ;; this UI would have quietly ignored it when dispatching messages.
    strID = oUI->RegisterWidget(wTLB_DAVETOOL,'wdDAVETool','wd_DAVETool_callback' $
                                ,description='DAVE Main Tool UI Adaptor')
    oUI->AddOnNotifyObserver, strID, visToolID
    oUI->AddOnNotifyObserver, strID, 'Visualization'

    ;; Modify the gr window name to reflect the toolname
    oVisTool->getProperty,name=toolname,tool_filename=filename
    oItem->SetProperty, description=toolname,name=toolname ;+ ' [' + file_basename(filename) + ']'
;    oItem->RegisterProperty, 'NAME', /string, name='Label' $
;      ,description='Identify node/visulization tool',/sensitive
    oItem->RegisterProperty, 'DESCRIPTION', /string, name='Visualization Name'
    ;widget_control, wNode, set_value=toolname + ' [' + file_basename(filename) + ']'


    ;; Add a new node in the tree representing the Vis Tool
    cw_ittreeview_addLevel, wTreeRoot,oItem,wTreeRoot,oUI,strObserverID,/EXPANDED

    ;; Retrieve the widget ID of the node that was just added
    wNode = widget_info(wTreeRoot,find_by_uname=itemID)
    
    ;; Add a kill notify callback routine
    widget_control, wNode, kill_notify='cw_davevismanager_cleanupvisnode'

    ;; * Add a kill notify callback routine to the tlb of the Vis Tool's
    ;;   main widget. We need to know when the tool is being
    ;;   killed. 
    ;; * Stuff the value of wNode in the uvalue of the tlb.
    ;; * Make wTLB_DAVETOOL a group_leader for wTLB_VisTool
    oUI->GetProperty, group_leader=wTLB_VisTool
    widget_control, wTLB_VisTool $
                    ,set_uvalue=wNode $
                    ,kill_notify='cw_davevismanager_vistoolkilled' $
                    ,group_leader=wTLB_DaveTool

    ;; Update this Vis Tool's  TLB and oUI in a list maintained in the
    ;; state var of the DAVETool's TLB
    ;(*(*sPtr_DAVETool).visTLBListPtr) = [(*(*sPtr_DAVETool).visTLBListPtr),wTLB_VisTool]
    ;(*(*sPtr_DAVETool).visOUIListPtr) = [(*(*sPtr_DAVETool).visOUIListPtr),oUI]
    

    ;strObsID=oUI->RegisterWidget(wNode,'MyNode','cw_davevismanager_callback')
    ;oUI->AddOnNotifyObserver, strObsID, oVisTool->GetFullIdentifier()

    ;; Create a context menu from the 'ContextMenu/DrawContext' container
    ;; of the Vis Tool's hierarchy. Attach the context menu to
    ;; wTreeRoot's parent (it generates context-sensitive events)
    wContext = cw_itmenu(widget_info(wTreeRoot,/parent),oUI $
                         ,'ContextMenu/DrawContext',/context_menu)

    ;; Get a copy of the state variable from wTreeRoot and store it in
    ;; the wNode after updating the oUI and wContext tags. 
    ;; Whenever wNode (and its sub-widgets) generates an event, it
    ;; would then be possible to locate this state var and pass it
    ;; along to wTreeRoot. This is necessary because
    ;; cw_ittreeview_event only retrieves info from the tree_root widget!
    ;; (wNode will be identified in the event handler by looking for
    ;; the widget whose parent is the tree_root!!!) 
    sPtrNode = ptr_new((stateTreeRoot))
    (*sPtrNode).oUI = oUI
    (*sPtrNode).idSelf = strObserverID
    (*sPtrNode).VisToolState = 1B
    (*sPtrNode).wContext = wContext
    (*sPtrNode).wVisNode = wNode
    (*sPtrNode).wTLB_DAVETool = wTLB_DAVETool 
    widget_control, wNode, set_uvalue=sPtrNode
    
    
    ;; Update tree widget selection state to match Vis Tool's.
    oItems = oVisTool->GetSelectedItems(count=nItems)
    if (nItems gt 0) then begin
        ;; Unselect any items currently selected in the tree widget
        wSel = widget_info(wTreeRoot,/tree_select)
        if (widget_info(wSel[0],/valid)) then $
          for i = 0,n_elements(wSel)-1 do widget_control, wSel[i], set_tree_select=0

        ;; Select items selected in the visualization
        for i=0, nItems-1 do begin
            idItem= WIDGET_INFO(wTreeRoot,find_by_uname=oItems[i]->GetfullIdentifier())
            if (idItem gt 0) then begin
                selectionChanged = 1
                WIDGET_CONTROL,idItem, /SET_TREE_SELECT, set_tree_visible=(i eq 0)
                IDs = (n_elements(IDs) eq 0)? $
                      oItems[i]->GetfullIdentifier() : $
                      [IDs,oItems[i]->GetfullIdentifier()]
            endif
        endfor
        ;; If necessary, notify observers of selection change message
        ;; from 'Visualization'
        if ((n_elements(IDs) gt 0) && ((*sPtr_DAVETool).currentTab eq 1)) then begin
;        (oDAVEToolUI->GetTool())->DoOnNotify,'Visualization','Select',IDs
;            oVisTool->DoOnNotify,'Visualization','Selectionchanged',IDs
            oVisTool->DoOnNotify,'Visualization','Select',IDs
        endif
    endif

    ;; Make this the current Vis Tool
    (*sPtr_DAVETool).oVisUI = oUI

    ;; Record the visTool obj ref.
    visToolArr = [(*(*sPTR_DAVETool).visToolArrPtr),oVisTool]
    index = where(obj_valid(visToolArr),count)
    (*(*sPTR_DAVETool).visToolArrPtr) = (count gt 0)?  visToolArr[index] : objarr(1)
endif


return, 0L

end
