; $Id$
;===============================================================================
; plot3dOptions::GetProperty
; 
; PURPOSE:
;   Accessor
;
; PARAMETERS:
;
; KEYWORDS:
;   offset [out] - The offset that should be applied to the data
;
; RETURN VALUE:
;
pro plot3dOptions::GetProperty,plane=plane,maxgrp=maxgrp,grps=grps,nygrps=ycnt $
                   ,nxgrps=xcnt, grpIndices=grpIndices, _REF_EXTRA=etc
compile_opt idl2

;
if (arg_present(plane)) then plane = self.plane
if (arg_present(xcnt)) then xcnt = self._xgrpcnt
if (arg_present(ycnt)) then ycnt = self._ygrpcnt
if (arg_present(grps)) then  grps = self.grps
if (arg_present(grpIndices)) then  begin
   void = compactString2IntVector(self.grps,grpIndices)
endif
if (arg_present(maxgrp)) then  maxgrp = self._maxgrp


; call base class accessor
if(n_elements(etc) gt 0) then $
  self->IDLitComponent::GetProperty, _EXTRA=etc

end


;===============================================================================
; plot3dOptions::SetProperty
; 
; PURPOSE:
;   Mutator
;
; PARAMETERS:
;
; KEYWORDS:
;   offset [in] - The offset that should be applied to the data
;
; RETURN VALUE:
;
pro plot3dOptions::SetProperty,plane=plane,grps=strGrps,nygrps=ycnt,nxgrps=xcnt, _EXTRA=etc
compile_opt idl2

; nos of elements in x or y-axis has changed
; so also modify the maximum groups available and reset the grps to plot 
; to ensure they do not exceed the maximum available.
if ((n_elements(xcnt) gt 0) || (n_elements(ycnt) gt 0)) then begin
   if (n_elements(xcnt) gt 0) then self._xgrpcnt = xcnt
   if (n_elements(ycnt) gt 0) then self._ygrpcnt = ycnt

   validGrpMax = (self.plane eq 0)? self._ygrpcnt : self._xgrpcnt
   self._maxgrp=validGrpMax
   maxLabel = (self.plane eq 0)? 'Max Y Group' : 'Max X Group'
   self->SetPropertyAttribute, 'maxgrp', name=maxLabel

   Self->GetProperty, grpindices=intGrps
   index = where(intGrps le validGrpMax, isValid)
   if (isValid gt 0) then intGrps = intGrps[index]
   if (intVector2CompactString(intGrps,strGrps)) then begin
      Self.grps = strGrps
   endif
endif

; view plane has changed (0 or 1)
if (n_elements(plane) gt 0) then begin
    self.plane=plane

    ;; reset groups field to be consistent with selected plane
    validGrpMax = (self.plane eq 0)? self._ygrpcnt : self._xgrpcnt
    self._maxgrp=validGrpMax
    maxLabel = (self.plane eq 0)? 'Max Y Group Available' : 'Max X Group Available'
    self->SetPropertyAttribute, 'maxgrp', name=maxLabel

    label = (self.plane eq 0)? 'Y Group(s) to Plot (eg 2,4-6,8)' : 'X Group(s) to Plot (eg 2,4-6,8)'
    self->setPropertyAttribute, 'grps', name=label ;, valid_range=[1,validGrpMax]
    
    Self->GetProperty, grpindices=intGrps
    index = where(intGrps le validGrpMax, isValid)
    if (isValid gt 0) then intGrps = intGrps[index]
 
    if (intVector2CompactString(intGrps,strGrps)) then begin
       Self.grps = strGrps
    endif
    
endif

; Change in groups to view.
if (n_elements(strGrps) gt 0) then begin
    validGrpMax = (self.plane eq 0)? self._ygrpcnt : self._xgrpcnt
    
    strGrpsCopy = strGrps
    strGrpsCopy = validateCompactString(strGrpsCopy)
    
    if (compactString2IntVector(strGrpsCopy,intGrps)) then begin
      index = where(intGrps le validGrpMax, isValid)
      if (isValid gt 0) then intGrps = intGrps[index]
    
      if (intVector2CompactString(intGrps,strGrpsCopy)) then begin
         Self.grps = strGrpsCopy
      endif
    
    endif
endif


; Call base class mutator
if(n_elements(etc) gt 0) then $
  self->IDLitComponent::SetProperty, _EXTRA=etc 

end


;===============================================================================
; plot3dOptions::Cleanup
pro plot3dOptions::Cleanup
compile_opt idl2

;if (ptr_valid(self._xGrpValues)) then ptr_free, self._xGrpValues
;if (ptr_valid(self._yGrpValues)) then ptr_free, self._yGrpValues

end


;===============================================================================
; plot3dOptions::Init
; 
; PURPOSE:
;   Initialize an object of this class
;
; PARAMETERS:
;
; KEYWORDS:
;
; RETURN VALUE:
;    1 - if successful
;    0 - otherwise
;
function plot3dOptions::init,  name=name, desc=desc, xgrpcnt=xcnt, ygrpcnt=ycnt, _REF_EXTRA=etc 
compile_opt idl2

if ((n_elements(xcnt) eq 0) || xcnt le 0) then xcnt = 1
if ((n_elements(ycnt) eq 0) || ycnt le 0) then ycnt = 1

self._xgrpcnt = xcnt
self._ygrpcnt = ycnt
self._maxgrp = ycnt

self.grps = '1'

if(not keyword_set(name))then name ="Plot3d Options"
if(not keyword_set(description))then desc ="Specify plane/group to display"

; Initialize superclass
if (~self->IDLitComponent::Init(/register_properties,name=name, description=desc, _EXTRA=etc)) then $
  return, 0

; register properties
self->registerProperty, 'plane', name='Plane to Plot', enumlist=['Z-X Plane','Z-Y Plane']
self->RegisterProperty, 'maxgrp', name='Max Y Group Available',/integer,sensitive=0
self->registerProperty, 'grps', name='Y Group(s) to Plot (eg 2,4-6,8)',/string ;,valid_range=[1,self._ygrpcnt]

if (n_elements(etc) gt 0) then $
  self->SetProperty, _extra=etc

return, 1
end


;===============================================================================
; plot3dOptions__define
; 
; PURPOSE:
;   plot3dOptions class structure definition
;
pro plot3dOptions__define
compile_opt idl2

struc = {plot3dOptions $
         ,inherits IDLitComponent $
         ,plane:0B $            ;
         ,grps:'' $            ;
         ,_xGrpCnt:0.0 $        ;
         ,_yGrpCnt:0.0 $        ;
         ,_maxgrp:0.0 $
;         ,_xGrpValues:ptr_new() $        ;
;         ,_yGrpValues:ptr_new() $        ;
        }

end
