; $Id$ 
;
; Copyright (c) 2000-2004, Research Systems, Inc.  All rights reserved.
;   Unauthorized reproduction prohibited.
;----------------------------------------------------------------------------
;+
; CLASS_NAME:
;   IDLitToolbase
;
; PURPOSE:
;   This file implements the BT7 PSD Tool object
;
; CATEGORY:
;
;
; SUPERCLASSES:
;   IDLitTool
;
; SUBCLASSES:
;
; CREATION:
;   See IDLitToolbase::Init
;
; METHODS:
;   This class has the following methods:
;
;   IDLitToolbase::Init
;
; INTERFACES:
; IIDLProperty
;-



;===============================================================================
; Bt7psdTool::GetSystem
;
; PURPOSE:
;   Return the IDLitSystem object
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::GetSystem
  compile_opt idl2

  Return, self->_Getsystem()

end


;===============================================================================
; Bt7psdTool::GetUI
;
; PURPOSE:
;   Return the IDLitUI object for this tool
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::GetUI
  compile_opt idl2

  Return, self._ouiconnection

end


;-------------------------------------------------------------------------------
pro Bt7psdtool::Cleanup
  compile_opt idl2

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      ;;print, 'Error handled!'
      eTitle = 'Bt7psdTool::Cleanup: Error encountered'
      eMsg = 'An error or unusual condition was encountered!'
      eMsg = [eMsg,'Please, report the following to the DAVE team:']
      eMsg = [eMsg,!error_state.msg]
      void = Dialog_message(/error,eMsg,title=eTitle)

      Catch, /cancel
      Ptr_free, Self.prefsptr
      Ptr_free, Self.historyptr
      Self->Idlittool::cleanup
      Self->Enableupdates
      Return
    endif
  endif

  Self->Disableupdates

  ; save session preferences
  status = Self->Savepreferences()

  Ptr_free, Self.prefsptr
  Ptr_free, Self.historyptr

  ; Clean up samp container
  oItems = Self.sampcontref->Get(/all, count=n)
  if (n gt 0) then begin
    for i=0,n-1 do begin
      void = oItems[i]->Getmetadata('DATAPTRREF',dataPtr)
      if (Ptr_valid(dataPtr)) then Heap_free, dataPtr
    endfor
  endif

  ; Clean up samp container
  oItems = Self.bkgdcontref->Get(/all, count=n)
  if (n gt 0) then begin
    for i=0,n-1 do begin
      void = oItems[i]->Getmetadata('DATAPTRREF',dataPtr)
      if (Ptr_valid(dataPtr)) then Heap_free, dataPtr
    endfor
  endif


  Obj_destroy, [Self.sampcontref,Self.bkgdcontref]

  ; Call base class cleanup
  self->Idlittool::cleanup

  Self->Enableupdates

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; Bt7psdTool::savePreferences
;
; PURPOSE:
;   Update and save current user preferences
;
; PARAMETERS:
;
; RETURN VALUE:
;-
function Bt7psdtool::SavePreferences, skip_filesave=skip_filesave
  compile_opt idl2

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB
  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      ;;print, 'Error handled!'
      eTitle = 'Bt7psdTool::savePreferences: Error encountered'
      eMsg = 'An error or unusual condition was encountered!'
      eMsg = [eMsg,'Please, report the following to the DAVE team:']
      eMsg = [eMsg,!error_state.msg]
      void = Dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
      Catch, /cancel
      Return, 0
    endif
  endif

  ; Save current user graphic customizations and preferences
  if (Self->Hasvisualizations()) then begin
    oWin = Self->Getcurrentwindow()
    oView = oWin->Getcurrentview()
    oLayer = oView->Getcurrentlayer()
    oWorld = oLayer->Getworld()
    oDataSpace = oWorld->Getdataspaces()
    oVis = oDataSpace->Getvisualizations(count = nVis)

    for j=nVis-1,0,-1 do begin
      oVis[j]->Select
      Self->Savevisprops, oVis[j]
    endfor
  endif

  Self->Getproperty, preferences=preferences

  if Keyword_set(skip_filesave) then Return, 1

  if (N_elements(preferences) gt 0) then $
    status = Bt7psdreducpreferences(preferences, /save)

  Return, 1

end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::Exit
;+
; PURPOSE:
;   Exit handler
;
; PARAMETERS:
;
; RETURN VALUE:
;-
function Bt7psdtool::Exit
  compile_opt idl2

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB
  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      ;;print, 'Error handled!'
      eTitle = 'Bt7psdTool::Exit: Error encountered'
      eMsg = 'An error or unusual condition was encountered!'
      eMsg = [eMsg,'Please, report the following to the DAVE team:']
      eMsg = [eMsg,!error_state.msg]
      void = Dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
      Catch, /cancel
      Return, 0
    endif
  endif

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB
  Wd_bt7psdtool_event, { Widget_kill_request, id:wTLB, top:wTLB, handler:wTLB }

  Return, 1
end


;-------------------------------------------------------------------------------
pro Bt7psdtool::GetProperty, nameTag=nameTag, prompt=prompt, prmptTitle=prmptTitle, prmptDesc=prmptDesc $
  ,nActiveDetectors=nActiveDetectors,energyUnitFlag=energyUnitFlag, PSDDisplayAs=PSDDisplayAs $
  ,maskedDets=maskedDets,fastFunc=fastFunc,monScaleValue=monScaleValue,multipleMsliceWinFlag=multipleMsliceWinFlag $
  ,monScaleFlag=monScaleFlag,maskFlag=maskFlag,bkgdFlag=bkgdFlag,calibParamsisSet=calibParamsisSet $
  ,fastFlag=fastFlag,nSamp=nSamp,nBkgd=nBkgd,nFast=nFast,effNormFlag=effNormFlag,logFlag=logFlag $
  ,sumSampFlag=sumSampFlag,sumBkgdFlag=sumBkgdFlag, chDelA4isSet=chDelA4isSet, curMaxDataLen=curMaxDataLen $
  ,sampContRef=sampContRef,bkgdContRef=bkgdContRef,fastContRef=fastContRef,phiOffset=phiOffset $
  ,data_directory=dataDir,mev2wnos=mev2wnos,fastparams=fastparams, daveTool=daveTool $
  ,sampSelected=sampSelected, bkgdSelected=bkgdSelected, fastSelected=fastSelected $
  ,bkgdSubVarFlag=bkgdSubVarFlag,bkgdSubVarTol=bkgdSubVarTol, clearDisplayFlag=clearDisplayFlag $
  ,constBinFlag=constBinFlag,useTempAverageFlag=useTempAverageFlag $
  ,preferences=preferences,history=history,oplotFastFitFlag=oplotFastFitFlag $
  ,minChan=minChan,maxChan=maxChan,minDPnt=minDPnt,maxDPnt=maxDPnt,dpntIndex=dpntIndex $
  ,sharedSettingsFlag=sharedSettingsFlag,settingIndex=settingIndex, combVarVal=combVarVal $
  ,oplotBkgdFlag=oplotBkgdFlag, modifiedStatus=modifiedStatus, ftpObject=ftpObject $
  ,defaultIntensityFlag=defaultIntensityFlag, maxIntensity=maxIntensity, minIntensity=minIntensity $
  ,latParamFlag=latParamFlag, latticeParameters=latticeParameters, qUnits=qUnits $
  ,xAxisVar=xAxisVar,yAxisVar=yAxisVar,minBinWidth=minBinWidth,binwidths=binWidths $
  ,exportIndex1=exportIndex1,exportIndex2=exportIndex2,exportIndex3=exportIndex3 $
  ,indepVar1List=indepVar1List,indepVar2List=indepVar2List,indepVar3List=indepVar3List $
  ,detailedBalanceFlag=detailedBalanceFlag,fastValue=fastValue, resCorFlag=resCorFlag $
  ,monCorFlag=monCorFlag, normalizeTo=normalizeTo ,mergeChannelsFlag=mergeChannelsFlag $
  ,sampTypeFlag=sampTypeFlag, sampTyps=sampTyps $
  ,selectedIDs=selectedIDs,nSelectedIDs=nSelectedIDs,selectedNames=selectedNames  $
  ,s_errorbar_capsize=s_errorbar_capsize $
  ,s_transparency=s_transparency $
  ,s_antialias=s_antialias $
  ,s_color=s_color $
  ,s_errorbar_color=s_errorbar_color $
  ,s_use_default_color=s_use_default_color $
  ,s_sym_increment=s_sym_increment $
  ,s_sym_index=s_sym_index $
  ,s_sym_size=s_sym_size $
  ,s_sym_color=s_sym_color $
  ,s_sym_thick=s_sym_thick $
  ,s_y_errorbars=s_y_errorbars $
  ,s_linestyle=s_linestyle $
  ,s_thick=s_thick $
  ,s_sym_filled=s_sym_filled $
  ,s_sym_fill_color=s_sym_fill_color $
  ,s_font_name=s_font_name  $
  ,s_font_size=s_font_size $
  ,s_text_color=s_text_color  $
  ,b_errorbar_capsize=b_errorbar_capsize $
  ,b_transparency=b_transparency $
  ,b_antialias=b_antialias $
  ,b_color=b_color $
  ,b_errorbar_color=b_errorbar_color $
  ,b_use_default_color=b_use_default_color $
  ,b_sym_increment=b_sym_increment $
  ,b_sym_index=b_sym_index $
  ,b_sym_size=b_sym_size $
  ,b_sym_color=b_sym_color $
  ,b_sym_thick=b_sym_thick $
  ,b_y_errorbars=b_y_errorbars $
  ,b_linestyle=b_linestyle $
  ,b_thick=b_thick $
  ,b_sym_filled=b_sym_filled $
  ,b_sym_fill_color=b_sym_fill_color $
  ,b_font_name=b_font_name  $
  ,b_font_size=b_font_size $
  ,b_text_color=b_text_color  $
  ,f_errorbar_capsize=f_errorbar_capsize $
  ,f_transparency=f_transparency $
  ,f_antialias=f_antialias $
  ,f_color=f_color $
  ,f_errorbar_color=f_errorbar_color $
  ,f_use_default_color=f_use_default_color $
  ,f_sym_increment=f_sym_increment $
  ,f_sym_index=f_sym_index $
  ,f_sym_size=f_sym_size $
  ,f_sym_color=f_sym_color $
  ,f_sym_thick=f_sym_thick $
  ,f_y_errorbars=f_y_errorbars $
  ,f_linestyle=f_linestyle $
  ,f_thick=f_thick $
  ,f_sym_filled=f_sym_filled $
  ,f_sym_fill_color=f_sym_fill_color $
  ,f_font_name=f_font_name  $
  ,f_font_size=f_font_size $
  ,f_text_color=f_text_color  $
  ,ff_transparency=ff_transparency $
  ,ff_antialias=ff_antialias $
  ,ff_color=ff_color $
  ,ff_use_default_color=ff_use_default_color $
  ,ff_sym_index=ff_sym_index $
  ,ff_linestyle=ff_linestyle $
  ,ff_thick=ff_thick $
  ,sb_transparency=sb_transparency $
  ,sb_antialias=sb_antialias $
  ,sb_color=sb_color $
  ,sb_use_default_color=sb_use_default_color $
  ,sb_sym_index=sb_sym_index $
  ,sb_linestyle=sb_linestyle $
  ,sb_thick=sb_thick $
  ,_REF_EXTRA=etc

  compile_opt idl2

  ; daveTool
  if (Arg_present(daveTool)) then $
    daveTool = self.davetool

  if (Arg_present(s_errorbar_capsize)) then s_errorbar_capsize=Self.s_errorbar_capsize
  if (Arg_present(s_transparency)) then s_transparency=Self.s_transparency
  if (Arg_present(s_antialias)) then s_antialias=Self.s_antialias
  if (Arg_present(s_color)) then s_color=Self.s_color
  if (Arg_present(s_errorbar_color)) then s_errorbar_color=Self.s_errorbar_color
  if (Arg_present(s_use_default_color)) then s_use_default_color=Self.s_use_default_color
  if (Arg_present(s_sym_increment)) then s_sym_increment=Self.s_sym_increment
  if (Arg_present(s_sym_index)) then s_sym_index=Self.s_sym_index
  if (Arg_present(s_sym_size)) then s_sym_size=Self.s_sym_size
  if (Arg_present(s_sym_color)) then s_sym_color=Self.s_sym_color
  if (Arg_present(s_sym_thick)) then s_sym_thick=Self.s_sym_thick
  if (Arg_present(s_y_errorbars)) then s_y_errorbars=Self.s_y_errorbars
  if (Arg_present(s_linestyle)) then s_linestyle=Self.s_linestyle
  if (Arg_present(s_thick)) then s_thick=Self.s_thick
  if (Arg_present(s_sym_filled)) then s_sym_filled=Self.s_sym_filled
  if (Arg_present(s_sym_fill_color)) then s_sym_fill_color=Self.s_sym_fill_color
  if (Arg_present(s_font_name)) then s_font_name=Self.s_font_name
  if (Arg_present(s_font_size)) then s_font_size=Self.s_font_size
  if (Arg_present(s_text_color)) then s_text_color=Self.s_text_color
  if (Arg_present(b_errorbar_capsize)) then b_errorbar_capsize=Self.b_errorbar_capsize
  if (Arg_present(b_transparency)) then b_transparency=Self.b_transparency
  if (Arg_present(b_antialias)) then b_antialias=Self.b_antialias
  if (Arg_present(b_color)) then b_color=Self.b_color
  if (Arg_present(b_errorbar_color)) then b_errorbar_color=Self.b_errorbar_color
  if (Arg_present(b_use_default_color)) then b_use_default_color=Self.b_use_default_color
  if (Arg_present(b_sym_increment)) then b_sym_increment=Self.b_sym_increment
  if (Arg_present(b_sym_index)) then b_sym_index=Self.b_sym_index
  if (Arg_present(b_sym_size)) then b_sym_size=Self.b_sym_size
  if (Arg_present(b_sym_color)) then b_sym_color=Self.b_sym_color
  if (Arg_present(b_sym_thick)) then b_sym_thick=Self.b_sym_thick
  if (Arg_present(b_y_errorbars)) then b_y_errorbars=Self.b_y_errorbars
  if (Arg_present(b_linestyle)) then b_linestyle=Self.b_linestyle
  if (Arg_present(b_thick)) then b_thick=Self.b_thick
  if (Arg_present(b_sym_filled)) then b_sym_filled=Self.b_sym_filled
  if (Arg_present(b_sym_fill_color)) then b_sym_fill_color=Self.b_sym_fill_color
  if (Arg_present(b_sym_fill_color)) then b_errorbar_capsize=Self.b_errorbar_capsize
  if (Arg_present(b_font_name)) then b_font_name=Self.b_font_name
  if (Arg_present(b_font_size)) then b_font_size=Self.b_font_size
  if (Arg_present(b_text_color)) then b_text_color=Self.b_text_color
  if (Arg_present(f_transparency)) then f_transparency=Self.f_transparency
  if (Arg_present(f_antialias)) then f_antialias=Self.f_antialias
  if (Arg_present(f_color)) then f_color=Self.f_color
  if (Arg_present(f_errorbar_color)) then f_errorbar_color=Self.f_errorbar_color
  if (Arg_present(f_use_default_color)) then f_use_default_color=Self.f_use_default_color
  if (Arg_present(f_sym_increment)) then f_sym_increment=Self.f_sym_increment
  if (Arg_present(f_sym_index)) then f_sym_index=Self.f_sym_index
  if (Arg_present(f_sym_size)) then f_sym_size=Self.f_sym_size
  if (Arg_present(f_sym_color)) then f_sym_color=Self.f_sym_color
  if (Arg_present(f_sym_thick)) then f_sym_thick=Self.f_sym_thick
  if (Arg_present(f_y_errorbars)) then f_y_errorbars=Self.f_y_errorbars
  if (Arg_present(f_linestyle)) then f_linestyle=Self.f_linestyle
  if (Arg_present(f_thick)) then f_thick=Self.f_thick
  if (Arg_present(f_sym_filled)) then f_sym_filled=Self.f_sym_filled
  if (Arg_present(f_sym_fill_color)) then f_sym_fill_color=Self.f_sym_fill_color
  if (Arg_present(f_font_name)) then f_font_name=Self.f_font_name
  if (Arg_present(f_font_size)) then f_font_size=Self.f_font_size
  if (Arg_present(f_text_color)) then f_text_color=Self.f_text_color
  if (Arg_present(ff_transparency)) then ff_transparency=Self.ff_transparency
  if (Arg_present(ff_antialias)) then ff_antialias=Self.ff_antialias
  if (Arg_present(ff_color)) then ff_color=Self.ff_color
  if (Arg_present(ff_use_default_color)) then ff_use_default_color=Self.ff_use_default_color
  if (Arg_present(ff_sym_index)) then ff_sym_index=Self.ff_sym_index
  if (Arg_present(ff_linestyle)) then ff_linestyle=Self.ff_linestyle
  if (Arg_present(ff_thick)) then ff_thick=Self.ff_thick
  if (Arg_present(sb_transparency)) then sb_transparency=Self.sb_transparency
  if (Arg_present(sb_antialias)) then sb_antialias=Self.sb_antialias
  if (Arg_present(sb_color)) then sb_color=Self.sb_color
  if (Arg_present(sb_use_default_color)) then sb_use_default_color=Self.sb_use_default_color
  if (Arg_present(sb_sym_index)) then sb_sym_index=Self.sb_sym_index
  if (Arg_present(sb_linestyle)) then sb_linestyle=Self.sb_linestyle
  if (Arg_present(sb_thick)) then sb_thick=Self.sb_thick


  ; Preferences structure
  if (Arg_present(preferences)) then begin
    if (Ptr_valid(Self.prefsptr)) then begin
      preferences = (*self.prefsptr)

      ; update the preferences structure
      ntags = N_tags(preferences)
      tags = Tag_names(preferences)
      for i=0,ntags-1 do begin
        status = Self->Getpropertybyidentifier(tags[i], value)
        if (status) then preferences.(i) = Strjoin(Strtrim(String(value),2),',')
        ;         if (~status) then continue
        ;         if (strmatch(tags[i],'*color*',/fold_case)) then begin
        ;            ; for colors, first convert byte vector to a string eg [0,128,0] to '0,128,0'
        ;            preference.(i) = strjoin(value,',')
        ;         endif else $
        ;            preferences.(i) = value
      endfor
    endif
  endif


  if (Arg_present(PSDDisplayAs)) then PSDDisplayAs = self.PSDDisplayAs
  if (Arg_present(combVarVal)) then combVarVal = self.combvarval
  ; modifiedStatus
  if (Arg_present(modifiedStatus)) then modifiedStatus = self.modifiedflag
  ; nameTag
  if (Arg_present(nameTag)) then nameTag = self.nametag
  ; nameTag
  if (Arg_present(history)) then history = (*Self.historyptr)
  ; prompt
  if (Arg_present(prompt)) then prompt = self.prompt
  ; prompt Title
  if (Arg_present(prmptTitle)) then prmptTitle = self.prompttitle
  ; prompt Desc
  if (Arg_present(prmptDesc)) then prmptDesc = self.promptdesc
  ;
  if (Arg_present(constBinFlag)) then constBinFlag = Self.constbinflag
  ;
  if (Arg_present(useTempAverageFlag)) then useTempAverageFlag = Self.usetempaverageflag
  ;
  if (Arg_present(nSamp)) then nSamp = Self.nsamp
  ;
  if (Arg_present(nBkgd)) then nBkgd = Self.nbkgd
  ;
  if (Arg_present(nFast)) then nFast = Self.nfast
  ;
  if (Arg_present(sampSelected)) then sampSelected = Self.sampselected
  ;
  if (Arg_present(bkgdSelected)) then bkgdSelected = Self.bkgdselected
  ;
  if (Arg_present(fastSelected)) then fastSelected = Self.fastselected
  ;
  if (Arg_present(sampContRef)) then sampContRef = Self.sampcontref
  ;
  if (Arg_present(bkgdContRef)) then bkgdContRef = Self.bkgdcontref
  ;
  if (Arg_present(fastContRef)) then fastContRef = Self.fastcontref
  ;
  if (Arg_present(nActiveDetectors)) then nActiveDetectors = Self.nactivedetectors
  ;
  if (Arg_present(energyUnitFlag)) then energyUnitFlag = Self.energyunitflag
  ;
  if (Arg_present(maskedDets)) then maskedDets = Self.maskeddets
  ;
  if (Arg_present(fastparams)) then fastparams = Self.fastparams
  ;
  if (Arg_present(fastfunc)) then fastfunc = Self.fastfunc
  ;
  if (Arg_present(funcs)) then funcs = Self.fastfuncs
  ;
  if (Arg_present(monScaleValue)) then monScaleValue = Self.monscalevalue
  ;
  if (Arg_present(monScaleFlag)) then monScaleFlag = Self.monscaleflag
  ;
  if (Arg_present(sumSampFlag)) then sumSampFlag = Self.sumsampflag
  ;
  if (Arg_present(sumBkgdFlag)) then sumBkgdFlag = Self.sumbkgdflag
  ;
  if (Arg_present(maskFlag)) then maskFlag = Self.maskflag
  ;
  if (Arg_present(bkgdFlag)) then bkgdFlag = Self.bkgdflag
  ;
  if (Arg_present(bkgdSubVarFlag)) then bkgdSubVarFlag = Self.bkgdsubvarflag
  ;
  if (Arg_present(bkgdSubVarTol)) then bkgdSubVarTol = Self.bkgdsubvartol
  ;
  if (Arg_present(fastFlag)) then fastFlag = Self.fastflag
  ;
  if (Arg_present(dataDir)) then dataDir = Self.datadir
  ;
  if (Arg_present(mev2wnos)) then mev2wnos = Self.mev2wnos
  ;
  if (Arg_present(oplotFastFitFlag)) then oplotFastFitFlag = Self.oplotfastfitflag
  ;
  if (Arg_present(oplotBkgdFlag)) then oplotBkgdFlag = Self.oplotbkgdflag
  ;
  if (Arg_present(ftpObject)) then ftpObject = Self.ftpobject
  ;
  if (Arg_present(latParamFlag)) then latParamFlag = Self.latparamflag
  ;
  if (Arg_present(latticeParameters)) then latticeParameters = Self.latticeparameters
  ;
  if (Arg_present(detailedBalanceFlag)) then detailedBalanceFlag = Self.detailedbalanceflag
  ;
  if (Arg_present(fastValue)) then fastValue = Self.fastvalue
  ;
  if (Arg_present(resCorFlag)) then resCorFlag = Self.rescorflag
  ;
  if (Arg_present(monCorFlag)) then monCorFlag = Self.moncorflag
  ;
  if (Arg_present(normalizeTo)) then normalizeTo = Self.normalizeto
  ;
  if (Arg_present(sampTypeFlag)) then sampTypeFlag = Self.samptypeflag
  ;
  if (Arg_present(clearDisplayFlag)) then clearDisplayFlag = Self.cleardisplayflag
  ;
  if (Arg_present(sampTyps)) then sampTyps = (*Self.samptyps)
  ;
  if (Arg_present(qUnits)) then qUnits = Self.qunits
  ;
  if (Arg_present(xAxisVar)) then xAxisVar = Self.xaxisvar
  ;
  if (Arg_present(yAxisVar)) then yAxisVar = Self.yaxisvar
  ;
  if (Arg_present(indepVar1List)) then indepVar1List = (*Self.indepvars1ptr)
  ;
  if (Arg_present(indepVar12List)) then indepVar2List = (*Self.indepvars2ptr)
  ;
  if (Arg_present(indepVar2List)) then indepVar2List = (*Self.indepvars2ptr)
  ;
  if (Arg_present(indepVar3List)) then indepVar3List = (*Self.indepvars3ptr)
  ;
  if (Arg_present(exportIndex1)) then exportIndex1 = (*Self.exportindex1ptr)
  ;
  if (Arg_present(exportIndex2)) then exportIndex2 = (*Self.exportindex2ptr)
  ;
  if (Arg_present(exportIndex3)) then exportIndex3 = (*Self.exportindex3ptr)
  ;
  if (Arg_present(calibParamsisSet)) then calibParamsisSet = Self.calibparamsisset
  ;
  if (Arg_present(multipleMsliceWinFlag)) then multipleMsliceWinFlag = Self.multiplemslicewinflag
  ;
  if (Arg_present(effNormFlag)) then effNormFlag = Self.effnormflag
  ;
  if (Arg_present(mergeChannelsFlag)) then mergeChannelsFlag = Self.mergechannelsflag
  ;
  if (Arg_present(minBinWidth)) then minBinWidth = Self.minbinwidth
  ;
  if (Arg_present(binWidths)) then binWidths = Self.binwidths
  ;
  if (Arg_present(defaultIntensityFlag)) then defaultIntensityFlag = Self.defaultintensityflag
  ;
  if (Arg_present(maxIntensity)) then maxIntensity = Self.maxintensity
  ;
  if (Arg_present(minIntensity)) then minIntensity = Self.minintensity
  ;
  if (Arg_present(phiOffset)) then phiOffset = Self.phioffset
  ;
  if (Arg_present(logFlag)) then logFlag = Self.logflag
  ;
  if (Arg_present(minChan)) then minChan = Self.minchan
  ;
  if (Arg_present(maxChan)) then maxChan = Self.maxchan
  ;
  if (Arg_present(minDPnt)) then minDPnt = Self.mindpnt
  ;
  if (Arg_present(maxDPnt)) then maxDPnt = Self.maxdpnt
  ;
  if (Arg_present(sharedSettingsFlag)) then sharedSettingsFlag = Self.sharedsettingsflag
  ;
  if (Arg_present(settingIndex)) then settingIndex = Self.settingindex
  ;
  if (Arg_present(dpntIndex)) then dpntIndex = Self.dpntindex
  ;
  if (Arg_present(selectedIDs) || Arg_present(nSelectedIDs) || Arg_present(selectedNames)) then begin
    oUI = Self->Getui()
    oUI->Getproperty, group_leader = wTLB
    wChild = Widget_info(wTLB, /CHILD)
    Widget_control, wChild, GET_UVALUE=sPtr
    ; retrieve list of all _selected_ datasets from the data manager
    wDM = (*sPtr).wdm ; the data manager widget ID
    Widget_control, wDM, get_uvalue=sPtrDM ; the data manager state ptr

    oSampCont = Self.sampcontref
    if (oSampCont->Count() eq 0) then begin
      ; no data currently loaded
      (*(*sPtrDM).pdataids) = ''
      selectedIDs = ''
      selectedNames = ''
      nSelectedIDs = 0
    endif else begin
      selectedIDs = (*(*sPtrDM).pdataids)  ; currently selected identifiers
      nSelectedIDs = N_elements(selectedIDs)
      if (selectedIDs[0] eq '') then nSelectedIDs = 0
      selectedNames = (nSelectedIDs eq 0)? '' :  Strarr(nSelectedIDs)
      for i=0,nSelectedIDs-1 do begin
        (Self->Getbyidentifier(selectedIDs[i]))->Getproperty, name=name
        selectedNames[i] = name
      endfor
    endelse
  endif

  if (Arg_present(curMaxDataLen)) then begin
    oSampCont = Self.sampcontref
    curMaxDataLen = 1
    if (Obj_valid(oSampCont) && (oSampCont->Count() gt 0)) then begin
      nSamp = oSampCont->Count()
      for i = 0, nSamp-1 do begin
        oI = oSampCont->Get(position=i)
        status = oI->Getmetadata('NPTS',npts)
        if (status) then curMaxDataLen = curMaxDataLen > npts
      endfor
    endif

  endif

  ; Call base class method
  if (N_elements(etc) gt 0) then $
    self->Idlittool::getproperty, _EXTRA=etc

end


;-------------------------------------------------------------------------------
pro Bt7psdtool::SetProperty, nameTag=nameTag, prompt=prompt,preferences=preferences, _EXTRA=etc $
  ,nActiveDetectors=nActiveDetectors,energyUnitFlag=energyUnitFlag, PSDDisplayAs=PSDDisplayAs $
  ,maskedDets=maskedDets,fastFunc=fastFunc,monScaleValue=monScaleValue $
  ,monScaleFlag=monScaleFlag,maskFlag=maskFlag,bkgdFlag=bkgdFlag $
  ,sumSampFlag=sumSampFlag,sumBkgdFlag=sumBkgdFlag,effNormFlag=effNormFlag $
  ,fastFlag=fastFlag, data_directory=dataDir, daveTool=daveTool $
  ,bkgdSubVarFlag=bkgdSubVarFlag,bkgdSubVarTol=bkgdSubVarTol,clearDisplayFlag=clearDisplayFlag $
  ,constBinFlag=constBinFlag,useTempAverageFlag=useTempAverageFlag,combVarVal=combVarVal $
  ,minChan=minChan,maxChan=maxChan,minDPnt=minDPnt,maxDPnt=maxDPnt,dpntIndex=dpntIndex $
  ,sharedSettingsFlag=sharedSettingsFlag,settingIndex=settingIndex $
  ,nSamp=nSamp,nBkgd=nBkgd,nFast=nFast,fastparams=fastparams,phiOffset=phiOffset,logFlag=logFlag $
  ,defaultIntensityFlag=defaultIntensityFlag, maxIntensity=maxIntensity, minIntensity=minIntensity $
  ,sampSelected=sampSelected, bkgdSelected=bkgdSelected, fastSelected=fastSelected $
  ,oplotFastFitFlag=oplotFastFitFlag,oplotBkgdFlag=oplotBkgdFlag, typeCheck=typeCheck $
  ,modifiedStatus=modifiedStatus,minBinWidth=minBinWidth,binWidths=binWidths $
  ,exportIndex1=exportIndex1,exportIndex2=exportIndex2,exportIndex3=exportIndex3 $
  ,latParamFlag=latParamFlag, latticeParameters=latticeParameters, qUnits=qUnits $
  ,xAxisVar=xAxisVar,yAxisVar=yAxisVar,multipleMsliceWinFlag=multipleMsliceWinFlag $
  ,detailedBalanceFlag=detailedBalanceFlag,fastValue=fastValue, resCorFlag=resCorFlag $
  ,monCorFlag=monCorFlag, normalizeTo=normalizeTo, sampTypeFlag=sampTypeFlag,mergeChannelsFlag=mergeChannelsFlag $
  ,s_errorbar_capsize=s_errorbar_capsize $
  ,s_transparency=s_transparency $
  ,s_antialias=s_antialias $
  ,s_color=s_color $
  ,s_errorbar_color=s_errorbar_color $
  ,s_use_default_color=s_use_default_color $
  ,s_sym_increment=s_sym_increment $
  ,s_sym_index=s_sym_index $
  ,s_sym_size=s_sym_size $
  ,s_sym_color=s_sym_color $
  ,s_sym_thick=s_sym_thick $
  ,s_y_errorbars=s_y_errorbars $
  ,s_linestyle=s_linestyle $
  ,s_thick=s_thick $
  ,s_sym_filled=s_sym_filled $
  ,s_sym_fill_color=s_sym_fill_color $
  ,s_font_name=s_font_name  $
  ,s_font_size=s_font_size $
  ,s_text_color=s_text_color  $
  ,b_errorbar_capsize=b_errorbar_capsize $
  ,b_transparency=b_transparency $
  ,b_antialias=b_antialias $
  ,b_color=b_color $
  ,b_errorbar_color=b_errorbar_color $
  ,b_use_default_color=b_use_default_color $
  ,b_sym_increment=b_sym_increment $
  ,b_sym_index=b_sym_index $
  ,b_sym_size=b_sym_size $
  ,b_sym_color=b_sym_color $
  ,b_sym_thick=b_sym_thick $
  ,b_y_errorbars=b_y_errorbars $
  ,b_linestyle=b_linestyle $
  ,b_thick=b_thick $
  ,b_sym_filled=b_sym_filled $
  ,b_sym_fill_color=b_sym_fill_color $
  ,b_font_name=b_font_name  $
  ,b_font_size=b_font_size $
  ,b_text_color=b_text_color  $
  ,f_errorbar_capsize=f_errorbar_capsize $
  ,f_transparency=f_transparency $
  ,f_antialias=f_antialias $
  ,f_color=f_color $
  ,f_errorbar_color=f_errorbar_color $
  ,f_use_default_color=f_use_default_color $
  ,f_sym_increment=f_sym_increment $
  ,f_sym_index=f_sym_index $
  ,f_sym_size=f_sym_size $
  ,f_sym_color=f_sym_color $
  ,f_sym_thick=f_sym_thick $
  ,f_y_errorbars=f_y_errorbars $
  ,f_linestyle=f_linestyle $
  ,f_thick=f_thick $
  ,f_sym_filled=f_sym_filled $
  ,f_sym_fill_color=f_sym_fill_color $
  ,f_font_name=f_font_name  $
  ,f_font_size=f_font_size $
  ,f_text_color=f_text_color  $
  ,ff_transparency=ff_transparency $
  ,ff_antialias=ff_antialias $
  ,ff_color=ff_color $
  ,ff_use_default_color=ff_use_default_color $
  ,ff_sym_index=ff_sym_index $
  ,ff_linestyle=ff_linestyle $
  ,ff_thick=ff_thick $
  ,sb_transparency=sb_transparency $
  ,sb_antialias=sb_antialias $
  ,sb_color=sb_color $
  ,sb_use_default_color=sb_use_default_color $
  ,sb_sym_index=sb_sym_index $
  ,sb_linestyle=sb_linestyle $
  ,sb_thick=sb_thick

  compile_opt idl2

  if N_elements(s_errorbar_capsize) then Self.s_errorbar_capsize=s_errorbar_capsize
  if N_elements(s_transparency) then Self.s_transparency=s_transparency
  if N_elements(s_antialias) then Self.s_antialias=s_antialias
  if N_elements(s_color) then Self.s_color=s_color
  if N_elements(s_errorbar_color) then Self.s_errorbar_color=s_errorbar_color
  if N_elements(s_use_default_color) then Self.s_use_default_color=s_use_default_color
  if N_elements(s_sym_increment) then Self.s_sym_increment=s_sym_increment
  if N_elements(s_sym_index) then Self.s_sym_index=s_sym_index
  if N_elements(s_sym_size) then Self.s_sym_size=s_sym_size
  if N_elements(s_sym_color) then Self.s_sym_color=s_sym_color
  if N_elements(s_sym_thick) then Self.s_sym_thick=s_sym_thick
  if N_elements(s_y_errorbars) then Self.s_y_errorbars=s_y_errorbars
  if N_elements(s_linestyle) then Self.s_linestyle=s_linestyle
  if N_elements(s_thick) then Self.s_thick=s_thick
  if N_elements(s_sym_filled) then Self.s_sym_filled=s_sym_filled
  if N_elements(s_sym_fill_color) then Self.s_sym_fill_color=s_sym_fill_color
  if N_elements(s_font_name) then Self.s_font_name=s_font_name
  if N_elements(s_font_size) then Self.s_font_size=s_font_size
  if N_elements(s_text_color) then Self.s_text_color=s_text_color
  if N_elements(b_errorbar_capsize) then Self.b_errorbar_capsize=b_errorbar_capsize
  if N_elements(b_transparency) then Self.b_transparency=b_transparency
  if N_elements(b_antialias) then Self.b_antialias=b_antialias
  if N_elements(b_color) then Self.b_color=b_color
  if N_elements(b_use_default_color) then Self.b_use_default_color=b_use_default_color
  if N_elements(b_errorbar_color) then Self.b_errorbar_color=b_errorbar_color
  if N_elements(b_sym_increment) then Self.b_sym_increment=b_sym_increment
  if N_elements(b_sym_index) then Self.b_sym_index=b_sym_index
  if N_elements(b_sym_size) then Self.b_sym_size=b_sym_size
  if N_elements(b_sym_color) then Self.b_sym_color=b_sym_color
  if N_elements(b_sym_thick) then Self.b_sym_thick=b_sym_thick
  if N_elements(b_y_errorbars) then Self.b_y_errorbars=b_y_errorbars
  if N_elements(b_linestyle) then Self.b_linestyle=b_linestyle
  if N_elements(b_thick) then Self.b_thick=b_thick
  if N_elements(b_sym_filled) then Self.b_sym_filled=b_sym_filled
  if N_elements(b_sym_fill_color) then Self.b_sym_fill_color=b_sym_fill_color
  if N_elements(b_font_name) then Self.b_font_name=b_font_name
  if N_elements(b_font_size) then Self.b_font_size=b_font_size
  if N_elements(b_text_color) then Self.b_text_color=b_text_color
  if N_elements(f_errorbar_capsize) then Self.f_errorbar_capsize=f_errorbar_capsize
  if N_elements(f_transparency) then Self.f_transparency=f_transparency
  if N_elements(f_antialias) then Self.f_antialias=f_antialias
  if N_elements(f_color) then Self.f_color=f_color
  if N_elements(f_errorbar_color) then Self.f_errorbar_color=f_errorbar_color
  if N_elements(f_use_default_color) then Self.f_use_default_color=f_use_default_color
  if N_elements(f_sym_increment) then Self.f_sym_increment=f_sym_increment
  if N_elements(f_sym_index) then Self.f_sym_index=f_sym_index
  if N_elements(f_sym_size) then Self.f_sym_size=f_sym_size
  if N_elements(f_sym_color) then Self.f_sym_color=f_sym_color
  if N_elements(f_sym_thick) then Self.f_sym_thick=f_sym_thick
  if N_elements(f_y_errorbars) then Self.f_y_errorbars=f_y_errorbars
  if N_elements(f_linestyle) then Self.f_linestyle=f_linestyle
  if N_elements(f_thick) then Self.f_thick=f_thick
  if N_elements(f_sym_filled) then Self.f_sym_filled=f_sym_filled
  if N_elements(f_sym_fill_color) then Self.f_sym_fill_color=f_sym_fill_color
  if N_elements(f_font_name) then Self.f_font_name=f_font_name
  if N_elements(f_font_size) then Self.f_font_size=f_font_size
  if N_elements(f_text_color) then Self.f_text_color=f_text_color
  if N_elements(ff_transparency) then Self.ff_transparency=ff_transparency
  if N_elements(ff_antialias) then Self.ff_antialias=ff_antialias
  if N_elements(ff_color) then Self.ff_color=ff_color
  if N_elements(ff_use_default_color) then Self.ff_use_default_color=ff_use_default_color
  if N_elements(ff_sym_index) then Self.ff_sym_index=ff_sym_index
  if N_elements(ff_linestyle) then Self.ff_linestyle=ff_linestyle
  if N_elements(ff_thick) then Self.ff_thick=ff_thick
  if N_elements(sb_transparency) then Self.sb_transparency=sb_transparency
  if N_elements(sb_antialias) then Self.sb_antialias=sb_antialias
  if N_elements(sb_color) then Self.sb_color=sb_color
  if N_elements(sb_use_default_color) then Self.sb_use_default_color=sb_use_default_color
  if N_elements(sb_sym_index) then Self.sb_sym_index=sb_sym_index
  if N_elements(sb_linestyle) then Self.sb_linestyle=sb_linestyle
  if N_elements(sb_thick) then Self.sb_thick=sb_thick

  ; DAVETool
  if (N_elements(daveTool) && Obj_valid(daveTool) && Obj_isa(daveTool,'DAVETool')) then $
    Self.davetool = daveTool

  ; Preferences
  if (N_elements(preferences)) then begin
    if (Strcmp(Size(preferences,/tname),'STRUCT')) then begin
      ntags = N_tags(preferences)
      tags = Tag_names(preferences)
      index = Indgen(ntags)

      ; handle color tags - convert string to byte array, eg '0,128,255' to [0,128,255]
      spIndex = Where(Strmatch(tags,'*color*',/fold) eq 1, spCnt, complement=index, ncomplement=theRest)
      if (spCnt gt 0) then begin
        for i=0,spCnt-1 do begin
          strColor = preferences.(spIndex[i])
          bytColor = Fix(Strsplit(strColor,',',/extract))
          Self->Setpropertybyidentifier, tags[spIndex[i]], bytColor
        endfor
      endif

      ; all other tags
      for i=0,theRest-1 do begin
        if (Strcmp(tags[index[i]],'binWidths',/fold)) then begin
          ; another special case (binwidths) - convert string to 7 element float array
          strBW = preferences.(index[i])
          fltBW = Float(Strsplit(strBW,',',/extract))
          Self->Setpropertybyidentifier, tags[index[i]], fltBW
        endif else $
          Self->Setpropertybyidentifier, tags[index[i]], preferences.(index[i])
      endfor

      ; Need further to assign some userdef attribute for user-defined properties
      ; in order for property sheet to reflect updated value
      uProps = ['MASKEDDETS']
      n = N_elements(uProps)
      for i = 0,n-1 do begin
        index = Where(Strcmp(tags,uProps[i]), found)
        if (found) then $
          Self->Setpropertyattribute, uProps[i],userdef=preferences.(index)
      endfor

      ; Finally, store the preferences structure
      if (Ptr_valid(Self.prefsptr)) then (*Self.prefsptr) = preferences $
      else Self.prefsptr = Ptr_new(preferences)
    endif
  endif

  ; modifiedStatus
  if (N_elements(modifiedStatus)) then Self.modifiedflag = (Fix(modifiedStatus) gt 0)? 1 : 0
  ; nameTag
  if (N_elements(nameTag)) then Self.nametag = Strtrim(nameTag,2)
  ; prompt
  if (N_elements(prompt)) then begin
    Self.prompt = prompt
    if (prompt eq 0) then Self._bdirty = 0
  endif

  if (N_elements(PSDDisplayAs)) then Self.PSDDisplayAs = PSDDisplayAs
  if (N_elements(combVarVal)) then Self.combvarval = combVarVal
  ;
  if (N_elements(clearDisplayFlag)) then Self.cleardisplayflag = clearDisplayFlag
  ;
  if (N_elements(constBinFlag)) then Self.constbinflag = constBinFlag
  ;
  if (N_elements(useTempAverageFlag)) then Self.usetempaverageflag = useTempAverageFlag
  ;
  if (N_elements(nActiveDetectors)) then Self.nactivedetectors = nActiveDetectors
  ;
  if (N_elements(energyUnitFlag)) then Self.energyunitflag = energyUnitFlag
  ;
  if (N_elements(maskedDets)) then Self.maskeddets = maskedDets
  ;
  if (N_elements(fastfunc)) then Self.fastfunc = fastfunc
  ;
  if (N_elements(fastparams)) then Self.fastparams = fastparams
  ;
  if (N_elements(monScaleValue)) then Self.monscalevalue = (monScaleValue eq 0.0)? 1.0 : monScaleValue
  ;
  if (N_elements(monScaleFlag)) then Self.monscaleflag = monScaleFlag
  ;
  if (N_elements(sumSampFlag)) then Self.sumsampflag = sumSampFlag
  ;
  if (N_elements(sumBkgdFlag)) then Self.sumbkgdflag = sumBkgdFlag
  ;
  if (N_elements(maskFlag)) then Self.maskflag = maskFlag
  ;
  if (N_elements(bkgdFlag)) then Self.bkgdflag = bkgdFlag
  ;
  if (N_elements(bkgdSubVarFlag)) then Self.bkgdsubvarflag = bkgdSubVarFlag
  ;
  if (N_elements(bkgdSubVarTol)) then Self.bkgdsubvartol = bkgdSubVarTol
  ;
  if (N_elements(fastFlag)) then Self.fastflag = fastFlag
  ;
  if (N_elements(dataDir)) then Self.datadir = dataDir
  ;
  if (N_elements(nSamp)) then Self.nsamp = nSamp
  ;
  if (N_elements(nBkgd)) then Self.nbkgd = nBkgd
  ;
  if (N_elements(nFast)) then Self.nfast = nFast
  ;
  if (N_elements(sampSelected)) then Self.sampselected = sampSelected
  ;
  if (N_elements(bkgdSelected)) then Self.bkgdselected = bkgdSelected
  ;
  if (N_elements(fastSelected)) then Self.fastselected = fastSelected
  ;
  if (N_elements(oplotFastFitFlag)) then Self.oplotfastfitflag = oplotFastFitFlag
  ;
  if (N_elements(oplotBkgdFlag)) then Self.oplotbkgdflag = oplotBkgdFlag
  ;
  if (N_elements(latParamFlag)) then  Self.latparamflag = latParamFlag
  ;
  if (N_elements(latticeParameters)) then  Self.latticeparameters = latticeParameters
  ;
  if (N_elements(detailedBalanceFlag)) then Self.detailedbalanceflag = detailedBalanceFlag
  ;
  if (N_elements(fastValue)) then Self.fastvalue = fastValue
  ;
  if (N_elements(resCorFlag)) then Self.rescorflag = resCorFlag
  ;
  if (N_elements(monCorFlag)) then Self.moncorflag = monCorFlag
  ;
  if (N_elements(normalizeTo)) then Self.normalizeto = normalizeTo
  ;
  if (N_elements(minbinWidth)) then Self.minbinwidth = minbinWidth
  ;
  if (N_elements(binWidths)) then Self.binwidths = binWidths
  ;
  if (N_elements(minChan)) then Self.minchan = minChan > 1
  ;
  if (N_elements(maxChan)) then Self.maxchan = maxChan
  ;
  if (N_elements(minDPnt)) then Self.mindpnt = minDPnt > 1
  ;
  if (N_elements(maxDPnt)) then Self.maxdpnt = maxDPnt
  ;
  if (N_elements(dpntIndex)) then Self.dpntindex = dpntIndex > 1
  ;
  if (N_elements(sharedSettingsFlag)) then Self.sharedsettingsflag = sharedSettingsFlag
  ;
  if (N_elements(settingIndex)) then Self.settingindex = settingIndex
  ;
  if (N_elements(sampTypeFlag)) then begin
    Self.samptypeflag = sampTypeFlag
    if (N_elements(typeCheck) eq 0) then typeCheck = 1 ; ==> default typeCheck is set to 1
    Self->Updatepropertysheet, typeCheck = typeCheck
  endif
  ;
  if (N_elements(qUnits)) then Self.qunits = qUnits
  ;
  if (N_elements(xAxisVar)) then Self.xaxisvar = xAxisVar
  ;
  if (N_elements(yAxisVar)) then Self.yaxisvar = yAxisVar
  ;
  if (N_elements(exportIndex1) gt 0) then (*Self.exportindex1ptr) = exportIndex1
  ;
  if (N_elements(exportIndex2) gt 0) then (*Self.exportindex2ptr) = exportIndex2
  ;
  if (N_elements(exportIndex3) gt 0) then (*Self.exportindex3ptr) = exportIndex3
  ;
  if (N_elements(effNormFlag) gt 0) then Self.effnormflag = effNormFlag
  ;
  if (N_elements(multipleMsliceWinFlag) gt 0) then Self.multiplemslicewinflag = multipleMsliceWinFlag
  ;
  if (N_elements(mergeChannelsFlag) gt 0) then Self.mergechannelsflag = mergeChannelsFlag
  ;
  if (N_elements(defaultIntensityFlag) gt 0) then Self.defaultintensityflag = defaultIntensityFlag
  ;
  if (N_elements(maxIntensity) gt 0) then begin
    if (maxIntensity gt Self.minintensity) then Self.maxintensity = maxIntensity
  endif
  ;
  if (N_elements(minIntensity) gt 0) then begin
    if (minIntensity lt Self.maxintensity) then Self.minintensity = minIntensity
  endif
  ;
  if (N_elements(phiOffset) gt 0) then Self.phioffset = phiOffset
  ;
  if (N_elements(logFlag) gt 0) then Self.logflag = logFlag





  ; Call base class method
  if (N_elements(etc) gt 0) then $
    self->Idlittool::setproperty, _EXTRA=etc

end


;===============================================================================
; Bt7psdTool::deleteAllDatasets
;
; PURPOSE:
;   Delete all datasets currently loaded
;
; PARAMETERS:
;
; RETURN VALUE:
;
function Bt7psdtool::deleteAllDatasets, _EXTRA=etc
  compile_opt idl2

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB
  wChild = Widget_info(wTLB, /child)
  Widget_control, wChild, get_uvalue=sPtr

  wDM = (*sPtr).wdm
  Widget_control, wDM, get_uvalue=sPtrDM

  Cw_bt7psddatamanager_deletedata, sPtrDM, wDM, /delall, _EXTRA=etc

  Return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::ReloadAllDatasets
;
; PURPOSE:
;   Reload all datasets currently loaded
;
; PARAMETERS:
;
; RETURN VALUE:
;
function Bt7psdtool::ReloadAllDatasets, _EXTRA=etc
  compile_opt idl2

  oBItems = Self.bkgdcontref->Get(/all, count=nBkgd)
  oSItems = Self.sampcontref->Get(/all, count=nSamp)

  ; reload bkgd data, if any
  ; NB: reload bkgd first before samp!
  if (nBkgd gt 0) then begin
    for i=0,nBkgd-1 do status = Self->Loadbkgd(dataObject=oBItems[i], /reload)
    ; if no samp present then refresh display with bkgd data
    if (nSamp le 0) then Wd_bt7psdtool_sendplotevent, Self->Getui(), oBItems[0]
  endif

  ; reload samp data, if any
  if (nSamp gt 0) then begin
    for i=0,nSamp-1 do status = Self->Loadsamp(dataObject=oSItems[i], /reload)
    Wd_bt7psdtool_sendplotevent, Self->Getui(), oSItems[0]
  endif

  Return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::loadSamp
;
; PURPOSE:
;   Specify and load sample data file(s)
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::Getfilelist, title, count, fromFTP=fromFTP, filter=filter $
  ,multiple_files=multiple_files, path=path, newPath=newPath

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB

  if (Keyword_set(fromFTP)) then begin
    Self->Getproperty, ftpObject=oFTP
    if (N_elements(filter) eq 0) then filter = ['*.bt7','*.*']
    files = Dialog_ncnrpublicdata(oFTP,title=title,filter=filter,group_leader=wTLB,count=count)
  endif else begin
    if (N_elements(filter) eq 0) then filter = '*.bt7'
    if (N_elements(multiple_files) eq 0) then multiple_files=1
    if (N_elements(path) eq 0) then Self->Getproperty, data_directory=path
    if (N_elements(title) eq 0) then title='Specify files to load'

    files = Dialog_pickfile(title=title,multiple_files=multiple_files,/must_exist, dialog_parent=wTLB $
      ,filter=filter,path=path, get_path=newPath)

    if (files[0] eq '') then begin
      count = 0
      Return, ''
    endif

    count = N_elements(files)
    ;Self->SetProperty, data_directory=newPath
  endelse

  Return, files

end
;-------------------------------------------------------------------------------



;===============================================================================
; Bt7psdTool::refreshPropertySheet
;
; PURPOSE:
;   Refresh the propertysheet UI
;
; PARAMETERS:
;
; KEYWORDS:
;
pro Bt7psdtool::RefreshPropertySheet

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB
  wChild = Widget_info(wTLB, /child)
  Widget_control, wChild, get_uvalue=sPtr

  Widget_control, (*sPtr).wps, /refresh_property

end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::loadFastFtp
;
; PURPOSE:
;   Specify and load fast bkgd data file(s) from NCNR ftp server
;
; PARAMETERS:
;
; KEYWORDS:
;
;function Bt7psdtool::loadFastFtp
;
;  Return, Self->Loadfast(/fromFtp)
;
;end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::loadBkgdFtp
;
; PURPOSE:
;   Specify and load bkgd data file(s) from NCNR ftp server
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::loadBkgdFtp

  Return, Self->Loadbkgd(/fromFtp)

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; Bt7psdTool::loadBkgd
;
; PURPOSE:
;   Select and load Bkgd data file(s)
;
; PARAMETERS:
;
; KEYWORDS:
;
;   dataObject - specifies the data object whose data is to be reloaded
;
;   reload  - set if the data specified by the dataObject keyword is to be reloaded
;
;   fromFTP - set if the source of the datafile to be loaded is the FTP server
;-
function Bt7psdtool::loadBkgd, reload=reload, dataObject=oItem, fromFTP=fromFTP

  Return, Self->loadDataset(reload=reload, dataObject=oItem, fromFTP=fromFTP, datasetType='bkgd')

end
;-------------------------------------------------------------------------------



;===============================================================================
; SPINSpsdTool::ViewCalibParams
;
; PURPOSE:
;   View raw contents of loaded PSD detector calibration parameter file
;   (Pixel efficiencies and delta A4, Ef).
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::ViewCalibParams

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB

  status = File_test(Self.calibparamsfilename,/read)
  if (~status) then begin
    msg = ['The following calibration file could not be located',Self.calibparamsfilename]
    Self->Errormessage, msg,title='Calibration not found',severity=0
    Self->Statusmessage, Self.calibparamsfilename+' could not be located'
    Return, 0
  endif

  font = (!version.os_family eq 'Windows')? 'Courier New*24*Bold' : $
    '-adobe-courier-bold-o-normal--24-240-75-75-m-150-iso8859-1'
  font1 = (!version.os_family eq 'Windows')? 'Courier New*18*Bold' : $
    '-adobe-courier-bold-o-normal--18-180-75-75-m-110-iso8859-1'
  font2 = (!version.os_family eq 'Windows')? 'Courier New*16' : $
    '-adobe-courier-medium-o-normal--14-140-75-75-m-90-iso8859-1'

  doneTxt = "Close "+Self.calibparamsbasefilename

  Xdisplayfile, Self.calibparamsfilename, done_button=doneTxt, /grow_to_screen, group=wTLB, font=font2

  Return, 1

end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::loadCalibParams
;
; PURPOSE:
;   Specify calibration file and load PSD detector calibration parameters
;   (channel efficiencies and delta A4, Ef) values from it
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::loadCalibParams

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      ;;print, 'Error handled!'
      eTitle = 'Bt7psdTool::loadCalibParams: Error encountered'
      eMsg = 'An error or unusual condition was encountered!'
      eMsg = [eMsg,'Please, report the following to the DAVE team:']
      eMsg = [eMsg,!error_state.msg]
      void = Dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
      Catch, /cancel
      if (N_elements(lun) gt 0) then Free_lun, lun, /force
      Return, 0
    endif
  endif

  ; Let user specify file to load
  title = 'Select PSD Calibration Parameter file to load'
  etc = {filter:'*',multiple_files:0}
  calidFileNameExists = (Strlen(Self.calibparamsfilename) gt 0) && $
    File_test(Self.calibparamsfilename)
  if (calidFileNameExists) then $
    etc = Create_struct(etc,'path',File_dirname(Self.calibparamsfilename))
  filename = Self->Getfilelist(title,count,newPath=newPath,_EXTRA=etc)
  if (count eq 0) then Return, 0
  if (N_elements(newPath) gt 0) then Self->Setproperty, data_directory=newPath
  lines = ''
  Openr, lun, filename, /get_lun
  Readf, lun, lines
  isCalib = Stregex(lines[0],'BT7 PSD Calibration',/fold,/bool)
  if (~isCalib) then begin
    Free_lun, lun, /force
    msg = [Filename, 'is not a proper BT7 calibration parameter file']
    Self->Errormessage, msg,title='Invalid file',severity=1
    Return, 0
  endif
  nlines = 1
  while (~Eof(lun)) do begin
    Readf, lun, lines
    if (~Strcmp(lines,'#',1)) then break
    nlines++
  endwhile
  Point_lun, lun, 0 ; rewind to beginning of file

  lines = Strarr(nlines)
  buf = Fltarr(3,48)
  ;if (isCalib) then begin
  Readf, lun, lines
  Readf, lun, buf
  Free_lun, lun, /force

  Self.cheff = Reform(buf[0,*])
  Self.chdela4 = Reform(buf[1,*])
  Self.chdelef = Reform(buf[2,*])
  Self.calibparamsisset = 1
  Self.calibparamsfilename = filename
  Self.calibparamsbasefilename = File_basename(filename)

  ; parse efficiencies for channels to be masked by default - will have negative efficiencies
  maskIndex = Where(Stregex(lines,'Channels to be masked',/fold,/bool) eq 1, maskFound)
  index = Where(Self.cheff lt 0.0, nMask)
  if (nMask gt 0) then begin
    status = Intvector2compactstring(index+1,sIndex)   ; index+1 converts indices to channel number
    Self->Setproperty, MASKEDDETS=sIndex
    Self->Setpropertyattribute, 'MASKEDDETS', userdef=sIndex, sensitive=1
    Self->Setproperty, MASKFLAG=1
  endif else if (maskFound) then begin
    ; check if there are channels to be masked in header section
    ; this is the new way of specifying channels for masking
    toks = Strsplit(lines[maskIndex[0]],':',/extract,count=ntoks)
    if (ntoks eq 2 && Strtrim(toks[1]) ne '') then begin
      Self->Setproperty, MASKEDDETS=Strtrim(toks[1])
      Self->Setpropertyattribute, 'MASKEDDETS', userdef=Strtrim(toks[1]), sensitive=1
      Self->Setproperty, MASKFLAG=1
    endif
  endif

  Self->Setpropertyattribute, 'calibParamsBaseFilename', userdef=Self.calibparamsbasefilename
  Self->Setpropertyattribute, 'effNormFlag', sensitive=1

  Self->Refreshpropertysheet
  ;endif else begin
  ;   free_lun, lun, /force
  ;   msg = [Filename, 'is not a proper BT7 calibration parameter file']
  ;   Self->ErrorMessage, msg,title='Invalid file',severity=1
  ;   return, 0
  ;endelse

  ; re-evaluate calculated quantities for already loaded datasets
  Self->Getproperty, sampContRef=oCont
  oData = oCont->Get(/all,count=nData)
  for i = 0, nData-1 do Self->Updatecalculation, oData[i]

  ; initiate a plot event to update any plotted data
  Wd_bt7psdtool_sendplotevent, Self->Getui()

  Return, 1

end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::loadSampFtp
;
; PURPOSE:
;   Specify and load sample data file(s) from NCNR ftp server
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::loadSampFtp

  Return, Self->Loadsamp(/fromFtp)

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; Bt7psdTool::loadSamp
;
; PURPOSE:
;   Specify and load sample data file(s)
;
; PARAMETERS:
;
; KEYWORDS:
;
;   dataObject - specifies the data object whose data is to be reloaded
;
;   reload  - set if the data specified by the dataObject keyword is to be reloaded
;
;   fromFTP - set if the source of the datafile to be loaded is the FTP server
;-
function Bt7psdtool::loadSamp, reload=reload, dataObject=oItem, fromFTP=fromFTP

  Return, Self->loadDataset(reload=reload, dataObject=oItem, fromFTP=fromFTP, datasetType='samp')
end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; Bt7psdTool::loadDataset
;
; PURPOSE:
;   Specify and load bkgd or sample data file(s)
;
; PARAMETERS:
;
; KEYWORDS:
;
;   dataObject - specifies the data object whose data is to be reloaded
;
;   reload  - set if the data specified by the dataObject keyword is to be reloaded
;
;   fromFTP - set if the source of the datafile to be loaded is the FTP server
;   
;   datasetType - specifies whether the dataset is intended to be read in as 'samp' | 'bkgd'
;-
function Bt7psdtool::loadDataset, reload=reload, dataObject=oItem, fromFTP=fromFTP, datasetType=datasetType

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      ;;print, 'Error handled!'
      eTitle = 'Bt7psdTool::loadDataset: Error encountered'
      eMsg = 'An error or unusual condition was encountered!'
      eMsg = [eMsg,'Please, report the following to the DAVE team:']
      eMsg = [eMsg,!error_state.msg]
      void = Dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
      Catch, /cancel
      Self->Enableupdates
      Return, 0
    endif
  endif
  
  ; datasetType is required and should be either 'samp' or 'bkgd'
  if (~isa(datasetType)) then return, 0
  if (~(datasetType.Matches('samp',/fold) || datasetType.Matches('bkgd',/fold))) then return, 0
  if (datasetType.Matches('samp',/fold)) then begin
    title = 'Select Sample Files to Load'
    Self->Getproperty, sumSampFlag=sumFlag, sampContRef=oCont, nSamp=nData
    dataManagerLeaf = 'Sample Data Manager'
  endif else begin
    title = 'Select Background Files to Load'
    Self->Getproperty, sumBkgdFlag=sumFlag, bkgdContRef=oCont, nBkgd=nData
    dataManagerLeaf = 'Bkgd Data Manager'
  endelse

  reloading = Keyword_set(reload)
  if (reloading) then begin
    if (~Obj_valid(oItem)) then Return, 0
    oItem->Getproperty, description=files
    count = 1
    void = oItem->Getmetadata('FROMFTP',fromFtp)
    void = oItem->Getmetadata('HDFFLAG',hdfFlag)
    if (hdfFlag) then void = oItem->Getmetadata('ENTRYINDEX',entryIndex)
    ;if (~Self->ReadData(filename, dataPtr)) then return, 0
  endif else begin
    ; Let user specify files to load
    files = Self->Getfilelist(title,count,fromFTP=fromFTP,newPath=newPath)
    if (count eq 0) then Return, 0
    if (N_elements(newPath) gt 0) then Self->Setproperty, data_directory=newPath
  endelse

  ; switch on the busy symbol for cursor
  Widget_control, /HOURGLASS

  nMultiHDFFile = 0
  entryCount = []
  multiHDFFiles = []
  Self->Disableupdates
  ; Read the contents of the data files and make entries in the 'Sample' tree of the data manager
  ;Self->Getproperty, sumSampFlag=sumFlag, sampContRef=oCont, nSamp=nData
  for i=0, count-1 do begin

    ; need to handle hdf files with multiple top-level entries seperately
    ; so simply record and handle later
    isHDF = Is_hdf_nice(files[i], oFTP=Self.ftpobject, nEntries=nEntries)
    if (isHDF) then begin
      if (nEntries gt 1) then begin
        nMultiHDFFile++
        multiHDFFiles = [multiHDFFiles,files[i]]
        entryCount = [entryCount,nEntries]
        continue
      endif
    endif

    filename = files[i]

    if (isHDF) then begin
      status = Self->Readnicehdf(filename, dataPtr, fromFTP=fromFTP,entryIndex=entryIndex)  ; if reloading, entryIndex is define otherwise it won't be defined
      ; and if not defined then it is likely a single entry HDF file!
      if (~status) then continue
    endif else begin
      if (~Self->Readdata(filename, dataPtr, fromFTP=fromFTP)) then continue
    endelse
    basename = File_basename(filename,'.bt7',/fold_case)

    if (~reloading) then begin
      ;; create new object and attach dataPtr
      oItem = Obj_new('IDLitParameterSet',name=basename,description=filename,type=datasetType)
      oItem->Addmetadata,'DATAPTRREF',dataPtr
      oItem->Addmetadata,'HDFFLAG',isHDF
      oItem->Addmetadata,'ENTRYINDEX',0
      oItem->Addmetadata,'FROMFTP',Keyword_set(fromFTP)

      ; iTools does not handle '_[0-9]' characters in identifiers well eg _0, _1, etc
      ; replace all '_' with '-'
      oItem->Getproperty, identifier=idd
      hasChanged = 0
      while ((pos = Stregex(idd,'_[0-9]')) ne -1) do begin
        Strput, idd,'-',pos
        hasChanged = 1
      endwhile
      if (Strmatch(idd,'[0-9]*')) then begin   ; if first char is a number
        idd = 'id'+idd
        hasChanged = 1
      endif
      if (hasChanged) then oItem->Setproperty,identifier=idd

      ; Add to the data manager
      Self->Addbyidentifier, dataManagerLeaf, oItem, position=0
    endif else begin
      ;; simply replace previous dataPtr with updated one
      void = oItem->Getmetadata('DATAPTRREF',tempPtr)
      if (Ptr_valid(tempPtr)) then Heap_free, tempPtr
      oItem->Addmetadata,'DATAPTRREF',dataPtr
    endelse

    ; Update calculations (q,e,intensity) for data
    Self->Updatecalculation, oItem

    if (~reloading) then begin
      oCont->Add, oItem
      if (datasetType.Matches('samp',/fold)) then Self.nsamp++
      if (datasetType.Matches('bkgd',/fold)) then Self.nbkgd++
    endif

    dataPtr = 0   ; make dataPtr invalid before it is used again when looping
  endfor


  ; Now load multi-HDF files, if any
  if (nMultiHDFFile gt 0) then begin
    for i=0,nMultiHDFFile-1 do begin
      filename = multiHDFFiles[i]
      for j=0,entryCount[i]-1 do begin

        status = Self->Readnicehdf(filename, dataPtr, fromFTP=fromFTP,entryIndex=j)
        if (~status) then continue
        ;; create new object and attach dataPtr
        objIDD = File_basename(filename,'.bt7',/fold_case) +'-'+ Strtrim(String(j),2)

        oItem = Obj_new('IDLitParameterSet',name=objIDD,description=filename,type=datasetType)
        oItem->Addmetadata,'DATAPTRREF',dataPtr
        oItem->Addmetadata,'HDFFLAG',isHDF
        oItem->Addmetadata,'ENTRYINDEX',0
        oItem->Addmetadata,'FROMFTP',Keyword_set(fromFTP)

        ; iTools does not handle '_[0-9]' characters in identifiers well eg _0, _1, etc
        ; replace all '_' with '-'
        oItem->Getproperty, identifier=idd
        hasChanged = 0
        while ((pos = Stregex(idd,'_[0-9]')) ne -1) do begin
          Strput, idd,'-',pos
          hasChanged = 1
        endwhile
        if (Strmatch(idd,'[0-9]*')) then begin   ; if first char is a number
          idd = 'id'+idd
          hasChanged = 1
        endif
        if (hasChanged) then oItem->Setproperty,identifier=idd

        ; Add to the data manager
        Self->Addbyidentifier, dataManagerLeaf, oItem, position=0

        ; Update calculations (q,e,intensity) for data
        Self->Updatecalculation, oItem

        oCont->Add, oItem
        if (datasetType.Matches('samp',/fold)) then Self.nsamp++
        if (datasetType.Matches('bkgd',/fold)) then Self.nbkgd++

        dataPtr = 0   ; make dataPtr invalid before it is used again when looping
      endfor
    endfor
  endif

  ; TODO
  ;if ((Self.nSamp gt 1) && sumFlag) then Self->MergeData, 'samp'
  ;
  ;Self->SetPropertyAttribute, 'SUMSAMPFLAG', sensitive=(Self.nSamp gt 0)
  ;Self->refreshPropertySheet   ; force prop sheet to update

  Self.modifiedflag = 1
  
  if (datasetType.Matches('samp',/fold)) then begin
    Self->Enableupdates

    nSamp = oCont->Count()
    wChild = Widget_info(wTLB, /CHILD)
    Widget_control, wChild, GET_UVALUE=sPtr
    Widget_control, (*sPtr).wmslice, sensitive=((nSamp gt 0) && (Self.samptypeflag lt 2) )
    ;widget_control, (*sPtr).wDaveDM, sensitive=(nSamp gt 0)
    ;widget_control, (*sPtr).wPAN, sensitive=(nSamp gt 0)
  endif else begin
    Self->Updatecounts  ; Since bkgd data has changed, trigger an update so this change can be reflected.
    Self->Enableupdates
    ;Self->SetPropertyAttribute, 'SUMBKGDFLAG', sensitive=(Self.nBkgd gt 0)
    Self->Setpropertyattribute, 'BKGDFLAG', sensitive=(Self.nbkgd gt 0)
    Self->Setpropertyattribute, 'bkgdSubVarFlag', sensitive=(Self.bkgdflag eq 1)
    Self->Setpropertyattribute, 'bkgdSubVarTol', sensitive=(Self.bkgdflag eq 1)
  endelse

  Self->Updatepropertysheet
  Self->Refreshpropertysheet

  Return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::UpdateCalculation
;
; PURPOSE:
;   Update the PSD wavevector and energy transfer for the dataset
;
; PARAMETERS:
;   oPSet [in|out] - object whose data is to be updated
;
; KEYWORDS:
;
pro Bt7psdtool::UpdateCalculation, oPSet
  compile_opt idl2

  void = oPSet->Getmetadata('DATAPTRREF',dataPtr)
  if (~Ptr_valid(dataPtr)) then Return
  dataStr = *dataPtr
  Self->Getproperty, QUNITS=rlu, sampTypeFlag=sampTypeFlag ;  rlu = 0 => 1/A, 1 => r.l.u.; sampTypeFlag=0 (powder), 1 (single xtal)
  ekFac = Self.ekfac  ; E = ekFac * k^2

  ; calibration stuff
  chDelA4 = Self.chdela4
  chEff = Abs(Self.cheff) ; some values may be negative, signfying channels intended to be masked
  chDelEf = Self.chdelef
  nCh = N_elements(chDelA4)

  ; norminal values for ei, ef, a3, a4
  eio = (*dataStr.ei)
  efo = (*dataStr.ef)
  a3o = (*dataStr.a3)
  a4o = (*dataStr.a4)
  nPts = N_elements(a4o)

  qType = Partype(a3o)

  oPSet->Addmetadata,'sampTypeFlag',sampTypeFlag

  case sampTypeFlag of

    2: begin    ;; raw view
      counts = []

      ;Loop through data points in dataset:
      for i = 0, nPts-1 do begin
        counts = [[counts],[(*dataStr.psddets)[*,i]]]
      endfor

      ; A1 -> A6
      oA1 = Idlitdata((*dataStr.a1),name='A1',type=qtype)
      oA1->Addmetadata,'Long_name','A1'
      oA1->Addmetadata,'Units',''
      oA2 = Idlitdata((*dataStr.a2),name='A2',type=qtype)
      oA2->Addmetadata,'Long_name','A2'
      oA2->Addmetadata,'Units',''
      oA3 = Idlitdata((*dataStr.a3),name='A3',type=qtype)
      oA3->Addmetadata,'Long_name','A3'
      oA3->Addmetadata,'Units',''
      oA4 = Idlitdata((*dataStr.a4),name='A4',type=qtype)
      oA4->Addmetadata,'Long_name','A4'
      oA4->Addmetadata,'Units',''
      oA5 = Idlitdata((*dataStr.a5),name='A5',type=qtype)
      oA5->Addmetadata,'Long_name','A5'
      oA5->Addmetadata,'Units',''
      oA6 = Idlitdata((*dataStr.a6),name='A6',type=qtype)
      oA6->Addmetadata,'Long_name','A6'
      oA6->Addmetadata,'Units',''
      ; H,K,L
      oH = Idlitdata((*dataStr.h),name='H',type=qtype)
      oH->Addmetadata,'Long_name','H'
      oH->Addmetadata,'Units','rlu'
      oK = Idlitdata((*dataStr.k),name='K',type=qtype)
      oK->Addmetadata,'Long_name','K'
      oK->Addmetadata,'Units','rlu'
      oL = Idlitdata((*dataStr.l),name='L',type=qtype)
      oL->Addmetadata,'Long_name','L'
      oL->Addmetadata,'Units','rlu'
      ; E
      oE = Idlitdata((*dataStr.e),name='E',/no_copy,type=qtype)
      oE->Addmetadata,'Long_name','E'
      oE->Addmetadata,'Units','meV'


      ; TEMP
      temp = (*dataStr.temp)
      oTemp = Idlitdata(temp,name='TEMP',/no_copy,type=qtype)
      oTemp->Addmetadata,'Long_name','Temp'
      oTemp->Addmetadata,'Units','K'

      ; magfield
      if (ptr_valid(dataStr.magfield)) then begin
        magfield = (*dataStr.magfield)
      endif else magfield = fltarr(npts)
      ;magfield = unitVec # (*dataStr.magfield)
      oMagfield = Idlitdata(magfield,name='MAGFIELD',/no_copy,type=qtype)
      oMagfield->Addmetadata,'Long_name','Magnetic-field'
      oMagfield->Addmetadata,'Units','T'

      ; Data point index
      ;unitVec = intarr(nPts) + 1
      dPt = Indgen(nPts) + 1
      odPt = Idlitdata(name='Data_Index',dpt,/no_copy,type=Partype(dpt))
      odPt->Addmetadata,'Long_name','Data Index'
      odPt->Addmetadata,'Units',''

      ;PSD Channel Nos
      ch = Indgen(nCh) + 1
      oChNos = Idlitdata(name='PSDChannel',ch,/no_copy,type=Partype(ch))
      oChNos->Addmetadata,'Long_name','PSD channel Nos'
      oChNos->Addmetadata,'Units',''

      ;PSD Channel A4
      oChA4 = Idlitdata(name='PSDChannelA4',chDelA4,type=Partype(chDelA4))
      oChA4->Addmetadata,'Long_name','PSD channel $2\theta$'
        oChA4->Addmetadata,'Units','$\deg$'


      ; Error
      zType = Partype(counts)
      oErr = Idlitdata(name='Error',type=qtype) ; NULL data to start
      oErr->Addmetadata,'Long_name','Error'
      oErr->Addmetadata,'Units',''
      ; Counts
      oZ = Idlitdata(name='Counts',type=qtype)  ; NULL data to start
      oZ->Addmetadata,'Long_name','Counts'
      oZ->Addmetadata,'Units',''
      oZ->Addmetadata,'Signal', 1


      ; Channel Effieciencies
      unitVec = Intarr(nPts) + 1
      chEff = chEff # unitVec       ; creates a array of dims [nCh,nPts]

      unitVec = Fltarr(nCh) + 1.0
      ;      ; Monitor
      mon = unitVec # (*dataStr.mon)  ; replicate mon at each datapoint to all 48 channels of PSD
      ;      ; TIME
      time = unitVec # (*dataStr.time)

      oPSet->Addmetadata,'OriginalCounts',counts
      ;      oZ->AddMetaData,'2Theta',A4
      ;      oZ->AddMetaData,'QTOT',qtot
      ;      oZ->AddMetaData,'OMEGA',omega
      oPSet->Addmetadata,'CHEFF',ChEff
      oPSet->Addmetadata,'CHDELA4',ChDelA4
      oPSet->Addmetadata,'INDEP_VAR_TAG',dataStr.indep_var_tag
      oPSet->Addmetadata,'INDEP_VAR_VAL',(*dataStr.indep_var_val)
      oPSet->Addmetadata,'TIME',time
      oPSet->Addmetadata,'MON',mon
      oPSet->Addmetadata,'NPTS',nPts
      oPSet->Addmetadata,'MINDPNT',1
      oPSet->Addmetadata,'MAXDPNT',nPts
      oPSet->Addmetadata,'DPNTINDEX',1
      objects = [odPt,oChNos,oA1,oA2,oA3,oA4,oA5,oA6,oE,oH,oK,oL,oTemp,oMagfield,oZ,oErr,oChA4]
      pnames = ['Data_Index','PSDChannel','A1','A2','A3','A4','A5','A6','E','H','K','L','TEMP','MAGFIELD','Counts','Error','PSDChannelA4']
      oPSet->Add, objects, parameter_name=pnames

    end


    0: begin    ;; powder
      ; initialize a few variables
      A4 = []
      qtot = []
      omega = []
      counts = []

      ;Loop through data points in dataset:
      ; - calculate q, e and dspace
      nPts = N_elements(a4o)
      for i = 0, nPts-1 do begin
        cha4 = a4o[i] - chDelA4
        chEi = eio[i]
        chEf = efo[i] - chDelEf  ;
        chki = Sqrt(chEi/ekFac)
        chkf = Sqrt(chEf/ekFac)

        chq = Sqrt(chki^2 + chkf^2 - 2*chki*chkf*Cos(cha4*!dtor))
        a4 = [[a4],[cha4]]
        qTot = [[qTot],[chq]]
        omega = [[omega],[chEi - chEf]]

        counts = [[counts],[(*dataStr.psddets)[*,i]]]
      endfor

      qType = Partype(qTot)
      ; A4
      oA4 = Idlitdata(name='2Theta',type=qtype)
      oA4->Addmetadata,'Long_name','$2\theta$'
      oA4->Addmetadata,'Units','$\deg$'
      ; d-space
      odsp = Idlitdata(name='dspace',type=qtype)
      odsp->Addmetadata,'Long_name','d'
      odsp->Addmetadata,'Units','$\AA$'
      ; Q
      oQTot = Idlitdata(name='|Q|',type=qtype)
      oQTot->Addmetadata,'Long_name','|Q|'
      oQTot->Addmetadata,'Units','$\AA^{-1}$'
      ; E
      oE = Idlitdata(name='E',type=qtype)
      oE->Addmetadata,'Long_name','E'
      oE->Addmetadata,'Units','meV'

      unitVec = Fltarr(nCh) + 1.0
      ;      ; Monitor
      mon = unitVec # (*dataStr.mon)  ; replicate mon at each datapoint to all 48 channels of PSD
      ;      ; TIME
      time = unitVec # (*dataStr.time)
      ; TEMP
      temp = (*dataStr.temp)
      tempAverage = (Fltarr(nPts)+1) * Mean(temp)
      oTemp = Idlitdata(name='TEMP',type=qtype)
      oTemp->Addmetadata,'Long_name','Temperature'
      oTemp->Addmetadata,'Units','K'
      ; magfield
      magfield = (*dataStr.magfield)
      ;magfield = unitVec # (*dataStr.magfield)
      oMagfield = Idlitdata(name='MAGFIELD',type=qtype)
      oMagfield->Addmetadata,'Long_name','Magnetic-field'
      oMagfield->Addmetadata,'Units','T'

      ; Channel Effieciencies
      unitVec = Intarr(nPts) + 1
      chEff = chEff # unitVec       ; creates a array of dims [nCh,nPts]
      ;oChEff = IDLitData(name='PSDChannelEff',chEff,/no_copy,type=qType)

      ; Error
      zType = Partype(counts)
      oErr = Idlitdata(name='Error',type=ztype) ; NULL data to start
      oErr->Addmetadata,'Long_name','Error'
      oErr->Addmetadata,'Units',''
      ; Counts
      oZ = Idlitdata(name='Counts',type=ztype)  ; NULL data to start
      oZ->Addmetadata,'Long_name','Counts'
      oZ->Addmetadata,'Units',''
      oZ->Addmetadata,'Signal', 1
      oZ->Addmetadata,'OriginalCounts',counts
      oZ->Addmetadata,'2Theta',A4
      oZ->Addmetadata,'QTOT',qtot
      oZ->Addmetadata,'D-SPACE',2*!pi/qtot
      oZ->Addmetadata,'OMEGA',omega
      oZ->Addmetadata,'TEMP',(Fltarr(nCh) + 1.0) # temp
      oZ->Addmetadata,'TEMPAVERAGE',(Fltarr(nCh) + 1.0) # tempAverage
      oZ->Addmetadata,'MAGFIELD',(Fltarr(nCh) + 1.0) # magfield
      oZ->Addmetadata,'CHEFF',ChEff
      oZ->Addmetadata,'CHDELA4',ChDelA4
      oZ->Addmetadata,'TIME',time
      oZ->Addmetadata,'MON',mon
      oZ->Addmetadata,'NPTS',nPts
      oZ->Addmetadata,'INDEP_VAR_TAG',dataStr.indep_var_tag
      oZ->Addmetadata,'INDEP_VAR_VAL',(*dataStr.indep_var_val)


      ; Data point index
      ;unitVec = intarr(nPts) + 1
      dPt = Indgen(nPts) + 1
      odPt = Idlitdata(name='Data_Index',dpt,/no_copy,type=Partype(dpt))
      odPt->Addmetadata,'Long_name','Data Index'
      odPt->Addmetadata,'Units',''


      oPSet->Add, [oA4,oDsp,oE,oQTot,oTemp,oMagfield,oZ,oErr,odPt], $
        parameter_name=['2Theta','d-space','E','|Q|','TEMP','MAGFIELD','Counts','Error','Data_Index']

      Self->Updatepowdervariables, oPSet

    end

    1: begin    ;; single crystal

      ; initialize a few variables
      qTot = []
      qx = []
      qy = []
      a4 = []
      counts = []
      omega = []
      Temp = []
      magfield = []
      mon = []


      orient = *dataStr.orientation_ptr ; retrieve crystal orientation vectors u,v in rec. space coordinates
      orient_u = orient[0:2]            ; the crystal orientation vectors specified in multiples of a*, b* and c*
      orient_v = orient[3:5]

      ; determine appropriate labels to use for qx and qy
      xlabrlu = (orient_u[0] eq 0)? '0' : 'H'
      xlabrlu += ','+(orient_u[1] eq 0)? '0' : 'K'
      xlabrlu += ','+(orient_u[2] eq 0)? '0' : 'L'
      ylabrlu = (orient_v[0] eq 0)? '0' : 'H'
      ylabrlu += ','+(orient_v[1] eq 0)? '0' : 'K'
      ylabrlu += ','+(orient_v[2] eq 0)? '0' : 'L'
      xunitrlu = 'r.l.u.'
      yunitrlu = 'r.l.u.'

      xlabang = (Float(!version.release) lt 8.3)? 'qx $||$ '+xlabrlu : 'qx $\parallel$ '+xlabrlu
        ylabang = (Float(!version.release) lt 8.3)? 'qy $\bot$ '+xlabrlu : 'qy $\perp$ '+xlabrlu
        xunitang = '$\AA^{-1}$'
      yunitang = '$\AA^{-1}$'
      if (rlu eq 1) then begin
        xlab = xlabrlu
        ylab = ylabrlu
        xunit = xunitrlu
        yunit = xunitrlu
      endif else begin
        xlab = xlabang
        ylab = ylabang
        xunit = xunitang
        yunit = xunitang
      endelse

      ; calibration stuff
      chDelA4 = Self.chdela4
      chEff = Abs(Self.cheff) ; some values may be negative, signfying channels intended to be masked
      chDelEf = Self.chdelef
      nCh = N_elements(chDelA4)


      ;Loop through data points in dataset:
      ; - calculate (q,qx,qy), given ki, kf, a3 and a4 for each channel
      nPts = N_elements(a4o)
      for i = 0, nPts-1 do begin
        cha3 = a3o[i]
        cha4 = a4o[i] - chDelA4
        chEi = eio[i]
        chEf = efo[i] - chDelEf  ;
        chki = Sqrt(chEi/ekFac)
        chkf = Sqrt(chEf/ekFac)
        ;  monNorm = baseMon/(*dataStr.mon)[i]

        Angle2q, chki, chkf, cha3, cha4, chq, chqx, chqy, phiOffset=Self.phioffset

        omega = [[omega],[chEi - chEf]]
        qTot = [[qTot],[chq]]
        a4 = [[a4],[cha4]]

        qx = [[qx],[chqx]]
        qy = [[qy],[chqy]]
        counts = [[counts],[(*dataStr.psddets)[*,i]]]
        ;counts = [[counts],[(*dataStr.PSDDETS)[*,i]/chEff]] ;Normalize to detector efficiency
      endfor


      ; Q
      qType = Partype(qTot)
      oQTot = Idlitdata(qTot,name='|Q|',/no_copy,type=qtype)
      oQTot->Addmetadata,'Long_name','|Q|'
      oQTot->Addmetadata,'Units','$\AA^{-1}$'
      ; 2Theta
      qType = Partype(A4)
      oA4 = Idlitdata(A4,name='2Theta',/no_copy,type=qtype)
      oA4->Addmetadata,'Long_name','$2\theta$'
      oA4->Addmetadata,'Units','$\deg$'
      ; E
      oE = Idlitdata(omega,name='E',/no_copy,type=qtype)
      oE->Addmetadata,'Long_name','E'
      oE->Addmetadata,'Units','meV'
      ; Qx
      oQx = Idlitdata(qx,name='QX',/no_copy,type=qtype)
      oQx->Addmetadata,'Long_name',xlab
      oQx->Addmetadata,'Units',xunit
      oQx->Addmetadata,'RLU',rlu
      oQx->Addmetadata,'AA2RLU',1            ; will be updated later in UpdateQxQy method
      oQx->Addmetadata,'LABRLU', xlabrlu
      oQx->Addmetadata,'LABANG', xlabang
      ; Qy
      oQy = Idlitdata(qy,name='QY',/no_copy,type=qtype)
      oQy->Addmetadata,'Long_name',ylab
      oQy->Addmetadata,'Units',yunit
      oQy->Addmetadata,'RLU',rlu
      oQy->Addmetadata,'AA2RLU',1            ; will be updated later in UpdateQxQy method
      oQy->Addmetadata,'LABRLU', ylabrlu
      oQy->Addmetadata,'LABANG', ylabang

      unitVec = Fltarr(nCh) + 1.0

      ; Monitor
      mon = unitVec # (*dataStr.mon)  ; replicate mon at each datapoint to all 48 channels of PSD
      ;oMon = IDLitData(mon,name='MON',/no_copy,type=qtype)
      ;oMon->AddMetaData,'Long_name','Monitor'
      ;oMon->AddMetaData,'Units',''
      ; TIME
      time = unitVec # (*dataStr.time)
      ;oTime = IDLitData(time,name='TIME',/no_copy,type=qtype)
      ;oTime->AddMetaData,'Long_name','Time'
      ;oTime->AddMetaData,'Units','seconds'
      ; TEMP
      temp = unitVec # (*dataStr.temp)
      oTemp = Idlitdata(temp,name='TEMP',/no_copy,type=qtype)
      oTemp->Addmetadata,'Long_name','Temperature'
      oTemp->Addmetadata,'Units','K'
      ; magfield
      magfield = unitVec # (*dataStr.magfield)
      oMagfield = Idlitdata(magfield,name='MAGFIELD',/no_copy,type=qtype)
      oMagfield->Addmetadata,'Long_name','Magnetic-field'
      oMagfield->Addmetadata,'Units','T'

      ;PSD Channel Nos
      unitVec = Intarr(nPts) + 1
      ch = Indgen(nCh) + 1
      ch = ch # unitVec ; creates a array of dims [nCh,nPts], same as counts variable
      oChNos = Idlitdata(name='PSDChannel',ch,/no_copy,type=Partype(ch))
      oChNos->Addmetadata,'Long_name','PSD channel Nos'
      oChNos->Addmetadata,'Units',''

      ; Channel Effieciencies
      chEff = chEff # unitVec
      ;oChEff = IDLitData(name='PSDChannelEff',chEff,/no_copy,type=qType)


      ; Error
      zType = Partype(counts)
      oErr = Idlitdata(name='Error',type=ztype) ; NULL data to start
      oErr->Addmetadata,'Long_name','Error'
      oErr->Addmetadata,'Units',''
      ; Counts
      oZ = Idlitdata(name='Counts',type=ztype)  ; NULL data to start
      oZ->Addmetadata,'Long_name','Counts'
      oZ->Addmetadata,'Units',''
      oZ->Addmetadata,'Signal', 1
      oZ->Addmetadata,'OriginalCounts',counts
      oZ->Addmetadata,'CHEFF',ChEff
      oZ->Addmetadata,'CHDELA4',ChDelA4
      oZ->Addmetadata,'TIME',time
      oZ->Addmetadata,'MON',mon
      oZ->Addmetadata,'INDEP_VAR_TAG',dataStr.indep_var_tag
      oZ->Addmetadata,'INDEP_VAR_VAL',(*dataStr.indep_var_val)

      oPSet->Add, [oQx,oQy,oE,oQTot,oA4,oTemp,oMagfield,oZ,oErr,oChNos], $
        parameter_name=['QX','QY','E','|Q|','2THETA','TEMP','MAGFIELD','Counts','Error','PSDChannel']

      ;
      Self->Updateindependentvariables, oPSet
      Self->Updatecounts, oPSet

    end
  endcase



end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::UpdatePowderVariables
;+
; PURPOSE:
;   Update all variables (dependent and independent) to reflect current user settings
;   Only applicable to powder samples
;
; PARAMETERS:
;   oPSet [in|out] - object whose data is to be updated
;
; KEYWORDS:
;-
pro Bt7psdtool::UpdatePowderVariables, oPSet
  compile_opt idl2

  if ((N_elements(oPSet) eq 0) || ~Obj_valid(oPSet[0])) then begin
    ; retrieve all loaded datasets
    Self->Getproperty, sampContRef=oCont, bkgdContref=oContB
    oPSetS = oCont->Get(/all,count=nDataS)
    oPSetB = oContB->Get(/all,count=nDataB)
    nData = nDataS
    oPSet = oPsetS
    if (nData gt 0 && nDataB gt 0) then begin
      oPSet = [oPSetB,oPSet]
      nData = nData+nDataB
    endif else if (nDataB gt 0) then begin
      oPSet = oPSetB
      nData = nDataB
    endif
  endif else begin
    nData = N_elements(oPSet)
    Self->Getproperty, sampContRef=oCont, bkgdContref=oContB
    oPSetS = oCont->Get(/all,count=nDataS)
    oPSetB = oContB->Get(/all,count=nDataB)
  endelse

  if (nData eq 0) then Return

  Self->Getproperty, MONSCALEVALUE=monScaleVal, NORMALIZETO=normTo, MONCORFLAG=monCorFlag $
    ,RESCORFLAG=resCorFlag, FASTFLAG=fastFlag, FASTVALUE=fastVal $
    ,DETAILEDBALANCEFLAG=detBalFlag,effNormFlag=effFlag, sampTypeFlag=sampTypeFlag $
    ,bkgdFlag=bkgdFlag, nBkgd=nBkgd, bkgdContRef=bkgdContRef $
    ,bkgdSubVarTol=bkgdSubVarTol, bkgdSubVarFlag=bkgdSubVarFlag, logFlag=logFlag

  if (sampTypeFlag ne 0) then Return  ; only proceed if user selection is set to powder
  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB
  for i=0,nData-1 do begin
    oData = oPSet[i]
    oZ = oData->Getbyname('Counts')
    if (~Obj_valid(oZ)) then Return
    status = oData->Getmetadata('sampTypeFlag',sTypeFlag)
    if (sTypeFlag ne 0) then continue  ; only proceed if dataset was originally read in as powder

    oErr = oData->Getbyname('Error')
    if (~Obj_valid(oErr)) then Return
    if (~oZ->Getmetadata('OriginalCounts',counts)) then Return
    error = counts
    index = Where(error le 0.0,cnt)
    if (cnt gt 0) then error[index] = 1.0
    error = Sqrt(error)

    status = oZ->Getmetadata('MON',mon)
    status = oZ->Getmetadata('TIME',time)
    if (i eq 0 && monScaleVal eq 1.0) then begin
      if (normTo eq 0) then monScaleVal = mon[0]
      if (normTo eq 1) then monScaleVal = time[0]
    endif

    if (effFlag) then begin
      if (~oZ->Getmetadata('CHEFF',chEff)) then Return
      counts = Temporary(counts)/chEff
      error = Temporary(error)/chEff   ;temporary(error)/sqrt(chEff)
      ;oChEff = oData->GetByName('ChEff')
      ;if (obj_valid(ochEff)) then begin
      ;   status = oChEff->GetData(chEff)
      ;   counts = temporary(counts)/chEff
      ;   error = temporary(error)/sqrt(chEff)
      ;endif
    endif

    if (fastFlag) then begin   ; perform corrections that depend on first applying fast bkgd correction
      ;; Apply fast Correction
      if (fastVal ne 0.0) then begin
        counts = Temporary(counts) - (time/60.0)*fastVal ; time is measured in secs and fastVal is fast bkgd in cnts/min
      endif

      ;; Apply monitor correction
      if (monCorFlag) then begin
        ;; Constraints are:
        ;; 1 - PG monochromator is in use (d spacing = 3.354)
        ;; 2 - 5 <= Ei <= 34; For Ei < 5, flag an error, for Ei > 34, correction = 1
        ;; CF(Ei) = M0 + M1*Ei + M2*Ei^2 + M3*Ei^3 + M4*Ei^4
        status = oData->Getmetadata('DATAPTRREF',dataPtr)
        if (~Ptr_valid(dataPtr)) then Return
        dspacem = (*dataPtr).dspacem  ; d spacing of monochromator
        diff = Abs(dspacem - 3.354)
        PGMON = diff lt 0.001
        Ei = (*(*dataPtr).ei)
        index = Where(Ei lt 5.0,Eilt5)  ; correction not aloowed if Ei < 5.0 meV
        if (Eilt5) then begin
          msg = ['Ei is lower than 5.0 meV.','Monitor correction was not applied']
          title = 'Monitor Correction'
          Self->Errormessage,msg,title=title,severity=0
        endif else if (PGMON) then begin
          M0 =  6.1230
          M1 = -5.9630e-1
          M2 =  2.6244e-2
          M3 = -4.8430e-4
          M4 =  2.8810e-6
          index = Where(Ei gt 34.0,Eigt34)
          CFEi = M0 + M1*Ei + M2*Ei^2 + M3*Ei^3 + M4*Ei^4
          if (Eigt34) then CFEi[index] = 1.0  ; for Ei > 34, CF = 1
          counts = Temporary(counts)*CFEi
          error  = Temporary(error)*CFEi
        endif
      endif

      ;if (resCorFlag) then begin
      ;   ; apply resolution correction
      ;endif
      ;
      ;if (detBalFlag) rhen begin
      ;   ; apply detailed balance correction
      ;endif
    endif

    ;; Apply monitor normalization
    case normTo of

      0: begin
        monScale = monScaleVal/mon
      end

      1: begin
        monScale = monScaleVal/time
      end

      else: monScale = monScaleVal
    endcase
    counts = Temporary(counts)*monScale
    error = Temporary(error)*monscale

    ;; Mask bad channels
    Self->Getproperty, maskFlag=maskFlag
    sBadChans = Self.maskeddets
    maskedChansExist = ~Strcmp(sBadChans,'')
    if (maskFlag && maskedChansExist) then begin
      status = Compactstring2intvector(sBadChans, badChans)
      badChanIndex = badChans - 1   ; convert channel nos to 0-based channel index
      ; Apply mask by simple replacing the counts in the masked channels by NaNs
      ; Leave error variable untouched
      counts[badChanIndex,*] = !values.f_nan
      error[badChanIndex,*] = 0.0
    endif


    ;; Store processed 2D counts and erros in metadata in oZ and oErr objects
    ;; the processed counts and errors are used only when exporting powder data to Mslice!
    oZ->Addmetadata, 'ProcessedCounts',counts
    oZ->Addmetadata, 'ProcessedErrors',error

    tolB = 0.001
    oData->Getproperty, type=type
    Self->Getproperty, constBinFlag=constBinFlag, minbinWidth=binwidth
    counts2D = counts
    error2D = error
    counts = Reform(counts,N_elements(counts))
    error = Reform(error,N_elements(error))

    ;; Merge data wrt 2theta
    status = oZ->Getmetadata('2Theta',var)
    mgCount = counts
    mgError = error
    var = Reform(var,N_elements(var))
    ;Self->MergePowderChannels, var, mgCount, mgError, tol=0.05
    Dm_step_bin, xstart=Min(var),binwidth,var,ydat=mgCount,yerr=mgError,conststep=constBinFlag,avgsum=0,/CHECKFINITE,/truncatemax,group_leader=wTLB
    oVar = oData->Getbyname('2Theta',count=cnt)
    status = oVar->Setdata(var,/no_notify)
    ; For sample datasets, perform bkgd subtraction if requested
    if (Strcmp(type,'samp') && bkgdFlag && (nBkgd gt 0)) then begin
      for j = 0,nDataB-1 do begin  ; bkgd datasets were already processed earlier in the initial for loop
        oDataB = oPSetB[j]
        oVarB = oDataB->Getbyname('2Theta',count=cnt)
        status = oVarB->Getdata(varB)
        status = oVarB->Getmetadata('Counts',mgCountB)
        status = oVarB->Getmetadata('Error',mgErrorB)

        ; now perform subtraction for correspong datapoints in signal and bkgd
        ; datasets that have the same value of the independent variable
        sIndex = []
        bIndex = []
        for k=0, N_elements(varB)-1 do begin
          index = Where(Abs(var - varB[k]) lt tolB, found)
          if (found eq 1) then begin
            sIndex = [sIndex,index]
            bIndex = [bIndex,k]
          endif
        endfor
        if (N_elements(sIndex) gt 0 && N_elements(bIndex) gt 0) then begin
          mgCount[sIndex] = mgCount[sIndex] - mgCountB[bindex]
          mgError[sIndex] = Sqrt(mgError[sIndex]^2 + mgErrorB[bindex]^2)
        endif
      endfor
      ; take a log of the data if necessary
      if (logFlag gt 0) then begin
        index = Where(mgCount le 0.0, nBad)
        if (nBad gt 0) then mgCount[index] = !values.f_nan
        ; NB if we have y and dy then taking log such that
        ; z = log(y) then dz is actually proportional to the relative error in y
        ; See http://faculty.washington.edu/stuve/log_error.pdf
        ; ie dz = differential (log(y))
        ;    dz = dy/y * 1/ln(10)
        ;       = dy/y * 0.434
        ;mgError = Temporary(mgError)/mgCount/(Alog(10))
        ;mgCount = Alog10(Temporary(mgCount))
      endif
    endif else if (Strcmp(type,'samp') && (logFlag gt 0)) then begin
      ; take log of sample data
      ; NB - log is not taken for bkgd data
      index = Where(mgCount le 0.0, nBad)
      if (nBad gt 0) then mgCount[index] = !values.f_nan
      ;mgError = Temporary(mgError)/mgCount/(Alog(10))
      ;mgCount = Alog10(Temporary(mgCount))
    endif

    oVar->Addmetadata,'Counts',mgCount
    oVar->Addmetadata,'Error',mgError

    ;; Merge data wrt E
    status = oZ->Getmetadata('Omega',var)
    mgCount = counts
    mgError = error
    var = Reform(var,N_elements(var))
    ;Self->MergePowderChannels, var, mgCount, mgError, tol=0.05
    Dm_step_bin, xstart=Min(var), binwidth, var, ydat=mgCount, yerr=mgError, conststep=constBinFlag, avgsum=0, /CHECKFINITE, /truncatemax,group_leader=wTLB
    oVar = oData->Getbyname('E',count=cnt)
    status = oVar->Setdata(var,/no_notify)
    ; For sample datasets, perform bkgd subtraction if requested
    if (Strcmp(type,'samp') && bkgdFlag && (nBkgd gt 0)) then begin
      for j = 0,nDataB-1 do begin  ; bkgd datasets were already processed earlier in the initial for loop
        oDataB = oPSetB[j]
        oVarB = oDataB->Getbyname('E',count=cnt)
        status = oVarB->Getdata(varB)
        status = oVarB->Getmetadata('Counts',mgCountB)
        status = oVarB->Getmetadata('Error',mgErrorB)

        ; now perform subtraction for correspong datapoints in signal and bkgd
        ; datasets that have the same value of the independent variable
        sIndex = []
        bIndex = []
        for k=0, N_elements(varB)-1 do begin
          index = Where(Abs(var - varB[k]) lt tolB, found)
          if (found eq 1) then begin
            sIndex = [sIndex,index]
            bIndex = [bIndex,k]
          endif
        endfor
        if (N_elements(sIndex) gt 0 && N_elements(bIndex) gt 0) then begin
          mgCount[sIndex] = mgCount[sIndex] - mgCountB[bindex]
          mgError[sIndex] = Sqrt(mgError[sIndex]^2 + mgErrorB[bindex]^2)
        endif
      endfor
      ; take a log of the data if necessary
      if (logFlag gt 0) then begin
        index = Where(mgCount le 0.0, nBad)
        if (nBad gt 0) then mgCount[index] = !values.f_nan
        case logFlag of
          1: begin  ; log to base 10
            mgError = Temporary(mgError)/mgCount/(Alog(10))
            mgCount = Alog10(Temporary(mgCount))            
          end

          2:begin  ; log to base e
            mgError = Temporary(mgError)/mgCount
            mgCount = Alog(Temporary(mgCount))
          end

          3:begin  ; log to base 2
            mgError = Temporary(mgError)/mgCount/(Alog(2))
            mgCount = Alog2(Temporary(mgCount))
          end
        endcase
      endif
    endif else if (Strcmp(type,'samp') && (logFlag gt 0)) then begin
      ; take log of sample data
      ; NB - log is not taken for bkgd data
      index = Where(mgCount le 0.0, nBad)
      if (nBad gt 0) then mgCount[index] = !values.f_nan
      case logFlag of
        1: begin  ; log to base 10
          mgError = Temporary(mgError)/mgCount/(Alog(10))
          mgCount = Alog10(Temporary(mgCount))            
        end

        2:begin  ; log to base e
          mgError = Temporary(mgError)/mgCount
          mgCount = Alog(Temporary(mgCount))
        end

        3:begin  ; log to base 2
          mgError = Temporary(mgError)/mgCount/(Alog(2))
          mgCount = Alog2(Temporary(mgCount))
        end

        else:    ; linear
      endcase
    endif
    oVar->Addmetadata,'Counts',mgCount
    oVar->Addmetadata,'Error',mgError

    ;; Merge data wrt Q and d
    status = oZ->Getmetadata('Qtot',var)
    mgCount = counts
    mgError = error
    var = Reform(var,N_elements(var))
    Dm_step_bin, xstart=Min(var), binwidth, var, ydat=mgCount, yerr=mgError, conststep=constBinFlag, avgsum=0, /CHECKFINITE, /truncatemax,group_leader=wTLB
    oVar = oData->Getbyname('|Q|',count=cnt)
    status = oVar->Setdata(var,/no_notify)
    ; For sample datasets, perform bkgd subtraction if requested
    if (Strcmp(type,'samp') && bkgdFlag && (nBkgd gt 0)) then begin
      for j = 0,nDataB-1 do begin  ; bkgd datasets were already processed earlier in the initial for loop
        oDataB = oPSetB[j]
        oVarB = oDataB->Getbyname('|Q|',count=cnt)
        status = oVarB->Getdata(varB)
        status = oVarB->Getmetadata('Counts',mgCountB)
        status = oVarB->Getmetadata('Error',mgErrorB)

        ; now perform subtraction for correspong datapoints in signal and bkgd
        ; datasets that have the same value of the independent variable
        sIndex = []
        bIndex = []
        for k=0, N_elements(varB)-1 do begin
          index = Where(Abs(var - varB[k]) lt tolB, found)
          if (found eq 1) then begin
            sIndex = [sIndex,index]
            bIndex = [bIndex,k]
          endif
        endfor
        if (N_elements(sIndex) gt 0 && N_elements(bIndex) gt 0) then begin
          mgCount[sIndex] = mgCount[sIndex] - mgCountB[bindex]
          mgError[sIndex] = Sqrt(mgError[sIndex]^2 + mgErrorB[bindex]^2)
        endif
      endfor
      ; take a log of the data if necessary
      case (logFlag) of
        1: begin     ; log base 10
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount/Alog(10)       ; delta(x)/x/ln(10)
          mgCount = Alog10(Temporary(mgCount))
        end

        2: begin     ; log base e
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount                  ; delta(x)/x
          mgCount = Alog(Temporary(mgCount))
        end
        
        3: begin     ; log base 2
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount/Alog(2)       ; delta(x)/x/ln(2)
          mgCount = Alog2(Temporary(mgCount))
        end
        
        else: ; linear scale
      endcase
;      if (logFlag) then begin
;        index = Where(mgCount le 0.0, nBad)
;        if (nBad gt 0) then mgCount[index] = !values.f_nan
;        mgError = Temporary(mgError)/mgCount/(Alog(10))
;        mgCount = Alog10(Temporary(mgCount))
;      endif
    endif
    oVar->Addmetadata,'Counts',mgCount
    oVar->Addmetadata,'Error',mgError


    status = oZ->Getmetadata('Qtot',var)
    mgCount = counts
    mgError = error
    var = Reform(var,N_elements(var))
    var = 2*!pi/var
    Dm_step_bin, xstart=Min(var), binwidth, var, ydat=mgCount, yerr=mgError, conststep=constBinFlag, avgsum=0, /CHECKFINITE, /truncatemax,group_leader=wTLB
    oVar = oData->Getbyname('d-space',count=cnt)
    status = oVar->Setdata(var,/no_notify)
    ; For sample datasets, perform bkgd subtraction if requested
    if (Strcmp(type,'samp') && bkgdFlag && (nBkgd gt 0)) then begin
      for j = 0,nDataB-1 do begin  ; bkgd datasets were already processed earlier in the initial for loop
        oDataB = oPSetB[j]
        oVarB = oDataB->Getbyname('d-space',count=cnt)
        status = oVarB->Getdata(varB)
        status = oVarB->Getmetadata('Counts',mgCountB)
        status = oVarB->Getmetadata('Error',mgErrorB)

        ; now perform subtraction for correspong datapoints in signal and bkgd
        ; datasets that have the same value of the independent variable
        sIndex = []
        bIndex = []
        for k=0, N_elements(varB)-1 do begin
          index = Where(Abs(var - varB[k]) lt tolB, found)
          if (found eq 1) then begin
            sIndex = [sIndex,index]
            bIndex = [bIndex,k]
          endif
        endfor
        if (N_elements(sIndex) gt 0 && N_elements(bIndex) gt 0) then begin
          mgCount[sIndex] = mgCount[sIndex] - mgCountB[bindex]
          mgError[sIndex] = Sqrt(mgError[sIndex]^2 + mgErrorB[bindex]^2)
        endif
      endfor
      ; take a log of the data if necessary
      case (logFlag) of
        1: begin     ; log base 10
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount/Alog(10)       ; delta(x)/x/ln(10)
          mgCount = Alog10(Temporary(mgCount))
        end

        2: begin     ; log base e
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount                  ; delta(x)/x
          mgCount = Alog(Temporary(mgCount))
        end

        3: begin     ; log base 2
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount/Alog(2)       ; delta(x)/x/ln(2)
          mgCount = Alog2(Temporary(mgCount))
        end
        
        else:        ; linear scale
      endcase
;      if (logFlag) then begin
;        index = Where(mgCount le 0.0, nBad)
;        if (nBad gt 0) then mgCount[index] = !values.f_nan
;        mgError = Temporary(mgError)/mgCount/(Alog(10))
;        mgCount = Alog10(Temporary(mgCount))
;      endif
    endif
    oVar->Addmetadata,'Counts',mgCount
    oVar->Addmetadata,'Error',mgError

    ;; Merge data wrt Temp
    Self->Getproperty, useTempAverageFlag=useTempAverageFlag
    if (useTempAverageFlag) then $
      status = oZ->Getmetadata('TEMPAVERAGE',var) else $
      status = oZ->Getmetadata('TEMP',var)
    mgCount = counts
    mgError = error
    var = Reform(var,N_elements(var))
    Dm_step_bin, xstart=Min(var), binwidth, var, ydat=mgCount, yerr=mgError, conststep=constBinFlag, avgsum=0, /CHECKFINITE, /truncatemax,group_leader=wTLB
    oVar = oData->Getbyname('TEMP',count=cnt)
    status = oVar->Setdata(var,/no_notify)
    ; For sample datasets, perform bkgd subtraction if requested
    if (Strcmp(type,'samp') && bkgdFlag && (nBkgd gt 0)) then begin
      for j = 0,nDataB-1 do begin  ; bkgd datasets were already processed earlier in the initial for loop
        oDataB = oPSetB[j]
        oVarB = oDataB->Getbyname('TEMP',count=cnt)
        status = oVarB->Getdata(varB)
        status = oVarB->Getmetadata('Counts',mgCountB)
        status = oVarB->Getmetadata('Error',mgErrorB)

        ; now perform subtraction for correspong datapoints in signal and bkgd
        ; datasets that have the same value of the independent variable
        sIndex = []
        bIndex = []
        for k=0, N_elements(varB)-1 do begin
          index = Where(Abs(var - varB[k]) lt tolB, found)
          if (found eq 1) then begin
            sIndex = [sIndex,index]
            bIndex = [bIndex,k]
          endif
        endfor
        if (N_elements(sIndex) gt 0 && N_elements(bIndex) gt 0) then begin
          mgCount[sIndex] = mgCount[sIndex] - mgCountB[bindex]
          mgError[sIndex] = Sqrt(mgError[sIndex]^2 + mgErrorB[bindex]^2)
        endif
      endfor
      ; take a log of the data if necessary
      case (logFlag) of
        1: begin     ; log base 10
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount/Alog(10)       ; delta(x)/x/ln(10)
          mgCount = Alog10(Temporary(mgCount))
        end

        2: begin     ; log base e
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount                  ; delta(x)/x
          mgCount = Alog(Temporary(mgCount))
        end

        3: begin     ; log base 2
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount/Alog(2)       ; delta(x)/x/ln(2)
          mgCount = Alog2(Temporary(mgCount))
        end
        
        else:        ; linear
      endcase
;      if (logFlag) then begin
;        index = Where(mgCount le 0.0, nBad)
;        if (nBad gt 0) then mgCount[index] = !values.f_nan
;        mgError = Temporary(mgError)/mgCount/(Alog(10))
;        mgCount = Alog10(Temporary(mgCount))
;      endif
    endif
    oVar->Addmetadata,'Counts',mgCount
    oVar->Addmetadata,'Error',mgError

    ;; Merge data wrt Magfield
    status = oZ->Getmetadata('MAGFIELD',var)
    mgCount = counts
    mgError = error
    var = Reform(var,N_elements(var))
    Dm_step_bin, xstart=Min(var), binwidth, var, ydat=mgCount, yerr=mgError, conststep=constBinFlag, avgsum=0, /CHECKFINITE, /truncatemax,group_leader=wTLB
    oVar = oData->Getbyname('MAGFIELD',count=cnt)
    status = oVar->Setdata(var,/no_notify)
    ; For sample datasets, perform bkgd subtraction if requested
    if (Strcmp(type,'samp') && bkgdFlag && (nBkgd gt 0)) then begin
      for j = 0,nDataB-1 do begin  ; bkgd datasets were already processed earlier in the initial for loop
        oDataB = oPSetB[j]
        oVarB = oDataB->Getbyname('MAGFIELD',count=cnt)
        status = oVarB->Getdata(varB)
        status = oVarB->Getmetadata('Counts',mgCountB)
        status = oVarB->Getmetadata('Error',mgErrorB)

        ; now perform subtraction for correspong datapoints in signal and bkgd
        ; datasets that have the same value of the independent variable
        sIndex = []
        bIndex = []
        for k=0, N_elements(varB)-1 do begin
          index = Where(Abs(var - varB[k]) lt tolB, found)
          if (found eq 1) then begin
            sIndex = [sIndex,index]
            bIndex = [bIndex,k]
          endif
        endfor
        if (N_elements(sIndex) gt 0 && N_elements(bIndex) gt 0) then begin
          mgCount[sIndex] = mgCount[sIndex] - mgCountB[bindex]
          mgError[sIndex] = Sqrt(mgError[sIndex]^2 + mgErrorB[bindex]^2)
        endif
      endfor
      ; take a log of the data if necessary
      case (logFlag) of
        1: begin     ; log base 10
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount/Alog(10)       ; delta(x)/x/ln(10)
          mgCount = Alog10(Temporary(mgCount))
        end

        2: begin     ; log base e
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount                  ; delta(x)/x
          mgCount = Alog(Temporary(mgCount))
        end

        3: begin     ; log base 2
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount/Alog(2)       ; delta(x)/x/ln(2)
          mgCount = Alog2(Temporary(mgCount))
        end
        
        else:         ; linear
      endcase
;      if (logFlag) then begin
;        index = Where(mgCount le 0.0, nBad)
;        if (nBad gt 0) then mgCount[index] = !values.f_nan
;        mgError = Temporary(mgError)/mgCount/(Alog(10))
;        mgCount = Alog10(Temporary(mgCount))
;      endif
    endif
    oVar->Addmetadata,'Counts',mgCount
    oVar->Addmetadata,'Error',mgError

    ;; Merge data wrt data_index
    mgCount = counts2D
    mgError = error2D
    Self->Mergepowderchannels, var, mgCount, mgError, /SUMCHANNELS
    oVar = oData->Getbyname('Data_Index',count=cnt)
    if (Strcmp(type,'samp') && bkgdFlag && (nBkgd gt 0)) then begin
      for j = 0,nDataB-1 do begin  ; bkgd datasets were already processed earlier in the initial for loop
        oDataB = oPSetB[j]
        oVarB = oDataB->Getbyname('Data_Index',count=cnt)
        status = oVarB->Getdata(varB)
        status = oVarB->Getmetadata('Counts',mgCountB)
        status = oVarB->Getmetadata('Error',mgErrorB)

        ; now perform subtraction for correspong datapoints in signal and bkgd
        ; datasets that have the same value of the independent variable
        ns = N_elements(mgCount)
        nb = N_elements(mgCountB)
        sIndex = Lindgen(ns)
        bIndex = Lindgen(nb)
        if (ns ge nb) then begin
          mgCount[bindex] = mgCount[bindex] - mgCountB[bindex]
          mgError[bindex] = Sqrt(mgError[bindex]^2 + mgErrorB[bindex]^2)
        endif else begin
          mgCount[sIndex] = mgCount[sIndex] - mgCountB[sIndex]
          mgError[sIndex] = Sqrt(mgError[sIndex]^2 + mgErrorB[sIndex]^2)
        endelse
      endfor
      ; take a log of the data if necessary
      case (logFlag) of
        1: begin     ; log base 10
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount/Alog(10)       ; delta(x)/x/ln(10)
          mgCount = Alog10(Temporary(mgCount))
        end

        2: begin     ; log base e
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount                  ; delta(x)/x
          mgCount = Alog(Temporary(mgCount))
        end

        3: begin     ; log base 2
          index = Where(mgCount le 0.0, nBad)
          if (nBad gt 0) then mgCount[index] = !values.f_nan
          mgError = Temporary(mgError)/mgCount/Alog(2)       ; delta(x)/x/ln(2)
          mgCount = Alog2(Temporary(mgCount))
        end

        else:         ; linear
      endcase
;      if (logFlag) then begin
;        index = Where(mgCount le 0.0, nBad)
;        if (nBad gt 0) then mgCount[index] = !values.f_nan
;        mgError = Temporary(mgError)/mgCount/(Alog(10))
;        mgCount = Alog10(Temporary(mgCount))
;      endif
    endif
    oVar->Addmetadata,'Counts',mgcount
    oVar->Addmetadata,'Error',mgError

  endfor

end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::MergePowderChannels
;+
; PURPOSE:
;   Merge the PSD channels together for powder samples so that overlapping data
;   determined with respect to the specified xvalues (x) are combined such
;   that the corresponding errors are added in quadrature. NaNs are appropriately handled
;
; PARAMETERS:
;   x [in|out] - the xvalues controlling how the data are to be merged
;
;   counts [in|out] - the data to be merged
;
;   error [in|out] - the error are to be added in quadrature where there is overlap
;
; KEYWORDS:
;
;   tolerance - any two values seperated by less than or equal to tolerance are treated
;               as the same and hence added in quadrature.
;
;   sumChannels - Set this keyword to simply sum counts and error wrt to the channel dimension
;                 to have counts at each data point
;-
pro Bt7psdtool::MergePowderChannels, x, counts, error, tolerance=tol, sumChannels=sumChannels, uniformBins=uniformBins
  ;pro MergePowderChannels, x, counts, error, tolerance=tol, sumChannels=sumChannels
  compile_opt idl2

  ; Note: if xvals, counts and error are 2D then they are of the form
  ; counts[n_ch, n_pts] where
  ;     n_ch are the nos of PSD channels and
  ;     n_pts are the number of data points

  dimC = Size(counts,/N_DIMENSIONS)
  if (Keyword_set(sumChannels) && (dimC eq 2)) then begin
    ;; simply sum counts and error wrt to the channel dimension to have counts at each data point
    counts = Total(Temporary(counts),1,/NAN)
    error = Sqrt(Total(Temporary(error)^2,1,/NAN))
    Return
  endif

  ;if (n_elements(tol) eq 0) then tol = 0.001
  ;Self->GetProperty, minbinWidth=tol

  ; if x is not varying then simply sum everthing and return scalars
  xmax = Max(x,min=xmin)
  if (Abs(xmax-xmin) le tol) then begin ;if (xmax eq xmin) then begin
    x = x[0]
    counts = Total(counts,/NAN)
    error = Total(error,/NAN)
    Return
  endif

  dimX = Size(x,/N_DIMENSIONS)
  if (dimX eq 2) then x = Reform(x,N_elements(x),/OVERWRITE)
  if (dimC eq 2) then begin
    counts = Reform(counts,N_elements(counts),/OVERWRITE)
    error = Reform(error,N_elements(error),/OVERWRITE)
  endif

  ; sort data in ascending x order
  sindex = Sort(x)
  x = x[sindex]
  counts = counts[sindex]
  error = error[sindex]

  ; Get rid of data points that are NaNs
  nanIndex = Where(Finite(counts,/NAN),nanPresent, complement=validIndex)
  if (nanPresent gt 0) then begin
    x = x[validIndex]
    counts = counts[validIndex]
    error = error[validIndex]
  endif

  ; If constant bin width is required, initially regroup the data using
  ; very fine bins (specified through the tol keyword) and then use
  ; Drebin to rebin the regrouped data into constant bin
  Self->Getproperty, constBinFlag=constBinFlag, minbinWidth=tol
  if (constBinFlag) then begin
    x_out = xmin + tol*Findgen(Round((xmax - xmin)/tol) + 1)
    tol = 0.000000 ; essentially trying to merge values with the same x value
  endif

  ; Locate duplicate x values
  nElmts = N_elements(counts)
  i = 0
  newx = []
  newc = []
  newe = []
  while (i lt nElmts-1) do begin
    index = i
    for j = i, nElmts-2 do begin
      diff = Abs(x[i] - x[j+1])
      if (diff le tol) then begin
        index = [index,j+1]
      endif else begin
        break
      endelse
    endfor
    i = j + 1
    xmean = Mean(x[index]) ;(moment(x[index],maxmoment=1))[0]
    newx = [newx,xmean]
    c1 = Mean(counts[index],/NAN) ;total(counts[index],/NAN)/float(n_elements(index))
    e1 = Sqrt(Total(error[index]^2,/NAN))/Float(N_elements(index))
    newc = [newc,c1]
    newe = [newe,e1]
  endwhile
  lastIndex = index[N_elements(index)-1]
  if (lastIndex eq nElmts-2) then begin
    newx = [newx,x[nElmts-1]]
    newc = [newc,counts[nElmts-1]]
    newe = [newe,error[nElmts-1]]
  endif
  x = newx
  counts = newc
  error = newe
  if (constBinFlag) then begin
    Drebin,x,counts,error,x_out,newc,newe,/points,/to_points,err=err,emsg=emsg
    if (err eq 0) then begin
      x = x_out
      counts = newc
      error = newe
    endif
  endif


end
;-------------------------------------------------------------------------------

;===============================================================================
; Bt7psdTool::MergeDupGroups
;+
; PURPOSE:
;   For the specified 2D dataset, merge groups that have overlapping values. Use the
;   specified tolerance to determine if group values are the same or not. Groups are combined such
;   that the corresponding errors are added in quadrature. NaNs are appropriately handled
;
; PARAMETERS:
;   y [in|out] - the y or group values that determine how the data are to be merged
;
;   counts [in|out] - the data to be merged
;
;   error [in|out] - the error are to be added in quadrature where there is overlap
;
; KEYWORDS:
;
;   tolerance - any two values seperated by less than or equal to tolerance are treated
;               as the same and hence added in quadrature.
;
;-
pro Bt7psdtool::MergeDupGroups, y, z, dz, tolerance=tol
  compile_opt idl2

  ; y must be a vector
  ; z and dz are 2D of dimension
  ; z[n_x, n_y] where
  ;     n_x are nos of x values
  ;     n_y are the number of y values or groups
  if (Size(z,/n_dimensions) ne 2) then Return
  if (Size(dz,/n_dimensions) ne 2) then Return
  if (Size(y,/n_dimensions) ne 1) then Return

  dims = Size(z,/dimensions)
  n_x = dims[0]
  n_y = dims[1]
  if (Size(y,/dimensions) ne n_y) then Return

  ; Locate duplicate y values
  i = 0
  while (i lt n_y-1) do begin
    index = i
    for j = i, n_y-2 do begin
      diff = Abs(y[i] - y[j+1])
      if (diff le tol) then begin
        index = [index,j+1]
      endif else begin
        break
      endelse
    endfor
    i = j + 1
    ymean = Mean(y[index])  ;(moment(y[index],maxmoment=1))[0]
    nIndex = N_elements(index)
    if (nIndex gt 1) then begin
      c1 = Mean(z[*,index],dimension=2,/NAN) ;total(z[*,index],2,/NAN)/float(nIndex)
      e1 = Sqrt(Total(dz[*,index]^2,2,/NAN))/Float(nIndex)
    endif else begin
      c1 = z[*,index]
      e1 = dz[*,index]
    endelse
    if (Size(c1,/n_dimensions) eq 1) then begin
      c1 = Reform(c1,n_x,1)
      e1 = Reform(e1,n_x,1)
    endif
    if (N_elements(newy) eq 0) then begin
      newy = ymean
      newc = c1
      newe = e1
    endif else begin
      newy = [newy,ymean]
      newc = Transpose([Transpose(newc),Transpose(c1)])
      newe = Transpose([Transpose(newe),Transpose(e1)])
    endelse
    ;   if (i gt 6189) then begin
    ;      print,i
    ;   endif
  endwhile
  lastIndex = index[N_elements(index)-1]
  if (lastIndex eq n_y-2) then begin
    ; the last group was not processed so include it.
    newy = [newy,y[n_y-1]]
    c1 = Reform(z[*,n_y-1],n_x,1)
    e1 = Reform(dz[*,n_y-1],n_x,1)
    newc = Transpose([Transpose(newc),Transpose(c1)])
    newe = Transpose([Transpose(newe),Transpose(e1)])
  endif
  y = newy
  z = newc
  dz = newe



  ;
  ;
  ;
  ;; Look for duplicate y values and merge the corresponding groups in z and dz
  ;diff = abs(y[0:n_y-2] - y[1:n_y-1])
  ;dupIndex = where(diff lt tol, complement=uniqIndex, nDup)
  ;if (nDup le 0) then return
  ;
  ;i = 0
  ;mon = fltarr(n_x,n_y) + 1.0
  ;nanIndex = where(finite(z,/NAN),nanPresent);, complement=validIndex)
  ;if (nanPresent gt 0) then mon[nanIndex] = 0.0 ; set mon eq 0 for undefined counts
  ;
  ;while (i lt nDup) do begin
  ;   index = [dupIndex[i], dupIndex[i] + 1]   ; each entry in dupIndex implies a dup pair in y
  ;   for j = i, nDup-1 do begin
  ;      gap = 2
  ;      if (j lt nDup-1) then gap = abs(dupIndex[j] - dupIndex[j+1])
  ;      if (gap eq 1) then $ => more than two consecutive values are the same in y
  ;         index = [index, dupIndex[j] + 2] $
  ;      else $
  ;         break
  ;   endfor
  ;   ;print,index
  ;   i = j + 1
  ;
  ;   ; add up duplicate entries
  ;   z[*,dupIndex[j]+1] = total(z[*,index], 2, /NAN)
  ;   dz[*,dupIndex[j]+1] = sqrt(total(dz[*,index]^2, 2, /NAN))
  ;   mon[*,dupIndex[j]+1] = total(mon[*,index], 2, /NAN)
  ;   zeroMonIndex = where(mon[*,dupIndex[j]+1] eq 0.0,zeroMonCnt)
  ;   if (zeroMonCnt gt 0) then begin
  ;      ;a mon value of 0.0 signifies that the corresponding count should be undefined
  ;      ;so make sure those values are replaced with NaNs. This step is necessary b/c
  ;      ;total(z[],/NAN) will return a 0.0 instead of a NaN if z[] contains all NaNs
  ;      z[zeroMonIndex,dupIndex[j]+1] = !values.D_NAN
  ;      dz[zeroMonIndex,dupIndex[j]+1] = !values.D_NAN
  ;   endif
  ;endwhile
  ;
  ;
  ;if (nDup gt 0) then begin
  ;   z = temporary(z[*,uniqIndex])
  ;   dz = temporary(dz[*,uniqIndex])
  ;   mon = temporary(mon[*,uniqIndex])
  ;   y = y[uniqIndex]
  ;endif
  ;
  ;; normalize so duplicate groups are smoothed out
  ;z = z/mon
  ;dz = dz/mon

end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::UpdateCounts
;+
; PURPOSE:
;   Update Counts/Error for the specified dataset according to current settings
;
; PARAMETERS:
;   oPSet [in|out] - object whose data is to be updated. If not specified, then
;
; KEYWORDS:
;-
pro Bt7psdtool::UpdateCounts, oPSet
  compile_opt idl2
print,'-------------------------------------------------------------------------------'
print,'UpdateCounts...'
print,'-------------------------------------------------------------------------------'

  if ((N_elements(oPSet) eq 0) || ~Obj_valid(oPSet[0])) then begin
    ; retrieve all loaded datasets
    Self->Getproperty, sampContRef=oCont, bkgdContref=oContB
    oPSet = oCont->Get(/all,count=nData)
    oPSetB = oContB->Get(/all,count=nDataB)
    if (nData gt 0 && nDataB gt 0) then begin
      oPSet = [oPSetB,oPSet]
      nData = nData+nDataB
    endif else if (nDataB gt 0) then begin
      oPSet = oPSetB
      nData = nDataB
    endif
  endif else begin
    nData = N_elements(oPSet)
  endelse

  if (nData eq 0) then Return

  Self->Getproperty, MONSCALEVALUE=monScaleVal, NORMALIZETO=normTo, MONCORFLAG=monCorFlag $
    ,RESCORFLAG=resCorFlag, FASTFLAG=fastFlag, FASTVALUE=fastVal $
    ,DETAILEDBALANCEFLAG=detBalFlag,effNormFlag=effFlag, sampTypeFlag=sampTypeFlag $
    ,logFlag=logFlag, bkgdFlag=bkgdFlag, nBkgd=nBkgd, bkgdContRef=bkgdContRef $
    ,bkgdSubVarTol=bkgdSubVarTol, bkgdSubVarFlag=bkgdSubVarFlag

  case sampTypeFlag of
    0: Self->Updatepowdervariables, oPSet

    1: begin
      ;; single xtal

      maxVals = []
      minVals = []
      for i=0,nData-1 do begin
        oData = oPSet[i]

        status = oData->Getmetadata('sampTypeFlag',sTypeFlag)
        if (sTypeFlag ne 1) then continue  ; only proceed if dataset was originally read in as Single Crystal

        oZ = oData->Getbyname('Counts')
        if (~Obj_valid(oZ)) then Return
        oErr = oData->Getbyname('Error')
        if (~Obj_valid(oErr)) then Return
        if (~oZ->Getmetadata('OriginalCounts',counts)) then Return
        error = counts
        index = Where(error le 0.0,cnt)
        if (cnt gt 0) then error[index] = 1.0
        error = Sqrt(error)

        status = oZ->Getmetadata('MON',mon)
        status = oZ->Getmetadata('TIME',time)

        ;; Perform bkgd subtraction if appropriate
        status = oData->Getmetadata('DATAPTRREF',dataPtr)
        dataStr = *dataPtr
        bkgdSubVarTag = Strupcase(Self.bkgdsubvars[bkgdSubVarFlag])
        tagNames = Tag_names(dataStr)
        if (bkgdSubVarTag eq 'HKL') then begin
          ; replace 'HKL' with 'H','K' and 'L'
          varHIndex = Where(tagNames eq 'H', HtagFound4Samp)
          varKIndex = Where(tagNames eq 'K', KtagFound4Samp)
          varLIndex = Where(tagNames eq 'L', LtagFound4Samp)
          tagFound4Samp = HtagFound4Samp && KtagFound4Samp && LtagFound4Samp
          if (tagFound4Samp) then begin
            bkgdSubVarValH = Mean((*dataStr.(varHIndex)))
            bkgdSubVarValK = Mean((*dataStr.(varKIndex)))
            bkgdSubVarValL = Mean((*dataStr.(varLIndex)))
          end
        endif else begin
          varIndex = Where(tagNames eq bkgdSubVarTag, tagFound4Samp)
          if (tagFound4Samp) then bkgdSubVarVal = Mean((*dataStr.(varIndex)))
        endelse

        oData->Getproperty, type=type
        if (Strcmp(type,'samp') && bkgdFlag && (nBkgd gt 0)) then begin
          status = oZ->Getmetadata('INDEP_VAR_TAG',sampIndepVarTag)
          status = oZ->Getmetadata('INDEP_VAR_VAL',sampIndepVarVal)
          tolB = 0.005
          bkgdCntBuf = counts*0.0
          bkgdMonBuf = bkgdCntBuf
          bkgdSub = 0
          for j = 0, nBkgd-1 do begin
            oPsetB = bkgdContRef->Get(position=j)
            if (~Obj_valid(oPsetB)) then continue
            ;             status = oPsetB->GetMetaData('sampTypeFlag',sTypeFlagB)
            ;             if (sTypeFlagB ne 1) then continue  ; only proceed if dataset was originally read in as single crystal

            ; retrieve the bkgdSubVarVal for bkgd dataset and compare with
            ; same quantity for signal dataset
            if (tagFound4Samp) then begin
              status = oPsetB->Getmetadata('DATAPTRREF',dataPtr)
              dataStr = *dataPtr
              if (bkgdSubVarTag eq 'HKL') then begin
                bkgdSubVarValBH = Mean((*dataStr.(varHIndex)))
                bkgdSubVarValBK = Mean((*dataStr.(varKIndex)))
                bkgdSubVarValBL = Mean((*dataStr.(varLIndex)))
                HNotSame = Abs(bkgdSubVarValH-bkgdSubVarValBH) gt bkgdSubVarTol
                KNotSame = Abs(bkgdSubVarValK-bkgdSubVarValBK) gt bkgdSubVarTol
                LNotSame = Abs(bkgdSubVarValL-bkgdSubVarValBL) gt bkgdSubVarTol
                ; Is the keyword variable same for singnal and bkgd datasets?
                ; If not then skip to next bkgd dataset
                if (HNotSame || KNotSame || LNotSame) then continue  ; to next bkgd dataset
              endif else begin
                bkgdSubVarValB = Mean((*dataStr.(varIndex)))
                ; Is the keyword variable same for singnal and bkgd datasets?
                ; If not then skip to next bkgd dataset
                if (Abs(bkgdSubVarVal-bkgdSubVarValB) gt bkgdSubVarTol) then continue ; to next bkgd dataset
              endelse
            endif

            oZB = oPsetB->Getbyname('Counts')
            if (~Obj_valid(oZB)) then continue

            status = oZB->Getmetadata('INDEP_VAR_TAG',bkgdIndepVarTag)
            status = oZB->Getmetadata('INDEP_VAR_VAL',bkgdIndepVarVal)
            if (sampIndepVarTag ne bkgdIndepVarTag) then continue

            status = oZB->Getmetadata('MON',monB)
            if (~oZB->Getmetadata('OriginalCounts',countsB)) then continue

            ; now perform subtraction for correspong datapoints in signal and bkgd
            ; datasets that have the same value of the independent variable (scan variable)
            sIndex = []
            bIndex = []
            for k=0, N_elements(bkgdIndepVarVal)-1 do begin
              index = Where(Abs(sampIndepVarVal - bkgdIndepVarVal[k]) lt tolB, found)
              if (found eq 1) then begin
                sIndex = [sIndex,index]
                bIndex = [bIndex,k]
              endif
            endfor
            if (N_elements(sIndex) gt 0) then begin
              ;; accumulate the bkgd counts and corresponding monitor values so that
              ;; we end up with a sum of counts and sum of monitor over all bkgd before doing
              ;; the subtration outside the bkgd loop
              bkgdSub = 1
              bkgdCntBuf[*,sIndex] = bkgdCntBuf[*,sIndex] + countsB[*,bIndex]
              bkgdMonBuf[*,sIndex] = bkgdMonBuf[*,sIndex] + monB[*,bIndex]
            endif
          endfor
          if (bkgdSub) then begin
            index = Where(bkgdMonBuf eq 0.0, zeroMonPresent)
            if (zeroMonPresent gt 0) then bkgdMonBuf[index] = 1.0
            scaleFactB = mon / bkgdMonBuf
            counts = Temporary(counts) - scaleFactB * bkgdCntBuf
            error = Sqrt(Temporary(error)^2 + scaleFactB * bkgdCntBuf)
          endif
        endif

        if (effFlag) then begin
          status = oZ->Getmetadata('CHEFF',chEff)
          counts = Temporary(counts)/chEff
          error = Temporary(error)/Sqrt(chEff)
          ;oChEff = oData->GetByName('ChEff')
          ;if (obj_valid(ochEff)) then begin
          ;   status = oChEff->GetData(chEff)
          ;   counts = temporary(counts)/chEff
          ;   error = temporary(error)/sqrt(chEff)
          ;endif
        endif

        if (fastFlag) then begin   ; perform corrections that depend on first applying fast bkgd correction
          ;; Apply fast Correction
          if (fastVal ne 0.0) then begin
            counts = Temporary(counts) - (time/60.0)*fastVal ; time is measured in secs and fastVal is fast bkgd in cnts/min
          endif

          ;; Apply monitor correction
          if (monCorFlag) then begin
            ;; Constraints are:
            ;; 1 - PG monochromator is in use (d spacing = 3.354)
            ;; 2 - 5 <= Ei <= 34; For Ei < 5, flag an error, for Ei > 34, correction = 1
            ;; CF(Ei) = M0 + M1*Ei + M2*Ei^2 + M3*Ei^3 + M4*Ei^4
            status = oData->Getmetadata('DATAPTRREF',dataPtr)
            if (~Ptr_valid(dataPtr)) then Return
            dspacem = (*dataPtr).dspacem  ; d spacing of monochromator
            diff = Abs(dspacem - 3.354)
            PGMON = diff lt 0.001
            Ei = (*(*dataPtr).ei)
            index = Where(Ei lt 5.0,Eilt5)  ; correction not aloowed if Ei < 5.0 meV
            if (Eilt5) then begin
              msg = ['Ei is lower than 5.0 meV.','Monitor correction was not applied']
              title = 'Monitor Correction'
              Self->Errormessage,msg,title=title,severity=0
            endif else if (PGMON) then begin
              M0 =  6.1230
              M1 = -5.9630e-1
              M2 =  2.6244e-2
              M3 = -4.8430e-4
              M4 =  2.8810e-6
              index = Where(Ei gt 34.0,Eigt34)
              CFEi = M0 + M1*Ei + M2*Ei^2 + M3*Ei^3 + M4*Ei^4
              if (Eigt34) then CFEi[index] = 1.0  ; for Ei > 34, CF = 1
              counts = Temporary(counts)*CFEi
              error  = Temporary(error)*CFEi
            endif
          endif

          ;      if (resCorFlag) then begin
          ;         ; apply resolution correction
          ;      endif
          ;
          ;      if (detBalFlag) rhen begin
          ;         ; apply detailed balance correction
          ;      endif
        endif

        ;; Apply monitor normalization
        case normTo of

          0: begin
            monScale = monScaleVal/mon
          end

          1: begin
            monScale = monScaleVal/time
          end

          else: monScale = monScaleVal
        endcase
        counts = Temporary(counts)*monScale
        error = Temporary(error)*monscale

        ;; Mask bad channels
        Self->Getproperty, maskFlag=maskFlag
        sBadChans = Self.maskeddets
        maskedChansExist = ~Strcmp(sBadChans,'')
        if (maskFlag && maskedChansExist) then begin
          status = Compactstring2intvector(sBadChans, badChans)
          badChanIndex = badChans - 1   ; convert channel nos to 0-based channel index
          ; Apply mask by simple replacing the counts in the masked channels by NaNs
          ; Leave error variable untouched
          counts[badChanIndex,*] = !values.f_nan
        endif

        maxVal = Max(counts, min=minVal,/NAN)
        maxVals = [maxVals,maxVal]
        minVals = [minVals,minVal]

        ; Save copy of counts in linearCount metadata
        oZ->Addmetadata, 'linearCounts',counts

        ; take a log of the data if necessary
        if (logFlag) then begin
          index = Where(counts le 0.0, nBad)
          if (nBad gt 0) then counts[index] = !values.f_nan
          counts = Alog10(Temporary(counts))
        endif

        status = oZ->Setdata(counts,/no_copy);,/no_notify)
        status = oErr->Setdata(error,/no_copy,/no_notify)
      endfor

      ; If max and min intensity properties are undefined,
      ; use the current max and min values to define them
      if ((Self.minintensity eq 0.0) && (Self.maxintensity eq 0.0)) then begin
        ; NB: This should run at most once during a session!

        minVal = Min(minVals)   ; these are linear values!
        maxVal = Max(maxVals)

        ; take a log of the intensity limits if necessary
        case logFlag of
          0:

          1: begin ; log scale is active
            minVal = (minVal gt 0.0)? Alog10(minVal) : 0.0
            maxVal = (maxVal gt 0.0)? Alog10(maxVal) : 0.0
          end

          2: begin ; log scale is active
            minVal = (minVal gt 0.0)? Alog(minVal) : 0.0
            maxVal = (maxVal gt 0.0)? Alog(maxVal) : 0.0
          end

          3: begin ; log scale is active
            minVal = (minVal gt 0.0)? Alog2(minVal) : 0.0
            maxVal = (maxVal gt 0.0)? Alog2(maxVal) : 0.0
          end

          else:     ; linear
        endcase

        Self.maxintensity = maxVal
        Self.minintensity = minVal
      endif

    end

    else:
  endcase


end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::UpdateIntensityScale
;+
; PURPOSE:
;   Update the intensity scale - switch between linear/logbase10 scales
;
; PARAMETERS:
;
;
; KEYWORDS:
;-
pro Bt7psdtool::UpdateIntensityScale
  compile_opt idl2

  Self->Getproperty, logFlag=logFlag, sampContRef=oCont, minIntensity=minval, maxIntensity=maxval

  ; must be single crystal sample
  if (Self.samptypeflag ne 1) then Return

  nData = oCont->Count()
  if (nData eq 0) then Return

  oData = oCont->Get(/all)

  case logFlag of
    0: begin ; switch to linear scale
      minVal = 10.0^(minVal)  ; update max and min intensity to the same scale as the intensity
      maxVal = 10.0^(maxVal)
      for i = 0,nData-1 do begin
        oZ = oData[i]->Getbyname('Counts')
        if (~Obj_valid(oZ)) then continue
        if (~oZ->Getmetadata('LinearCounts',counts)) then continue
        status = oZ->Setdata(counts,/no_copy);,/no_notify)
      endfor
    end

    1: begin ; switch to log scale
      minVal = (minVal gt 0.0)? Alog10(minVal) : 0.0 ; update max and min intensity to the same scale as the intensity
      maxVal = (maxVal gt 0.0)? Alog10(maxVal) : 0.0
      for i = 0,nData-1 do begin
        oZ = oData[i]->Getbyname('Counts')
        if (~Obj_valid(oZ)) then continue
        if (~oZ->Getmetadata('LinearCounts',counts)) then begin
          ; probably data from an older session so create the metadata
          status = oZ->Getdata(counts)
          oZ->Addmetadata, 'LinearCounts',counts
        endif

        index = Where(counts le 0.0, nBad)
        if (nBad gt 0) then counts[index] = !values.f_nan
        counts = Alog10(Temporary(counts))
        status = oZ->Setdata(counts,/no_copy);,/no_notify)
      endfor

    end

    2: begin ; switch to log scale
      minVal = (minVal gt 0.0)? Alog(minVal) : 0.0 ; update max and min intensity to the same scale as the intensity
      maxVal = (maxVal gt 0.0)? Alog(maxVal) : 0.0
      for i = 0,nData-1 do begin
        oZ = oData[i]->Getbyname('Counts')
        if (~Obj_valid(oZ)) then continue
        if (~oZ->Getmetadata('LinearCounts',counts)) then begin
          ; probably data from an older session so create the metadata
          status = oZ->Getdata(counts)
          oZ->Addmetadata, 'LinearCounts',counts
        endif

        index = Where(counts le 0.0, nBad)
        if (nBad gt 0) then counts[index] = !values.f_nan
        counts = Alog(Temporary(counts))
        status = oZ->Setdata(counts,/no_copy);,/no_notify)
      endfor

    end

    3: begin ; switch to log scale
      minVal = (minVal gt 0.0)? Alog2(minVal) : 0.0 ; update max and min intensity to the same scale as the intensity
      maxVal = (maxVal gt 0.0)? Alog2(maxVal) : 0.0
      for i = 0,nData-1 do begin
        oZ = oData[i]->Getbyname('Counts')
        if (~Obj_valid(oZ)) then continue
        if (~oZ->Getmetadata('LinearCounts',counts)) then begin
          ; probably data from an older session so create the metadata
          status = oZ->Getdata(counts)
          oZ->Addmetadata, 'LinearCounts',counts
        endif

        index = Where(counts le 0.0, nBad)
        if (nBad gt 0) then counts[index] = !values.f_nan
        counts = Alog2(Temporary(counts))
        status = oZ->Setdata(counts,/no_copy);,/no_notify)
      endfor

    end

    else:
  endcase
  Self->Setproperty, minIntensity=minVal, maxIntensity=maxVal

  ; Update the intensity range
  Self->Updateplotintensityrange

end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::UpdatePlotIntensityRange
;+
; PURPOSE:
;   Update the max and min intensity of the existing plot
;
; PARAMETERS:
;
;
; KEYWORDS:
;-
pro Bt7psdtool::UpdatePlotIntensityRange, oVis
  compile_opt idl2

  Self->Getproperty, defaultIntensityFlag=defIntFlag, sampTypeFlag=sampTypeFlag, maxIntensity=maxVal, minIntensity=minVal

  ; must be single crystal sample
  if (Self.samptypeflag ne 1) then Return

  if (Self.defaultintensityflag eq 1) then begin  ;using default intensity range
    Self->Getproperty, selectedIDs=selIDs,nSelectedIDs=nSel
    if (nSel eq 0) then Return   ; exit if no dataset is currently selected
    ; Retrieve intensity of selected data
    intensity = []
    for i=0,nSel - 1 do begin
      oTest = Self->Getbyidentifier(selIDs[i])
      if (~Isa(oTest,'IDLitParameterSet')) then continue
      status = oTest->Getmetadata('sampTypeFlag',sTypeFlag)
      if (sTypeFlag ne 1) then continue
      oZ = oTest->Getbyname('Counts')
      status = oZ->Getdata(counts)
      intensity = [intensity,Reform(counts,N_elements(counts))]
    endfor
    if (~Isa(intensity)) then Return
    maxVal = Max(intensity,min=minVal,/NAN)
  endif else begin
    maxVal = Self.maxintensity
    minVal = Self.minintensity
  endelse

  if (maxVal eq minVal) then Return

  if (maxVal lt minVal) then begin
    tempVal = maxVal
    maxVal = minVal
    minVal = tempVal
  endif

  if (Obj_valid(oVis) && Isa(oVis,'IDLitVisualization')) then begin
    oVis->Setproperty, min_value=minVal, max_value=maxVal
  endif else begin
    if (Self->Hasvisualizations()) then begin
      oWin = Self->Getcurrentwindow()
      oView = oWin->Getcurrentview()
      oLayer = oView->Getcurrentlayer()
      oWorld = oLayer->Getworld()
      oDataSpace = oWorld->Getdataspaces()
      oVis = oDataSpace->Getvisualizations(count = nVis)

      for i=0, nVis-1 do oVis[i]->Setproperty, min_value=minVal, max_value=maxVal
    endif
  endelse
end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::UpdateIndependentVariables
;+
; PURPOSE:
;   Update the Qx and Qy variables due to changes in the lattice parameter
;
; PARAMETERS:
;   oPSet [in|out] - object whose data is to be updated
;
; KEYWORDS:
;-
pro Bt7psdtool::UpdateIndependentVariables, oPSet, updateObservers=updateObservers
  compile_opt idl2

  void = oPSet->Getmetadata('DATAPTRREF',dataPtr)
  if (~Ptr_valid(dataPtr)) then Return
  dataStr = *dataPtr
  Self->Getproperty, LATPARAMFLAG=lpFlag, LATTICEPARAMETERS=latParam_str, indepVar1List=varList, sampTypeFlag=sampTypeFlag

  case (sampTypeFlag) of
    0: begin ; Powder sample

    end

    1: begin ; Single Crystal sample
      lpLen = Strlen(Strtrim(latParam_str))
      if (lpFlag) then begin             ; 0 = from data, 1 = user specified
        ; if using user specified lat params
        toks = Strsplit(latParam_str,/extract,count=nToks)
        if (nToks eq 6) then latParam = Float(toks)
      endif
      if ((lpFlag eq 0) || (N_elements(latParam) eq 0)) then begin
        ; if lat params is undefined or not using user specified lat params
        ; use the dataset's lattice parameters
        latParam = (*dataStr.lattice_ptr)
        if (lpLen eq 0) then begin
          ; if the Tool's lattice Parameter property is blank, initialize it with the current dataset's
          latParam_str = Strjoin(Strtrim(String(Float(latParam)),2),' ',/single)
          Self->Setproperty, latticeParameters = latParam_str
          Self->Refreshpropertysheet
        endif
      endif

      basis = Dm_basis_r(latParam)        ; convert lattice paramters to basis vectors in rec. space for crystal

      orient = (*dataStr.orientation_ptr) ; retrieve crystal orientation vectors u,v in rec. space coordinates
      ; These are defined in terms of the rec. space basis vectors

      a_star = basis[*,0]                 ; the three basis vectors a*, b*, c* in reciprocal space
      b_star = basis[*,1]
      c_star = basis[*,2]

      orient_u = orient[0:2]              ; the crystal orientation vectors specified in multiples of a*, b* and c*
      orient_v = orient[3:5]

      ; Q(hkl) = h.a_star + k.b_star + l.c_star
      ; Q vector on TAS is measured in a plane such that two of it's components are determine
      ; along u and v. Using (ki,kf,a3 and a4), the manitude of these components can be determined
      ; in units of inverse angstroms. To convert from inverse angstroms to rel. lattice units (hkl)
      ; we need to divide by the magnitude of the basis vectors along u and v.
      uVec = orient_u[0]*a_star + orient_u[1]*b_star + orient_u[2]*c_star ; the orientation vectors in rec space
      vVec = orient_v[0]*a_star + orient_v[1]*b_star + orient_v[2]*c_star
      magn_uVec = Sqrt(Dotp(uVec,uVec))   ; the magnitude of the orientation vectors == HKLnorm(orient_u,latparm=latParam)
      magn_vVec = Sqrt(Dotp(vVec,vVec))

      xAA2RLU = magn_uVec                 ; e.g. ~ 2*pi/a  if u = [1,0,0]
      yAA2RLU = magn_vVec                 ; e.g. ~ 2*pi/c  if v = [0,0,1]

      ; determine appropriate labels to use for qx and qy
      xlabrlu = (orient_u[0] eq 0)? '0' : 'H'
      xlabrlu += (orient_u[1] eq 0)? ',0' : ',K'
      xlabrlu += (orient_u[2] eq 0)? ',0' : ',L'
      ylabrlu = (orient_v[0] eq 0)? '0' : 'H'
      ylabrlu += (orient_v[1] eq 0)? ',0' : ',K'
      ylabrlu += (orient_v[2] eq 0)? ',0' : ',L'

      auv = !RADEG*Acos(Dotp(uVec,vVec)/(magn_uVec*magn_vVec)) ; == getangle2hkl(orient_u,orient_v,latparm=latParam,/degree)
      if (Abs(auv - 90.0) gt 0.01) then begin
        ; In case v is not perpendicular to u, w is obtained so that u & w are orthogonal
        orient_w = orient_v - orient_u/magn_uVec*magn_vVec*Sin((90.-auv)*!dtor)
        qw = Hklnorm(orient_w,latparm=latParam)
        ;orient_w = orient_w/qw*qv

        ; Angle between the two vectors
        ;print,'Orientation vectors and angle'
        ;print,'u: ',uVec
        ;print,'v: ',vVec
        ;print,'angle: ',!RADEG*acos(dotp(uVec,vVec)/(magn_uVec*magn_vVec))
        ;auv = getangle2hkl(orient_u,orient_w,latparm=latParam,/degree)

        xAA2RLU = magn_uVec                 ; e.g. ~ 2*pi/a  if u = [1,0,0]
        yAA2RLU = qw                        ; e.g. ~ 2*pi/c  if v = [0,0,1]
        if (orient_w[0] eq 0 || orient_w[0] eq 1) then begin
          ylabrlu = (orient_w[0] eq 0)? '0' : 'H'
        endif else begin
          ylabrlu = Strtrim(String(orient_w[0],format='(F5.2)'),2)+'H'
        endelse
        if (orient_w[1] eq 0 || orient_w[1] eq 1) then begin
          ylabrlu += (orient_w[1] eq 0)? ',0' : ',K'
        endif else begin
          ylabrlu += ','+Strtrim(String(orient_w[1],format='(F5.2)'),2)+'K'
        endelse
        if (orient_w[2] eq 0 || orient_w[2] eq 1) then begin
          ylabrlu += (orient_w[2] eq 0)? ',0' : ',L'
        endif else begin
          ylabrlu += ','+Strtrim(String(orient_w[2],format='(F5.2)'),2)+'L'
        endelse
      endif

      Self->Getproperty, QUNITS=rlu       ;  rlu = 0 => 1/A, 1 => r.l.u.

      oQX = oPSet->Getbyname(varList[0],count=count)
      if (count ne 1) then Return
      oQY = oPSet->Getbyname(varList[1],count=count)
      if (count ne 1) then Return
      status = oQx->Getmetadata('RLU',unitFlag)    ; unitFlag eq 0 => 1/A, 1 => rlu
      status = oQx->Getmetadata('AA2RLU',oldxAA2RLU)
      status = oQy->Getmetadata('AA2RLU',oldyAA2RLU)

      ; Only need to rescale data if the active units for qx,qy is relative lattice units
      if (rlu eq 1) then begin                     ; rlu is equivalent to unitFlag, just stored at different locations
        ; rescale using updated conversion factor
        status = oQX->Getdata(data)
        data = data*(oldxAA2RLU/xAA2RLU)
        status = oQX->Setdata(data,/no_copy,/no_notify)
        status = oQY->Getdata(data)
        data = data*(oldyAA2RLU/yAA2RLU)
        status = oQY->Setdata(data,/no_copy,/no_notify)
        oQx->Addmetadata,'Long_name',xlabrlu
        oQy->Addmetadata,'Long_name',ylabrlu
      endif

      ; update metadata and the stored conversion factors
      oQx->Addmetadata,'AA2RLU', xAA2RLU
      oQx->Addmetadata,'LABRLU', xlabrlu
      oQy->Addmetadata,'AA2RLU', yAA2RLU
      oQy->Addmetadata,'LABRLU', ylabrlu

    end

    else:
  endcase


  if (Keyword_set(updateObservers)) then begin
    oQX->Notifydatachange
    oQX->Notifydatacomplete
    oQY->Notifydatachange
    oQY->Notifydatacomplete
  endif

end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::UpdateQxQyUnit
;+
; PURPOSE:
;   Update the units for the Qx and Qy variables for all loaded datasets. User can
;   swtich between inverse angstroms and relative lattice units
;
; PARAMETERS:
;
; KEYWORDS:
;-
pro Bt7psdtool::UpdateQxQyUnit
  compile_opt idl2

  ; Get the QX and QY parameters for all loaded datasets
  ; and change the units accordingly
  Self->Getproperty, sampContRef=oCont, indepVar1List=varList, qUnits=newUnitFlag
  nData = oCont->Count()
  if (nData eq 0) then Return

  newUnit = (newUnitFlag eq 0)? '$\AA^{-1}$' : 'r.l.u.'
  oData = oCont->Get(/all)
  for i = 0,nData-1 do begin
    oQX = oData[i]->Getbyname(varList[0],count=count)
    if (count ne 1) then continue
    oQY = oData[i]->Getbyname(varList[1],count=count)
    if (count ne 1) then continue
    status = oQx->Getmetadata('RLU',oldUnitFlag)
    status = oQx->Getmetadata('AA2RLU',xAA2RLU)
    status = oQy->Getmetadata('AA2RLU',yAA2RLU)
    changed = 0
    if (oldUnitFlag eq 0 and newUnitFlag eq 1) then begin
      status = oQX->Getdata(data)
      data = data/xAA2RLU
      status = oQX->Setdata(data,/no_copy,/no_notify)
      status = oQY->Getdata(data)
      data = data/yAA2RLU
      status = oQY->Setdata(data,/no_copy,/no_notify)
      aspect_ratio = yAA2RLU/xAA2RLU
      changed = 1
      status = oQx->Getmetadata('LABRLU',xlab)
      status = oQy->Getmetadata('LABRLU',ylab)
    endif else if (oldUnitFlag eq 1 and newUnitFlag eq 0) then begin
      status = oQX->Getdata(data)
      data = data*xAA2RLU
      status = oQX->Setdata(data,/no_copy,/no_notify)
      status = oQY->Getdata(data)
      data = data*yAA2RLU
      status = oQY->Setdata(data,/no_copy,/no_notify)
      aspect_ratio = 1.0
      changed = 1
      status = oQx->Getmetadata('LABANG',xlab)
      status = oQy->Getmetadata('LABANG',ylab)
    endif
    if (changed) then begin
      oQX->Addmetadata,'UNITS', newUnit
      oQX->Addmetadata,'RLU', newUnitFlag
      oQY->Addmetadata,'UNITS', newUnit
      oQY->Addmetadata,'RLU', newUnitFlag
      oQx->Addmetadata,'Long_name',xlab
      oQy->Addmetadata,'Long_name',ylab
      oQX->Notifydatachange
      oQX->Notifydatacomplete
      oQY->Notifydatachange
      oQY->Notifydatacomplete
    endif
  endfor

  if (changed) then begin
    ; If both x and y are in Q then if the units is in 1/A then the aspect_ratio of the
    ; plot is 1. However when it is r.l.u. then the x and y scales will be different.
    ; In this, reset the aspect ration to be the same as the ratio of the y and x
    ; relative lattice units so that the effective aspect ration comes out to be 1 again.
    ; The aspect_ration value is determined above.
    if (Self->Hasvisualizations()) then begin
      oWin = Self->Getcurrentwindow()
      oView = oWin->Getcurrentview()
      oLayer = oView->Getcurrentlayer()
      oWorld = oLayer->Getworld()
      oDataSpace = oWorld->Getdataspaces()
      if (Obj_valid(oDataSpace)) then begin
        oDataSpace->Setproperty, aspect_ratio = aspect_ratio
      endif
    endif
  endif

end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::Mslice
;+
; PURPOSE:
;   Launch Mslice tool with a copy of the currently selected data for further analysis.
;   If Mslice is already launched, update its data with the currently selected data.
;
; PARAMETERS:
;
; KEYWORDS:
;-
function Bt7psdtool::Mslice
  compile_opt idl2

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      if (Widget_info(wB,/valid)) then Widget_control, wB, /destroy
      Self->Statusmessage, !ERROR_STATE.msg
      Catch, /cancel
      Return, 0
    endif
  endif

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB

  ; display dialog to let user select variables to be exported to Mslice
  Self->Getproperty, daveTool=daveTool $
    , exportIndex1=exportIndex1, exportIndex2=exportIndex2, exportIndex3=exportIndex3  $
    ,indepVar1List=indepVar1List,indepVar2List=indepVar2List,indepVar3List=indepVar3List $
    ,selectedIDs=selIDs,nSelectedIDs=nSel, sampTypeFlag=sampTypeFlag
  if (nSel eq 0) then Return, 0  ; exit if no dataset is currently selected

  case sampTypeFlag of
    0: begin
      exportList = indepVar2List
      exportIndex = exportIndex2
    end; powder
    1: begin
      exportList = indepVar1List
      exportIndex = exportIndex1
    end; single crystal
    2: begin
      exportList = indepVar3List
      exportIndex = exportIndex3
    end; raw
  endcase

  ; construct basic dialog
  title = 'Select Variables to Export'
  wB = Widget_base(/col,title=title,/modal,group_leader=wTLB)
  wB1 = Widget_base(wB,/col,grid=2,/frame,/nonexclusive,scr_xsize=200)
  wB2 = Widget_base(wB,/row,/frame)

  n = N_elements(exportList)
  wButtons = Lindgen(n)
  for i=0,n-1 do begin
    wButtons[i] = Widget_button(wB1,value=exportList[i],uname=exportList[i])
    Widget_control, wButtons[i], set_button=exportIndex[i]
  endfor
  wOK = Widget_button(wB2,value='OK',uname='APPLY',/align_center)
  wCancel = Widget_button(wB2,value='Cancel',uname='CANCEL',/align_center)

  statePtr = Ptr_new({wbuttons:Wbuttons,exportindex:exportIndex,cancel:0})
  Widget_control, wB, /realize, set_uvalue=statePtr

  Xmanager, 'BT7PSDExport2Mslice', wB, event_handler='BT7PSDExport2Mslice_event'

  exportIndex = (*statePtr).exportindex
  cancel = (*statePtr).cancel
  Ptr_free, statePtr

  if (cancel) then Return, 0

  if (sampTypeFlag eq 0) then Self->Setproperty, exportIndex2=exportIndex
  if (sampTypeFlag eq 1) then Self->Setproperty, exportIndex1=exportIndex
  if (sampTypeFlag eq 2) then Self->Setproperty, exportIndex3=exportIndex

  index = Where(exportIndex eq 1,nVar)
  if (nVar lt 2) then Return, 0

  exportList = exportList[index]

  ; Init Counts and Error
  z = []
  Err = []
  label = ['Intensity','Error']
  unit = ['','']
  unique = [0,0]

  oData = []

  case sampTypeFlag of
    0: begin
      for i=0,nSel - 1 do begin
        oTest = Self->Getbyidentifier(selIDs[i])
        if (~Isa(oTest,'IDLitParameterSet')) then continue
        status = oTest->Getmetadata('sampTypeFlag',sTypeFlag) ; must be powder data
        if (sTypeFlag ne 0) then continue
        oZ = oTest->Getbyname('Counts')
        status = oZ->Getmetadata('ProcessedCounts',counts)
        status = oZ->Getmetadata('ProcessedErrors',error)
        Z = [Z,Reform(counts,N_elements(counts))]
        Err = [Err,Reform(error,N_elements(error))]
        oData = [oData,oTest]
      endfor
      nSel = N_elements(oData)
      npts = N_elements(Z)
      if (npts eq 0) then Return, 0
      data = Fltarr(npts,2+nVar)
      data[*,0] = Z
      data[*,1] = Err
      binWidths = Fltarr(2) + 0.1
      ; Get the independent vars
      for i=0,nVar-1 do begin
        varName = exportList[i]
        varData = []
        for j=0,nSel-1 do begin
          oVar = oData[j]->Getbyname(varName)
          if (~Obj_valid(oVar)) then continue
          if (j eq 0) then begin
            status = oVar->Getmetadata('Long_name',varLab)
            status = oVar->Getmetadata('Units',varUnit)
            label = [Label,varLab]
            unit = [unit,varUnit]
            unique = Strcmp(varName,'E',/fold_case)? [unique,1] : [unique,0]
            ;unique = [unique,1]
          endif
          oZ = oData[j]->Getbyname('Counts')
          metaName = (Strcmp(varName,'|Q|'))? 'QTOT' : varName
          if (Strcmp(varName,'TEMP',/fold)) then begin
            ; need to treat it specially
            Self->Getproperty, useTempAverageFlag=useTempAverageFlag
            metaName = (useTempAverageFlag)? 'TEMPAVERAGE' : 'TEMP'
          endif
          status = oZ->Getmetadata(metaName,iVarData) ; Get 2D variable values that have not been rebinned!
          npts = N_elements(iVarData)
          iVarData = Reform(Temporary(iVarData),npts)
          varData = [vardata,iVarData]
          if (i eq 0 || i eq 1) then begin
            iVarData = ivardata[Uniq(ivardata, Sort(ivardata))] ; return a copy of the sorted array with duplicate adjacent elements removed
            npts = N_elements(iVarData)
            binWidths[i] = (npts gt 1)? $
              Max(Abs(iVarData[1:npts-1] - iVarData[0:npts-2])) : $ ; use the max bin width
              1.0
            if (binWidths[i] lt 0.1) then binWidths[i] = 1.15*binWidths[i]
          endif
        endfor
        data[*,i+2] = varData
      endfor

    end

    1: begin
      for i=0,nSel - 1 do begin
        oTest = Self->Getbyidentifier(selIDs[i])
        if (~Isa(oTest,'IDLitParameterSet')) then continue
        status = oTest->Getmetadata('sampTypeFlag',sTypeFlag) ; only export single crystal data to Mslice
        if (sTypeFlag ne 1) then continue
        oZ = oTest->Getbyname('Counts')
        if (~oZ->Getmetadata('LinearCounts',counts)) then status = oZ->Getdata(counts)
        Z = [Z,Reform(counts,N_elements(counts))]
        oErr = oTest->Getbyname('Error')
        status = oErr->Getdata(error)
        Err = [Err,Reform(error,N_elements(error))]
        oData = [oData,oTest]
      endfor
      nSel = N_elements(oData)
      npts = N_elements(Z)
      if (npts eq 0) then Return, 0
      data = Fltarr(npts,2+nVar)
      data[*,0] = Z
      data[*,1] = Err
      binWidths = Fltarr(2) + 0.1
      ; Get the independent vars
      for i=0,nVar-1 do begin
        varName = exportList[i]
        varData = []
        for j=0,nSel-1 do begin
          oVar = oData[j]->Getbyname(varName)
          if (~Obj_valid(oVar)) then continue
          if (j eq 0) then begin
            status = oVar->Getmetadata('Long_name',varLab)
            status = oVar->Getmetadata('Units',varUnit)
            label = [Label,varLab]
            unit = [unit,varUnit]
            unique = Strcmp(varName,'E',/fold_case)? [unique,1] : [unique,0]
            ;unique = [unique,1]
          endif
          status = oVar->Getdata(iVarData)
          npts = N_elements(iVarData)
          iVarData = Reform(Temporary(iVarData),npts)
          varData = [vardata,iVarData]
          if (i eq 0 || i eq 1) then begin
            iVarData = ivardata[Uniq(ivardata, Sort(ivardata))] ; return a copy of the sorted array with duplicate adjacent elements removed
            npts = N_elements(iVarData)
            binWidths[i] = (npts gt 1)? $
              Max(Abs(iVarData[1:npts-1] - iVarData[0:npts-2])) : $ ; use the max bin width
              1.0
            if (binWidths[i] lt 0.1) then binWidths[i] = 1.15*binWidths[i]
          endif
        endfor
        data[*,i+2] = varData
      endfor
    end

    2: begin
    end

    else:
  ENDCASE

  ;; discriminate for any masked data
  ;void = where(finite(data),complement=mskIndex,ncomplement=nMsk)
  ;if (nMsk gt 0) then data[mskIndex] = -1.0e20


  ; Determine the top-level base widget ID for the main DAVE window
  ; and use this as the group_leader when Mslice is called. This way the Mslice instance will
  ; be killed automatically only when DAVE goes down rather than if the BT7 reduction module is killed.
  oUIMain = daveTool->Getui()
  oUIMain->Getproperty, group_leader = wTLBMain


  if (Obj_valid(Self.objmslice) && (Self.multiplemslicewinflag eq 0)) then begin
    Self.objmslice->Reset_data, data=data, label=Tex2idl(label), instrument='BT7' $
      ,is_uniq=unique, unit=Tex2idl(unit), /no_copy
    ; initialize the stepsize params in the Mslice UI to values commensurate with the data
    names = ['dispxstep','dispystep','cutstep']
    values = [binWidths[0],binWidths[1],binWidths[0]]
    ;values = [!values.F_NAN,!values.F_NAN,!values.F_NAN]
    Self.objmslice->Script,'set_parameter',name=names,value=values
  endif else begin
    dataPtr = Ptr_new({data:Temporary(data),label:Tex2idl(label),unit:Tex2idl(unit),instrument:'BT7',is_uniq:unique},/no_copy)
    Self->Getproperty, DAVETOOL=daveTool, DATA_DIRECTORY=dataDir, working_directory=workDir
    Dcs_mslice, dataPtr=dataPtr, obj_mslice=objMslice, group_leader=wTLBMain $
      ,DAVETool=daveTool, workDir=workDir, dataDir=dataDir, /no_parmfile
    Self.objmslice = objMslice

    ; initialize the stepsize params in the Mslice UI to values commensurate with the data
    names = ['dispxstep','dispystep','cutstep']
    values = [binWidths[0],binWidths[1],binWidths[0]]
    ;values = [!values.F_NAN,!values.F_NAN,!values.F_NAN]
    objMslice->Script,'set_parameter',name=names,value=values
  endelse

  Return, 0
end
;-------------------------------------------------------------------------------


;===============================================================================
pro Bt7psdexport2mslice_event, Event
  compile_opt idl2
  uname = Widget_info(Event.id,/uname)
  Widget_control, Event.top, get_uvalue=statePtr

  case uname of
    'APPLY': begin
      exportIndex = Widget_info((*statePtr).wbuttons,/button_set)
      (*statePtr).exportindex = exportIndex
      Widget_control, Event.top, /destroy
    end

    'CANCEL': begin
      (*statePtr).cancel = 1
      Widget_control, Event.top, /destroy
    end

    else:

  endcase
  if (Strcmp(uname,'APPLY')) then begin
  endif

end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::restoreDataVersion
;
; PURPOSE:
;   Restore the specified object to the latest version
;
; PARAMETERS:
;   oData [in|out] - object to be restored to the latest version
;
; KEYWORDS:
;
pro Bt7psdtool::restoreDataVersion, oData
  compile_opt idl2

  ; restore to latest IDLitData version
  oData->Restore

  ; Pull the data pointer structure and ensure it is up to data
  currentVersion = Self.dataversion

  void = oData->Getmetadata('DATAPTRREF',tempPtr)
  oldDataVersion = (*tempPtr).dataversion

  if (currentVersion gt oldDataVersion) then begin
    ; Update the data as necessary
  endif

end


;===============================================================================
; Bt7psdTool::readNiceHDF
;
; PURPOSE:
;   Read the contents of an HDF NICE dataset
;
; PARAMETERS:
;   file [in] - filename to be read.
;
;   dataPtr [out] - data structure to read file contents into
;
; KEYWORDS:
;
function Bt7psdtool::readNiceHDF, filename, dataPtr, fromFTP=fromFTP, entryIndex=entryIndex
compile_opt idl2

oUI = Self->Getui()
oUI->Getproperty, group_leader = wTLB

; Basic error Handler
if (N_elements(!debug) && (!debug eq 0)) then begin
  Catch, catchError
  if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'Bt7psdTool::readNiceHDF: Error encountered'
    eMsg = 'An error or unusual condition was encountered!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
    Catch, /cancel
    if (Ptr_valid(dataPtr)) then Heap_free, dataPtr
    if (N_elements(lun) gt 0) then Free_lun, lun, /force
    Return, 0
  endif
endif

; check parameter count
if (N_params() ne 2) then Return, 0

; check file parameter is defined
if (N_elements(filename) le 0) then Return, 0

fromFtp = (Stregex(filename,'/pub/ncnrdata/',/fold,/bool))? 1 : 0
if (~fromFTP && ~File_test(filename)) then Return, 0

if (Keyword_set(fromFTP)) then Self->Getproperty, ftpObject=oFTP

; Read raw file contents
if (fromFTP) then begin
  ; if fromFTP, get contents of remote file and save in a local file on disk
  if (~Obj_valid(oFTP)) then begin
    errmsg = 'The FTP service object is invalid. Cannot proceed'
    void = dialog_message([filename,' ',errmsg],/error)
    Return, 0
  endif
  ; retrieve the file contents from ftp server and save in temporal local file
  tmpFile = !home_dir+'BT7TmpDatasetFromFTP.dat'
  filename=oFTP->Getfilecontent(filename,localfilename=tmpFile)
  if (~File_test(filename,/read)) then begin
    errmsg = 'Unable to create local file '+tmpFile
    void = Dialog_message([Self.filename,' ',errmsg],/error)
    Return, 0  ; if local file was not created then bail
  endif
endif else begin
  if ~File_test(filename) then begin
    errmsg = 'File '+filename+' not found'
    void = Dialog_message([filename,' ',errmsg],/error)
    Return,0B
  endif
endelse

; Exit if not an hdf format dataset
if (~H5f_is_hdf5(filename)) then Return, 0

; file handle must be a long integer and must be set before calling Nxopen()
handle=0L
hdlerror=0

; Open the hdf file
; The file handle will subsequently be used just like a file unit
status = Nxopen(filename,'NXACC_READ',handle)
if (~status) then begin
  errmsg = 'Could not open nexus file: '+filename
  void = Dialog_message([filename,' ',errmsg],/error)
  Return, 0
endif

; Determine the name of the main group/entry to be read from the file
; Required because groups are opened by name
nEntry = H5g_get_nmembers(handle.ivid, '/')
if (nEntry lt 1) then begin
  errmsg = filename + " contains no entries"
  void = Dialog_message([filename,' ',errmsg],/error)
  Return, 0
endif
group_name = '/'
if (N_elements(entryIndex) eq 0) then entryIndex = 0    ; if not specified, read the first entry in the file by default
entryName = H5g_get_member_name(handle.ivid, group_name, entryIndex)
if (nEntry gt 1) then begin
  ; this file contains more than 1 top-level entries
  ; so modify the display name, which is normally the filename, to include the entry index
  ;Self.display_name = File_basename(filename)+'_'+Strtrim(String(entryIndex),2)
  display_name = File_basename(filename)+'-'+Strtrim(String(entryIndex),2)
endif

; Can't proceed if the PSD is NOT the primary/detector of interest
status = Davenxopengetclosedata(handle,"/"+entryName+"/DAS_logs/counter/primaryDetector",data=primaryDetector)
if (~primaryDetector.Matches('psDetector')) then begin
  errmsg = "PSD Detector was not the detector of interest for this dataset"
  void = Dialog_message([filename,' ',errmsg],/error)
  Return, 0  
endif

; Basic data structure to contain relevant data from the dataset
if (Ptr_valid(dataPtr)) then Heap_free, dataPtr
dataPtr =  { filename:''        $
  ,entryIndex:0                 $
  ,data_ptr:Ptr_new()           $
  ,dataversion:0                $
  ,indep_var_tag:''             $
  ,indep_var_val:Ptr_new()      $
  ;            ,scan:''                      $
  ;            ,prf:0L                       $
  ;            ,tot_mon:0L                   $
  ;            ,num_pts:0                    $
  ;            ,type:''                      $
  ;            ,date:''                      $
  ;            ,time:''                      $
  ;            ,comments:''                  $
  ;            ,header_ptr:ptr_new()        $
  ;            ,headText_ptr:ptr_new()      $
  ;            ,dattaText_ptr:ptr_new()      $
  ;            ,fit_ptr:ptr_new()           $
  ;            ,descriptr:ptr_new()         $
  ,monave:0L                       $
  ;            ,signal_type:''               $
  ;            ,ytitle:''                    $
  ;            ,magfield:0D                    $
  ;            ,shift_value:0D               $
  ;            ,plot_ptr:ptr_new()           $
  ;            ,mcf_ptr:ptr_new()            $
  ;            ,collim_ptr:ptr_new()         $
  ;            ,econfig_ptr:ptr_new()        $
  ;            ,qconfig_ptr:ptr_new()        $
  ;            ,mosaic_ptr:ptr_new()         $
  ;            ,instrument_ptr:ptr_new()     $
  ;            ,motors_ptr:ptr_new()         $
  ,lattice_ptr:Ptr_new()        $
  ;            ,xtal_orientation_ptr:ptr_new()  $
  ;            ,second_var_name:''           $
  ;            ,treatment_ptr:ptr_new()      $
  ,orientation_ptr:Ptr_new() $
  ,fixedetype:'' $
  ,fixedevalue:0.0 $
  ,dspacem:0.0 $
  ,dspacea:0.0 $
  ;            ,isICE:0B $       ; is data from an ICE formated file? 0=>no, 1=>yes
  ,anapkgptr:Ptr_new() $ ; info about BT7 analyzer package
  ;            ,oFTP:obj_new() $
  ;            ,sdesc:'' $
  ,psddets:Ptr_new() $
  ,tddets:Ptr_new() $
  ,dddets:Ptr_new() $
  ,sddets:Ptr_new() $
  ;            ,angles:ptr_new() $
  ,a1:Ptr_new() $
  ,a2:Ptr_new() $
  ,a3:Ptr_new() $
  ,a4:Ptr_new() $
  ,a5:Ptr_new() $
  ,a6:Ptr_new() $
  ,e:Ptr_new() $
  ,ei:Ptr_new() $
  ,ef:Ptr_new() $
  ,h:Ptr_new() $
  ,k:Ptr_new() $
  ,l:Ptr_new() $
  ,mon:Ptr_new() $
  ,time:Ptr_new() $
  ,temp:Ptr_new() $
  ,magfield:Ptr_new() $
}

dataPtr.filename = filename
dataPtr.entryindex = entryIndex
dataPtr.dataversion = Self.dataversion


; Sample information:
;--------------------
grpName = "/"+entryName+"/DAS_logs/sampleState"
status = Nxopengroup(handle,grpName,'NXcollection')

; Lattice params
status = Davenxopengetclosedata(handle,'A',data=sampA)
status = Davenxopengetclosedata(handle,'B',data=sampB)
status = Davenxopengetclosedata(handle,'C',data=sampC)
status = Davenxopengetclosedata(handle,'Alpha',data=sampAlpha)
status = Davenxopengetclosedata(handle,'Beta',data=sampBeta)
status = Davenxopengetclosedata(handle,'Gamma',data=sampGamma)
latparms = [sampA[0],sampB[0],sampC[0],sampAlpha[0],sampBeta[0],sampGamma[0]]
;(*Self.lattice_ptr) = latparms
dataPtr.lattice_ptr = ptr_new(latparms) 

; Orientation vectors
status = Davenxopengetclosedata(handle,'refPlane1',data=refPlane1)
status = Davenxopengetclosedata(handle,'refPlane2',data=refPlane2)
status = Davenxopengetclosedata(handle,'UQuaternion',data=sampOrientQuaternion)
;(*Self.orientation_ptr) = [refplane1[*,0],refPlane2[*,0]]
dataPtr.orientation_ptr = ptr_new([refplane1[*,0],refPlane2[*,0]])

status = Davenxopengetclosedata(handle,'a3Zero',data=a3Zero)
status = Davenxopengetclosedata(handle,'chiZero',data=chiZero)
status = Davenxopengetclosedata(handle,'crystalSystem',data=crystalSystem)

status = Nxclosegroup(handle)

; Monochromator
dataItemToRead = "/"+entryName+"/DAS_logs/ei/energy"
status = Davenxopengetclosedata(handle,dataItemToRead,data=Ei)
dataItemToRead = "/"+entryName+"/DAS_logs/ei/dSpacing"
status = Davenxopengetclosedata(handle,dataItemToRead,data=dspaceM)
;self.dspacem = dspaceM

; Analyzer
dataItemToRead = "/"+entryName+"/DAS_logs/ef/energy"
status = Davenxopengetclosedata(handle,dataItemToRead,data=Ef)
dataItemToRead = "/"+entryName+"/DAS_logs/ef/dSpacing"
status = Davenxopengetclosedata(handle,dataItemToRead,data=dspaceA)
;self.dspacea = dspaceA

; fixed energy mode
dataItemToRead = "/"+entryName+"/DAS_logs/et/fixedEnergyMode"
status = Davenxopengetclosedata(handle,dataItemToRead,data=fixedEType)
;self.fixedetype = fixedEType[0]
fixedEValue = Strcmp(fixedEType[0],'Ef',/fold)? Ef[0] : Ei[0]
;self.fixedevalue = fixedEValue

; fixed energy mode
dataItemToRead = "/"+entryName+"/DAS_logs/et/deltaE"
status = Davenxopengetclosedata(handle,dataItemToRead,data=et)

dataPtr.dspacea = dspaceA
dataPtr.dspacem = dspaceM
dataPtr.fixedetype = fixedEType[0]
dataPtr.fixedevalue = fixedEValue
dataPtr.e = ptr_new(et)
dataPtr.ei = ptr_new(Ei)
dataPtr.ef = ptr_new(Ef)

; primary angles 
status = Davenxopengetclosedata(handle,"/"+entryName+"/DAS_logs/monoTheta/theta",data=A1)
status = Davenxopengetclosedata(handle,"/"+entryName+"/DAS_logs/monoTwoTheta/softPosition",data=A2)
status = Davenxopengetclosedata(handle,"/"+entryName+"/DAS_logs/sampleTheta/softPosition",data=A3)
status = Davenxopengetclosedata(handle,"/"+entryName+"/DAS_logs/sampleTwoTheta/softPosition",data=A4)
status = Davenxopengetclosedata(handle,"/"+entryName+"/DAS_logs/anaTheta/theta",data=A5)
status = Davenxopengetclosedata(handle,"/"+entryName+"/DAS_logs/anaTwoTheta/twoTheta",data=A6)
status = Davenxopengetclosedata(handle,"/"+entryName+"/DAS_logs/Q/H",data=qx)
status = Davenxopengetclosedata(handle,"/"+entryName+"/DAS_logs/Q/K",data=qy)
status = Davenxopengetclosedata(handle,"/"+entryName+"/DAS_logs/Q/L",data=qz)
dataPtr.a1 = ptr_new(A1)
dataPtr.a2 = Ptr_new(A2)
dataPtr.a3 = Ptr_new(A3)
dataPtr.a4 = Ptr_new(A4)
dataPtr.a5 = Ptr_new(A5)
dataPtr.a6 = Ptr_new(A6)
dataPtr.h  = Ptr_new(qx)
dataPtr.k  = Ptr_new(qy)
dataPtr.l  = Ptr_new(qz)

; monitor data
status = Davenxopengetclosedata(handle,"/"+entryName+"/DAS_logs/counter/liveMonitor",data=mon)
status = Davenxopengetclosedata(handle,"/"+entryName+"/DAS_logs/counter/liveTime",data=time)
dataPtr.mon  = Ptr_new(mon)
dataPtr.monave = mean(mon)
dataPtr.time = Ptr_new(time)

; temperature and magField
itemName = "/"+entryName+"/DAS_logs/sampleState/temp"
if (Davenxitemexistatcurloc(handle,itemName)) then begin
  status = Davenxopengetclosedata(handle,itemName,data=temp)
  dataPtr.temp = Ptr_new(temp)
endif
itemName = "/"+entryName+"/DAS_logs/sampleState/magField"
if (Davenxitemexistatcurloc(handle,itemName)) then begin
  status = Davenxopengetclosedata(handle,itemName,data=magField)
  dataPtr.magfield = Ptr_new(magField)
endif else begin
  dataPtr.magfield = Ptr_new(Fltarr(n_elements(A1)))
endelse


; PSD Detector counts
status = Davenxopengetclosedata(handle,"/"+entryName+"/DAS_logs/psDetector/counts",data=psdData)
dataPtr.psddets = Ptr_new(psdData)
anaPSDDets =  'PSD'+Strtrim(String(Indgen(48)),2)
anaSigDets = anaPSDDets

; Remaining detectors
itemName = "/"+entryName+"/DAS_logs/singleDetector"
anaSDDets = ''
if (Davenxitemexistatcurloc(handle,itemName)) then begin
  status = Davenxopengetclosedata(handle,itemName+"/counts",data=counts)
  dataPtr.sddets = ptr_new(counts)
  anaSDDets =  'SD'+Strtrim(String(Indgen(3)),2)
endif

itemName = "/"+entryName+"/DAS_logs/diffDetector"
anaDDDets = ''
if (Davenxitemexistatcurloc(handle,itemName)) then begin
  status = Davenxopengetclosedata(handle,itemName+"/counts",data=counts)
  dataPtr.dddets = ptr_new(counts)
  anaDDDets =  'DD'+Strtrim(String(Indgen(3)),2)
endif

itemName = "/"+entryName+"/DAS_logs/doorDetector"
anaTDDets = ''
if (Davenxitemexistatcurloc(handle,itemName)) then begin
  status = Davenxopengetclosedata(handle,itemName+"/counts",data=counts)
  dataPtr.tddets = ptr_new(counts)
  anaTDDets =  'DoorD'+Strtrim(String(Indgen(11)),2)
endif

; the independent or scan variable and its value
itemName = "/"+entryName+"/DAS_logs/trajectory/defaultXAxisPlotNode"
status = Davenxopengetclosedata(handle,itemName,data=scanVarName)
dataItemToRead = scanVarName.Replace('.','/')                     ; replace any . seperator in name with a /
dataItemToRead = "/"+entryName+"/DAS_logs"+"/"+dataItemToRead     ; all devices are located under DAS_logs group
if (Davenxitemexistatcurloc(handle,dataItemToRead)) then begin
  status = Davenxopengetclosedata(handle,dataItemToRead,data=scanValue)
  dataPtr.indep_var_tag = scanVarName
  dataPtr.indep_var_val = ptr_new(scanValue)
endif

; Analyzer-Detector mode name
status = Davenxopengetclosedata(handle,"/"+entryName+"/DAS_logs/analyzerMode/mode",data=anaModeName)         ; read the analyzerMode

; Done with the hdf file so close it
status = Nxclose(handle)          ; Nexus/hdf file

; if necessary, delete tmpfile that was created above
if (fromFTP && File_test(tmpFile)) then File_delete, tmpFile

; Mapping scheme for Analyzer-Detector modes between ICE and NICE datasets
;ICE Mode      ICE Mode Names                 NICE modes                     Description
;1             DiffDet                        DD_2AXIS
;2             SDFlat                         SD_3AXIS_FLAT
;3             SDHF (Hor Foc)                 SD_3AXIS_ENERGY
;4             PSDDiff                        PSD_2AXIS                      ;<--  2-AXIS analyzer mode
;5             PSDFlat                        PSD_3AXIS_FLAT                 ;<--  Flat analyzer mode
;6             PSDFixedEf                     PSD_3AXIS_CONSTANT_EF          ;<--  Fixed Ef analyzer mode
;7             Undefined                      SD_2AXIS
;8             PSDSeeThrough                  PSD_3AXIS_ENERGY               ;<--  See Through analyzer mode
NICE_anaModeNames = ['DD_2AXIS', $
  'SD_3AXIS_FLAT', $
  'SD_3AXIS_ENERGY', $
  'PSD_2AXIS', $
  'PSD_3AXIS_FLAT', $
  'PSD_3AXIS_CONSTANT_EF', $
  'SD_2AXIS', $
  'PSD_3AXIS_ENERGY' $
  ]
anaMode = Where(NICE_anaModeNames eq anaModeName)

;; record analyzer info in a structure
anaPkgStr = {mode:anaMode $
  ,signaldets:anaSigDets $
  ,sigdetsinsum:Strjoin(anaSigDets,';',/single) $
,tddetsinsum:Strjoin(anaTDDets,';',/single) $
,sddets:anaSDDets $
  ,dddets:anaDDDets $
  ,tddets:anaTDDets $
  ,psddets:anaPSDDets $
}
dataPtr.anapkgptr = Ptr_new(anaPkgStr)

dataPtr = Ptr_new(dataPtr,/no_copy)       ; convert struct to a heap var

return, 1
end


;===============================================================================
; Bt7psdTool::readData
;
; PURPOSE:
;   Read the contents of a .bt4 file
;
; PARAMETERS:
;   file [in] - filename to be read.
;
;   dataPtr [out] - data structure to read file contents into
;
; KEYWORDS:
;
function Bt7psdtool::ReadData, filename, dataPtr, fromFTP=fromFTP
  compile_opt idl2

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      ;;print, 'Error handled!'
      eTitle = 'Bt7psdTool::readData: Error encountered'
      eMsg = 'An error or unusual condition was encountered!'
      eMsg = [eMsg,'Please, report the following to the DAVE team:']
      eMsg = [eMsg,!error_state.msg]
      void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
      Catch, /cancel
      if (Ptr_valid(dataPtr)) then Heap_free, dataPtr
      if (N_elements(lun) gt 0) then Free_lun, lun, /force
      Return, 0
    endif
  endif


  ; check parameter count
  if (N_params() ne 2) then Return, 0

  ; check file parameter is defined
  if (N_elements(filename) le 0) then Return, 0

  fromFtp = (Stregex(filename,'/pub/ncnrdata/',/fold,/bool))? 1 : 0
  if (~fromFTP && ~File_test(filename)) then Return, 0

  if (Keyword_set(fromFTP)) then Self->Getproperty, ftpObject=oFTP

  ; Read raw file contents
  if (fromFTP) then begin
    ; retrieve file contents from ftp server and store into dstring array
    dstring = oFtp->Getfilecontent(filename,/string)
    if (Strcmp(dstring[0],'')) then Return, 0
    nlines = N_elements(dstring)
  endif else begin
    read_ok = Dave_read_filecontents(filename,dstring=dstring,errmsg=errmsg)
    if ~read_ok then begin
      void = Dialog_message(errmsg)
      Return, 0
    endif
  endelse
  
  ; Parse the file contents
  ; Support for ICE file format
  ; Support for NICE file format
  parse_ok = 0
  errmsg = "Unsupported file format"
  ice_file = 0
  nice_file = 0
  if (Is_ice(filename,errmsg = errmsg,oFTP=oFtp)) then begin
    ice_file = 1
    parse_ok = Dave_parse_ice(dstring,dstruct,header=header $
      ,dattaText=dattaText, headText=headText $
      ,indep_var_pos=indep_var_pos $
      ,dep_var_pos=dep_var_pos $
      ,lattice=lattice $
      ,fixedEType=fixedEType $
      ,fixedEValue=fixedEValue $
      ,dSpaceM=dSpaceM $
      ,dSpaceA=dSpaceA $
      ,orientation=orientation $
      ,sdesc=sdesc $
      ,anaPkgStr=anaPkgStr $
      ,errmsg=errmsg $
      ,/PSD_DOI_only $
      )
  endif

  if (Is_nice(filename,errmsg = errmsg,oFTP=oFtp)) then begin
    nice_file = 1
    parse_ok = Dave_parse_nice(dstring,dstruct,header=header $
      ,dattaText=dattaText, headText=headText $
      ,indep_var_pos=indep_var_pos $
      ,dep_var_pos=dep_var_pos $
      ,lattice=lattice $
      ,fixedEType=fixedEType $
      ,fixedEValue=fixedEValue $
      ,dSpaceM=dSpaceM $
      ,dSpaceA=dSpaceA $
      ,orientation=orientation $
      ,sdesc=sdesc $
      ,anaPkgStr=anaPkgStr $
      ,errmsg=errmsg $
      ,/PSD_DOI_only $
      )
  endif

  if (~parse_ok) then begin
    if (Keyword_set(quiet)) then begin
      Print, 'Error reading file: ',filename
      Print, errmsg
    endif else begin
      void = Dialog_message([filename,' ',errmsg],/error)
    endelse
    Return, 0
  endif

  if (Ptr_valid(dataPtr)) then Heap_free, dataPtr
  dataPtr =  { filename:'' $
    ,data_ptr:Ptr_new()           $
    ,dataversion:0                $
    ,indep_var_tag:''             $
    ,indep_var_val:Ptr_new()      $
    ;            ,scan:''                      $
    ;            ,prf:0L                       $
    ;            ,tot_mon:0L                   $
    ;            ,num_pts:0                    $
    ;            ,type:''                      $
    ;            ,date:''                      $
    ;            ,time:''                      $
    ;            ,comments:''                  $
    ;            ,header_ptr:ptr_new()        $
    ;            ,headText_ptr:ptr_new()      $
    ;            ,dattaText_ptr:ptr_new()      $
    ;            ,fit_ptr:ptr_new()           $
    ;            ,descriptr:ptr_new()         $
    ,monave:0L                       $
    ;            ,signal_type:''               $
    ;            ,ytitle:''                    $
    ;            ,magfield:0D                    $
    ;            ,shift_value:0D               $
    ;            ,plot_ptr:ptr_new()           $
    ;            ,mcf_ptr:ptr_new()            $
    ;            ,collim_ptr:ptr_new()         $
    ;            ,econfig_ptr:ptr_new()        $
    ;            ,qconfig_ptr:ptr_new()        $
    ;            ,mosaic_ptr:ptr_new()         $
    ;            ,instrument_ptr:ptr_new()     $
    ;            ,motors_ptr:ptr_new()         $
    ,lattice_ptr:Ptr_new()        $
    ;            ,xtal_orientation_ptr:ptr_new()  $
    ;            ,second_var_name:''           $
    ;            ,treatment_ptr:ptr_new()      $
    ,orientation_ptr:Ptr_new() $
    ,fixedetype:'' $
    ,fixedevalue:0.0 $
    ,dspacem:0.0 $
    ,dspacea:0.0 $
    ;            ,isICE:0B $       ; is data from an ICE formated file? 0=>no, 1=>yes
    ,anapkgptr:Ptr_new() $ ; info about BT7 analyzer package
    ;            ,oFTP:obj_new() $
    ;            ,sdesc:'' $
    ,psddets:Ptr_new() $
    ,tddets:Ptr_new() $
    ,dddets:Ptr_new() $
    ,sddets:Ptr_new() $
    ;            ,angles:ptr_new() $
    ,a1:Ptr_new() $
    ,a2:Ptr_new() $
    ,a3:Ptr_new() $
    ,a4:Ptr_new() $
    ,a5:Ptr_new() $
    ,a6:Ptr_new() $
    ,e:Ptr_new() $
    ,ei:Ptr_new() $
    ,ef:Ptr_new() $
    ,h:Ptr_new() $
    ,k:Ptr_new() $
    ,l:Ptr_new() $
    ,mon:Ptr_new() $
    ,time:Ptr_new() $
    ,temp:Ptr_new() $
    ,magfield:Ptr_new() $
  }


  ;(*self.data_file_contents) = dstring
  ;(*self.header_ptr) = header       ;dstruct.header
  ;self.display_name = dtas_get_filename(self.filename)
  ;self.isICE = 1
  ;
  ;(*self.headText_ptr) = headText
  ;(*self.dattaText_ptr) = dattaText

  ; Ok now we have the entire data structure with titles and all
  ; stored in dstruct.  Now we need to convert it to the form used
  ; throughout the TAS data reduction.  In other words...warp it into
  ; the ICP format.

  ;; What is the file extension?
  ;ppos = strpos(self.filename,'.')
  ;self.extension = strmid(self.filename,ppos+1)
  ;self.display_name = dtas_get_filename(self.filename)

  dataPtr.filename = filename
  dataPtr.dataversion = Self.dataversion

  ; Lattice
  dataPtr.lattice_ptr = Ptr_new(lattice)
  ; Orientation
  dataPtr.orientation_ptr = Ptr_new(orientation)
  ; Fixed anergy and its value
  dataPtr.fixedetype = fixedEType
  dataPtr.fixedevalue = fixedEValue
  ; Monochromator and Analyzer d spacing
  dataPtr.dspacea = dspaceA
  dataPtr.dspacem = dspaceM
  ; Scan description
  ;dataPtr.sdesc = sdesc

  ;; Retrieve plottable data
  ;x = ptr_new(*dstruct.(indep_var_pos))
  ;xtitle = titles[indep_var_pos]
  ;y = ptr_new(*dstruct.(dep_var_pos))
  ;ytitle = titles[dep_var_pos]
  ;dy = ptr_new(*dstruct.error)

  ;; BT7 Analyzer package details
  ;nd = n_elements(*y)
  ;TDy = fltarr(nd)*0.0
  ;anaMode = 0
  ;show_td = 0
  dataPtr.indep_var_tag = dattaText[indep_var_pos]
  dataPtr.indep_var_val = Ptr_new(*dstruct.(indep_var_pos))


  if (N_elements(anaPkgStr) gt 0) then begin
    dataPtr.anapkgptr = Ptr_new(anaPkgStr)
    ;
    ;    ;; Retrieve door detector data
    ;    anaMode = anaPkgStr.mode
    ;    if (anaMode eq 2 || anaMode eq 3) then begin
    ;        detsInSum = strsplit(anaPkgStr.TDDetsInSum,';',/extract,count=nDets)
    ;        if (nDets gt 0) then begin
    ;            for i=0,nDets-1 do begin
    ;                ind = where(strupcase(titles) eq strupcase(detsInSum[i]))
    ;                TDy = TDy + *dstruct.(ind[0])
    ;            endfor
    ;        endif
    ;    endif
    ;
    ;    status = tasreducpreferences(tasprefs)
    ;    if (status) then begin
    ;      tags = tag_names(tasprefs)
    ;      index = where(tags eq 'SHOW_TD', found)
    ;      if (found) then show_td = fix(tasprefs.(index))
    ;    endif
  endif

  ; The Data block stored as a structure using column headers as field name tags
  dataPtr.data_ptr = Ptr_new(dstruct)
  tags = Strupcase(Tag_names(dstruct))

  ; a1 - a6 angles
  atags = ['A1','A2','A3','A4','A5','A6']
  ntags = 6
  dtags = Tag_names(dataPtr)
  ;angles = fltarr(6,ndat)
  for i=0,ntags-1 do begin
    index = Where(tags eq atags[i], cnt)
    ;  if cnt then angles[i,*] = (*dstruct.(index))
    if (cnt eq 1) then begin
      index1 = Where(dtags eq atags[i], cnt1)
      if (cnt1 eq 1) then dataPtr.(index1) = dstruct.(index)  ; make dataPtr.A* and dstruct.A* point to same heap var
    endif
  endfor

  ; monitor
  index = Where(tags eq 'MONITOR',cnt)
  if (cnt) then begin
    dataPtr.monave = (*dstruct.(index))[0]
    dataPtr.mon = Ptr_new(*dstruct.(index))
  endif

  ; time (counting time)
  index = Where(tags eq 'TIME',cnt)
  if (cnt) then dataPtr.time = Ptr_new(*dstruct.(index))

  ; magfield
  index = Where(tags eq 'MAGFIELD',cnt)
  if (cnt) then begin
    dataPtr.magfield = Ptr_new(*dstruct.(index))
  endif else begin
    ; magfield not normally defined in ICE intermediate raw file so inialize to zero
    n = N_elements(*dataPtr.mon)
    dataPtr.magfield = Ptr_new(Fltarr(n))
  endelse

  ; temperature
  index = Where(strcmp(tags,'TEMP') or strcmp(tags,'TEMPERATURE'),cnt)
  if (cnt) then begin
    dataPtr.temp = Ptr_new(*dstruct.(index))
  endif else begin
    ; temperature not defined in ICE intermediate raw file so inialize to zero
    n = N_elements(*dataPtr.mon)
    dataPtr.temp = Ptr_new(Fltarr(n))
  endelse

  ; hkl components
  if (ice_file) then begin
    index = Where(tags eq 'H',cnt)
    if (cnt) then dataPtr.h = Ptr_new(*dstruct.(index))
    index = Where(tags eq 'K',cnt)
    if (cnt) then dataPtr.k = Ptr_new(*dstruct.(index))
    index = Where(tags eq 'L',cnt)
    if (cnt) then dataPtr.l = Ptr_new(*dstruct.(index))
    ;dataPtr.hkl = ptr_new(transpose([[h],[k],[l]]))
  endif
  if (nice_file) then begin
    index = Where(tags eq 'Q_H',cnt)
    if (cnt) then dataPtr.h = Ptr_new(*dstruct.(index))
    index = Where(tags eq 'Q_K',cnt)
    if (cnt) then dataPtr.k = Ptr_new(*dstruct.(index))
    index = Where(tags eq 'Q_L',cnt)
    if (cnt) then dataPtr.l = Ptr_new(*dstruct.(index))
    ;dataPtr.hkl = ptr_new(transpose([[h],[k],[l]]))
  endif

  ; E (energy transfer)
  if (ice_file) then index = Where(tags eq 'E',eFound)
  if (nice_file) then index = Where(tags eq 'ET',eFound)
  if (eFound) then begin
    eTrans = *dstruct.(index)
    dataPtr.e = Ptr_new(eTrans)
  endif

  ; Ei
  index = Where(tags eq 'EI',eiFound)
  if (eiFound) then dataPtr.ei = Ptr_new(*dstruct.(index))

  ; Ef
  index = Where(tags eq 'EF',efFound)
  if (efFound) then dataPtr.ef = Ptr_new(*dstruct.(index))

  ; Some older files did not include Ei, Ef fields but did include
  ; the 'fixedE' keyword in the header which can be used to determine Ei or Ef given
  ; two out of Ei,Ef,E
  if ((~eiFound || ~efFound) && eFound) then begin
    fixedET = dataPtr.fixedetype
    fixedEV = dataPtr.fixedevalue
    nDat = N_elements(eTrans)
    if (Strcmp(fixedET,'Ei',/fold)) then begin
      ;; ==> Ei is fixed
      ei = Fltarr(nDat) + fixedEV
      ef = ei - eTrans
    endif else if (Strcmp(fixedET,'Ef',/fold)) then begin
      ;; ==> Ef is fixed
      ef = Fltarr(nDat) + fixedEV
      ei = ef + eTrans
    endif else begin
      ;; calculate Ei from A2;
      ;; Ei = 2.0722*Ki^2 where ki = 2*pi/lambda_i and lambda_i = 2*(dSpaceM)*sin(A2/2);
      ei = Self.ekfac * (2*!pi/(2*dSpaceM*Sin(0.5*(*dataPtr.a2)*!dtor)))^2
      ef = ei - eTrans
    endelse
    dataPtr.ei = Ptr_new(ei)
    dataPtr.ef = Ptr_new(ef)
  endif

  ; In 2-axis mode, A6 is expected to be zero. however, there sometimes rounding-off errors in ICE
  ; that results in A6 being asigned a small value hence screwing up energy calculations. Hence
  ; if A6 is small (ie zero within tolerance), then assumme we are running in 2-axis mode and therefore
  ; set Ei=Ef and determine the value from A2.
  A6_tolerance = 0.05
  small = 0.001
  A6 = (*dataPtr.a6)
  n = N_elements(A6)
  notVarying = Abs(A6[n-1] - A6[0]) le small
  isZero = Abs(a6[0]) le A6_tolerance
  if (isZero && notVarying) then begin
    ; data likely collected in 2-Axis mode
    ; so recalculate energy values
    Ei = Self.ekfac * (2*!pi/(2*dSpaceM*Sin(0.5*(*dataPtr.a2)*!dtor)))^2
    (*dataPtr.ei) = Ei
    (*dataPtr.ef) = Ei
    (*dataPtr.e) = Ei*0.0
  endif

  ; psd detectors from PSD Detector package
  dettags = Strupcase(anaPkgStr.psddets)
  ndets = N_elements(dettags)
  ndat = N_elements(etrans)
  dets = Fltarr(ndets,ndat)
  for i=0,ndets-1 do begin
    index = Where(tags eq dettags[i], cnt)
    if cnt then dets[i,*] = (*dstruct.(index))
  endfor
  dataPtr.psddets = Ptr_new(dets)

  ; door detectors from PSD Detector package
  dettags = Strupcase(anaPkgStr.tddets)
  ndets = N_elements(dettags)
  dets = Fltarr(ndets,ndat)
  for i=0,ndets-1 do begin
    index = Where(tags eq dettags[i], cnt)
    if cnt then dets[i,*] = (*dstruct.(index))
  endfor
  dataPtr.tddets = Ptr_new(dets)

  ; diffraction detectors from PSD Detector package
  dettags = Strupcase(anaPkgStr.dddets)
  ndets = N_elements(dettags)
  dets = Fltarr(ndets,ndat)
  for i=0,ndets-1 do begin
    index = Where(tags eq dettags[i], cnt)
    if cnt then dets[i,*] = (*dstruct.(index))
  endfor
  dataPtr.dddets = Ptr_new(dets)

  ; single detectors from PSD Detector package
  dettags = Strupcase(anaPkgStr.sddets)
  ndets = N_elements(dettags)
  dets = Fltarr(ndets,ndat)
  for i=0,ndets-1 do begin
    index = Where(tags eq dettags[i], cnt)
    if cnt then dets[i,*] = (*dstruct.(index))
  endfor
  dataPtr.sddets = Ptr_new(dets)


  ;mon_counts = strtrim(string(self.tot_mon,format = '(e15.3)'),2)
  ;ytitle = 'COUNTS PER '+mon_counts+' MONITOR'
  ;self.ytitle = ytitle
  ;plot_str = {x:x,y:y,dy:dy,TDy:ptr_new(TDy),anaMode:anaMode,show_td:show_td $
  ;            ,xtitle:xtitle,ytitle:self.ytitle,title:self.display_name}
  ;*self.plot_ptr = plot_str
  ;new_treatment = 'Raw data file read in: '+self.display_name
  ;ret = self->update_treatment(new_treatment)

  ;; Set the descriptive variable to the average temperature of the file
  ;; as a starting point (default).
  ;ret = self->udpate_descriptr(/temperature)
  ;ret = self->get_magfield()

  dataPtr = Ptr_new(dataPtr,/no_copy)
  Return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::UpdatePropertySheet
;
; PURPOSE:
;   Update the propertysheet to reflect the current sample type
;
; PARAMETERS:
;
; KEYWORDS:
;    typeCheck - if datasets already loaded use dialog to warn about possibility of samplt type change
;
pro Bt7psdtool::UpdatePropertySheet, typeCheck=typeCheck
  compile_opt idl2

  Self->Getproperty, SAMPCONTREF=oSamp, sampTyps=sampTyps, sampTypeFlag=sampTypeFlag
  nSamp = oSamp->Count()
  if (nSamp gt 0 && Keyword_set(typeCheck)) then begin
    sampType=sampTyps[sampTypeFlag]
    msg = 'Not advisable to change Sample Type with data already loaded!'
    msg = [msg,'Do you wish to reload all datasets as "'+sampType+'" first?']
    title = 'Sample Type has Changed: Reload All Data?'
    status = Self->Promptuseryesno(msg,answer,title=title)
    if (status && answer) then $
      void = Self->Reloadalldatasets() ;Self->DeleteAllDatasets(/noPrompt)
  endif

  sxProps = Ptr_valid(Self.sxtalonlypropsptr)? (*Self.sxtalonlypropsptr) : []
  nsxProps = N_elements(sxProps)
  pdProps = Ptr_valid(Self.powderonlypropsptr)? (*Self.powderonlypropsptr) : []
  npdProps = N_elements(pdProps)
  sxPdProps = Ptr_valid(Self.sxtalpowderpropsptr)? (*Self.sxtalpowderpropsptr) : []
  nSxPdProps = N_elements(sxPdProps)
  rwProps = Ptr_valid(Self.rawonlypropsptr)? (*Self.rawonlypropsptr) : []
  nrwProps = N_elements(rwProps)

  oUI = Self->Getui()
  uiPresent = Obj_valid(oUI)
  if (uiPresent) then begin
    oUI->Getproperty, group_leader = wTLB
    wChild = Widget_info(wTLB, /child)
    Widget_control, wChild, get_uvalue=sPtr
  endif

  Self->Setpropertyattribute, 'BKGDFLAG', sensitive=(Self.nbkgd gt 0)
  Self->Setpropertyattribute, 'bkgdSubVarFlag', sensitive=(Self.bkgdflag eq 1)
  Self->Setpropertyattribute, 'bkgdSubVarTol', sensitive=(Self.bkgdflag eq 1)

  case Self.samptypeflag of

    0: begin ; powder
      for i = 0, npdProps-1 do Self->Setpropertyattribute, pdProps[i], hide=0
      for i = 0, nSxPdProps-1 do Self->Setpropertyattribute, sxPdProps[i], hide=0

      for i = 0, nsxProps-1 do Self->Setpropertyattribute, sxProps[i], hide=1
      for i = 0, nrwProps-1 do Self->Setpropertyattribute, rwProps[i], hide=1

      ; fix label for x-axis variable
      Self->Setpropertyattribute,'xAxisVar', name='Scan Variable', enumlist=(*Self.indepvars2ptr)

      if (uiPresent) then begin
        ;widget_control, (*sPtr).wMslice, sensitive=0
        ;; unmap the sxtalbase and map the powderbase
        ;widget_control, (*sPtr).wSxtalBase, map=0
        ;widget_control, (*sPtr).wPowderBase, map=1
      endif
    end

    1: begin ; single crystal
      for i = 0, nsxProps-1 do Self->Setpropertyattribute, sxProps[i], hide=0
      for i = 0, nSxPdProps-1 do Self->Setpropertyattribute, sxPdProps[i], hide=0

      for i = 0, npdProps-1 do Self->Setpropertyattribute, pdProps[i], hide=1
      for i = 0, nrwProps-1 do Self->Setpropertyattribute, rwProps[i], hide=1

      ; fix label for x-axis variable
      Self->Setpropertyattribute,'xAxisVar', name='Horizontal Axis Variable', enumlist=(*Self.indepvars1ptr)

      ; fix label for y-axis variable
      Self->Setpropertyattribute,'yAxisVar', name='Vertical Axis Variable', enumlist=(*Self.indepvars1ptr)
      Self->Getproperty, yAxisVar=yAxisVar
      if (yAxisVar ge N_elements((*Self.indepvars1ptr)) ) then begin
        Self->Setproperty, yAxisVar = 1
      endif

      Self->Setpropertyattribute, 'maxIntensity', hide=(Self.defaultintensityflag eq 1)
      Self->Setpropertyattribute, 'minIntensity', hide=(Self.defaultintensityflag eq 1)
      if (uiPresent) then begin
        ;widget_control, (*sPtr).wMslice, sensitive=1
      endif
    end

    2: begin ; Raw View
      for i = 0, nrwProps-1 do Self->Setpropertyattribute, rwProps[i], hide=0

      for i = 0, nsxProps-1 do Self->Setpropertyattribute, sxProps[i], hide=1
      for i = 0, npdProps-1 do Self->Setpropertyattribute, pdProps[i], hide=1
      for i = 0, nSxPdProps-1 do Self->Setpropertyattribute, sxPdProps[i], hide=1

      ; fix label for x-axis variable
      Self->Setpropertyattribute,'xAxisVar', name='Plot Type', enumlist=(*Self.rawmodesptr)
      Self.xaxisvar = (Self.xaxisvar > 0) < 3
      xAxisVar = Self.xaxisvar
      ;if ((xAxisVar lt 0) || (xAxisVar gt 2)) then xAxisVar = 0
      case xAxisVar of
        0: begin ; Cnts vs Channel
          Self->Setpropertyattribute,'yAxisVar', hide=1
          Self->Setpropertyattribute,'minChan', hide=1
          Self->Setpropertyattribute,'maxChan', hide=1
          Self->Setpropertyattribute,'minDPnt', hide=1
          Self->Setpropertyattribute,'maxDPnt', hide=1
;          Self->Setpropertyattribute,'PSDDisplayAs', hide=1
          Self->Setpropertyattribute,'sharedSettingsFlag', hide=0
          Self->Getproperty, selectedIDs=selIDs, nSelectedIDs=nSel, curMaxDataLen=maxLen $
            , settingIndex=sIndex, dpntIndex=dpntIndex
          hideSI = Self.sharedsettingsflag || (nSel lt 2)
          showSI = ~Self.sharedsettingsflag && (nSel ge 2)
          Self->Setpropertyattribute,'settingIndex', hide=hideSI, name='Dataset name:' $
            , enumlist = File_basename(selIDs)
          if (Self.sharedsettingsflag) then begin
            Self.dpntindex = Self.dpntindex < maxLen
            Self->Setpropertyattribute,'dpntIndex', hide=0, valid_range=[1,maxLen,1]
          endif else begin
            oItem = Self->Getbyidentifier(selIDs[sIndex])
            if (Obj_valid(oItem)) then begin
              status = oItem->Getmetadata('NPTS',nPts)
              dpntIndex = (dpntIndex > 1) < nPts
              Self.dpntindex = dpntIndex
              oItem->Addmetadata, 'DPNTINDEX', dpntIndex
              Self->Setpropertyattribute, 'dpntIndex', valid_range=[1,nPts,1]
            endif
          endelse
        end

        1: begin ; Integrated Cnts vs Channel
          Self->Setpropertyattribute,'yAxisVar', hide = 1
          Self->Setpropertyattribute,'minChan', hide=1
          Self->Setpropertyattribute,'maxChan', hide=1
          Self->Setpropertyattribute,'dpntIndex', hide=1
;          Self->Setpropertyattribute,'PSDDisplayAs', hide=1
          Self->Setpropertyattribute,'sharedSettingsFlag', hide=0
          Self->Getproperty, selectedIDs=selIDs, nSelectedIDs=nSel, curMaxDataLen=maxLen $
            , settingIndex=sIndex, minDPnt=minDPnt, maxDPnt=maxDPnt
          hideSI = Self.sharedsettingsflag || (nSel lt 2)
          Self->Setpropertyattribute,'settingIndex', hide=hideSI, name='Dataset name:' $
            , enumlist = File_basename(selIDs)

          if (Self.sharedsettingsflag) then begin
            Self.minDPnt = Self.minDPnt > 1
            Self.maxDPnt = Self.maxDPnt < maxLen
            Self->Setpropertyattribute,'minDPnt', hide=0, valid_range=[1,maxLen,1]
            Self->Setpropertyattribute,'maxDPnt', hide=0, valid_range=[1,maxLen,1]
          endif else begin
            oItem = Self->Getbyidentifier(selIDs[sIndex])
            if (Obj_valid(oItem)) then begin
              status = oItem->Getmetadata('NPTS',nPts)
              minDPnt = minDPnt > 1
              maxDPnt = maxDPnt < nPts
              Self.minDPnt = minDPnt
              Self.maxDPnt = maxDPnt
              oItem->Addmetadata, 'MINDPNT', minDPnt
              oItem->Addmetadata, 'MAXDPNT', maxDPnt
              Self->Setpropertyattribute,'minDPnt', hide=0, valid_range=[1,nPts,1]
              Self->Setpropertyattribute,'maxDPnt', hide=0, valid_range=[1,nPts,1]
            endif
          endelse


        end

        2: begin ; Integrated Cnts vs Scan Variable
          Self->Getproperty, indepVar3List=scanList
          Self->Setpropertyattribute,'yAxisVar', hide = 0, name='Scan Variable', enumlist=scanList
          Self->Setpropertyattribute,'minDPnt', hide=1
          Self->Setpropertyattribute,'maxDPnt', hide=1
          Self->Setpropertyattribute,'dpntIndex', hide=1
;          Self->Setpropertyattribute,'PSDDisplayAs', hide=1
          Self->Setpropertyattribute,'sharedSettingsFlag', hide=1
          Self->Setpropertyattribute,'settingIndex', hide=1
          Self.maxchan = Self.maxchan < 48
          Self->Setpropertyattribute,'minChan', hide=0, name = 'Min Channel to sum', valid_range=[1,48,1]
          Self->Setpropertyattribute,'maxChan', hide=0, name = 'Max Channel to sum', valid_range=[1,48,1]
        end
        
        3: begin  ; All Channels (2D)
          
;          Self->Setpropertyattribute,'PSDDisplayAs', hide=0
          Self->Setpropertyattribute,'minChan', hide=1
          Self->Setpropertyattribute,'maxChan', hide=1
          Self->Setpropertyattribute,'minDPnt', hide=1
          Self->Setpropertyattribute,'maxDPnt', hide=1
          Self->Setpropertyattribute,'dpntIndex', hide=1
          Self->Getproperty, indepVar3List=scanList
          Self->Setpropertyattribute,'yAxisVar', hide = 0, name='Scan Variable', enumlist=scanList
          Self->Setpropertyattribute,'sharedSettingsFlag', hide=1
          Self->Setpropertyattribute,'settingIndex', hide=1
        end

        else:
      endcase
    end

    else:
  endcase

;  Self->refreshPropertySheet

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; Bt7psdTool::Plot
;
; PURPOSE:
;   Generates a plot of the specified dataset
;
; PARAMETERS:
;   oItem   - dataset to be plotted
;   sPtr    - heap variable containing useful widget related info
;   overPlotFlag  - is overplotting on (1) or off (0)
;   lastPltFlag   - if overplotting, is this the last plot to be included
;
; KEYWORDS:
;-
pro Bt7psdtool::Plot, oItem, sPtr, identifiers
  compile_opt idl2

  Self->Getproperty, sampTypeFlag = sampTypeFlag

  if (sampTypeFlag eq 0) then Self->Plotpowder, oItem, sPtr, identifiers
  if (sampTypeFlag eq 1) then Self->Plotsinglecrystal, oItem, sPtr, identifiers
  if (sampTypeFlag eq 2) then Self->Plotraw, oItem, sPtr, identifiers

end
;-------------------------------------------------------------------------------


;;===============================================================================
;;+
;; Bt7psdTool::PlotRaw
;;
;; PURPOSE:
;;   Generates a line or contour plot of the specified dataset for raw data view
;;
;; PARAMETERS:
;;   oItem   - dataset to be plotted
;;   sPtr    - heap variable containing useful widget related info
;;   overPlotFlag  - is overplotting on (1) or off (0)
;;   lastPlotFlag   - if overplotting, is this the last plot to be included
;;
;; KEYWORDS:
;;-
pro Bt7psdtool::PlotRaw, oItem, sPtr, identifiers
compile_opt idl2
Self->Getproperty, xAxisVar=mode
case mode of
  3: Self->PlotRaw_mode3, oItem, sPtr, identifiers
  else: Self->PlotRaw_mode2orLess, oItem, sPtr, identifiers
endcase

end



;===============================================================================
;+
; Bt7psdTool::PlotRaw_mode2orLess
;
; PURPOSE:
;   Generates a line or contour plot of the specified dataset for raw data view
;
; PARAMETERS:
;   oItem   - dataset to be plotted
;   sPtr    - heap variable containing useful widget related info
;   overPlotFlag  - is overplotting on (1) or off (0)
;   lastPlotFlag   - if overplotting, is this the last plot to be included
;
; KEYWORDS:
;-
pro Bt7psdtool::PlotRaw_mode3, oItem, sPtr, identifiers
compile_opt idl2

print,'Mode 3 plot called...'

Self->Getproperty, xAxisVar=mode, yAxisVar=yAxisVar, indepVar3List=varList, calibParamsisSet=calibParamsisSet $
  , minChan=minChan,maxChan=maxChan, MONSCALEVALUE=monScaleVal, NORMALIZETO=normTo, effNormFlag=effFlag $
  , sampTypeFlag=sampTypeFlag, logFlag=logFlag, nSelectedIDs=nSel $
  ,bkgdFlag=bkgdFlag, nBkgd=nBkgd, bkgdContRef=bkgdContRef $
  ,bkgdSubVarTol=bkgdSubVarTol, bkgdSubVarFlag=bkgdSubVarFlag, clearDisplayFlag=clearDisplayFlag


ids = identifiers ;(*sPtr).itemID
nData = N_elements(ids)
overplotFlag = 0
cIndex = -1
for pos=0, nData-1 do begin
  oItem = Self->Getbyidentifier(ids[pos])
  lastPlotFlag = pos eq (nData - 1)

  if (~Obj_isa(oItem, 'IDLitParameterSet')) then continue
  if (oItem->Getmetadatacount() eq 0) then continue
  cIndex++
  ; Ensure dataset was processed for 'Raw Data' view
  status = oItem->Getmetadata('sampTypeFlag',sTypeFlag)
  if (sTypeFlag ne 2) then begin
    stypes = ['Powder','Single Crystal','Raw Data']
    msg = 'Cannot plot dataset; It is of Sample Type: "'+stypes[sTypeFlag]+'" which does not match current setting!'
    Self->Statusmessage, msg
    continue
  endif
  
  status = oItem->Getmetadata('CHDELA4',chDelA4)

  ; Dim 1
  if (calibParamsisSet) then begin
    ; Determine the A4 accross PSD for the first data point in the dataset
    ; using the norminal A4 and delta A4 (= A4o- DelA4)
    ; and set this to the PSDChannelA4 object before plotting
    oA4 = oItem->Getbyname('A4')
    status = oA4->Getdata(A4o)
    xvals = A4o[0] - chDelA4
    oX = oItem->Getbyname('PSDChannelA4')
  endif else begin
    ; just use the PSD Channel index since there is no calibration
    oX = oItem->Getbyname('PSDChannel')
    status = oX->Getdata(xvals)
  endelse

  ; Dim 2
  ; Retrieve the selected scan variable and use it as 2nd dim
  ; else use the data point indices if the san variable is not found
  yvar = varList[yAxisVar]
  oY = oItem->Getbyname(yvar,count=cnt)
  if (cnt ne 1) then begin
    oY = oItem->Getbyname('Data_Index',count=cnt)
    if (cnt ne 1) then Return
    yAxisVar = Where(varList eq 'Data_Index')
    Self->Setproperty, yAxisVar=yAxisVar
    axisHasChanged = 1
    msg = ['Scan variable "'+yvar+'" not found!','Switching to "Data_Index"']
    Self->Errormessage, msg, severity=0
    yvar = 'Data_Index'
  endif  
  status = oY->Getdata(yvals)  
  vmax = Max(yvals,min=vmin)
  if (vmax eq vmin) then begin
    oY = oItem->Getbyname('Data_Index',count=cnt)
    if (cnt ne 1) then Return
    yAxisVar = Where(varList eq 'Data_Index')
    Self->Setproperty, yAxisVar=yAxisVar
    axisHasChanged = 1
    msg = [yvar+' does not vary hence switching Vertical axis to Data_Index']
    Self->Errormessage, msg, severity=0
    yvar = 'Data_Index'
  endif



  ; Intensity
  status = oItem->Getmetadata('OriginalCounts',counts)
  error = counts
  index = Where(error le 0.0,cnt)
  if (cnt gt 0) then error[index] = 1.0
  error = Sqrt(error)


  ; efficiency correction
  if (effFlag) then begin
    status = oItem->Getmetadata('CHEFF',chEff)
    counts = Temporary(counts)/chEff
    error = Temporary(error)/Sqrt(chEff)
  endif

  ;; Mask bad channels
  Self->Getproperty, maskFlag=maskFlag
  sBadChans = Self.maskeddets
  maskedChansExist = ~Strcmp(sBadChans,'')
  if (maskFlag && maskedChansExist) then begin
    status = Compactstring2intvector(sBadChans, badChans)
    badChanIndex = badChans - 1   ; convert channel nos to 0-based channel index
    ; Apply mask by simple replacing the counts in the masked channels by NaNs
    ; Leave error variable untouched
    counts[badChanIndex,*] = !values.f_nan
    error[badChanIndex,*] = 0.0
  endif


  ;; Apply monitor normalization
  case normTo of
    0: begin
      status = oItem->Getmetadata('MON',mon)
      monScale = monScaleVal/mon
    end

    1: begin
      if (~Isa(time)) then begin    ; may have retrieve time already
        status = oItem->Getmetadata('TIME',time)
      endif
      monScale = monScaleVal/time
    end

    else: monScale = monScaleVal
  endcase
  counts = Temporary(counts)*monScale
  error = Temporary(error)*monscale

  if (yVals.ndim eq 2) then begin
    ny = (yVals.dim)[1]
    xVals = xVals#(fltarr(ny)+1)
  endif

  oZ = oItem->Getbyname('Counts')
  ;oErr = oItem->Getbyname('Error')
  oZ->SetProperty, type=partype(counts) ; because the same oZ is used to make 1D plots so can contain 1D data sometimes
  status = oZ->Setdata(counts,/no_copy,/no_notify)
  ;status = oErr->Setdata(error,/no_copy,/no_notify)
  status = oX->Setdata(xvals,/no_copy,/no_notify)
  status = oY->Setdata(yvals,/no_copy,/no_notify)
  
  strparms = ['Z','X','Y','PALETTE','RGB_INDICES']
  idparms = [oZ->Getfullidentifier() $
    ,oX->Getfullidentifier() $
    ,oY->Getfullidentifier() $
    ,'' $ ;oDataRGB->GetFullIdentifier() $
    ,'']
  visID = 'CONTOUR'
  opID = 'Operations/Insert Visualization'
  oRequester = (Self->Getbyidentifier(opID))->Getobjectinstance()
  oRequester->_Settool, Self
  oRequester->Getproperty, show_execution_ui = orig_showUI
  oRequester->Setproperty, show_execution_ui = 0

  oRequester->Setproperty, parameter_names=strParms, data_ids=idParms, visualization_id=visID

  ;Self->DisableUpdates
  oWin = Self->Getcurrentwindow()
  oView = oWin->Getcurrentview()
  activateManip = 0
  rangeChange = 0

  noOverplot = overplotFlag eq 0
  if (Self->Hasvisualizations() && noOverplot) then begin
    Print, 'Vis deleted...'
    ;; store the active manipulator
    (*sPtr).manipid = (Self->Getcurrentmanipulator())->Getfullidentifier()
    activateManip = 1

    ;; ensure the existing visualization is selected
    oLayer = oView->Getcurrentlayer()
    oWorld = oLayer->Getworld()
    oDataSpace = oWorld->Getdataspaces()
    oVis = oDataSpace->Getvisualizations(count = nVis)

    ; retrieve current xrange and yrange to determine if user has zoomed plot
    oDataSpace->Getproperty, xrange=xr, yrange=yr
    xChange = ((*sPtr).xrange[0] ne xr[0]) || ((*sPtr).xrange[1] ne xr[1])
    yChange = ((*sPtr).yrange[0] ne yr[0]) || ((*sPtr).yrange[1] ne yr[1])
    rangeChange = xChange && yChange

    delID = 'Operations/Edit/Delete'
    oDelete = (Self->Getbyidentifier(delID))->Getobjectinstance()

    ;for i=0,nVis-1 do begin
    ;  oVis[i]->Select ; make it current selection in Tool window
    ; TODO - save vis props
    ;  ;Self->saveVisProps, oVis  ; save vis properties before deleting it
    ;  void = oDelete->DoAction(Self)   ; delete selected item ie the vis
    ;endfor
    oDataSpace->Select
    void = oDelete->Doaction(Self)

    Obj_destroy, [oVis,oDataSpace]

    ; delete any residual annotations that may have been added
    annID = oView->Findidentifiers('*ANNOTATION LAYER*',count=nAnn)
    if (nAnn gt 2) then begin
      oVoid = []
      for i=2, nAnn-1 do begin
        oTmp = Self->Getbyidentifier(annID[i])
        oTmp->Select
        oVoid = [oVoid,oTmp]
      endfor
      void = oDelete->Doaction(Self) ; delete selected anootations
      Obj_destroy, oVoid
    endif
  endif

  ; create the new vis
  oCmd = oRequester->Doaction(Self)

  ;; Get the newly created vis
  oLayer = oView->Getcurrentlayer()
  oWorld = oLayer->Getworld()
  oDataSpace = oWorld->Getdataspaces()
  oVis = oDataSpace->Getvisualizations(count = nVis)

  ; TODO - fix vis cuztomization
  ; Customize it
  ;Self->CustomizeVis, oVis, plotname
  oItem->Getproperty, name=visname
  oVis[nVis-1]->Setproperty, /fill $
    ,aspect_ratio=aspect_ratio $
    ,transparency = 5 $
    ,n_levels=15 $
    ,name = visname $
    ,description = visname $
    ,pal_color=1  ; => use palette for level colors
  
  if (pos eq 0) then begin
    ; create color Palette using IDL color table colors
    oTempPalette = Idlgrpalette()
    oTempPalette->Loadct, 13
    oTempPalette->Getproperty, red_values=red, green_values=green, blue_values=blue
    Obj_destroy, oTempPalette
    oDataRGB = Idlitdataidlpalette(Transpose([[red],[green],[blue]]),name='RGB Table')
  endif
  status = oVis[nVis-1]->Setdata(oDataRGB, parameter_name='PALETTE',/by_value)

  Self->Updateplotintensityrange, oVis[nVis-1]

  if ((nVis gt 1) && overplotFlag && lastplotFlag) then begin
    ; if a multiplot and this is the last entry group all the plots together
    ; to form a single entity in the property sheet view
    ; And change the new group's name property to 'Contour'
    ;  for i=0,nVis-1 do oVis[i]->Select, additive=(i gt 0)
    ;  grpID = 'Operations/Edit/Grouping/Group'
    ;  oGrpOI = (Self->GetByIdentifier(grpID))->GetObjectInstance()
    ;  oGrpCmdSet = oGrpOI->DoAction(Self)
    ;  oGrpCmd = (oGrpCmdSet->Get(/all,count=nGrpCmd))[0]
    ;  if (isa(oGrpCmd,'IDLitCommand')) then begin
    ;    oGrpCmd->GetProperty, target_identifier=targID
    ;    (Self->GetByIdentifier(targID))->SetProperty, name='Contour';, manipulator_target=1
    ;  endif
    oVis[0]->Group,oVis[1:nVis-1]
    oDataSpace->Getproperty, transform=tf
    Help,tf
  endif
  ;if (noOverplot) then oDataSpace->Translate, 0.20, 0.0, 0.0 ; shift dataspace a bit to left for first plot only
  if (noOverplot) then begin
    oDataSpace->Scale, 0.85,0.85,1
    oDataSpace->Translate, 0.15, 0.0, 0.0 ; shift dataspace a bit to left for first plot only
  endif
  oDataSpace->Setproperty, aspect_ratio=aspect_ratio

  ; customize axes
  oAxes = oDataSpace->Getaxes(/container)
  oAxes->Setproperty,axis_style=2  $    ; draw box axes
    ;,yTitle=ylabel, xTitle=xlabel $
    ,zTitle=zlabel

  ; Update Plot Title text to reflect name of dataset being plotted
  ; The plot title annotation was automatically created when visualization was first created so
  ; all we need to do is change the text string
  annID = oView->Findidentifiers('*ANNOTATION LAYER*',count=nAnn)
  if (nAnn gt 0) then begin
    oText = Self->Getbyidentifier(annID[1])
    if (Isa(oText,'IDLitvisText')) then oText->Setproperty, string=visname
  endif
  overPlotFlag = 1
endfor

if (activateManip) then Self->Activatemanipulator, (*sPtr).manipid
Self->Refreshcurrentwindow   ;oWin->Draw   ; force window to refresh

end


;===============================================================================
;+
; Bt7psdTool::PlotRaw_mode2orLess
;
; PURPOSE:
;   Generates a line or contour plot of the specified dataset for raw data view
;
; PARAMETERS:
;   oItem   - dataset to be plotted
;   sPtr    - heap variable containing useful widget related info
;   overPlotFlag  - is overplotting on (1) or off (0)
;   lastPlotFlag   - if overplotting, is this the last plot to be included
;
; KEYWORDS:
;-
pro Bt7psdtool::PlotRaw_mode2orLess, oItem, sPtr, identifiers
  compile_opt idl2

  colors = [[0,0,255],[0255,0,0],[0,255,0],[0,255,255],[255,0,255] $
    ,[128,255,0],[255,128,0],[0,255,128],[128,128,255],[255,128,128] $
    ,[128,255,128],[128,128,128],[255,255,0]]
  nColors = N_elements(colors)/3

  Self->Getproperty, xAxisVar=mode, yAxisVar=xAxisVar, indepVar3List=varList, calibParamsisSet=calibParamsisSet $
    , minChan=minChan,maxChan=maxChan,minDPnt=minDPnt,maxDPnt=maxDPnt,dpntIndex=dpntIndex $
    , MONSCALEVALUE=monScaleVal, NORMALIZETO=normTo, effNormFlag=effFlag $
    , sampTypeFlag=sampTypeFlag, logFlag=logFlag, nSelectedIDs=nSel $
    ,bkgdFlag=bkgdFlag, nBkgd=nBkgd, bkgdContRef=bkgdContRef $
    ,bkgdSubVarTol=bkgdSubVarTol, bkgdSubVarFlag=bkgdSubVarFlag, clearDisplayFlag=clearDisplayFlag

  ids = identifiers ;(*sPtr).itemID
  nData = N_elements(ids)
  overplotFlag = 0
  cIndex = -1
  for pos=0, nData-1 do begin
    oItem = Self->Getbyidentifier(ids[pos])
    lastPlotFlag = pos eq (nData - 1)

    if (~Obj_isa(oItem, 'IDLitParameterSet')) then continue
    if (oItem->Getmetadatacount() eq 0) then continue
    cIndex++
    ; Ensure dataset was processed for 'Raw Data' view
    status = oItem->Getmetadata('sampTypeFlag',sTypeFlag)
    if (sTypeFlag ne 2) then begin
      stypes = ['Powder','Single Crystal','Raw Data']
      msg = 'Cannot plot dataset; It is of Sample Type: "'+stypes[sTypeFlag]+'" which does not match current setting!'
      Self->Statusmessage, msg
      continue
    endif

    ;; Plot the data

    status = oItem->Getmetadata('OriginalCounts',counts)
    error = counts
    index = Where(error le 0.0,cnt)
    if (cnt gt 0) then error[index] = 1.0
    error = Sqrt(error)

    status = oItem->Getmetadata('MON',mon)
    status = oItem->Getmetadata('TIME',time)

    ;; Perform bkgd subtraction if appropriate
    status = oItem->Getmetadata('DATAPTRREF',dataPtr)
    dataStr = *dataPtr
    bkgdSubVarTag = Strupcase(Self.bkgdsubvars[bkgdSubVarFlag])
    tagNames = Tag_names(dataStr)
    if (bkgdSubVarTag eq 'HKL') then begin
      ; replace 'HKL' with 'H','K' and 'L'
      varHIndex = Where(tagNames eq 'H', HtagFound4Samp)
      varKIndex = Where(tagNames eq 'K', KtagFound4Samp)
      varLIndex = Where(tagNames eq 'L', LtagFound4Samp)
      tagFound4Samp = HtagFound4Samp && KtagFound4Samp && LtagFound4Samp
      if (tagFound4Samp) then begin
        bkgdSubVarValH = Mean((*dataStr.(varHIndex)))
        bkgdSubVarValK = Mean((*dataStr.(varKIndex)))
        bkgdSubVarValL = Mean((*dataStr.(varLIndex)))
      end
    endif else begin
      varIndex = Where(tagNames eq bkgdSubVarTag, tagFound4Samp)
      if (tagFound4Samp) then bkgdSubVarVal = Mean((*dataStr.(varIndex)))
    endelse

    oItem->Getproperty, type=type
    if (Strcmp(type,'samp') && bkgdFlag && (nBkgd gt 0)) then begin
      status = oItem->Getmetadata('INDEP_VAR_TAG',sampIndepVarTag)
      status = oItem->Getmetadata('INDEP_VAR_VAL',sampIndepVarVal)
      tolB = 0.005
      bkgdCntBuf = counts*0.0
      bkgdMonBuf = bkgdCntBuf
      bkgdSub = 0
      for j = 0, nBkgd-1 do begin
        oPsetB = bkgdContRef->Get(position=j)
        if (~Obj_valid(oPsetB)) then continue
        ;        status = oPsetB->GetMetaData('sampTypeFlag',sTypeFlagB)
        ;        if (sTypeFlagB ne 2) then continue  ; only proceed if dataset was originally read in as powder

        ; retrieve the bkgdSubVarVal for bkgd dataset and compare with
        ; same quantity for signal dataset
        if (tagFound4Samp) then begin
          status = oPsetB->Getmetadata('DATAPTRREF',dataPtr)
          dataStr = *dataPtr
          if (bkgdSubVarTag eq 'HKL') then begin
            bkgdSubVarValBH = Mean((*dataStr.(varHIndex)))
            bkgdSubVarValBK = Mean((*dataStr.(varKIndex)))
            bkgdSubVarValBL = Mean((*dataStr.(varLIndex)))
            HNotSame = Abs(bkgdSubVarValH-bkgdSubVarValBH) gt bkgdSubVarTol
            KNotSame = Abs(bkgdSubVarValK-bkgdSubVarValBK) gt bkgdSubVarTol
            LNotSame = Abs(bkgdSubVarValL-bkgdSubVarValBL) gt bkgdSubVarTol
            ; Is the keyword variable same for singnal and bkgd datasets?
            ; If not then skip to next bkgd dataset
            if (HNotSame || KNotSame || LNotSame) then continue  ; to next bkgd dataset
          endif else begin
            bkgdSubVarValB = Mean((*dataStr.(varIndex)))
            ; Is the keyword variable same for singnal and bkgd datasets?
            ; If not then skip to next bkgd dataset
            if (Abs(bkgdSubVarVal-bkgdSubVarValB) gt bkgdSubVarTol) then continue ; to next bkgd dataset
          endelse
        endif

        status = oPsetB->Getmetadata('INDEP_VAR_TAG',bkgdIndepVarTag)
        status = oPsetB->Getmetadata('INDEP_VAR_VAL',bkgdIndepVarVal)
        if (sampIndepVarTag ne bkgdIndepVarTag) then continue

        status = oPsetB->Getmetadata('MON',monB)
        if (~oPsetB->Getmetadata('OriginalCounts',countsB)) then continue

        ; now perform subtraction for correspong datapoints in signal and bkgd
        ; datasets that have the same value of the independent variable (scan variable)
        sIndex = []
        bIndex = []
        for k=0, N_elements(bkgdIndepVarVal)-1 do begin
          index = Where(Abs(sampIndepVarVal - bkgdIndepVarVal[k]) lt tolB, found)
          if (found eq 1) then begin
            sIndex = [sIndex,index]
            bIndex = [bIndex,k]
          endif
        endfor
        if (N_elements(sIndex) gt 0) then begin
          ;; accumulate the bkgd counts and corresponding monitor values so that
          ;; we end up with a sum of counts and sum of monitor over all bkgd before doing
          ;; the subtration outside the bkgd loop
          bkgdSub = 1
          bkgdCntBuf[*,sIndex] = bkgdCntBuf[*,sIndex] + countsB[*,bIndex]
          bkgdMonBuf[*,sIndex] = bkgdMonBuf[*,sIndex] + monB[*,bIndex]
        endif
      endfor
      if (bkgdSub) then begin
        index = Where(bkgdMonBuf eq 0.0, zeroMonPresent)
        if (zeroMonPresent gt 0) then bkgdMonBuf[index] = 1.0
        scaleFactB = mon / bkgdMonBuf
        counts = Temporary(counts) - scaleFactB * bkgdCntBuf
        error = Sqrt(Temporary(error)^2 + scaleFactB * bkgdCntBuf)
      endif
    endif

    ; Efficiency correction
    if (effFlag) then begin
      status = oItem->Getmetadata('CHEFF',chEff)
      counts = Temporary(counts)/chEff
      error = Temporary(error)/Sqrt(chEff)
    endif

    ;; Mask bad channels
    Self->Getproperty, maskFlag=maskFlag
    sBadChans = Self.maskeddets
    maskedChansExist = ~Strcmp(sBadChans,'')
    if (maskFlag && maskedChansExist) then begin
      status = Compactstring2intvector(sBadChans, badChans)
      badChanIndex = badChans - 1   ; convert channel nos to 0-based channel index
      ; Apply mask by simple replacing the counts in the masked channels by NaNs
      ; Leave error variable untouched
      counts[badChanIndex,*] = !values.f_nan
      error[badChanIndex,*] = 0.0
    endif


    ;; Apply monitor normalization
    case normTo of
      0: begin
        monScale = monScaleVal/mon
      end

      1: begin
        monScale = monScaleVal/time
      end

      else: monScale = monScaleVal
    endcase
    counts = Temporary(counts)*monScale
    error = Temporary(error)*monscale

    oZ = oItem->Getbyname('Counts')
    oErr = oItem->Getbyname('Error')

    PSDDims = Size(counts,/dimensions)  ; dimension lenghts
    status = oItem->Getmetadata('NPTS',npts)  ; determine nos of datapoints in dataset


    showSI = ~Self.sharedsettingsflag && (nSel ge 2)
    if (showSI) then begin
      status = oItem->Getmetadata('DPNTINDEX', dpntIndex)
      status = oItem->Getmetadata('MINDPNT', minDPnt)
      status = oItem->Getmetadata('MAXDPNT', maxDPnt)
    endif

    status = oItem->Getmetadata('CHDELA4',chDelA4)

    case mode of
      0: begin    ; Cts vs Channel
        ;if (~isa(xAxisVar)) then xAxisVar = 0
        if (npts gt 1) then begin
          index = ((dpntIndex-1) > 0) < (PSDDims[1] - 1) ; 0 < xAxisVar < npts-1
          counts = counts[*,index]
          error = error[*,index]
        endif else begin
          ; dataset has a single datapoint, no need to do anything
          index = 0
        endelse

        if (Self.calibparamsisset) then begin
          ; Determine the A4 accross PSD from norminal A4 and delta A4 (= A4o- DelA4)
          ; and set this to the PSDChannelA4 object before plotting
          oA4 = oItem->Getbyname('A4')
          status = oA4->Getdata(A4o)
          chA4 = A4o[index] - chDelA4
          oX = oItem->Getbyname('PSDChannelA4',count=cnt)
          status = oX->Setdata(chA4,/no_copy,/no_notify)
        endif else begin
          ; just use the PSD Channel index
          oX = oItem->Getbyname('PSDChannel',count=cnt)
        endelse

        ; If the scan variable was identified from the raw data, then use it in the
        ; y-axis label in addition to the datapoint index nos
        status = oItem->Getmetadata('INDEP_VAR_TAG',indep_var_tag)
        oIndepVar = oItem->Getbyname(indep_var_tag)
        if (Obj_valid(oIndepVar)) then begin
          status = oIndepVar->Getdata(IV_value)
          status = oIndepVar->Getmetadata('Long_name',IV_name)
          oZ->Addmetadata,'Long_name','Counts, dPnt='+Strtrim(String(index),2)+', '+IV_name+'='+Strtrim(String(IV_value[index]),2)
        endif else begin
          oZ->Addmetadata,'Long_name','Counts, dPnt='+Strtrim(String(index),2)
        endelse
      end

      1: begin    ; Integrated Cts (data points) vs Channel
        if (npts gt 1) then begin
          ;; dataset has moe than 1 datapoint
          if (minDPnt gt maxDPnt) then begin
            Self.maxdpnt = minDPnt
            Self.mindpnt = maxDPnt
            minDPnt = Self.mindpnt
            maxDPnt = Self.maxdpnt
            ;Self->RefreshPropertySheet
          endif
          index =  minDPnt - 1 + Indgen(maxDPnt - minDPnt + 1)  ; minDPnt -1 converts pnt nos to index nos
          nIndex = N_elements(index)
          if (nIndex gt 1) then begin
            counts = Total(counts[*,index],2,/NAN)   ; integrated along data point from minDPnt to maxDPnt
            error = Sqrt(Total(error[*,index]^2,2,/NAN))
          endif else begin
            counts = Reform(counts[*,index])
            error = Reform(error[*,index])
          endelse
        endif else begin
          ;; dataset has only 1 datapoint
          minDPnt = 1
          maxDPnt = 1
        endelse

        oX = oItem->Getbyname('PSDChannel',count=cnt)
        strMinDPnt = Strtrim(String(minDPnt),2)
        strMaxDPnt = Strtrim(String(maxDPnt),2)
        oZ->Addmetadata,'Long_name','$\sum_{dPnt='+strMinDPnt+'}^{'+strMaxDPnt+'}$ Counts'
      end

      2: begin    ; Integrated Cts (detector channels) vs ScanVariable
        if (minChan gt maxChan) then begin
          Self.maxchan = minChan
          Self.minchan = maxChan
          minChan = Self.minchan
          maxChan = Self.maxchan
          ;Self->RefreshPropertySheet
        endif
        index =  minChan - 1 + Indgen(maxChan - minChan + 1)  ; minChan -1 converts channels to index nos
        nIndex = N_elements(index)
        if (nIndex gt 1) then begin
          counts = Total(counts[index,*],1,/NAN)   ; integrated along det channel from minChan to maxChan
          error = Sqrt(Total(error[index, *]^2,1,/NAN))
        endif else begin
          counts = Reform(counts[index,*])
          error = Reform(error[index,*])
        endelse

        xvar = varList[xAxisVar]
        oX = oItem->Getbyname(xvar,count=cnt)
        if (cnt ne 1) then begin
          oX = oItem->Getbyname('Data_Index',count=cnt)
          msg = ['Scan variable "'+xvar+'" not found!','Switching to "Data_Index"']
          Self->Errormessage, msg, severity=0
        endif
        strMinChan = Strtrim(String(minChan),2)
        strMaxChan = Strtrim(String(maxChan),2)
        oZ->Addmetadata,'Long_name','$\sum_{chan='+strMinChan+'}^{'+strMaxChan+'}$ Counts'
      end

      else:

    endcase

    ctype = Partype(counts)

    if (ctype ne 'IDLVECTOR') then Return  ; can't crate a plot from non-vector data

    status = oZ->Setdata(counts,/no_copy,/no_notify)
    status = oErr->Setdata(error,/no_copy,/no_notify)

    oZ->Setproperty, type=ctype
    oX->Setproperty, type=ctype
    oErr->Setproperty, type=ctype

    strparms = ['Y','X','Y ERROR','X ERROR','VERTICES','PALETTE','VERTEX_COLORS']
    idparms = [oZ->Getfullidentifier() $
      ,oX->Getfullidentifier() $
      ,oErr->Getfullidentifier() $
      ,'','','','']
    visID = 'PLOT'
    opID = 'Operations/Insert Visualization'
    oRequester = (Self->Getbyidentifier(opID))->Getobjectinstance()
    oRequester->_Settool, Self
    oRequester->Getproperty, show_execution_ui = orig_showUI
    oRequester->Setproperty, show_execution_ui = 0

    oItem->Getproperty, name=plotName   ; retrieve the dataset name as shown in the data manager and set it as plotname
    oRequester->Setproperty, name=plotName, parameter_names=strParms, data_ids=idParms, visualization_id=visID

    oWin = Self->Getcurrentwindow()
    oView = oWin->Getcurrentview()
    activateManip = 0
    rangeChange = 0

    ;noOverplot = overplotFlag eq 0
    noOverplot = overplotFlag eq 0 && clearDisplayFlag
    if (Self->Hasvisualizations() && noOverplot) then begin
      ;; store the active manipulator
      (*sPtr).manipid = (Self->Getcurrentmanipulator())->Getfullidentifier()
      activateManip = 1

      ;; ensure the existing visualization is selected
      oLayer = oView->Getcurrentlayer()
      oWorld = oLayer->Getworld()
      oDataSpace = oWorld->Getdataspaces()
      oVis = oDataSpace->Getvisualizations(count = nVis)

      ; retrieve current xrange and yrange to determine if user has zoomed plot
      oDataSpace->Getproperty, xrange=xr, yrange=yr
      xChange = ((*sPtr).xrange[0] ne xr[0]) || ((*sPtr).xrange[1] ne xr[1])
      yChange = ((*sPtr).yrange[0] ne yr[0]) || ((*sPtr).yrange[1] ne yr[1])
      rangeChange = xChange && yChange

      delID = 'Operations/Edit/Delete'
      oDelete = (Self->Getbyidentifier(delID))->Getobjectinstance()

      oDataSpace->Select
      void = oDelete->Doaction(Self)

      Obj_destroy, [oVis,oDataSpace]

      ; delete any residual annotations that may have been added
      annID = oView->Findidentifiers('*ANNOTATION LAYER*',count=nAnn)
      if (nAnn gt 2) then begin
        oVoid = []
        for i=2, nAnn-1 do begin
          oTmp = Self->Getbyidentifier(annID[i])
          oTmp->Select
          oVoid = [oVoid,oTmp]
        endfor
        void = oDelete->Doaction(Self) ; delete selected anootations
        Obj_destroy, oVoid
      endif
    endif

    ; create the new vis
    oCmd = oRequester->Doaction(Self)

    ;; Get the newly created vis
    oLayer = oView->Getcurrentlayer()
    oWorld = oLayer->Getworld()
    oDataSpace = oWorld->Getdataspaces()
    oVis = oDataSpace->Getvisualizations(count = nVis)

    ; TODO - fix vis cuztomization
    ; Customize it
    color = colors[*,cIndex mod nColors]
    Self->Setproperty, b_color=color,b_sym_color=color,b_use_default_color=1,b_errorbar_color=color,b_sym_fill_color=color
    Self->Customizevis, oVis[nVis-1], plotName, 'BKGDPLOT'
    ;oVis[nVis-1]->SetProperty, /fill $
    ;                 ,aspect_ratio=aspect_ratio $
    ;                 ,transparency = 5 $
    ;                 ,n_levels=15 $
    ;                 ,pal_color=1  ; => use palette for level colors
    ;status = oVis[nVis-1]->SetData(oDataRGB, parameter_name='PALETTE',/by_value)


    ;if ((nVis gt 1) && overplotFlag && lastplotFlag) then begin
    ;  ; if a multiplot and this is the last entry group all the plots together
    ;  ; to form a single entity in the property sheet view
    ;  ; And change the new group's name property to 'Contour'
    ;  for i=0,nVis-1 do oVis[i]->Select, additive=(i gt 0)
    ;  grpID = 'Operations/Edit/Grouping/Group'
    ;  oGrpOI = (Self->GetByIdentifier(grpID))->GetObjectInstance()
    ;  oGrpCmdSet = oGrpOI->DoAction(Self)
    ;  oGrpCmd = (oGrpCmdSet->Get(/all,count=nGrpCmd))[0]
    ;  if (isa(oGrpCmd,'IDLitCommand')) then begin
    ;    oGrpCmd->GetProperty, target_identifier=targID
    ;    (Self->GetByIdentifier(targID))->SetProperty, name='Contour'
    ;  endif
    ;endif
    ;oDataSpace->SetProperty, aspect_ratio=aspect_ratio
    ;if (noOverplot) then oDataSpace->Translate, 0.20, 0.0, 0.0 ; shift dataspace a bit to left for first plot only
    if (noOverplot) then begin
      oDataSpace->Scale, 0.85,1.1,1
      oDataSpace->Translate, 0.15, 0.0, 0.0 ; shift dataspace a bit to left for first plot only
    endif

    ;; customize axes
    ;oAxes = oDataSpace->GetAxes(/container)
    ;oAxes->SetProperty,axis_style=2  $    ; draw box axes
    ;                  ;,yTitle=ylabel, xTitle=xlabel $
    ;                  ,zTitle=zlabel


    ; Update Plot Title text to reflect name of dataset being plotted
    ; The plot title annotation was automatically created when visualization was first created so
    ; all we need to do is change the text string
    annID = oView->Findidentifiers('*ANNOTATION LAYER*',count=nAnn)
    if (nAnn gt 0) then begin
      oText = Self->Getbyidentifier(annID[1])
      oItem->Getproperty, name=visname
      if (Isa(oText,'IDLitvisText')) then oText->Setproperty, string=visname
    endif


    overPlotFlag = 1
  endfor


  if (activateManip) then Self->Activatemanipulator, (*sPtr).manipid
  Self->Refreshcurrentwindow   ;oWin->Draw   ; force window to refresh




end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; Bt7psdTool::PlotPowder
;
; PURPOSE:
;   Generates a line or contour plot of the specified dataset for the case of a powder sample
;
; PARAMETERS:
;   oItem   - dataset to be plotted
;   sPtr    - heap variable containing useful widget related info
;   overPlotFlag  - is overplotting on (1) or off (0)
;   lastPltFlag   - if overplotting, is this the last plot to be included
;
; KEYWORDS:
;-
pro Bt7psdtool::PlotPowder, oItem, sPtr, identifiers
  compile_opt idl2

  colors = [[0,0,255],[0255,0,0],[0,255,0],[0,255,255],[255,0,255] $
    ,[128,255,0],[255,128,0],[0,255,128],[128,128,255],[255,128,128] $
    ,[128,255,128],[128,128,128],[255,255,0]]
  nColors = N_elements(colors)/3
  ids = identifiers ;(*sPtr).itemID
  nData = N_elements(ids)
  overplotFlag = 0
  cIndex = -1
  Self->Getproperty, xAxisVar=xAxisVar, indepVar2List=varList, calibParamsisSet=calibParamsisSet, clearDisplayFlag=clearDisplayFlag, logFlag=logFlag
  for pos=0, nData-1 do begin
    oItem = Self->Getbyidentifier(ids[pos])
    lastPlotFlag = pos eq (nData - 1)

    if (~Obj_isa(oItem, 'IDLitParameterSet')) then continue
    if (oItem->Getmetadatacount() eq 0) then continue
    cIndex++
    ; Ensure dataset was processed as 'Powder' sample
    status = oItem->Getmetadata('sampTypeFlag',sTypeFlag)
    if (sTypeFlag ne 0) then begin
      stypes = ['Powder','Single Crystal','Raw Data']
      msg = 'Cannot plot dataset; It is of Sample Type: "'+stypes[sTypeFlag]+'" which does not match current setting!'
      Self->Statusmessage, msg
      continue
    endif

    ;; Plot the data
    xvar = varList[xAxisVar]
    axisHasChanged = 0
    msg = []

    ; Default to Data_Index for x-axis if one of the calculated
    ; quantities ['2Theta','d-space','|Q|','E'] was selected by the user
    ; and the calibration parameters are not yet loaded
    calculatedVarList = ['2Theta','d-space','|Q|','E']
    void = Where(calculatedVarList eq xvar, xvarIsCalculated)
    if (calibParamsisSet) then begin
      ; if calibration is loaded, use the user selected axes
      oX = oItem->Getbyname(xvar,count=count)
      if (count ne 1) then continue
    endif else begin
      msg = 'PSD Calibration parameters file is not yet loaded!'
      if (xvarIsCalculated) then begin
        oX = oItem->Getbyname('Data_Index',count=count)
        if (count ne 1) then Return
        xAxisVar = Where(varList eq 'Data_Index')
        Self->Setproperty, xAxisVar=xAxisVar
        msg = [msg,xvar+' cannot be evaluated hence switching Scan Variable axis to Data_Index']
        axisHasChanged = 1
        xvar = 'Data_Index'
      endif else $
        oX = oItem->Getbyname(xvar,count=count)
    endelse

    ;; If the x data values are constant default to the Data_Index as the axis value
    status = oX->Getdata(vdata)
    vmax = Max(vdata,min=vmin)
    if (vmax eq vmin) then begin
      oX = oItem->Getbyname('Data_Index',count=count)
      if (count ne 1) then Return
      xAxisVar = Where(varList eq 'Data_Index')
      Self->Setproperty, xAxisVar=xAxisVar
      axisHasChanged = 1
      msg = [msg,xvar+' does not vary hence switching Scan Variable axis to Data_Index']
      xvar = 'Data_Index'
    endif

    if (axisHasChanged) then Self->Errormessage, msg,severity=0,title='BT7 PSD Reduction - Axes selection'

    ; retrieve counts and error which are stored as metadata with the independent variable.
    ; Store these with the dependent and error variables
    status = oX->Getmetadata('Counts',counts)
    ctype = Partype(counts)

    if (ctype ne 'IDLVECTOR') then Return  ; can't crate a plot from non-vector data

    oZ = oItem->Getbyname('Counts')
    status = oZ->Setdata(counts,/no_copy,/no_notify)
    status = oX->Getmetadata('Error',error)
    oErr = oItem->Getbyname('Error')
    status = oErr->Setdata(error,/no_copy,/no_notify)


    oZ->Setproperty, type=ctype
    oX->Setproperty, type=ctype
    oErr->Setproperty, type=ctype

    ;; create color Palette using IDL color table colors
    ;oTempPalette = IDLgrPalette()
    ;oTempPalette->LoadCT, 13
    ;oTempPalette->GetProperty, red_values=red, green_values=green, blue_values=blue
    ;obj_destroy, oTempPalette
    ;oDataRGB = IDLitDataIDLPalette(transpose([[red],[green],[blue]]),name='RGB Table')

    strparms = ['Y','X','Y ERROR','X ERROR','VERTICES','PALETTE','VERTEX_COLORS']
    idparms = [oZ->Getfullidentifier() $
      ,oX->Getfullidentifier() $
      ,oErr->Getfullidentifier() $
      ,'','','','']
    visID = 'PLOT'
    opID = 'Operations/Insert Visualization'
    oRequester = (Self->Getbyidentifier(opID))->Getobjectinstance()
    oRequester->_Settool, Self
    oRequester->Getproperty, show_execution_ui = orig_showUI
    oRequester->Setproperty, show_execution_ui = 0

    oItem->Getproperty, name=plotName   ; retrieve the dataset name as shown in the data manager and set it as plotname
    oRequester->Setproperty, name=plotName, parameter_names=strParms, data_ids=idParms, visualization_id=visID

    oWin = Self->Getcurrentwindow()
    oView = oWin->Getcurrentview()
    activateManip = 0
    rangeChange = 0

    noOverplot = overplotFlag eq 0 && clearDisplayFlag
    if (Self->Hasvisualizations() && noOverplot) then begin
      ;; store the active manipulator
      (*sPtr).manipid = (Self->Getcurrentmanipulator())->Getfullidentifier()
      activateManip = 1

      ;; ensure the existing visualization is selected
      oLayer = oView->Getcurrentlayer()
      oWorld = oLayer->Getworld()
      oDataSpace = oWorld->Getdataspaces()
      oVis = oDataSpace->Getvisualizations(count = nVis)

      ; retrieve current xrange and yrange to determine if user has zoomed plot
      oDataSpace->Getproperty, xrange=xr, yrange=yr
      xChange = ((*sPtr).xrange[0] ne xr[0]) || ((*sPtr).xrange[1] ne xr[1])
      yChange = ((*sPtr).yrange[0] ne yr[0]) || ((*sPtr).yrange[1] ne yr[1])
      rangeChange = xChange && yChange

      delID = 'Operations/Edit/Delete'
      oDelete = (Self->Getbyidentifier(delID))->Getobjectinstance()

      oDataSpace->Select
      void = oDelete->Doaction(Self)

      Obj_destroy, [oVis,oDataSpace]

      ; delete any residual annotations that may have been added
      annID = oView->Findidentifiers('*ANNOTATION LAYER*',count=nAnn)
      if (nAnn gt 2) then begin
        oVoid = []
        for i=2, nAnn-1 do begin
          oTmp = Self->Getbyidentifier(annID[i])
          oTmp->Select
          oVoid = [oVoid,oTmp]
        endfor
        void = oDelete->Doaction(Self) ; delete selected anootations
        Obj_destroy, oVoid
      endif
    endif

    ; create the new vis
    oCmd = oRequester->Doaction(Self)

    ;; Get the newly created vis
    oLayer = oView->Getcurrentlayer()
    oWorld = oLayer->Getworld()
    oDataSpace = oWorld->Getdataspaces()
    oVis = oDataSpace->Getvisualizations(count = nVis)

    ; TODO - fix vis cuztomization
    ; Customize it
    if (clearDisplayFlag eq 0) then cIndex = nColors - 1 - cIndex ; if not clearing display, then use non-standard colors by starting from the end
    color = colors[*,cIndex mod nColors]
    Self->Setproperty, s_color=color,s_sym_color=color,s_use_default_color=1,s_errorbar_color=color,s_sym_fill_color=color
    Self->Customizevis, oVis[nVis-1], plotName, 'SAMPPLOT'
    ;oVis[nVis-1]->SetProperty, /fill $

    ;oDataSpace->SetProperty, aspect_ratio=aspect_ratio
    if (noOverplot) then begin
      oDataSpace->Scale, 0.85,1.1,1
      oDataSpace->Translate, 0.15, 0.0, 0.0 ; shift dataspace a bit to left for first plot only
      ;; customize axes
      oAxes = oDataSpace->Getaxes(/container)
      if (logFlag ge 1) then oAxes->Setproperty, ylog=1      ; use logarithmic y axis
      ;oAxes->SetProperty,axis_style=2  $    ; draw box axes
      ;                  ;,yTitle=ylabel, xTitle=xlabel $
      ;                  ,zTitle=zlabel
    endif



    ; Update Plot Title text to reflect name of dataset being plotted
    ; The plot title annotation was automatically created when visualization was first created so
    ; all we need to do is change the text string
    annID = oView->Findidentifiers('*ANNOTATION LAYER*',count=nAnn)
    if (nAnn gt 0) then begin
      oText = Self->Getbyidentifier(annID[1])
      oItem->Getproperty, name=visname
      if (Isa(oText,'IDLitvisText')) then oText->Setproperty, string=visname
    endif

    overPlotFlag = 1
  endfor

  if (activateManip) then Self->Activatemanipulator, (*sPtr).manipid
  Self->Refreshcurrentwindow   ;oWin->Draw   ; force window to refresh




end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; Bt7psdTool::PlotSinglecrystal_oldJune2019
;
; PURPOSE:
;   Generates a contour plot of the specified dataset for the case of a sngle crystal sample
;
; PARAMETERS:
;   oItem   - dataset to be plotted
;   sPtr    - heap variable containing useful widget related info
;   overPlotFlag  - is overplotting on (1) or off (0)
;   lastPltFlag   - if overplotting, is this the last plot to be included
;
; KEYWORDS:
;-
pro Bt7psdtool::PlotSinglecrystal_oldJune2019 , oItem, sPtr, identifiers
  compile_opt idl2

  ids = identifiers ;(*sPtr).itemID
  nData = N_elements(ids)
  overplotFlag = 0
  firstdata = 1
  xData = []
  yData = []
  zData = []
  oSystem = Self->Getsystem()
  for pos=0, nData-1 do begin
    oItem = Self->Getbyidentifier(ids[pos])
    lastPlotFlag = pos eq (nData - 1)

    if (~Obj_isa(oItem, 'IDLitParameterSet')) then continue
    if (oItem->Getmetadatacount() eq 0) then continue

    ; Ensure dataset was processed as 'Single Crystal' sample
    status = oItem->Getmetadata('sampTypeFlag',sTypeFlag)
    if (sTypeFlag ne 1) then begin
      stypes = ['Powder','Single Crystal','Raw Data']
      msg = 'Cannot plot dataset; It is of Sample Type: "'+stypes[sTypeFlag]+'" which does not match current setting!'
      Self->Statusmessage, msg
      Return
    endif

    ;; Plot the data
    Self->Getproperty, xAxisVar=xAxisVar,yAxisVar=yAxisVar, indepVar1List=varList $
      ,calibParamsisSet=calibParamsisSet, qUnits=qUnitsFlag
    xvar = varList[xAxisVar]
    yvar = varList[yAxisVar]

    axisHasChanged = 0
    msg = []
    if (calibParamsisSet) then begin
      ; if calibration is loaded, use the user selected axes
      oX = oItem->Getbyname(xvar,count=count)
      if (count ne 1) then Return
      oY = oItem->Getbyname(yvar,count=count)
      if (count ne 1) then Return
    endif else begin
      ; else default to PSDChannel for x and 'TEMP' for y axis
      ; if one of the calculated quantities ['QX','QY','|Q|','E'] was selected by the user
      calculatedVarList = ['QX','QY','|Q|','E']
      void = Where(calculatedVarList eq xvar, xvarIsCalculated)
      void = Where(calculatedVarList eq yvar, yvarIsCalculated)
      msg = 'PSD Calibration parameters file is not yet loaded!'

      if (xvarIsCalculated) then begin
        oX = oItem->Getbyname('PSDChannel',count=count)
        if (count ne 1) then Return
        xAxisVar = Where(varList eq 'PSDChannel')
        Self->Setproperty, xAxisVar=xAxisVar
        msg = [msg,xvar+' cannot be evaluated hence switching horizontal axis to PSDChannel']
        axisHasChanged = 1
        xvar = 'PSDChannel'
      endif else $
        oX = oItem->Getbyname(xvar,count=count)

      if (yvarIsCalculated) then begin
        oY = oItem->Getbyname('TEMP',count=count)
        if (count ne 1) then Return
        yAxisVar = Where(varList eq 'TEMP')
        Self->Setproperty, yaxisVar=yAxisVar
        msg = [msg,yvar+' cannot be evaluated hence switching vertical axis to Temperature']
        axisHasChanged = 1
        yvar = 'TEMP'
      endif else $
        oY = oItem->Getbyname(yvar,count=count)
    endelse

    ;; If the x or ydata values are constant default to the PSDChannel as the axis value
    status = oX->Getdata(xVals)
    vmax = Max(xVals,min=vmin)
    if (vmax eq vmin) then begin
      oX = oItem->Getbyname('PSDChannel',count=count)
      if (count ne 1) then Return
      xAxisVar = Where(varList eq 'PSDChannel')
      Self->Setproperty, xAxisVar=xAxisVar
      axisHasChanged = 1
      msg = [msg,xvar+' does not vary hence switching Horizontal axis to PSDChannel']
      xvar = 'PSDChannel'
    endif
    status = oY->Getdata(yVals)
    vmax = Max(yVals,min=vmin)
    if (vmax eq vmin) then begin
      oY = oItem->Getbyname('PSDChannel',count=count)
      if (count ne 1) then Return
      yAxisVar = Where(varList eq 'PSDChannel')
      Self->Setproperty, yAxisVar=yAxisVar
      axisHasChanged = 1
      msg = [msg,yvar+' does not vary hence switching Vertical axis to PSDChannel']
      yvar = 'PSDChannel'
    endif

    if (axisHasChanged) then Self->Errormessage, msg,severity=0,title='BT7 PSD Reduction - Axes selection'

    ; determine aspect ratio of plot
    ; It should be set to 1 (isotropic) if both x and y axis variables are
    ; wavevector ('QX' or 'QY')
    xIsQ = (xvar eq varList[0]) || (xvar eq varList[1])
    yIsQ = (yvar eq varList[0]) || (yvar eq varList[1])
    aspect_ratio = (xIsQ && yIsQ)? 1 : 0
    if (xIsQ && yIsQ) then begin
      ; If both x and y are in Q then if the units is in 1/A then the aspect_ratio of the
      ; plot is 1. However when it is r.l.u. then the x and y scales will be different.
      ; In this case, reset the aspect ration to be the same as the ratio of the y and x
      ; relative lattice units so that the aspect ratio will still appear to be 1.
      status = oY->Getmetadata('AA2RLU',yAA2RLU)
      status = oX->Getmetadata('AA2RLU',xAA2RLU)
      aspect_ratio = (qUnitsFlag eq 0)? 1.0 : yAA2RLU/xAA2RLU
      Help,'aspect_ratio = ',aspect_ratio
    endif

    oZ = oItem->Getbyname('Counts',count=count)
    if (count ne 1) then continue
    status = oZ->Getdata(zVals)
    CTYPE = Partype(zVals)
    if (ctype ne 'IDLARRAY2D') then continue ; can't create a plot from non-array (2D) data

    xData = [xData, xVals]
    yData = [yData, yVals]
    zData = [zData, zVals]
  endfor

  if (N_elements(zData) eq 0) then Return ; no data to be ploted so exit

  if (nData gt 1) then begin
    ;; if multiple datasets are being plotted then execute this block

    ; Retrieve label and units from x, y and z data
    void = oZ->Getmetadata('LONG_NAME',zLabel)
    void = oZ->Getmetadata('UNITS',zUnits)
    void = oX->Getmetadata('LONG_NAME',xLabel)
    void = oX->Getmetadata('UNITS',xUnits)
    void = oY->Getmetadata('LONG_NAME',yLabel)
    void = oY->Getmetadata('UNITS',yUnits)

    ; create new x, y and z data that will contain data from the multiple datasets
    oZ = Idlitdata(name='Z')
    oZ->Setproperty, /auto_delete ; data will be deleted when no visualization uses it
    oX = Idlitdata(name='X')
    oX->Setproperty, /auto_delete
    oY = Idlitdata(name='Y')
    oY->Setproperty, /auto_delete

    ; add to system datamanager so it has a fully qualified path/reference
    oSystem->Addbyidentifier, '/Data Manager', oZ
    oSystem->Addbyidentifier, '/Data Manager', oX
    oSystem->Addbyidentifier, '/Data Manager', oY

    oX->Setproperty, type=Partype(xData)
    status = oX->Setdata(xData,/no_copy,/no_notify)
    oX->Addmetadata,'Long_name',xLabel
    oX->Addmetadata,'Units',xUnits

    oY->Setproperty, type=Partype(yData)
    status = oY->Setdata(yData,/no_copy,/no_notify)
    oY->Addmetadata,'Long_name',yLabel
    oY->Addmetadata,'Units',yUnits

    oZ->Setproperty, type=Partype(zData)
    status = oZ->Setdata(zData,/no_copy,/no_notify)
    oZ->Addmetadata,'Long_name',zLabel
    oZ->Addmetadata,'Units',zUnits
    oZ->Addmetadata,'Signal', 1
  endif

  strparms = ['Z','X','Y','PALETTE','RGB_INDICES']
  idparms = [oZ->Getfullidentifier() $
    ,oX->Getfullidentifier() $
    ,oY->Getfullidentifier() $
    ,'' $ ;oDataRGB->GetFullIdentifier() $
    ,'']
  visID = 'CONTOUR'
  opID = 'Operations/Insert Visualization'
  oRequester = (Self->Getbyidentifier(opID))->Getobjectinstance()
  oRequester->_Settool, Self
  oRequester->Getproperty, show_execution_ui = orig_showUI
  oRequester->Setproperty, show_execution_ui = 0

  oRequester->Setproperty, parameter_names=strParms, data_ids=idParms, visualization_id=visID

  ;Self->DisableUpdates
  oWin = Self->Getcurrentwindow()
  oView = oWin->Getcurrentview()
  activateManip = 0
  rangeChange = 0

  noOverplot = overplotFlag eq 0
  if (Self->Hasvisualizations() && noOverplot) then begin
    Print, 'Vis deleted...'
    ;; store the active manipulator
    (*sPtr).manipid = (Self->Getcurrentmanipulator())->Getfullidentifier()
    activateManip = 1

    ;; ensure the existing visualization is selected
    oLayer = oView->Getcurrentlayer()
    oWorld = oLayer->Getworld()
    oDataSpace = oWorld->Getdataspaces()
    oVis = oDataSpace->Getvisualizations(count = nVis)

    ; retrieve current xrange and yrange to determine if user has zoomed plot
    oDataSpace->Getproperty, xrange=xr, yrange=yr
    xChange = ((*sPtr).xrange[0] ne xr[0]) || ((*sPtr).xrange[1] ne xr[1])
    yChange = ((*sPtr).yrange[0] ne yr[0]) || ((*sPtr).yrange[1] ne yr[1])
    rangeChange = xChange && yChange

    delID = 'Operations/Edit/Delete'
    oDelete = (Self->Getbyidentifier(delID))->Getobjectinstance()
    oDataSpace->Select
    void = oDelete->Doaction(Self)

    Obj_destroy, [oVis,oDataSpace]

    ; delete any residual annotations that may have been added
    annID = oView->Findidentifiers('*ANNOTATION LAYER*',count=nAnn)
    if (nAnn gt 2) then begin
      oVoid = []
      for i=2, nAnn-1 do begin
        oTmp = Self->Getbyidentifier(annID[i])
        oTmp->Select
        oVoid = [oVoid,oTmp]
      endfor
      void = oDelete->Doaction(Self) ; delete selected anootations
      Obj_destroy, oVoid
    endif
  endif

  ; create color Palette using IDL color table colors
  oTempPalette = Idlgrpalette()
  oTempPalette->Loadct, 13
  oTempPalette->Getproperty, red_values=red, green_values=green, blue_values=blue
  Obj_destroy, oTempPalette
  oDataRGB = Idlitdataidlpalette(Transpose([[red],[green],[blue]]),name='RGB Table')

  ; create the new vis
  oCmd = oRequester->Doaction(Self)

  ;; Get the newly created vis
  oLayer = oView->Getcurrentlayer()
  oWorld = oLayer->Getworld()
  oDataSpace = oWorld->Getdataspaces()
  oVis = oDataSpace->Getvisualizations(count = nVis)

  ; TODO - fix vis cuztomization
  ; Customize it
  ;Self->CustomizeVis, oVis, plotname
  oItem->Getproperty, name=visname
  oVis[nVis-1]->Setproperty, /fill $
    ,aspect_ratio=aspect_ratio $
    ,transparency = 5 $
    ,n_levels=15 $
    ,name = visname $
    ,description = visname $
    ,pal_color=1  ; => use palette for level colors

  status = oVis[nVis-1]->Setdata(oDataRGB, parameter_name='PALETTE',/by_value)

  Self->Updateplotintensityrange, oVis[nVis-1]

  if ((nVis gt 1) && overplotFlag && lastplotFlag) then begin
    ; if a multiplot and this is the last entry group all the plots together
    ; to form a single entity in the property sheet view
    ; And change the new group's name property to 'Contour'
    ;  for i=0,nVis-1 do oVis[i]->Select, additive=(i gt 0)
    ;  grpID = 'Operations/Edit/Grouping/Group'
    ;  oGrpOI = (Self->GetByIdentifier(grpID))->GetObjectInstance()
    ;  oGrpCmdSet = oGrpOI->DoAction(Self)
    ;  oGrpCmd = (oGrpCmdSet->Get(/all,count=nGrpCmd))[0]
    ;  if (isa(oGrpCmd,'IDLitCommand')) then begin
    ;    oGrpCmd->GetProperty, target_identifier=targID
    ;    (Self->GetByIdentifier(targID))->SetProperty, name='Contour';, manipulator_target=1
    ;  endif
    oVis[0]->Group,oVis[1:nVis-1]
    oDataSpace->Getproperty, transform=tf
    Help,tf
  endif
  ;if (noOverplot) then oDataSpace->Translate, 0.20, 0.0, 0.0 ; shift dataspace a bit to left for first plot only
  if (noOverplot) then begin
    oDataSpace->Scale, 0.85,0.85,1
    oDataSpace->Translate, 0.15, 0.0, 0.0 ; shift dataspace a bit to left for first plot only
  endif
  oDataSpace->Setproperty, aspect_ratio=aspect_ratio

  ; customize axes
  oAxes = oDataSpace->Getaxes(/container)
  oAxes->Setproperty,axis_style=2  $    ; draw box axes
    ;,yTitle=ylabel, xTitle=xlabel $
    ,zTitle=zlabel

  ; Update Plot Title text to reflect name of dataset being plotted
  ; The plot title annotation was automatically created when visualization was first created so
  ; all we need to do is change the text string
  annID = oView->Findidentifiers('*ANNOTATION LAYER*',count=nAnn)
  if (nAnn gt 0) then begin
    oText = Self->Getbyidentifier(annID[1])
    if (Isa(oText,'IDLitvisText')) then oText->Setproperty, string=visname
  endif

  if (activateManip) then Self->Activatemanipulator, (*sPtr).manipid
  Self->Refreshcurrentwindow   ;oWin->Draw   ; force window to refresh

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; Bt7psdTool::PlotSinglecrystal_oldJune2019
;
; PURPOSE:
;   Generates a contour plot of the specified dataset for the case of a sngle crystal sample
;
; PARAMETERS:
;   oItem   - dataset to be plotted
;   sPtr    - heap variable containing useful widget related info
;   overPlotFlag  - is overplotting on (1) or off (0)
;   lastPltFlag   - if overplotting, is this the last plot to be included
;
; KEYWORDS:
;-
pro Bt7psdtool::PlotSinglecrystal, oItem, sPtr, identifiers
  compile_opt idl2

  ids = identifiers ;(*sPtr).itemID
  nData = N_elements(ids)
  overplotFlag = 0
  firstdata = 1
  for pos=0, nData-1 do begin
    oItem = Self->Getbyidentifier(ids[pos])
    lastPlotFlag = pos eq (nData - 1)

    if (~Obj_isa(oItem, 'IDLitParameterSet')) then continue
    if (oItem->Getmetadatacount() eq 0) then continue

    ; Ensure dataset was processed as 'Single Crystal' sample
    status = oItem->Getmetadata('sampTypeFlag',sTypeFlag)
    if (sTypeFlag ne 1) then begin
      stypes = ['Powder','Single Crystal','Raw Data']
      msg = 'Cannot plot dataset; It is of Sample Type: "'+stypes[sTypeFlag]+'" which does not match current setting!'
      Self->Statusmessage, msg
      Return
    endif

    ;; Plot the data
    Self->Getproperty, xAxisVar=xAxisVar,yAxisVar=yAxisVar, indepVar1List=varList $
      ,calibParamsisSet=calibParamsisSet, qUnits=qUnitsFlag
    xvar = varList[xAxisVar]
    yvar = varList[yAxisVar]

    axisHasChanged = 0
    msg = []
    if (calibParamsisSet) then begin
      ; if calibration is loaded, use the user selected axes
      oX = oItem->Getbyname(xvar,count=count)
      if (count ne 1) then Return
      oY = oItem->Getbyname(yvar,count=count)
      if (count ne 1) then Return
    endif else begin
      ; else default to PSDChannel for x and 'TEMP' for y axis
      ; if one of the calculated quantities ['QX','QY','|Q|','E'] was selected by the user
      calculatedVarList = ['QX','QY','|Q|','E']
      void = Where(calculatedVarList eq xvar, xvarIsCalculated)
      void = Where(calculatedVarList eq yvar, yvarIsCalculated)
      msg = 'PSD Calibration parameters file is not yet loaded!'

      if (xvarIsCalculated) then begin
        oX = oItem->Getbyname('PSDChannel',count=count)
        if (count ne 1) then Return
        xAxisVar = Where(varList eq 'PSDChannel')
        Self->Setproperty, xAxisVar=xAxisVar
        msg = [msg,xvar+' cannot be evaluated hence switching horizontal axis to PSDChannel']
        axisHasChanged = 1
        xvar = 'PSDChannel'
      endif else $
        oX = oItem->Getbyname(xvar,count=count)

      if (yvarIsCalculated) then begin
        oY = oItem->Getbyname('TEMP',count=count)
        if (count ne 1) then Return
        yAxisVar = Where(varList eq 'TEMP')
        Self->Setproperty, yaxisVar=yAxisVar
        msg = [msg,yvar+' cannot be evaluated hence switching vertical axis to Temperature']
        axisHasChanged = 1
        yvar = 'TEMP'
      endif else $
        oY = oItem->Getbyname(yvar,count=count)
    endelse

    ;; If the x or ydata values are constant default to the PSDChannel as the axis value
    status = oX->Getdata(vdata)
    vmax = Max(vdata,min=vmin)
    if (vmax eq vmin) then begin
      oX = oItem->Getbyname('PSDChannel',count=count)
      if (count ne 1) then Return
      xAxisVar = Where(varList eq 'PSDChannel')
      Self->Setproperty, xAxisVar=xAxisVar
      axisHasChanged = 1
      msg = [msg,xvar+' does not vary hence switching Horizontal axis to PSDChannel']
      xvar = 'PSDChannel'
    endif
    status = oY->Getdata(vdata)
    vmax = Max(vdata,min=vmin)
    if (vmax eq vmin) then begin
      oY = oItem->Getbyname('PSDChannel',count=count)
      if (count ne 1) then Return
      yAxisVar = Where(varList eq 'PSDChannel')
      Self->Setproperty, yAxisVar=yAxisVar
      axisHasChanged = 1
      msg = [msg,yvar+' does not vary hence switching Vertical axis to PSDChannel']
      yvar = 'PSDChannel'
    endif

    if (axisHasChanged) then Self->Errormessage, msg,severity=0,title='BT7 PSD Reduction - Axes selection'

    ; determine aspect ratio of plot
    ; It should be set to 1 (isotropic) if both x and y axis variables are
    ; wavevector ('QX' or 'QY')
    xIsQ = (xvar eq varList[0]) || (xvar eq varList[1])
    yIsQ = (yvar eq varList[0]) || (yvar eq varList[1])
    aspect_ratio = (xIsQ && yIsQ)? 1 : 0
    if (xIsQ && yIsQ) then begin
      ; If both x and y are in Q then if the units is in 1/A then the aspect_ratio of the
      ; plot is 1. However when it is r.l.u. then the x and y scales will be different.
      ; In this case, reset the aspect ration to be the same as the ratio of the y and x
      ; relative lattice units so that the aspect ratio will still appear to be 1.
      status = oY->Getmetadata('AA2RLU',yAA2RLU)
      status = oX->Getmetadata('AA2RLU',xAA2RLU)
      aspect_ratio = (qUnitsFlag eq 0)? 1.0 : yAA2RLU/xAA2RLU
      Help,'aspect_ratio = ',aspect_ratio
    endif

    oZ = oItem->Getbyname('Counts',count=count)
    if (count ne 1) then Return
    status = oZ->Getdata(counts)
    CTYPE = Partype(counts)
    if (ctype ne 'IDLARRAY2D') then Return  ; can't create a plot from non-array (2D) data
    ;xLabel = ''
    ;if (oX->GetMetaData('LONG_NAME',label)) then xLabel += label
    ;if (oX->GetMetaData('UNITS',units)) then $
    ;  xLabel = (strlen(units) gt 0)? xLabel+' ('+units+')' : xLabel
    ;yLabel = ''
    ;if (oY->GetMetaData('LONG_NAME',label)) then yLabel += label
    ;if (oY->GetMetaData('UNITS',units)) then $
    ;  yLabel = (strlen(units) gt 0)? yLabel+' ('+units+')' : yLabel
    zLabel = ''
    if (oZ->Getmetadata('LONG_NAME',Label)) then zLabel += label
    if (oZ->Getmetadata('UNITS',units)) then $
      zLabel = (Strlen(units) gt 0)? zLabel+' ('+units+')' : zLabel

    strparms = ['Z','X','Y','PALETTE','RGB_INDICES']
    idparms = [oZ->Getfullidentifier() $
      ,oX->Getfullidentifier() $
      ,oY->Getfullidentifier() $
      ,'' $ ;oDataRGB->GetFullIdentifier() $
      ,'']
    visID = 'CONTOUR'
    opID = 'Operations/Insert Visualization'
    oRequester = (Self->Getbyidentifier(opID))->Getobjectinstance()
    oRequester->_Settool, Self
    oRequester->Getproperty, show_execution_ui = orig_showUI
    oRequester->Setproperty, show_execution_ui = 0

    oRequester->Setproperty, parameter_names=strParms, data_ids=idParms, visualization_id=visID

    ;Self->DisableUpdates
    oWin = Self->Getcurrentwindow()
    oView = oWin->Getcurrentview()
    activateManip = 0
    rangeChange = 0

    noOverplot = overplotFlag eq 0
    if (Self->Hasvisualizations() && noOverplot) then begin
      Print, 'Vis deleted...'
      ;; store the active manipulator
      (*sPtr).manipid = (Self->Getcurrentmanipulator())->Getfullidentifier()
      activateManip = 1

      ;; ensure the existing visualization is selected
      oLayer = oView->Getcurrentlayer()
      oWorld = oLayer->Getworld()
      oDataSpace = oWorld->Getdataspaces()
      oVis = oDataSpace->Getvisualizations(count = nVis)

      ; retrieve current xrange and yrange to determine if user has zoomed plot
      oDataSpace->Getproperty, xrange=xr, yrange=yr
      xChange = ((*sPtr).xrange[0] ne xr[0]) || ((*sPtr).xrange[1] ne xr[1])
      yChange = ((*sPtr).yrange[0] ne yr[0]) || ((*sPtr).yrange[1] ne yr[1])
      rangeChange = xChange && yChange

      delID = 'Operations/Edit/Delete'
      oDelete = (Self->Getbyidentifier(delID))->Getobjectinstance()

      ;for i=0,nVis-1 do begin
      ;  oVis[i]->Select ; make it current selection in Tool window
      ; TODO - save vis props
      ;  ;Self->saveVisProps, oVis  ; save vis properties before deleting it
      ;  void = oDelete->DoAction(Self)   ; delete selected item ie the vis
      ;endfor
      oDataSpace->Select
      void = oDelete->Doaction(Self)

      Obj_destroy, [oVis,oDataSpace]

      ; delete any residual annotations that may have been added
      annID = oView->Findidentifiers('*ANNOTATION LAYER*',count=nAnn)
      if (nAnn gt 2) then begin
        oVoid = []
        for i=2, nAnn-1 do begin
          oTmp = Self->Getbyidentifier(annID[i])
          oTmp->Select
          oVoid = [oVoid,oTmp]
        endfor
        void = oDelete->Doaction(Self) ; delete selected anootations
        Obj_destroy, oVoid
      endif
    endif

    ; create the new vis
    oCmd = oRequester->Doaction(Self)

    ;; Get the newly created vis
    oLayer = oView->Getcurrentlayer()
    oWorld = oLayer->Getworld()
    oDataSpace = oWorld->Getdataspaces()
    oVis = oDataSpace->Getvisualizations(count = nVis)

    ; TODO - fix vis cuztomization
    ; Customize it
    ;Self->CustomizeVis, oVis, plotname
    oItem->Getproperty, name=visname
    oVis[nVis-1]->Setproperty, /fill $
      ,aspect_ratio=aspect_ratio $
      ,transparency = 5 $
      ,n_levels=15 $
      ,name = visname $
      ,description = visname $
      ,pal_color=1  ; => use palette for level colors
    
    if (pos eq 0) then begin
      ; create color Palette using IDL color table colors
      oTempPalette = Idlgrpalette()
      oTempPalette->Loadct, 13
      oTempPalette->Getproperty, red_values=red, green_values=green, blue_values=blue
      Obj_destroy, oTempPalette
      oDataRGB = Idlitdataidlpalette(Transpose([[red],[green],[blue]]),name='RGB Table')
    endif
    status = oVis[nVis-1]->Setdata(oDataRGB, parameter_name='PALETTE',/by_value)

    Self->Updateplotintensityrange, oVis[nVis-1]

    if ((nVis gt 1) && overplotFlag && lastplotFlag) then begin
      ; if a multiplot and this is the last entry group all the plots together
      ; to form a single entity in the property sheet view
      ; And change the new group's name property to 'Contour'
      ;  for i=0,nVis-1 do oVis[i]->Select, additive=(i gt 0)
      ;  grpID = 'Operations/Edit/Grouping/Group'
      ;  oGrpOI = (Self->GetByIdentifier(grpID))->GetObjectInstance()
      ;  oGrpCmdSet = oGrpOI->DoAction(Self)
      ;  oGrpCmd = (oGrpCmdSet->Get(/all,count=nGrpCmd))[0]
      ;  if (isa(oGrpCmd,'IDLitCommand')) then begin
      ;    oGrpCmd->GetProperty, target_identifier=targID
      ;    (Self->GetByIdentifier(targID))->SetProperty, name='Contour';, manipulator_target=1
      ;  endif
      oVis[0]->Group,oVis[1:nVis-1]
      oDataSpace->Getproperty, transform=tf
      Help,tf
    endif
    ;if (noOverplot) then oDataSpace->Translate, 0.20, 0.0, 0.0 ; shift dataspace a bit to left for first plot only
    if (noOverplot) then begin
      oDataSpace->Scale, 0.85,0.85,1
      oDataSpace->Translate, 0.15, 0.0, 0.0 ; shift dataspace a bit to left for first plot only
    endif
    oDataSpace->Setproperty, aspect_ratio=aspect_ratio

    ; customize axes
    oAxes = oDataSpace->Getaxes(/container)
    oAxes->Setproperty,axis_style=2  $    ; draw box axes
      ;,yTitle=ylabel, xTitle=xlabel $
      ,zTitle=zlabel

    ; Update Plot Title text to reflect name of dataset being plotted
    ; The plot title annotation was automatically created when visualization was first created so
    ; all we need to do is change the text string
    annID = oView->Findidentifiers('*ANNOTATION LAYER*',count=nAnn)
    if (nAnn gt 0) then begin
      oText = Self->Getbyidentifier(annID[1])
      if (Isa(oText,'IDLitvisText')) then oText->Setproperty, string=visname
    endif
    overPlotFlag = 1
  endfor

  if (activateManip) then Self->Activatemanipulator, (*sPtr).manipid
  Self->Refreshcurrentwindow   ;oWin->Draw   ; force window to refresh

end
;-------------------------------------------------------------------------------


;===============================================================================
; Bt7psdTool::saveAsASCII
;
; PURPOSE:
;   Save output to file using DAVE format
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::SaveAsASCII
  compile_opt idl2

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB


  if (~Self->Exportselection(asciiPtr, nameTag=nametag, /useTexlabels,/ascii)) then Return, 0
  if (Ptr_valid(asciiPtr)) then begin

    Self->Getproperty, working_directory=workDir
    title = "Specify filename to store ASCII format data"
    ext = 'txt'
    filename = Dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
      ,/overwrite_prompt, file=nameTag+'.txt',path=workDir, get_path=new_workDir)

    if (~Strcmp(filename,'')) then begin
      xvals = (*asciiPtr).xvals
      yvals = (*asciiPtr).yvals
      evals = (*asciiPtr).evals
      nd = N_elements(xvals)
      Openw, lun, filename, /get_lun
      for i = 0,nd-1 do Printf, lun, format='(3(F11.4,2X))',xvals[i],yvals[i],evals[i]

      Free_lun, lun, /force

      if (File_test(new_workDir,/directory)) then Self->Setproperty, working_directory=new_workDir

      msg = 'Output stored in: '+filename
      Self->Statusmessage, msg
    endif

    Ptr_free, asciiPtr
  endif

  Return, 1
end


;===============================================================================
; Bt7psdTool::saveAsDave
;
; PURPOSE:
;   Save output to file using DAVE format
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::SaveAsDave
  compile_opt idl2

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB


  if (~Self->Exportselection(davePtr, nameTag=nametag, /useTexlabels,/dave)) then Return, 0
  if (Ptr_valid(davePtr)) then begin

    Self->Getproperty, working_directory=workDir
    title = "Specify filename to store DAVE format data"
    ext = 'dave'
    filename = Dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
      ,/overwrite_prompt, file=nameTag+'.dave',path=workDir, get_path=new_workDir)

    if (~Strcmp(filename,'')) then begin
      Save, davePtr, filename=filename
      if (File_test(new_workDir,/directory)) then Self->Setproperty, working_directory=new_workDir

      msg = 'Output stored in: '+filename
      Self->Statusmessage, msg
    endif

    Heap_free, davePtr
  endif

  Return, 1
end


;===============================================================================
; Bt7psdTool::CombineToDaveDM
;
; PURPOSE:
;   Combine datasets to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::CombineToDave
  compile_opt idl2

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      Self->Statusmessage, !ERROR_STATE.msg
      Catch, /cancel
      Return, 0
    endif
  endif

  if (~Self->Exportselection(davePtr, nameTag=nametag, /useTexlabels, /dave, /combine)) then Return, 0

  if (Ptr_valid(davePtr)) then begin

    Self->Getproperty, working_directory=workDir
    title = "Specify filename to store DAVE format data"
    ext = 'dave'
    filename = Dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
      ,/overwrite_prompt, file=nameTag+'.dave',path=workDir, get_path=new_workDir)

    if (~Strcmp(filename,'')) then begin
      Save, davePtr, filename=filename
      if (File_test(new_workDir,/directory)) then Self->Setproperty, working_directory=new_workDir

      msg = 'Output stored in: '+filename
      Self->Statusmessage, msg
    endif

    Heap_free, davePtr
  endif

  Return, 1
end


;===============================================================================
; Bt7psdTool::exportToDaveDM
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::exportToDaveDM
  compile_opt idl2

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      Self->Statusmessage, !ERROR_STATE.msg
      Catch, /cancel
      Return, 0
    endif
  endif

  if (~Self->Exportselection(davePtr, nameTag=nametag, /useTexlabels, /dave)) then Return, 0

  if (Ptr_valid(davePtr)) then begin
    if ((N_elements(nameTag) le 0) || (Strtrim(nameTag,2) eq '')) then nameTag='Untitled'

    ; Send data to DAVE Data Manager Folder
    Self.davetool->Adddaveptrtodatamanager, davePtr, nameTag

    msg = "New extry '"+nameTag+"' created in DAVE Data Manager"
    Self->Statusmessage, msg

    Heap_free, davePtr
  endif

  Return, 1
end


;===============================================================================
; Bt7psdTool::CombineToDM
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::CombineToDM
  compile_opt idl2

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      Self->Statusmessage, !ERROR_STATE.msg
      Catch, /cancel
      Return, 0
    endif
  endif

  if (~Self->Exportselection(davePtr, nameTag=nametag, /useTexlabels, /dave, /combine)) then Return, 0

  if (Ptr_valid(davePtr)) then begin
    if ((N_elements(nameTag) le 0) || (Strtrim(nameTag,2) eq '')) then nameTag='Untitled'

    ; Send data to DAVE Data Manager Folder
    Self.davetool->Adddaveptrtodatamanager, davePtr, nameTag

    msg = "New extry '"+nameTag+"' created in DAVE Data Manager"
    Self->Statusmessage, msg

    Heap_free, davePtr
  endif

  Return, 1
end


;===============================================================================
; Bt7psdTool::exportToPAN
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::ExportSelection, davePtr, nameTag=nameTag, useTexLabels=useTexLabels, combine=combine $
  ,dave=dave, ascii=ascii
  compile_opt idl2

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      Self->Statusmessage, !ERROR_STATE.msg
      Catch, /cancel
      Return, 0
    endif
  endif

  ; Check the sample type flag setting
  Self->Getproperty, sampTypeFlag=sampTypeFlag
  if (sampTypeFlag eq 1) then begin
    Self->Statusmessage, 'Cannot export single crystal data to ASCII or DAVE data Format!'
    Return, 0 ; can only export powder sample (type=0) or raw (type=2) data
  endif

  ; determine the independent variable required
  if (sampTypeFlag eq 0) then begin
    ; expect powder sample data
    Self->Getproperty, selectedIDs=selIDs,nSelectedIDs=nSel, xAxisVar=xAxisVar, indepVar2List=varList
    xvar = varList[xAxisVar]
  endif else begin
    ; raw data
    Self->Getproperty, xAxisVar=mode, yAxisVar=xAxisVar, indepVar3List=varList, nSelectedIDs=nSel, selectedIDs=selIDs
    ;if ((mode eq 0) || (mode eq 1)) then xvar = 'PSDChannel' ; Cts vs Channel || Integrated Cts (data points) vs Channel
    if (mode eq 0) then xvar = 'PSDChannelA4' ; Cts vs Channel
    if (mode eq 1) then xvar = 'PSDChannel' ; Integrated Cts (data points) vs Channel
    if (mode eq 2) then xvar = varList[xAxisVar] ; Integrated Cts (detector channels) vs ScanVariable
  endelse

  ; Are there any datasets selected?
  if (nSel eq 0) then begin
    Self->Statusmessage, 'No dataset selected!'
    Return, 0  ; exit if no dataset is currently selected
  endif

  ; Retrieve the selected datasets
  oData = []
  for i=0,nSel - 1 do begin
    oTmp = Self->Getbyidentifier(selIDs[i])
    if (~Obj_valid(oTmp) || ~Obj_isa(oTmp,'IDLitParameterSet')) then continue
    status = oTmp->Getmetadata('sampTypeFlag',sTypeFlag)
    if (sTypeFlag ne sampTypeFlag) then continue ; dataset's sample type flag must match current that of the app preference
    oData = [oData,oTmp]
  endfor
  nSel = N_elements(oData)
  if (nSel eq 0) then begin
    Self->Statusmessage, 'No valid dataset selected!'
    Return, 0  ; exit if no dataset is currently selected
  endif

  ; Convert selected datasets to ASCII or davePtr structure as necessary
  if (~Obj_valid(oData[0])) then Return, 0
  if (~Self->Retrievedaveptr(oData, xVar, davePtr, sampTypeFlag=sampTypeFlag, mode=mode, useTexLabels=useTexLabels $
    ,ascii=ascii, dave=dave, nameTag=nameTag, combine=combine)) then Return, 0

  ;oData[0]->GetProperty, name = nameTag

  Return, 1

end


;===============================================================================
; Bt7psdTool::exportToPAN
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::Exporttopan
  compile_opt idl2

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      Self->Statusmessage, !ERROR_STATE.msg
      Catch, /cancel
      Return, 0
    endif
  endif

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB
  notifyIDs = [wTLB,wTLB]
  Self->Getproperty, working_directory=workDir, data_directory=dataDir

  ;status = Self->ExportSelectionToDavePtr(davePtr)
  if (~Self->Exportselection(davePtr, nameTag=nametag, /useTexlabels, /dave)) then Return, 0

  ; Determine in top-level base widget ID for the main DAVE window
  ; and use this as the group_leader when PAN is called. This way the PAN instance will
  ; be killed automatically only when DAVE goes down rather than if the BT7 reduction module is killed.
  oUIMain = Self.davetool->Getui()
  oUIMain->Getproperty, group_leader = wTLBMain

  if (Ptr_valid(davePtr)) then  begin
    oVoid = Obj_new('OPAN',notifyID=[wTLBMain,wTLBMain],group_leader=wTLBMain $
      ,davePtr=davePtr,workDir=workDir,daveTool=Self.davetool,dataDir=dataDir)

    Heap_free, davePtr
  endif

  Return, 1
end


;===============================================================================
; Bt7psdTool::CombineToPAN
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::CombineToPAN
  compile_opt idl2

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      Self->Statusmessage, !ERROR_STATE.msg
      Catch, /cancel
      Return, 0
    endif
  endif

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB
  notifyIDs = [wTLB,wTLB]
  Self->Getproperty, working_directory=workDir, data_directory=dataDir

  ;status = Self->ExportSelectionToDavePtr(davePtr)
  if (~Self->Exportselection(davePtr, nameTag=nametag, /useTexlabels, /dave, /combine)) then Return, 0

  ; Determine in top-level base widget ID for the main DAVE window
  ; and use this as the group_leader when PAN is called. This way the PAN instance will
  ; be killed automatically only when DAVE goes down rather than if the BT7 reduction module is killed.
  oUIMain = Self.davetool->Getui()
  oUIMain->Getproperty, group_leader = wTLBMain

  if (Ptr_valid(davePtr)) then  begin
    oVoid = Obj_new('OPAN',notifyID=[wTLBMain,wTLBMain],group_leader=wTLBMain $
      ,davePtr=davePtr,workDir=workDir,daveTool=Self.davetool,dataDir=dataDir)

    Heap_free, davePtr
  endif

  Return, 1
end


;===============================================================================
; Bt7psdTool::saveProperties
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::SaveProperties
  compile_opt idl2

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB
  wChild = Widget_info(wTLB, /child)
  Widget_control, wChild, get_uvalue=sPtr

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      ;;print, 'Error handled!'
      eTitle = 'Bt7psdTool::saveProperties: Error encountered'
      eMsg = 'An error or unusual condition was encountered!'
      eMsg = [eMsg,'Please, report the following to the DAVE team:']
      eMsg = [eMsg,!error_state.msg]
      void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
      Catch, /cancel
      Return, 0
    endif
  endif

  Print, 'properties saved...'

  Return, 1
end


;===============================================================================
; Bt7psdTool::RetrieveDavePtr
;
; PURPOSE:
;   create a davePtr structure from the data in the specified dataset object
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::RetrieveDavePtr, oData, xVar, davePtr, sampTypeFlag=sampTypeFlag, mode=mode, useTexLabels=useTexLabels $
  ,dave=dave, ascii=ascii, nameTag=nameTag, combine=combine
  compile_opt idl2

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      Self->Statusmessage, !ERROR_STATE.msg
      Catch, /cancel
      if (Ptr_valid(davePtr)) then Heap_free, davePtr
      Return, 0
    endif
  endif

  if (~Obj_valid(oData[0])) then Return, 0
  if (xVar eq '') then Return, 0

  davePtr = Ptr_new()
  nData = N_elements(oData)
  if (Keyword_set(dave) && (sampTypeFlag eq 2) && (mode eq 0)) then begin
    ;; if rawmode and Cts vs Channel handle slightly differenly
    ;; - export 2D data
    ;; - dim 1 is the PSD channels in 2theta or index nos
    ;; - dim 2 is the scan variable or data point nos

    Self->Getproperty, calibParamsisSet=calibParamsisSet, maskFlag=maskFlag $
      , MONSCALEVALUE=monScaleVal, NORMALIZETO=normTo, effNormFlag=effFlag,dpntIndex=dpntIndex
    moreThanOne = 0
    for i = 0, nData-1 do begin
      if (~Obj_valid(oData[i])) then continue

      status = oData[i]->Getmetadata('CHDELA4',chDelA4)

      ; Dim 1
      if (calibParamsisSet) then begin
        ; Determine the A4 accross PSD from norminal A4 and delta A4 (= A4o- DelA4)
        ; and set this to the PSDChannelA4 object before plotting
        oA4 = oData[i]->Getbyname('A4')
        status = oA4->Getdata(A4o)
        index = (dpntIndex > 0) < (N_elements(A4o) - 1) ; 0 < xAxisVar < npts-1
        xvals = A4o[index] - chDelA4
        oX = oData[i]->Getbyname('PSDChannelA4')
      endif else begin
        ; just use the PSD Channel index
        oX = oData[i]->Getbyname('PSDChannel')
        status = oX->Getdata(xvals)
      endelse

      ; Dim 2
      ; If the scan variable was identified from the raw data, then use it as 2nd dim
      ; else use the data point indices
      if (moreThanOne eq 0) then begin
        status = oData[i]->Getmetadata('INDEP_VAR_TAG',indep_var_tag)
        oY = oData[i]->Getbyname(indep_var_tag)
        if (~Obj_valid(oY)) then begin
          indep_var_tag = 'Data_Index'
          oY = oData[i]->Getbyname(indep_var_tag)
        endif
        if (~Obj_valid(oY)) then continue
        status = oY->Getdata(yvals)
      endif else begin
        ; retrieve the same scan var from subsequent datasets
        oY = oData[i]->Getbyname(indep_var_tag)
        if (~Obj_valid(oY)) then continue
        status = oY->Getdata(yvals)
      endelse

      ; Intensity
      status = oData[i]->Getmetadata('OriginalCounts',counts)
      error = counts
      index = Where(error le 0.0,cnt)
      if (cnt gt 0) then error[index] = 1.0
      error = Sqrt(error)


      ; efficiency correction
      if (effFlag) then begin
        status = oData[i]->Getmetadata('CHEFF',chEff)
        counts = Temporary(counts)/chEff
        error = Temporary(error)/Sqrt(chEff)
      endif

      ;; Mask bad channels
      sBadChans = Self.maskeddets
      maskedChansExist = ~Strcmp(sBadChans,'')
      if (maskFlag && maskedChansExist) then begin
        status = Compactstring2intvector(sBadChans, badChans)
        badChanIndex = badChans - 1   ; convert channel nos to 0-based channel index
        ; Apply mask by simple replacing the counts in the masked channels by NaNs
        ; Leave error variable untouched
        counts[badChanIndex,*] = !values.f_nan
        error[badChanIndex,*] = 0.0
      endif


      ;; Apply monitor normalization
      case normTo of
        0: begin
          status = oData[i]->Getmetadata('MON',mon)
          monScale = monScaleVal/mon
        end

        1: begin
          if (~Isa(time)) then begin    ; may have retrieve time already
            status = oData[i]->Getmetadata('TIME',time)
          endif
          monScale = monScaleVal/time
        end

        else: monScale = monScaleVal
      endcase
      counts = Temporary(counts)*monScale
      error = Temporary(error)*monscale

      if (moreThanOne gt 0) then begin
        aggY = [aggY, yvals]
        if (N_elements(yvals) eq 1) then begin
          ; ==> counts and error are vectors of length n so reform to an nx1
          ; array so aggregation statements can work
          counts = Reform(counts,N_elements(counts),1)
          error = Reform(error,N_elements(error),1)
        endif
        aggCnts = Transpose([Transpose(aggCnts),Transpose(counts)])
        aggErr = Transpose([Transpose(aggErr),Transpose(error)])
      endif else begin
        aggY = yvals
        aggCnts = counts
        aggErr = error
      endelse

      moreThanOne++

      if (i eq 0) then begin
        xLabel = ''
        if (oX->Getmetadata('LONG_NAME',Label)) then xLabel += label
        xUnits = ''
        if (oX->Getmetadata('UNITS',units)) then xUnits += units
        yLabel = ''
        if (oY->Getmetadata('LONG_NAME',Label)) then yLabel += label
        yUnits = ''
        if (oY->Getmetadata('UNITS',units)) then yUnits += units
        zLabel = 'Counts'
      endif
    endfor

    counts = aggCnts
    error = aggErr
    yvals = aggY

    ; sort in increasing yvals
    if (N_elements(yvals) gt 1) then begin
      yindex = Sort(yvals)
      yvals = yvals[yindex]
      counts = counts[*,yindex]
      error = error[*,yindex]
      Self->Mergedupgroups, yvals, counts, error, tolerance=0.001
    endif

    status = Create_dave_pointer(davePtr, qty=counts, xvals=xvals, yvals=yvals, err=error)
    if (~status) then begin
      msg = "Unable to allocate memory!"
      Self->Statusmessage, msg
      if (Ptr_valid(davePtr)) then Heap_free, davePtr
      Return, 0
    endif

    (*(*davePtr).datastrptr).commonstr.instrument = 'BT7'
    (*(*davePtr).datastrptr).commonstr.xlabel = xLabel
    (*(*davePtr).datastrptr).commonstr.xunits = xunits
    (*(*davePtr).datastrptr).commonstr.xtype = 'points'
    (*(*davePtr).datastrptr).commonstr.ylabel = yLabel
    (*(*davePtr).datastrptr).commonstr.yunits = yunits
    (*(*davePtr).datastrptr).commonstr.ytype = 'points'

    (*(*davePtr).datastrptr).commonstr.histlabel = zLabel
    (*(*davePtr).datastrptr).commonstr.histunits = ''
    (*(*(*davePtr).datastrptr).commonstr.treatmentptr) = ''

    status = oData[0]->Getmetadata('DATAPTRREF',dataPtr)  ; get dataPtr from first dataset to retrieve expt info
    if (Ptr_valid(dataPtr)) then begin
      specificStr = { $
        filename:(*dataPtr).filename, $
        monitor:(*dataPtr).monave, $
        orientation:(*(*dataPtr).orientation_ptr), $
        latticeparams:(*(*dataPtr).lattice_ptr), $
        mondspace:(*dataPtr).dspacem, $
        anadspace:(*dataPtr).dspacea, $
        pan_filler:!VALUES.f_nan, $
        pan_mask:Ptr_new(Bits2bytes(Finite(counts))) $
      }

      (*(*davePtr).datastrptr).specificptr = Ptr_new(specificStr)
    endif

    ; davePtr is fully defined so exit now
    Return, 1
  endif else if (nData gt 1 && Keyword_set(combine) && Keyword_set(dave) && (sampTypeFlag eq 0)) then begin
    ;; if powdermode and combined flag set then
    ;; - export 2D data
    ;; - dim 1 is the PSD scan var (usually ttheta)
    ;; - dim 2 is a user specified variable selected from (temp,E,MAGFIELD,2theta,A1,A2,A3,A4,A5,A6)


    ; Retrieve the yVals (to be used for 2nd dimension) for each dataset
    ; Also determine the smallest xbin by examining the xvals from all datasets
    minXbin = 0.1D
    yVar = (*Self.combvarlist)[self.combvarval]
    yVals = []
    filenames = []
    for i = 0,nData-1 do begin
      oX = oData[i]->Getbyname(xVar)
      status = oX->Getdata(xv)
      nx = N_elements(xv)
      if (nx gt 2) then minXbin = minXbin < Min(xv[1:nx-1] - xv[0:nx-2])   ; accumulate the smallest x bin width
      ;oY = oData[i]->Getbyname(yVar)
      ;status = oY->Getdata(yv)
      status = oData[i]->Getmetadata('DATAPTRREF',dataPtr)
      tagnames = Tag_names(*dataPtr)
      yind = Where(tagnames eq yVar, yfound)
      if (yfound ne 1) then begin
        Self->Statusmessage, 'The combining variable data could not be found in the dataset!'
        Return, 0
      endif
      yVals = [yVals,Mean(*((*dataPtr).(yind)))]    ; take the mean of the yv column to be the yval of each dataset
      oData[i]->Getproperty, name = fname
      filenames = [filenames,fname]
    endfor

    ; sort the datasets in terms of increasing yvals
    index = Sort(yvals)
    yvals = yvals[index]
    oData = oData[index]
    ptol = 0.05*Abs(minXbin)  ; default o 5% of smallest x bin width
    mtol = -0.05*Abs(minxbin) ;-0.001

    ; Determine the agregate x-axis range that overlaps all datasets
    for i = 0,nData-1 do begin
      oX = oData[i]->Getbyname(xVar)
      status = oX->Getdata(xv)
      xv =  xv[Sort(xv)]  ; ensure x is in ascending order
      if (i eq 0) then xVals = xv
      nx = N_elements(xVals)
      index1 = Where((xv-xVals[0]) lt mtol,cnt1)        ;locate any xv values that are smaller than xVals within tol
      index2 = Where((xv-xVals[nx-1]) gt ptol,cnt2)         ;locate any xv values that are larger than xVals within tol
      if (cnt1 gt 0) then xVals = [xv[index1],xVals]    ; Append any such values found either below or above the exsting values
      if (cnt2 gt 0) then xVals = [xVals,xv[index2]]
    endfor

    ; Now put the final data set together
    nx = N_elements(xVals)
    ny = N_elements(yVals)
    z = Dblarr(nx,ny)
    dz = Dblarr(nx,ny)
    mon = Fltarr(nx,ny)
    sf = Fltarr(nx,ny) + 1.0   ;<-- records where data consists of overlapping data points
    for i = 0,nData-1 do begin
      oX = oData[i]->Getbyname(xVar)
      status = oX->Getdata(xnew)
      index = Sort(xnew)
      xnew =  xnew[index]  ; ensure x is in ascending order
      nxnew = N_elements(xnew)

      oZ = oData[i]->Getbyname('Counts')
      status = oZ->Getdata(znew)
      status = oZ->Getmetadata('MON',mnew)
      oErr = oData[i]->Getbyname('Error')
      status = oErr->Getdata(dznew)

      mnew = znew*0.0 + mnew[0]   ; this asusmes the monitor is constant vs x thus just recording a scalar value for each dataset
      znew = znew[index]
      dznew = dznew[index]
      sfnew = znew*0.0 + 1.0

      if i eq 0 then monScale = mnew[0] ; assign monitor scale to first point of first dataset

      if (i eq 0) then begin
        xLabel = ''
        if (oX->Getmetadata('LONG_NAME',Label)) then xLabel = label
        xUnits = ''
        if (oX->Getmetadata('UNITS',units)) then xUnits = units
        yLabel = ''
        oY = oData[i]->Getbyname(yVar)
        if (oY->Getmetadata('LONG_NAME',Label)) then yLabel += label
        yUnits = ''
        if (oY->Getmetadata('UNITS',units)) then yUnits += units
        zLabel = ''
        if (oZ->Getmetadata('LONG_NAME',Label)) then zLabel = label
        zUnits = ''
        if (oZ->Getmetadata('UNITS',units)) then zUnits = units
      endif

      void = Where(Abs(xnew-xVals) gt ptol,notTheSame)
      if (notTheSame eq 0) then notTheSame = nx ne nxnew
      if (notTheSame gt 0) then begin ; interpolate
        x0_le_xnew0 = ((xVals[0] - xnew[0]) lt mtol) || (xVals[0] eq xnew[0])
        xn_ge_xnewn = ((xVals[nx-1] - xnew[nxnew-1]) gt ptol) || (xValsx[nx - 1] eq xnew[nxnew - 1])
        if (x0_le_xnew0 or xn_ge_xnewn) then begin
          ;; avoid any extrapolation by running interpol() only for
          ;; values of x that lie within xnew
          x_ge_xnew0 = ((xVals - xnew[0]) gt mtol) or ((xVals - xnew[0]) eq 0)
          x_le_xnewn = ((xVals - xnew[nxnew-1]) lt ptol) or ((xVals - xnew[nxnew-1]) eq 0)
          inIndex = Where(x_ge_xnew0 and x_le_xnewn, inCnt $
            ,complement=outIndex,ncomplement=outCnt)
          if (inCnt gt 0) then begin
            xValid = xVals[inIndex]
            zinterp = Interpol(znew,xnew,xValid)
            dzinterp = Interpol(dznew,xnew,xValid)
            minterp = Interpol(mnew,xnew,xValid)
            z[inIndex,i] = zinterp
            dz[inIndex,i] = dzinterp
            mon[inIndex,i] = minterp
          endif
          if (outCnt gt 0) then begin
            ; value is undefined so use a NaN
            z[outIndex,i] = !values.d_nan
            dz[outIndex,i] = !values.d_nan
            mon[outIndex,i] = 0.0 ;monScale
            sf[outIndex,i] = 0.0
          endif
        endif
      endif else begin
        z[*,i] = znew
        dz[*,i] = dznew
        mon[*,i] = mnew
      endelse
    endfor
    ; Rescale monitor to that of the first data point of the first dataset
    mon = mon/monScale

    ; Look for duplicate y values and merge the corresponding groups in z and dz
    dims = Size(z,/dimensions)
    n_x = dims[0]
    n_y = dims[1]
    i = 0
    while (i lt n_y-1) do begin
      index = i
      for j = i, n_y-2 do begin
        diff = Abs(yVals[i] - yVals[j+1])
        if (diff le ptol) then begin
          index = [index,j+1]
        endif else begin
          break
        endelse
      endfor
      i = j + 1
      ymean = Mean(yVals[index]) ;(Moment(y[index],maxmoment=1))[0]
      nIndex = N_elements(index)
      if (nIndex gt 1) then begin
        c1 = Total(z[*,index],2,/NAN)
        e1 = Sqrt(Total(dz[*,index]^2,2,/NAN))
        m1 = Total(mon[*,index], 2, /NAN)
        s1 = Total(sf[*,index],2, /NAN)
      endif else begin
        c1 = z[*,index]
        e1 = dz[*,index]
        m1 = mon[*,index]
        s1 = sf[*,index]
      endelse
      if (Size(c1,/n_dimensions) eq 1) then begin
        c1 = Reform(c1,n_x,1)
        e1 = Reform(e1,n_x,1)
      endif
      if (N_elements(newy) eq 0) then begin
        newy = ymean
        newc = c1
        newe = e1
        newm = m1
        news = s1
      endif else begin
        newy = [newy,ymean]
        newc = Transpose([Transpose(newc),Transpose(c1)])
        newe = Transpose([Transpose(newe),Transpose(e1)])
        newm = Transpose([Transpose(newm),Transpose(m1)])
        news = Transpose([Transpose(news),Transpose(s1)])
      endelse
      ;   if (i gt 6189) then begin
      ;      print,i
      ;   endif
    endwhile
    lastIndex = index[N_elements(index)-1]
    if (lastIndex eq n_y-2) then begin
      ; the last group was not processed so include it.
      newy = [newy,yVals[n_y-1]]
      c1 = Reform(z[*,n_y-1],n_x,1)
      e1 = Reform(dz[*,n_y-1],n_x,1)
      m1 = Reform(mon[*,n_y-1],n_x,1)
      s1 = Reform(sf[*,n_y-1],n_x,1)
      newc = Transpose([Transpose(newc),Transpose(c1)])
      newe = Transpose([Transpose(newe),Transpose(e1)])
      newm = Transpose([Transpose(newm),Transpose(m1)])
      news = Transpose([Transpose(news),Transpose(s1)])
    endif
    y = newy
    z = newc
    dz = newe
    mon = newm
    sf = news

    ; normalize results
    index = Where(mon le 0.0, cnt)
    if (cnt gt 0) then mon[index] = 1.0
    z = z/mon
    dz = dz/mon

    ;  notAlreadynormalized = 0  ; assume this for now!
    ;
    ;  ;monitor = Transpose(mon*monscale) ; used below
    ;
    ;  ; Normalize data and error by monitor
    ;  if (notAlreadyNormalized) then begin
    ;    ; checking notAlreadynormalized ensures we don't re-normalize reduced data that was previously normalized
    ;    index = Where(mon le 0.0, cnt)
    ;    if (cnt gt 0) then mon[index] = 1.0
    ;    z = z/mon
    ;    dz = dz/mon
    ;  endif else begin
    ;    ; the data were previously normalised so all input data are on same monitor
    ;    ; So simply deal with overlapping data now by using sf which essentially contains
    ;    ; a record of the overlaps
    ;    index = Where(sf le 0.0, cnt)
    ;    if (cnt gt 0) then sf[index] = 1.0
    ;    z = z/sf
    ;    dz = dz/sf
    ;  endelse


    ;treatment = [treatment,'_________________________________________' $
    treatment = ['_________________________________________','BT7 PSD Data Reduction' $
      ,'The files listed below were combined', filenames]

    status = oData[0]->Getmetadata('DATAPTRREF',dataPtr)

    status = Create_dave_pointer(davePtr, qty=z, err=dz, xvals=xvals, yvals=y)
    if (~status) then begin
      msg = "Unable to allocate memory!"
      Self->Statusmessage, msg
      if (Ptr_valid(davePtr)) then Heap_free, davePtr
      Return, 0
    endif

    (*(*davePtr).datastrptr).commonstr.instrument = 'BT7'
    (*(*davePtr).datastrptr).commonstr.xlabel = xLabel
    (*(*davePtr).datastrptr).commonstr.xunits = xUnits
    (*(*davePtr).datastrptr).commonstr.xtype = 'points'
    (*(*davePtr).datastrptr).commonstr.ylabel = yLabel
    (*(*davePtr).datastrptr).commonstr.yunits = yUnits
    (*(*davePtr).datastrptr).commonstr.ytype = 'points'

    (*(*davePtr).datastrptr).commonstr.histlabel = zLabel ;'Counts'
    (*(*davePtr).datastrptr).commonstr.histunits = zUnits
    (*(*(*davePtr).datastrptr).commonstr.treatmentptr) = treatment

    if (Ptr_valid(dataPtr)) then begin
      specificStr = { $
        filename:(*dataPtr).filename, $
        monitor:(*dataPtr).monave, $
        orientation:(*(*dataPtr).orientation_ptr), $
        latticeparams:(*(*dataPtr).lattice_ptr), $
        mondspace:(*dataPtr).dspacem, $
        anadspace:(*dataPtr).dspacea, $
        pan_filler:!VALUES.f_nan, $
        pan_mask:Ptr_new(Bits2bytes(Finite(z))) $
      }

      (*(*davePtr).datastrptr).specificptr = Ptr_new(specificStr)
    endif

    oData[0]->Getproperty, name = nameTag
    nameTag += '-combined'

  endif else begin

    ; Retrieve and aggregate the data from all selected datasets
    n = N_elements(oData)
    xvals = []
    yvals = []
    evals = []
    for i = 0,n-1 do begin
      oX = oData[i]->Getbyname(xVar)
      status = oX->Getdata(x1)
      oZ = oData[i]->Getbyname('Counts')
      status = oZ->Getdata(y1)
      oErr = oData[i]->Getbyname('Error')
      status = oErr->Getdata(e1)
      xvals = [xvals,x1]
      yvals = [yvals,y1]
      evals = [evals,e1]
    endfor

    index = Sort(xvals)
    xvals = xvals[index]
    yvals = yvals[index]
    evals = evals[index]

    ; Merge the selected datasets so that overlapping data are averaged
    ; the new x bins are set to the unique x values.
    Dm_step_bin,0.0,xvals,ydat=yvals,yerr=evals,uniq_val=xvals[Uniq(xvals)],avgsum=0,/checkfinite

    xLabel = ''
    if (oX->Getmetadata('LONG_NAME',Label)) then xLabel += label
    xUnits = ''
    if (oX->Getmetadata('UNITS',units)) then xUnits += units
    yLabel = 'Counts'

    if (~Keyword_set(useTexLabels)) then begin
      xLabel = Tex2idl(xLabel)
      xUnits = Tex2idl(xunits)
      yLabel = Tex2idl(yLabel)
    endif

    oData[0]->Getproperty, name = nameTag
    if (n gt 1) then begin
      oData[n-1]->Getproperty, name=nm1
      nameTag = nameTag+'-to-'+nm1
    endif

    ; convert to ASCII struct if required
    if (Keyword_set(ascii)) then begin
      struct = {xvals:xvals,yvals:yvals,evals:evals,xlabel:xlabel,xunits:xunits,ylabel:ylabel}
      davePtr = Ptr_new(struct)
    endif

    ; convert to davePtr struct if required
    if (Keyword_set(dave)) then begin
      status = oData[0]->Getmetadata('DATAPTRREF',dataPtr)

      status = Create_dave_pointer(davePtr, qty=yvals, xvals=xvals, err=evals)
      if (~status) then begin
        msg = "Unable to allocate memory!"
        Self->Statusmessage, msg
        if (Ptr_valid(davePtr)) then Heap_free, davePtr
        Return, 0
      endif

      (*(*davePtr).datastrptr).commonstr.instrument = 'BT7'
      (*(*davePtr).datastrptr).commonstr.xlabel = xLabel
      (*(*davePtr).datastrptr).commonstr.xunits = xunits
      (*(*davePtr).datastrptr).commonstr.xtype = 'points'
      (*(*davePtr).datastrptr).commonstr.ylabel = ''
      (*(*davePtr).datastrptr).commonstr.yunits = ''
      (*(*davePtr).datastrptr).commonstr.ytype = 'points'

      (*(*davePtr).datastrptr).commonstr.histlabel = yLabel
      (*(*davePtr).datastrptr).commonstr.histunits = ''
      (*(*(*davePtr).datastrptr).commonstr.treatmentptr) = ''

      if (Ptr_valid(dataPtr)) then begin
        specificStr = { $
          filename:(*dataPtr).filename, $
          monitor:(*dataPtr).monave, $
          orientation:(*(*dataPtr).orientation_ptr), $
          latticeparams:(*(*dataPtr).lattice_ptr), $
          mondspace:(*dataPtr).dspacem, $
          anadspace:(*dataPtr).dspacea, $
          pan_filler:!VALUES.f_nan, $
          pan_mask:Ptr_new(Bits2bytes(Finite(yvals))) $
        }

        (*(*davePtr).datastrptr).specificptr = Ptr_new(specificStr)
      endif
    endif
  endelse


  Return, 1
end


;===============================================================================
;+
; Bt7psdTool::WriteProjectAs
;
; PURPOSE:
;   save project (data plus state) to file
;
; PARAMETERS:
;
; KEYWORDS:
;-
function Bt7psdtool::WriteProjectAs
  compile_opt idl2

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      ;;print, 'Error handled!'
      eTitle = 'Bt7psdTool::writeProjectAs: Error encountered'
      eMsg = 'An error or unusual condition was encountered!'
      eMsg = [eMsg,'Please, report the following to the DAVE team:']
      eMsg = [eMsg,!error_state.msg]
      void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
      Catch, /cancel
      Return, 0
    endif
  endif

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB
  wChild = Widget_info(wTLB, /child)
  Widget_control, wChild, get_uvalue=sPtr

  Self->Getproperty, nSamp=_nSamp, working_directory=workDir
  if (_nSamp le 0) then begin
    msg = 'No data in current session so cannot proceed with save action!'
    Self->Statusmessage, msg
    Self->Errormessage, msg, severity=0, title='Save Unnecessary!'
    Return, 0
  endif


  projName = File_basename(Self.projname,/fold_case,'.tisv')
  oSamp = Self.sampcontref->Get(position = 0)
  if (Strcmp(projName,'Untitled',/fold_case) && Obj_valid(oSamp)) then begin
    oSamp->Getproperty, description=desc
    projName = File_basename(desc,/fold_case,'.bt7')
    ; replace spaces in filename with _
    while ((pos = Stregex(projName,' ')) ne -1) do Strput, projName,'_',pos
  endif
  title = "Specify filename to store session"
  ext = 'tisv'
  filter = ['*.tisv']
  projName = Dialog_pickfile(title=title,filter=filter,default_extension=ext $
    ,dialog_parent=wTLB, /write $
    ,/overwrite_prompt, file=projName+'.tisv' $
    ,path=workDir, get_path=new_workDir)

  if (Strcmp(projName,'')) then Return, 0

  Return, Self->Writeproject(/noPrompt, new_workDir=File_dirname(projName,/mark_dir), new_projName=File_basename(projName,/fold_case,'.tisv'))

end


;===============================================================================
;+
; Bt7psdTool::WriteProject
;
; PURPOSE:
;   save project (data plus state) to file
;
; PARAMETERS:
;
; KEYWORDS:
;-
function Bt7psdtool::WriteProject, noPrompt=noPrompt, new_workDir=new_workDir,new_projName=new_projName
  compile_opt idl2

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB
  wChild = Widget_info(wTLB, /child)
  Widget_control, wChild, get_uvalue=sPtr

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      ;;print, 'Error handled!'
      eTitle = 'Bt7psdTool::writeProject: Error encountered'
      eMsg = 'An error or unusual condition was encountered!'
      eMsg = [eMsg,'Please, report the following to the DAVE team:']
      eMsg = [eMsg,!error_state.msg]
      void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
      Catch, /cancel
      Return, 0
    endif
  endif

  ; save session preferences
  status = Self->Savepreferences(/skip_filesave)

  Self->Getproperty, sampTypeFlag=_sampTypeFlag, nSamp=_nSamp, nBkgd=_nBkgd $ ,nFast=_nFast $
    , minIntensity=_minIntensity, maxIntensity=_maxIntensity $
    , preferences=_prefStr, working_directory=workDir
  noData = (_nSamp le 0) && (_nBkgd le 0) ;&& (_nFast le 0)
  if (noData) then begin
    msg = 'No data in current session so cannot proceed with save action!'
    Self->Statusmessage, msg
    Self->Errormessage, msg, severity=0, title='Save Unnecessary!'
    Return, 0
  endif

  projName = (Keyword_set(new_projName))? new_projname : Self.projname
  if (Keyword_set(new_workDir)) then workDir = new_workDir

  if (Keyword_set(noPrompt)) then begin
    projName = workDir+projName+'.tisv'
  endif else begin
    projName = Self.projname
    oSamp = Self.sampcontref->Get(position = 0)
    if (Strcmp(projName,'Untitled',/fold_case) || Strcmp(projName,'')) then begin
      oSamp->Getproperty, description=desc
      projName = File_basename(desc,/fold_case,'.bt7')
      ; replace spaces in filename with _
      while ((pos = Stregex(projName,' ')) ne -1) do Strput, projName,'_',pos

      title = "Specify filename to store session"
      ext = 'tisv'
      filter = ['*.tisv']
      projName = Dialog_pickfile(title=title,filter=filter,default_extension=ext $
        ,dialog_parent=wTLB, /write $
        ,/overwrite_prompt, file=projName+'.tisv' $
        ,path=workDir, get_path=new_workDir)
      ;projName = dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
      ;                       ,/overwrite_prompt, file=projName+'.tisv',path=workDir, get_path=new_workDir)

    endif else projName = workDir+projName+'.tisv'
  endelse

  if (~Strcmp(projName,'')) then begin
    if (_nSamp gt 0) then _datasets = (Self.sampcontref->Get(/all))[0:_nSamp-1]
    if (_nBkgd gt 0) then _datasets = (N_elements(_datasets) gt 0)? $
      [_datasets,(Self.bkgdcontref->Get(/all))[0:_nBkgd-1]] : $
      (Self.bkgdcontref->Get(/all))[0:_nBkgd-1]
    ;   if (_nFast gt 0) then _datasets = (n_elements(_datasets) gt 0)? $
    ;                                     [_datasets,(Self.fastContRef->Get(/all))[0:_nFast-1]] : $
    ;                                     (Self.fastContRef->Get(/all))[0:_nFast-1]
    nd = N_elements(_datasets)
    _dataPtrs = Ptrarr(nd)
    for i=0,nd-1 do begin
      void = _datasets[i]->Getmetadata('DATAPTRREF',dataPtr)
      _dataPtrs[i] = dataPtr
    endfor

    ; Get PSD calibration info
    if (Self.calibparamsisset) then begin
      _calibInfo = {calibparamsisset:Self.calibparamsisset $
        ,calibparamsfilename:Self.calibparamsfilename $
        ,calibparamsbasefilename:Self.calibparamsbasefilename $
        ,chdela4:Self.chdela4 $
        ,chdelef:Self.chdelef $
        ,cheff:Self.cheff $
      }
    endif else _calibInfo = {calibparamsisset:Self.calibparamsisset}

    ; Get masking details
    Self->Getproperty, maskedDets=_maskedDets, maskFlag=_maskFlag

    Save, _datasets, _dataPtrs, _nSamp, _prefStr, _calibInfo, _nBkgd $, _nFast
      , _minIntensity, _maxIntensity, _sampTypeFlag, _maskedDets, _maskFlag $
      , description = 'BT7PSD Data Reduction Session' $
      , filename=projName, /compress
    if (Isa(new_workDir) && File_test(new_workDir,/directory)) then Self->Setproperty, working_directory=new_workDir

    msg = 'Session stored in: '+projName
    Self->Statusmessage, msg

    projName = File_basename(projName,/fold_case,'.tisv')
    Self.projname = projName
    Self->Setproperty, tool_filename=projName

    Self.modifiedflag = 0
  endif

  Return, 1
end


;===============================================================================
; Bt7psdTool::readProject
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function Bt7psdtool::ReadProject
  compile_opt idl2

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB
  wChild = Widget_info(wTLB, /child)
  Widget_control, wChild, get_uvalue=sPtr

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      ;;print, 'Error handled!'
      eTitle = 'Bt7psdTool::ReadProject: Error encountered'
      eMsg = 'An error or unusual condition was encountered!'
      eMsg = [eMsg,'Please, report the following to the DAVE team:']
      eMsg = [eMsg,!error_state.msg]
      void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
      Catch, /cancel
      if (Obj_valid(oSave)) then Obj_destroy, oSave
      Self->Enableupdates
      Return, 0
    endif
  endif

  filter = '*.tisv'
  Self->Getproperty, working_directory=workDir
  if (N_elements(title) eq 0) then title='Specify session to load'

  filename = Dialog_pickfile(title=title,/must_exist, dialog_parent=wTLB $
    ,filter=filter,path=workDir, get_path=newWorkDir)

  if (filename eq '') then Return, 0
  Self->Setproperty, work_directory=newWorkDir

  oSave = Obj_new('IDL_Savefile', filename)
  contents = oSave->Contents()
  Obj_destroy, oSave
  expectedDesc='BT7PSD Data Reduction Session'
  if (~Strcmp(contents.description,expectedDesc,/fold_case)) then begin
    msg = 'Not a valid BT7 PSD Reduction session file!'
    Self->Statusmessage, msg
    Self->Errormessage, msg, severity=1, title='Invalid file type!'
    Return, 0
  endif

  Restore, filename, restored_objects=oObj, /relaxed_structure_assignment
  nObj = N_elements(oObj)
  if (nObj le 0) then Return, 0

  ; Check whether or not to save current session before closing it
  if (Self.modifiedflag) then begin
    ; If our current state is dirty, prompt to save first.
    Self->Getproperty, working_directory=workDir
    outfile = workDir+Self.projname+'.tisv'
    status = self->Promptuseryesno( $
      "Save changes to " + outfile + "?", $
      answer, $
      DEFAULT_NO=0, $
      TITLE='Save', $
      /CANCEL)

    if (status && (answer eq 1)) then begin
      void = Self->Writeproject(/noPrompt)
    endif

  endif

  Self->Disableupdates

  ; delete all datasets in current session
  void = Self->Deletealldatasets(/noPrompt)

  projName = File_basename(filename,/fold_case,'.tisv')
  Self.projname = projName

  ; update preferences structure to most current definition
  status = Bt7psdreducpreferences(_prefStr,/updateVersion)

  Self->Setproperty, preferences=_prefStr, tool_filename=projName $
    , maxIntensity=_maxIntensity, minIntensity=_minIntensity, maskedDets=_maskedDets, maskFlag=_maskFlag
  Self->Setpropertyattribute, 'MASKEDDETS', userdef=_maskedDets, sensitive=(_maskFlag eq 1)
  ; PSD calibration stuff
  ; Only alter current calib info if one was saved with the project file!
  if (_calibInfo.calibparamsisset) then begin
    Self.calibparamsisset = _calibInfo.calibparamsisset
    Self.calibparamsbasefilename = _calibInfo.calibparamsbasefilename
    Self.calibparamsfilename = _calibInfo.calibparamsfilename
    Self.chdela4 = _calibInfo.chdela4
    Self.chdelef = _calibInfo.chdelef
    Self.cheff = _calibInfo.cheff
    Self->Setpropertyattribute, 'calibParamsBaseFilename', userdef=Self.calibparamsbasefilename
  endif
  Self->Setpropertyattribute, 'effNormFlag', sensitive=_calibInfo.calibparamsisset


  Self->Getproperty, maskFlag=mF, fastFlag=fF, xAxisVar=xAxisVar $
    , binWidths=binWidths, defaultIntensityFlag=defIntFlag, sampTypeFlag=sampTypeFlag
  Self->Setproperty, minBinWidth = binwidths[xAxisVar]
  noHide = (defIntFlag eq 0) && (sampTypeFlag eq 1)  ; don't hide if not using default intensity and single crystal sample
  Self->Setpropertyattribute, 'maxIntensity', hide=~noHide
  Self->Setpropertyattribute, 'minIntensity', hide=~noHide
  Self->Setpropertyattribute, 'MASKEDDETS', sensitive=mF
  Self->Setpropertyattribute, 'FASTVALUE', sensitive=fF
  Self->Setpropertyattribute, 'MONCORFLAG', sensitive=fF

  ; restore datasets
  nd = N_elements(_datasets)
  for i=0, nd-1 do begin
    oData = _datasets[i]
    Self->Restoredataversion, oData
    oData->Getproperty, type=dataType
    case dataType of
      'samp': begin
        Self->Addbyidentifier, 'Sample Data Manager', oData, position=0
        Self.sampcontref->Add, oData
      end

      'bkgd': begin
        Self->Addbyidentifier, 'Bkgd Data Manager', oData, position=0
        Self.bkgdcontref->Add, oData
      end

      else:

    endcase

    ; If samTypeFlag variable was not saved (this would be case for projects save before July, 2012),
    ; then get the value using the sampTypeFlag property of the first dataset
    if (N_elements(_sampTypeFlag) eq 0) then begin
      status = oData->Getmetadata('sampTypeFlag',_sampTypeFlag)
    endif
  endfor
  Self->Setproperty, sampTypeFlag=_samptypeFlag, typeCheck = 0


  Self.nsamp = _nSamp
  if (N_elements(_nBkgd) gt 0) then Self.nbkgd = _nBkgd


  ;Self->SetPropertyAttribute, 'SUMSAMPFLAG', sensitive=(Self.nSamp gt 0)
  ;
  ;Self->SetPropertyAttribute, 'SUMBKGDFLAG', sensitive=(Self.nBkgd gt 0)
  ;Self->SetPropertyAttribute, 'BKGDFLAG', sensitive=(Self.nBkgd gt 0)

  Self->Updatepropertysheet

  ;; Select a dataset and plot it
  if (_nSamp gt 0) then begin
    oItem = Self.sampcontref->Get(position = 0)
    dataType='samp'
  endif else if (_nBkgd gt 0) then begin
    oItem = Self.bkgdcontref->Get(position = 0)
    dataType='bkgd'
  endif

  if (Obj_valid(oItem)) then begin
    (*sPtr).itemid = oItem->Getfullidentifier()
    Cw_bt7psddatamanager_setselect, (*sPtr).wdm, (*sPtr).itemid, /clear, dataType=dataType ; select it

    Wd_bt7psdtool_sendplotevent, oUI, oItem  ; plot it
  endif

  Self.modifiedflag = 0
  Self->Updatepropertysheet
  Self->Refreshpropertysheet
  Self->Enableupdates
  Return, 1
end


;---------------------------------------------------------------------------
; Lifecycle Routines
;---------------------------------------------------------------------------
; Bt7psdTool::Init
;
; Purpose:
; The constructor of the Bt7psdTool object.
;
; Parameters:
; None.
;
function Bt7psdtool::Init, _REF_EXTRA=_EXTRA
  compile_opt idl2

  ;; Call our super class
  if (~self->Idlittool::init(_EXTRA=_extra)) then $
    Return, 0

  oSystem = self->_Getsystem()

  ; Specify current data version number
  ; Essentially, whevever the data structure used to store
  ; datasets changes the version number should be incremented to reflect
  ; this. When the version number changes, restoreDataVersion() must also
  ; be modified to handle restoring older version datasets to the
  ; current version.
  Self.dataversion = 1

  ; Add a 'DAVEDATA_MANAGER' service
  ;self->AddService, OBJ_NEW("DAVEsrvDatamanager", name="DAVEDATA_MANAGER")

  ; Create the data manager folders
  oSampFolder = Obj_new("IDLitDataManagerFolder", identifier='Sample Data Manager' $
    ,name='Sample', description='Sample Data Manager Container',tool=self)
  oBkgdFolder = Obj_new("IDLitDataManagerFolder", identifier='Bkgd Data Manager' $
    ,name='Background', description='Bkgd Data Manager Container',tool=self)
  self->Add, [oSampFolder,oBkgdFolder]


  self->Createfolders,'Operations/       ',NAME='', description='Horizontal Space'
  ;;---------------------------------------------------------------------
  ;;*** File Menu

  ;; create folders
  self->Createfolders,'Operations/File',NAME=Idlitlangcatquery('Menu:File')
  ;   self->createfolders,'Operations/File/New', $
  ;                       NAME=IDLitLangCatQuery('Menu:File:New')

  ;     self->RegisterOperation, 'iPlot', 'IDLitOpNewTool', $
  ;         IDENTIFIER='File/New/Plot'

  ;     self->RegisterOperation, 'iSurface', 'IDLitOpNewTool', $
  ;         IDENTIFIER='File/New/Surface'

  ;     self->RegisterOperation, 'iContour', 'IDLitOpNewTool', $
  ;         IDENTIFIER='File/New/Contour'

  ;     self->RegisterOperation, 'iImage', 'IDLitOpNewTool', $
  ;         IDENTIFIER='File/New/Image'

  ;     self->RegisterOperation, 'iVolume', 'IDLitOpNewTool', $
  ;         IDENTIFIER='File/New/Volume'

  ;     self->RegisterOperation, 'iMap', 'IDLitOpNewTool', $
  ;         IDENTIFIER='File/New/Map'

  ;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Open'), $
  ;  'IDLitopFileOpen', $
  ;  ACCELERATOR='Ctrl+O', $
  ;  DESCRIPTION='Open an existing data or image file', $
  ;  IDENTIFIER='File/Open', ICON='open'


  ;-----------------
  ;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Import'), $
  ;  'IDLitopImportData', $
  ;  IDENTIFIER='File/Import', $
  ;  /SEPARATOR
  ;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Export'), $
  ;  'IDLitopExportData',icon='camera', $
  ;  IDENTIFIER='File/Export',/separator



  self->Registeroperation, 'Open Session', $
    'DAVEopMenuItem',icon='open', IDENTIFIER='File/readProject'

  self->Registeroperation, 'Save Session', $
    'DAVEopMenuItem',icon='save', IDENTIFIER='File/writeProject'
  self->Registeroperation, 'Save Session As', $
    'DAVEopMenuItem',icon='Save_24', IDENTIFIER='File/writeProjectAs'

  ;-----------------
  ;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Save'), $
  ;  'IDLitopFileSave', $
  ;  ACCELERATOR='Ctrl+S', $
  ;  IDENTIFIER='File/Save', ICON='save', /SEPARATOR

  ;self->RegisterOperation, IDLitLangCatQuery('Menu:File:SaveAs'), $
  ;  'IDLitopFileSaveAs', $
  ;  IDENTIFIER='File/SaveAs', ICON='save'

  ;-----------------
  Self->Registeroperation,'Export Graphics...' $
    ,'DAVEopExportGraphics' $
    ,identifier='File/Export' $
    ,ACCELERATOR='Ctrl+E' $
    ,writertypes=['IDLDEST','IDLIMAGE'] $
    ,icon='export',/separator

  self->Registeroperation, Idlitlangcatquery('Menu:File:PrintPreview'), $
    'IDLitopPrintPreview', $
    DESCRIPTION='Print the contents of the active window', $
    IDENTIFIER='File/PrintPreview', ICON='print'

  self->Registeroperation, Idlitlangcatquery('Menu:File:Print'), $
    'IDLitopFilePrint', $
    ACCELERATOR='Ctrl+P', $
    DESCRIPTION='Print the contents of the active window', $
    IDENTIFIER='File/Print', ICON='print_24'


  self->Registeroperation, 'Save Preferences', $
    'DAVEopMenuItem',icon='save', IDENTIFIER='File/savePreferences',/separator

  self->Registeroperation, 'Reset Preferences (Default Values)', $
    'DAVEopMenuItem',icon='save', IDENTIFIER='File/resetPreferences'

  ;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Preferences'), $
  ;  'IDLitopBrowserPrefs', $
  ;  IDENTIFIER='File/Preferences', /SEPARATOR

  ;-----------------
  self->Registeroperation, 'Exit', 'DAVEopMenuItem', ACCELERATOR='Ctrl+Q', $
    IDENTIFIER='File/Exit', /SEPARATOR

  self->Registeroperation, 'ExitOp', 'DAVEopFileExit', IDENTIFIER='ExitOp'


  ;-----------
  ; Data Input Menu
  self->Createfolders,'Operations/Input',NAME='Data Input'

  self->Registeroperation, 'Load PSD Calibration Parameters file', $
    'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadCalibParams'
  self->Registeroperation, 'View Loaded PSD Calibration Parameters', $
    'DAVEopMenuItem',icon='open', IDENTIFIER='Input/ViewCalibParams'
  ;self->RegisterOperation, 'Channel Efficiency', $
  ;  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/PSD Calibration/loadChEfficiency'
  ;self->RegisterOperation, 'Channel A4 Spacing', $
  ;  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/PSD Calibration/loadChA4'
  ;self->RegisterOperation, 'Channel Ef Spacing', $
  ;  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/PSD Calibration/loadChEf'

  self->Registeroperation, 'Load Sample Data', $
    'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadSamp', /separator

  self->Registeroperation, 'Load Sample Data (NCNR ftp server)', $
    'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadSampFtp'

  self->Registeroperation, 'Load Background Data', $
    'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadBkgd', /separator

  self->Registeroperation, 'Load Background Data (NCNR ftp server)', $
    'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadBkgdFtp'

  self->Registeroperation, 'Delete All Loaded Data', $
    'DAVEopMenuItem',icon='open', IDENTIFIER='Input/deleteAllDatasets',/separator



  ;-----------
  ; Data Output Menu
  self->Createfolders,'Operations/Output',NAME='Data Output'
  ;
  ;self->RegisterOperation, 'Save output as DAVE file', $
  ;  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/saveAsDave', sensitive=0
  ;
  ;self->RegisterOperation, 'Save output as ASCII file', $
  ;  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/saveAsAscii', sensitive=0
  ;
  ;self->RegisterOperation, 'Export output to DAVE Data Maneger', $
  ;  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/exportToDaveDM', sensitive=0
  ;
  ;self->RegisterOperation, 'Fit output in PAN', $
  ;  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/exportToPAN',/separator, sensitive=0

  self->Registeroperation, 'Export Selection to Mslice (Single Crystal, powder)', $
    'DAVEopMenuItem',icon='save', IDENTIFIER='Output/Mslice'
  self->Registeroperation, 'Export Selection to Data Manager (Powder, Raw)', $
    'DAVEopMenuItem',icon='save', IDENTIFIER='Output/ExportToDaveDM',/separator
  self->Registeroperation, 'Save Selection as DAVE file (Powder, Raw)', $
    'DAVEopMenuItem',icon='save', IDENTIFIER='Output/SaveAsDave'
  self->Registeroperation, 'Save Selection as ASCII file (Powder, Raw)', $
    'DAVEopMenuItem',icon='save', IDENTIFIER='Output/SaveAsASCII'
  self->Registeroperation, 'Combine Selection to Data Manager (Powder)', $
    'DAVEopMenuItem',icon='save', IDENTIFIER='Output/combineToDM',/separator
  self->Registeroperation, 'Combine Selection to DAVE file (Powder)', $
    'DAVEopMenuItem',icon='save', IDENTIFIER='Output/combineToDave'
  self->Registeroperation, 'Fit Selection in PAN (Powder, Raw)', $
    'DAVEopMenuItem',icon='save', IDENTIFIER='Output/exportToPAN',/separator
  self->Registeroperation, 'Combine Selection to PAN (Powder)', $
    'DAVEopMenuItem',icon='save', IDENTIFIER='Output/combineToPAN'

  ;;---------------------------------------------------------------------
  ;; Create our File toolbar container.
  ;;
  ;self->Register, IDLitLangCatQuery('Menu:File:New'), 'IDLitOpNewTool', $
  ;                IDENTIFIER='Toolbar/File/NewTool', ICON='new'
  ;self->Register, IDLitLangCatQuery('Menu:File:Open'), $
  ;                PROXY='Operations/File/Open', $
  ;                IDENTIFIER='Toolbar/File/Open'
  ;self->Register, IDLitLangCatQuery('Menu:File:Save'), $
  ;                PROXY='Operations/File/Save', $
  ;                IDENTIFIER='Toolbar/File/Save'
  self->Register, "Open Session", $
    PROXY='Operations/File/ReadProject', $
    IDENTIFIER='Toolbar/File/ReadProject'
  self->Register, "Save Session", $
    PROXY='Operations/File/WriteProject', $
    IDENTIFIER='Toolbar/File/WriteProject'
  self->Register, "Save Session As", $
    PROXY='Operations/File/WriteProjectAs', $
    IDENTIFIER='Toolbar/File/WriteProjectAs'
  self->Register, Idlitlangcatquery('Menu:File:Print'), $
    PROXY='Operations/File/Print', $
    IDENTIFIER='Toolbar/File/Print'
  self->Register, Idlitlangcatquery('Menu:File:PrintPreview'), $
    PROXY='Operations/File/PrintPreview', $
    IDENTIFIER='Toolbar/File/PrintPreview'
  self->Register, Idlitlangcatquery('Menu:File:Export'), $
    PROXY='Operations/File/Export', $
    IDENTIFIER='Toolbar/File/Export'


  ;;---------------------------------------------------------------------
  ;;*** Edit Menu

  self->Createfolders,'Operations/Edit',NAME=Idlitlangcatquery('Menu:Edit')

  self->Registeroperation, Idlitlangcatquery('Menu:Edit:Undo'), $
    'IDLitopUndo', $
    ACCELERATOR='Ctrl+Z', $
    IDENTIFIER='Edit/Undo', ICON='undo', /disable, $
    /IGNORE_AVAILABILITY

  self->Registeroperation, Idlitlangcatquery('Menu:Edit:Redo'), $
    'IDLitopRedo', $
    ACCELERATOR='Ctrl+Y', $
    IDENTIFIER='Edit/Redo', ICON='redo',/disable, $
    /IGNORE_AVAILABILITY

  ;; Clipboard...note these are proxied from the system registry!

  self->Registeroperation, Idlitlangcatquery('Menu:Edit:Cut'), $
    PROXY="/REGISTRY/OPERATIONS/CUT",$
    IDENTIFIER='Edit/Cut'

  self->Registeroperation, Idlitlangcatquery('Menu:Edit:Copy') , $
    PROXY='/REGISTRY/OPERATIONS/COPY', $
    IDENTIFIER='Edit/Copy'

  self->Registeroperation, Idlitlangcatquery('Menu:Edit:Paste') , $
    PROXY='/REGISTRY/OPERATIONS/Paste', $
    IDENTIFIER='Edit/Paste'

  self->Registeroperation, Idlitlangcatquery('Menu:Edit:PasteSpecial') , $
    PROXY='/REGISTRY/OPERATIONS/PASTESPECIAL', $
    IDENTIFIER='Edit/PasteSpecial'

  ;-----------------
  self->Registeroperation, Idlitlangcatquery('Menu:Edit:Delete') , $
    PROXY='/REGISTRY/OPERATIONS/Delete', $
    IDENTIFIER='Edit/Delete'

  self->Registeroperation, Idlitlangcatquery('Menu:Edit:SelectAll') , $
    'IDLitopSelectAll', $
    DESCRIPTION="Select all visualizations in the current view.", $
    IDENTIFIER='Edit/SelectAll', $
    ICON='select'


  ;-----------------
  self->Createfolders,'Operations/Edit/Grouping', $
    NAME=Idlitlangcatquery('Menu:Edit:Grouping')

  self->Registeroperation, Idlitlangcatquery('Menu:Edit:Group'), $
    'IDLitopGroup', $
    IDENTIFIER='Edit/Grouping/Group', $
    ICON='group', $
    /SEPARATOR

  self->Registeroperation, Idlitlangcatquery('Menu:Edit:Ungroup'), $
    'IDLitopUngroup', $
    IDENTIFIER='Edit/Grouping/Ungroup', $
    ICON='ungroup'

  ;self->createfolders,'Operations/Edit/Order', $
  ;                    NAME=IDLitLangCatQuery('Menu:Edit:Order')
  ;
  ;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:BringToFront'), $
  ;  'IDLitopBringToFront', $
  ;  IDENTIFIER='Edit/Order/BringToFront', $
  ;  ICON='front'
  ;
  ;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:SendToBack'), $
  ;  'IDLitopSendToBack', $
  ;  IDENTIFIER='Edit/Order/SendToBack', $
  ;  ICON='back'
  ;
  ;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:BringForward'), $
  ;  'IDLitopBringForward', $
  ;  IDENTIFIER='Edit/Order/BringForward', $
  ;  ICON='front'
  ;
  ;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:SendBackward'), $
  ;  'IDLitopSendBackward', $
  ;  IDENTIFIER='Edit/Order/SendBackward', $
  ;  ICON='back'


  ;;---------------------------------------------------------------------
  ;;*** Format Menu

  self->Createfolders,'Operations/Edit/Style', $
    NAME=Idlitlangcatquery('Menu:Style')

  self->Registeroperation, Idlitlangcatquery('Menu:Style:ApplyStyle') , $
    PROXY='/REGISTRY/OPERATIONS/Apply Style', $
    IDENTIFIER='Edit/Style/Apply Style'

  self->Registeroperation, $
    Idlitlangcatquery('Menu:Style:CreateStylefromSelection'), $
    'IDLitopStyleCreate', $
    IDENTIFIER='Edit/Style/Create Style', $
    ICON='style'

  self->Registeroperation, Idlitlangcatquery('Menu:Style:StyleEditor'), $
    'IDLitopStyleEditor', $
    IDENTIFIER='Edit/Style/StyleEditor', $
    ICON='style'


  ;;-----------------
  ;; Register here but make private. We only expose this operation
  ;; in the context menu, but we want it to be (de)sensitized along with
  ;; the rest of the Edit menu.
  ;self->RegisterOperation, 'Export to IDL...', 'IDLitopclExport', $
  ;  /PRIVATE, $
  ;  DESCRIPTION='Export Visualization Parameters to IDL Variables. ', $
  ;  IDENTIFIER='Edit/CLExport', $
  ;  /separator


  ;;-----------------
  ;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Parameters'), $
  ;  'IDLitopEditParameters', $
  ;  IDENTIFIER='Edit/EditParameters', $
  ;  ICON='binary', $
  ;  /separator
  self->Registeroperation, 'Edit Parameters','IDLitopEditParameters'

  Self->Registeroperation, 'SaveProperties','DAVEopMenuItem',identifier='Edit/SaveProperties'

  self->Registeroperation, Idlitlangcatquery('Menu:Edit:Properties'), $
    'IDLitopPropertySheet', $
    DESCRIPTION='Display the Property Sheet for the item', $
    IDENTIFIER='Edit/Properties', $
    ICON='propsheet'


  ;;---------------------------------------------------------------------
  ;; Create our Edit toolbar container.
  ;;
  self->Register, Idlitlangcatquery('Menu:Edit:Undo'), $
    PROXY='Operations/Edit/Undo', $
    IDENTIFIER='Toolbar/Edit/Undo'
  self->Register, Idlitlangcatquery('Menu:Edit:Redo'), $
    PROXY='Operations/Edit/Redo', $
    IDENTIFIER='Toolbar/Edit/Redo'
  self->Register, Idlitlangcatquery('Menu:Edit:Cut'), $
    PROXY="/REGISTRY/OPERATIONS/CUT",$
    IDENTIFIER='Toolbar/Edit/Cut'
  self->Register, Idlitlangcatquery('Menu:Edit:Copy'), $
    PROXY='/REGISTRY/OPERATIONS/COPY', $
    IDENTIFIER='Toolbar/Edit/Copy'
  self->Register, Idlitlangcatquery('Menu:Edit:Paste'), $
    PROXY='/REGISTRY/OPERATIONS/Paste', $
    IDENTIFIER='Toolbar/Edit/Paste'


  ;;---------------------------------------------------------------------
  ;;*** Insert menu

  self->Createfolders,'Operations/Insert', $
    NAME=Idlitlangcatquery('Menu:Insert')

  ;self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:Visualization'), 'IDLitopInsertVis', $
  ;;  IDENTIFIER='Insert/Visualization', ICON='view'

  self->Registeroperation, 'Insert Visualization','IDLitopInsertVis';, $
  ;  IDENTIFIER='Insert/Visualization', ICON='view'


  self->Registeroperation, Idlitlangcatquery('Menu:Insert:View'), $
    'IDLitopInsertView', $
    IDENTIFIER='Insert/View', ICON='view'

  self->Registeroperation, Idlitlangcatquery('Menu:Insert:DataSpace'), $
    'IDLitopInsertDataSpace';, $
  ;IDENTIFIER='Insert/Data Space', ICON='mcr'

  ;self->createfolders,'Operations/Insert/Axis', NAME=IDLitLangCatQuery('Menu:Insert:Axis')

  self->Registeroperation, Idlitlangcatquery('Menu:Insert:XAxis'), $
    'IDLitOpInsertAxisX';, IDENTIFIER='Insert/Axis/X Axis', ICON='mcr'
  self->Registeroperation, Idlitlangcatquery('Menu:Insert:YAxis'), $
    'IDLitOpInsertAxisY';, IDENTIFIER='Insert/Axis/Y Axis', ICON='mcr'
  self->Registeroperation, Idlitlangcatquery('Menu:Insert:ZAxis'), $
    'IDLitOpInsertAxisZ';, IDENTIFIER='Insert/Axis/Z Axis', ICON='mcr'


  ;;---------------------------------------------------------------------
  ;;*** Operations Menu
  self->Createfolders,'Operations/Operations', $
    NAME=Idlitlangcatquery('Menu:Operations')

  ;self->RegisterOperation, $
  ;  IDLitLangCatQuery('Menu:Operations:OperationsBrowser'), $
  ;  'IDLitopBrowserOperation', $
  ;  IDENTIFIER='Operations/Operations Browser' ; ,ICON='mcr'

  self->Createfolders,'Operations/Operations/Macros', $
    NAME=Idlitlangcatquery('Menu:Operations:Macros')

  self->Registeroperation, $
    Idlitlangcatquery('Menu:Operations:RunMacro'), $
    PROXY='/Registry/MacroTools/Run Macro', $
    IDENTIFIER='Operations/Macros/Run Macro'
  self->Registeroperation, $
    Idlitlangcatquery('Menu:Operations:StartRecording'), $
    PROXY='/Registry/MacroTools/Start Recording', $
    IDENTIFIER='Operations/Macros/Start Recording'
  self->Registeroperation, $
    Idlitlangcatquery('Menu:Operations:StopRecording'), $
    PROXY='/Registry/MacroTools/Stop Recording', $
    IDENTIFIER='Operations/Macros/Stop Recording'
  self->Registeroperation, $
    Idlitlangcatquery('Menu:Operations:MacroEditor'), $
    PROXY='/Registry/MacroTools/Macro Editor', $
    IDENTIFIER='Operations/Macros/Macro Editor'

  ;self->RegisterOperation, $
  ;  IDLitLangCatQuery('Menu:Operations:Statistics'), $
  ;  'IDLitopStatistics', $
  ;  DESCRIPTION='Display statistics for the selected item', $
  ;  IDENTIFIER='Operations/Statistics', ICON='sum', /SEPARATOR
  ;
  ;;self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:Histogram'), $
  ;;  'IDLitopHistogram', $
  ;;  DESCRIPTION='Perform the histogram operation on the selected item', $
  ;;  IDENTIFIER='Operations/Histogram', ICON='hist'
  ;
  self->Createfolders,'Operations/Operations/Filter', $
    NAME=Idlitlangcatquery('Menu:Operations:Filter')

  ;self->RegisterOperation, $
  ;  IDLitLangCatQuery('Menu:Operations:Convolution'), $
  ;  'IDLitopConvolution', $
  ;  DESCRIPTION='Perform the convolution operation on the selected item', $
  ;  IDENTIFIER='Operations/Filter/Convolution', ICON='sum'
  ;
  self->Registeroperation, $
    Idlitlangcatquery('Menu:Operations:Median'), $
    'IDLitopMedianFilter', $
    DESCRIPTION='Perform the median filter operation on the selected item', $
    IDENTIFIER='Operations/Filter/Median', ICON='sum'

  self->Registeroperation, Idlitlangcatquery('Menu:Operations:Smooth'), $
    'IDLitopSmooth', $
    DESCRIPTION='Perform the smooth operation on the selected item', $
    IDENTIFIER='Operations/Filter/Smooth', ICON='sum'

  self->Createfolders,'Operations/Operations/Rotate', $
    NAME=Idlitlangcatquery('Menu:Operations:Rotate')

  self->Registeroperation, $
    Idlitlangcatquery('Menu:Operations:RotateLeft'), $
    'IDLitopRotateLeft', $
    DESCRIPTION='Rotate left by 90 degrees', $
    IDENTIFIER='Operations/Rotate/RotateLeft', $
    ICON='rotate'

  self->Registeroperation, $
    Idlitlangcatquery('Menu:Operations:RotateRight'), $
    'IDLitopRotateRight', $
    DESCRIPTION='Rotate right by 90 degrees', $
    IDENTIFIER='Operations/Rotate/RotateRight', $
    ICON='rotate'

  self->Registeroperation, $
    Idlitlangcatquery('Menu:Operations:RotateByAngle'), $
    'IDLitopRotateByAngle', $
    DESCRIPTION='Rotate by a specified angle', $
    IDENTIFIER='Operations/Rotate/RotateByAngle', $
    ICON='rotate'

  ;self->createfolders,'Operations/Operations/Transform', $
  ;                    NAME=IDLitLangCatQuery('Menu:Operations:Transform')
  ;
  ;self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:Resample'), $
  ;  'IDLitopResample', $
  ;  IDENTIFIER='Operations/Transform/Resample', ICON='sum'
  ;
  ;self->RegisterOperation, $
  ;  IDLitLangCatQuery('Menu:Operations:RotateData'), $
  ;  'IDLitopRotateData', $
  ;  DESCRIPTION='Rotate the data by a specified angle', $
  ;  IDENTIFIER='Operations/Transform/RotateData', $
  ;  ICON='sum'
  ;
  ;self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:ScaleData'), $
  ;  'IDLitopScaleFactor', $
  ;  DESCRIPTION='Scale the data by a given factor', $
  ;  IDENTIFIER='Operations/Transform/ScaleFactor', ICON='sum'
  ;

  ;self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:MapProjection'), $
  ;  'IDLitopMapProjection', $
  ;  IDENTIFIER='Operations/Map Projection', ICON='surface'


  ;;---------------------------------------------------------------------
  ;;*** Window Menu

  self->Createfolders,'Operations/Window', $
    NAME=Idlitlangcatquery('Menu:Window')

  ;;  Note: temporarily disabling ICON settings for browsers.
  ;self->RegisterOperation, IDLitLangCatQuery('Menu:Window:DataManager'), $
  ;  'IDLitopDataManager', $
  ;  IDENTIFIER='Window/Data Manager', $
  ;  ICON='prop'                   ; , ICON='mcr'

  ;     self->RegisterOperation,'Manipulator Browser','IDLitopBrowserManip', $
  ;         IDENTIFIER='Window/Manipulator Browser'; , ICON='mcr'

  ;     self->RegisterOperation, 'Tool Browser', 'IDLitopBrowserTool', $
  ;         IDENTIFIER='Window/Tool Browser'; , ICON='mcr'

  ;self->RegisterOperation, $
  ;  IDLitLangCatQuery('Menu:Window:VisualizationBrowser'), $
  ;  'IDLitopBrowserVis', $
  ;  IDENTIFIER='Window/Visualization Browser' ; , ICON='mcr'

  ;;-----------------
  Self->Registeroperation, 'Reset to Default Data Range', 'IDLitopRangeReset' $
    ,description='Reset to default data range', identifier='Window/Resetrange' $
    ,icon='range_reset'

  ;;--
  self->Createfolders,'Operations/Toolbar/Dataspace',name='Dataspace'
  self->Register, 'Reset to Default Data Range', $
    PROXY='Operations/Window/Resetrange', $
    IDENTIFIER='Toolbar/Dataspace/Resetrange'

  self->Createfolders,'Operations/Window/Canvas Zoom', $
    NAME=Idlitlangcatquery('Menu:Window:CanvasZoom')

  self->Registeroperation, '800%', 'IDLitopCanvasZoom', $
    IDENTIFIER='Window/Canvas Zoom/800%', $
    ICON='zoom', /CHECKED;, /SEPARATOR
  self->Registeroperation, '400%', 'IDLitopCanvasZoom', $
    IDENTIFIER='Window/Canvas Zoom/400%', $
    ICON='zoom', /CHECKED
  self->Registeroperation, '200%', 'IDLitopCanvasZoom', $
    IDENTIFIER='Window/Canvas Zoom/200%', $
    ICON='zoom', /CHECKED
  self->Registeroperation, '100%', 'IDLitopCanvasZoom', $
    IDENTIFIER='Window/Canvas Zoom/100%', $
    ICON='zoom', /CHECKED
  self->Registeroperation, '75%', 'IDLitopCanvasZoom', $
    IDENTIFIER='Window/Canvas Zoom/75%', $
    ICON='zoom', /CHECKED
  self->Registeroperation, '50%', 'IDLitopCanvasZoom', $
    IDENTIFIER='Window/Canvas Zoom/50%', $
    ICON='zoom', /CHECKED
  self->Registeroperation, '25%', 'IDLitopCanvasZoom', $
    IDENTIFIER='Window/Canvas Zoom/25%', $
    ICON='zoom', /CHECKED

  self->Registeroperation, Idlitlangcatquery('Menu:Window:ZoomonResize'), $
    'IDLitopZoomResize', $
    ICON='zoom', $
    IDENTIFIER='Window/ZoomResize', /CHECKED

  self->Registeroperation, Idlitlangcatquery('Menu:Window:Layout'), $
    'IDLitopWindowLayout', $
    IDENTIFIER='Window/Layout'

  ;-----------------

  self->Registeroperation, Idlitlangcatquery('Menu:Window:FittoView'), $
    'IDLitopFitToView', $
    IDENTIFIER='Window/FitToView', $
    ICON='fitwindow', /SEPARATOR

  ;;---------------------------------------------------------------------
  ;;*** Help Menu
  self->Createfolders,'Operations/Help', $
    NAME=Idlitlangcatquery('Menu:Help')


  self->Registeroperation, "User's Manual", 'DAVEopHelp', $
    IDENTIFIER='Help/BT7PSDReductionManual',helptopic='BT7PSD_REDUCTION'
  ;-----------------

  self->Registeroperation, 'About BT7PSD Data Reduction', 'BT7PSDopHelpAbout', $
    IDENTIFIER='Help/About BT7PSD',/separator

  self->Registeroperation, 'About DAVE', 'DAVEopHelpAbout', $
    IDENTIFIER='Help/About DAVE',/separator




  ; self->RegisterOperation, IDLitLangCatQuery('Menu:Help:HelponiTools'), $
  ;   'IDLitopHelpiTools', $
  ;   ACCELERATOR='F1', $
  ;   IDENTIFIER='Help/HelpiTools'
  ;
  ; self->RegisterOperation, $
  ;   IDLitLangCatQuery('Menu:Help:HelpontheiToolsDataManager'), $
  ;   'IDLitopHelpDataManager', IDENTIFIER='Help/HelpDataManager'
  ;
  ; self->RegisterOperation, $
  ;   IDLitLangCatQuery('Menu:Help:HelpontheiToolsParameterEditor'), $
  ;   'IDLitopHelpParamEditor', IDENTIFIER='Help/HelpParamEditor'
  ;
  ; self->RegisterOperation, $
  ;   IDLitLangCatQuery('Menu:Help:HelponSelectedItem'), $
  ;   'IDLitopHelpSelection', $
  ;   IDENTIFIER='Help/HelpSelection', /SEPARATOR
  ;
  ; self->RegisterOperation, IDLitLangCatQuery('Menu:Help:HelponthisiTool'), $
  ;   'IDLitopHelpTool', $
  ;   IDENTIFIER='Help/HelpTool'
  ;
  ;self->RegisterOperation, IDLitLangCatQuery('Menu:Help:AboutiTools'), $
  ;  'IDLitopHelpAbout', $
  ;  IDENTIFIER='Help/About iTools'


  ;;---------------------------------------------------------------------
  ;;*** Manipulators
  self->Registermanipulator, 'Arrow', 'IDLitManipArrow', $
    ICON='arrow', /DEFAULT, IDENTIFIER="ARROW", $
    DESCRIPTION=Idlitlangcatquery('Status:Framework:Select')

  self->Registermanipulator, 'Rotate', 'IDLitManipRotate', $
    ICON='rotate', IDENTIFIER="ROTATE", $
    DESCRIPTION=Idlitlangcatquery('Status:Framework:Rotate')

  self->Registermanipulator, 'View Pan', 'IDLitManipViewPan', $
    ICON='hand', IDENTIFIER="VIEWPAN", $
    DESCRIPTION=Idlitlangcatquery('Status:Framework:Pan')


  ;;---------------------------------------------------------------------
  ;;*** View Zoom Manipulator
  self->Registermanipulator, 'View Zoom', 'IDLitManipViewZoom', $
    IDENTIFIER='View/ViewZoom', ICON='zoom', $
    DESCRIPTION=Idlitlangcatquery('Status:Framework:ViewZoom')

  ;;---------------------------------------------------------------------
  ;; *** View Zoom Combobox

  ; Combobox is not available on True64 (OSF Alpha)
  useCombobox = ~(!VERSION.os eq 'OSF')
  self->Register, 'View Zoom', 'IDLitopViewZoom', $
    IDENTIFIER='Toolbar/View/ViewZoom', $
    DROPLIST_EDIT=useCombobox, $
    DROPLIST_ITEMS=['800%', $
    '400%', $
    '200%', $
    '150%', $
    '130%', $
    '100%', $
    '75%',  $
    '50%',  $
    '25%'], $
    DROPLIST_INDEX=4, $
    /SINGLETON

  ;;---------------------------------------------------------------------
  ;;*** Annotation Manipulators
  self->Registermanipulator, 'Text', 'IDLitAnnotateText', $
    ICON='text', IDENTIFIER="ANNOTATION/TEXT", $
    DESCRIPTION=Idlitlangcatquery('Status:Framework:AnnotateText')

  self->Registermanipulator, 'Line', 'IDLitAnnotateLine', $
    ICON='line', IDENTIFIER="ANNOTATION/LINE", $
    DESCRIPTION=Idlitlangcatquery('Status:Framework:AnnotateLine')

  self->Registermanipulator, 'Rectangle', 'IDLitAnnotateRectangle', $
    ICON='rectangl', IDENTIFIER="ANNOTATION/RECTANGLE", $
    DESCRIPTION=Idlitlangcatquery('Status:Framework:AnnotateRectangle')

  self->Registermanipulator, 'Oval', 'IDLitAnnotateOval', $
    ICON='ellipse', IDENTIFIER="ANNOTATION/OVAL", $
    DESCRIPTION=Idlitlangcatquery('Status:Framework:AnnotateOval')

  self->Registermanipulator, 'Polygon', 'IDLitAnnotatePolygon', $
    ICON='segpoly', IDENTIFIER="ANNOTATION/POLYGON", $
    DESCRIPTION=Idlitlangcatquery('Status:Framework:AnnotatePolygon')

  self->Registermanipulator, 'Freehand', 'IDLitAnnotateFreehand', $
    ICON='freehand', IDENTIFIER="ANNOTATION/FREEHAND", $
    DESCRIPTION='Click & drag to draw'



  ;;---------------------------------------------------------------------
  ;;*** DrawContext
  ;self->Register, 'Cut', $
  ;                PROXY="/REGISTRY/OPERATIONS/CUT",$
  ;                IDENTIFIER='ContextMenu/DrawContext/Cut'
  ;
  ;self->Register, 'Copy', $
  ;                PROXY='/REGISTRY/OPERATIONS/COPY', $
  ;                IDENTIFIER='ContextMenu/DrawContext/Copy'
  ;
  ;self->Register, 'Paste', $
  ;                PROXY='/REGISTRY/OPERATIONS/Paste', $
  ;                IDENTIFIER='ContextMenu/DrawContext/Paste'
  ;
  ;                                ;-----------------
  self->Register, 'Delete', $
    PROXY='/REGISTRY/OPERATIONS/Delete', $
    IDENTIFIER='ContextMenu/DrawContext/Delete'

  ;-----------------
  self->Register, 'Group', $
    PROXY='Operations/Edit/Grouping/Group', $
    IDENTIFIER='ContextMenu/DrawContext/Grouping/Group'

  self->Register, 'Ungroup', $
    PROXY='Operations/Edit/Grouping/Ungroup', $
    IDENTIFIER='ContextMenu/DrawContext/Grouping/Ungroup'
  ;
  ;self->Register, 'Bring To Front', $
  ;                PROXY='Operations/Edit/Order/BringToFront', $
  ;                IDENTIFIER='ContextMenu/DrawContext/Order/BringToFront'
  ;
  ;self->Register, 'Send To Back', $
  ;                PROXY='Operations/Edit/Order/SendToBack', $
  ;                IDENTIFIER='ContextMenu/DrawContext/Order/SendToBack'
  ;
  ;self->Register, 'Bring Forward', $
  ;                PROXY='Operations/Edit/Order/BringForward', $
  ;                IDENTIFIER='ContextMenu/DrawContext/Order/BringForward'
  ;
  ;self->Register, 'Send Backward', $
  ;                PROXY='Operations/Edit/Order/SendBackward', $
  ;                IDENTIFIER='ContextMenu/DrawContext/Order/SendBackward'
  ;
  ;                                ;-----------------
  ;self->Register, 'Export to IDL...', $
  ;                PROXY='Operations/Edit/CLExport', $
  ;                IDENTIFIER='ContextMenu/DrawContext/CLExport'

  ;-----------------
  ;self->Register, 'Parameters...', $
  ;                PROXY='Operations/Edit/EditParameters', $
  ;                IDENTIFIER='ContextMenu/DrawContext/EditParameters'

  ;self->Register, 'Save Graph Properties...', $
  ;                PROXY='Operations/Edit/SaveProperties', $
  ;                IDENTIFIER='ContextMenu/DrawContext/SaveProperties'

  self->Register, 'Modify Properties...', $
    PROXY='Operations/Edit/Properties', $
    IDENTIFIER='ContextMenu/DrawContext/Properties'

  ;;---------------------------------------------------------------------
  ;;*** CropContext
  ;self->Register, 'Crop...', 'IDLitopCropImage', $
  ;                DESCRIPTION='Crop the selected image', $
  ;                IDENTIFIER='ContextMenu/CropDrawContext/Crop', $
  ;                ICON='crop', $
  ;                /SINGLETON

  Self.sampcontref = Obj_new('IDL_Container') ;obj_new('IDLitContainer',name='SampContainer')
  Self.bkgdcontref = Obj_new('IDL_Container') ;obj_new('IDLitContainer',name='BkgdContainer')

  ;; Initialise data and Register Properties

  Self.samptypeflag = 1
  sampTyps = ['Powder','Single Crystal','Raw Data']
  Self.samptyps = Ptr_new(sampTyps)
  Self->Registerproperty, 'sampTypeFlag', enumlist=sampTyps, name='Sample Type' $
    ,description='Sample Type'
  hideIfPowder = (Self.samptypeflag eq 0)? 1 : 0
  ;hideIfNotPowder = (Self.sampTypeFlag eq 0)? 1 : 0

  Self.calibparamsbasefilename = ''
  Self->Registerproperty, 'calibParamsBaseFilename', userdef='', name='PSD Calib Parameter file' $
    ,description='Channel effieciency file'
  ;Self.chEffbaseFilename = ''
  ;Self->RegisterProperty, 'chEfFbaseFilename', userdef='', name='Calib: PSD Eff. file' $
  ;                      ,description='Channel effieciency file'
  ;
  ;Self.chDelA4baseFilename = ''
  ;Self->RegisterProperty, 'chDelA4baseFilename', userdef='', name='Calib: PSD A4 file' $
  ;                      ,description='Channel A4 Spacing file'
  ;
  ;Self.chDelEfbaseFilename = ''
  ;Self->RegisterProperty, 'chDelEfbaseFilename', userdef='', name='Calib: PSD Ef file' $
  ;                      ,description='Channel final energy file'

  Self.effnormflag = 1
  Self->Registerproperty, 'effNormFlag', enumlist=['No','Yes'], name='Apply Channel Eff Corr?' $
    ,description='Should channel effieciency correction be applied?', sensitive=0


  Self.nsamp = 0
  Self.nbkgd = 0

  Self.sumsampflag = 0
  Self->Registerproperty, 'sumSampFlag', enumlist=['No','Yes'], name='Sum Sample Data?' $
    ,description='Sum all loaded Sample data?', sensitive=Self.nsamp, hide=1

  Self.sumbkgdflag = 0
  Self->Registerproperty, 'sumBkgdFlag', enumlist=['No','Yes'], name='Sum Bkgd Data?' $
    ,description='Sum all loaded Bkgd data?', sensitive=Self.nbkgd, hide=1

  Self.indepvars1ptr = Ptr_new(['QX','QY','E','|Q|','2Theta','TEMP','MAGFIELD','PSDChannel'])
  Self.exportindex1ptr = Ptr_new([1,1,0,0,0,0,0,0])  ; used when exporting to Mslice
  Self.indepvars2ptr = Ptr_new(['2Theta','d-space','|Q|','E','TEMP','MAGFIELD','Data_Index'])
  Self.exportindex2ptr = Ptr_new([1,0,0,0,1,0,0])  ; used when exporting to Mslice
  Self.indepvars3ptr = Ptr_new(['Data_Index','A1','A2','A3','A4','A5','A6','H','K','L','E','TEMP','MAGFIELD'])
  Self.exportindex3ptr = Ptr_new([0,0,0,1,1,0,0,0,0,0,0,0,0])  ; used when exporting to Mslice
  Self.rawmodesptr = Ptr_new(['Counts vs Channel','Integrated Cts vs Channel','Integrated Cts vs ScanVariable','All Channels vs ScanVariable (2D)'])

  if (Self.samptypeflag eq 1) then begin
    ; sxtal
    xindVars = (*Self.indepvars1ptr)
    yindVars = xindVars
    xname = 'Horizontal Axis Variable'
    yname = 'Vertical Axis Variable'
    xAxisVar = 0
    yAxisVar = 1
  endif else if (Self.samptypeflag eq 0) then begin
    ; powder
    xindVars = (*Self.indepvars2ptr)
    yindVars = xindVars
    xname = 'Scan Variable'
    yname = 'Vertical axis variable'
    xAxisVar = 0
    yAxisVar = 0
  endif else begin
    ; raw
    xindVars = (*Self.rawmodesptr)
    yindVars = (*Self.indepvars3ptr)
    xname = 'Plot Quantity'
    yname = 'Scan Variable'
    xAxisVar = 0
    yAxisVar = 0
  endelse

  Self.xaxisvar = xAxisVar
  Self->Registerproperty, 'xAxisVar', enumlist=xindVars, name=xname, description='X-Axis Variable'
  Self.yaxisvar = yAxisVar
  Self->Registerproperty, 'yAxisVar', enumlist=xindVars, name=yname, description='Y-Axis Variable' $
    ,hide=hideifpowder
;  Self->Registerproperty, 'PSDDisplayAs', enumlist=['Channel Nos','Delta A4'], name='Display PSD using', description='PSD Channel Label' $
;    ,hide=hideifpowder
  


  Self.sharedsettingsflag = 1
  Self->Registerproperty, 'sharedSettingsFlag', enumlist=['No','Yes'], name='Datasets share same settings?'
  Self.settingindex = 0
  Self->Registerproperty, 'settingIndex', enumlist=[''], name='Dataset name'

  Self.dpntindex=1
  Self->Registerproperty, 'dpntIndex', /integer, name='Data Point to view';, valid_range[1,1,1]
  Self.minchan=1
  Self->Registerproperty, 'minChan', /integer, name='Min Channel (to sum)';, valid_range[1,48,1]
  Self.maxchan=48
  Self->Registerproperty, 'maxChan', /integer, name='Max Channel (to sum)';, valid_range[1,48,1]
  Self.mindpnt=1
  Self->Registerproperty, 'minDPnt', /integer, name='Min Data Point (to sum)';, valid_range[1,1,1]
  Self.maxdpnt=1
  Self->Registerproperty, 'maxDPnt', /integer, name='Max Data Point (to sum)';, valid_range[1,1,1]

  Self.minbinwidth=0.01
  Self->Registerproperty, 'minBinWidth', /float, name='Min Bin Width (scan var)' $
    ,description='Min Bin Width (scan var)'
  Self.constbinflag = 0
  Self->Registerproperty, 'constBinFlag', enumlist=['No','Yes'], name='Enforce constant bin widths?'
  combVarList = ['TEMP','E','MAGFIELD','2Theta','A1','A2','A3','A4','A5','A6','H','K','L']
  Self.combvarlist = Ptr_new(combVarList)
  Self.combvarval = 0
  Self->Registerproperty, 'combVarVal', enumlist=combVarList, name='Combining Datasets? y-axis Var:'
  Self.usetempaverageflag = 0
  Self->Registerproperty, 'useTempAverageFlag', enumlist=['No','Yes'], name='Use the average scan temp?'


  Self.qunits = 1
  Self->Registerproperty, 'qUnits', enumlist=['Inverse Angstroms','Relative lattice units'], name='Units of QX, QY' $
    ,description='Units to use for QX, QY',hide=hideifpowder

  Self.logflag = 0
  Self->Registerproperty, 'logFlag', enumlist=['Linear','Logbase 10','Logbase e','Logbase 2'], name='Intensity Scale' $
    ,description='Intensity Scale' ,hide=hideifpowder

  Self.defaultintensityflag = 1
  Self->Registerproperty, 'defaultIntensityFlag', enumlist=['No','Yes'], name='Use Default Intensity Range?' $
    ,description='Use Default Intensity Range?' ,hide=hideifpowder
  Self.maxintensity = 0.0
  Self->Registerproperty, 'maxIntensity', /float, name='Max Intensity Value' $
    ,description='Max Intensity Value' ,hide=hideifpowder
  Self.minintensity = 0.0
  Self->Registerproperty, 'minIntensity', /float, name='Min Intensity Value' $
    ,description='Min Intensity Value' ,hide=hideifpowder

  Self.latparamflag = 0
  Self->Registerproperty, 'latParamFlag', enumlist=['From Data','User Specified'], name='Latt Param source' $
    ,description='Lattice Parameter flag' ,hide=hideifpowder
  Self.latticeparameters = ''
  Self->Registerproperty, 'latticeParameters', /string,name='Latt Param: a b c al be ga' $
    ,description='Lattice Parameters' $
    ,sensitive=Self.latparamflag,hide=hideifpowder

  Self.phioffset = 0.0
  Self->Registerproperty, 'phiOffset', /float, name='A3 Correction (Phi Offset)' $
    ,description='A3 Correction (Phi Offset)' ,hide=hideifpowder

  Self.maskflag = 0
  Self->Registerproperty, 'maskFlag', enumlist=['No','Yes'], name='Remove Masked Channels?' $
    ,description='Remove Masked Channels'
  Self.maskeddets = ''
  Self->Registerproperty, 'maskedDets', userdef='',name='Channels to Mask' $
    ,description='Channels to be masked' ,sensitive=Self.maskflag

  ;Self.mergeChannelsFlag = 0
  ;Self->RegisterProperty, 'mergeChannelsFlag', enumlist=['No','Yes'], name='Merge PSD Channels?' $
  ;                      ,description='Should PSD channels be combined?' $
  ;                      ,hide=~hideIfPowder

  Self.normalizeto = 0
  Self->Registerproperty, 'normalizeTo', enumlist=['Monitor','Counting Time','No Normalization'], name='Normalize To' $
    ,description='Normalize Counts To'

  Self.monscalevalue = 1.0
  Self->Registerproperty, 'monScaleValue', /float, name='Overall Scale Factor' $
    ,description='Overall Scale Factor'

  Self.bkgdflag = 0
  Self->Registerproperty, 'bkgdFlag', enumlist=['No','Yes'], name='Subtract Bkgd data?' $
    ,description='Should bkgd data be subtracted' $
    ,sensitive=(Self.nbkgd gt 0)? 1 : 0
  Self.bkgdsubvars = ['Not Applicable','A1','A2','A3','A4','A5','A6','H','K','L','HKL','E','Ei','Ef','Temp','Magfield']
  Self->Registerproperty, 'bkgdSubVarFlag', enumlist=Self.bkgdsubvars, name='Bkgd Sub: Matching Var' $
    ,description='Matching variable for paring signal and bkgd datasets' $
    ,sensitive=(Self.bkgdflag gt 0)? 1 : 0
  Self.bkgdsubvartol = 0.005
  Self->Registerproperty, 'bkgdSubVarTol', /float, name='Bkgd Sub: Matching Var Tol' $
    ,description='Tolerance threshold for bkgd subtraction ketword variable' $
    ,sensitive=(Self.bkgdflag gt 0)? 1 : 0

  Self.fastflag = 0
  Self->Registerproperty, 'fastFlag', enumlist=['No','Yes'], name='Fast Bkgd Corr.?' $
    ,description='Should fast bkgd correction be applied?'
  Self.fastvalue = 0.0
  Self->Registerproperty, 'fastValue', /float, name='Fast Bkgd (cts/min)' $
    ,description='Fast Background Level', sensitive=Self.fastflag

  Self.moncorflag = 0
  Self->Registerproperty, 'monCorFlag', enumlist=['No','Yes'], name='Monitor Correction?' $
    ,description='Should monitor correction be applied?' $
    ,sensitive=Self.fastflag

  Self.rescorflag = 0
  Self->Registerproperty, 'resCorFlag', enumlist=['No','Yes'], name='Resolution Correction?' $
    ,description='Should resolution volume correction be applied?' $
    ,sensitive=0

  Self.detailedbalanceflag = 0
  Self->Registerproperty, 'detailedBalanceFlag', enumlist=['No','Yes'], name='Det. balance Correction?' $
    ,description='Should detailed balance correction be applied?' $
    ,sensitive=Self.fastflag,hide=1

  Self.cleardisplayflag = 1
  Self->Registerproperty, 'clearDisplayFlag', enumlist=['No','Yes'], name='Clear Display before Plotting?' $
    ,description='Should multiple Mslice be allowed?'

  Self.multiplemslicewinflag = 0
  Self->Registerproperty, 'multipleMsliceWinFlag', enumlist=['No','Yes'], name='Allow multiple Mslice?' $
    ,description='Should multiple Mslice be allowed?'

  Self->Setpropertyattribute, 'NAME', /hide
  Self->Setpropertyattribute, 'DESCRIPTION', /hide
  Self.projname = 'Untitled'

  ;; Finally, set the prompt property to 1 meaning display a warning dialog
  ;; before deleting this tool
  Self.prompt = 1
  Self.promptdesc = 'BT7PSD Reduction Window'
  Self.prompttitle = 'Delete Reduction Window?'

  IDLge90 = (float(!version.release) ge 9.0)? 1 : 0
  Self.ftpObject =  (IDLge90)? DAVEHttpRequest() :  DAVEftpURL()
  Self.ftpobject->Setproperty, currentDir = '/pub/ncnrdata/bt7/'

  Self.historyptr = Ptr_new('')

  sxtalOnlyProps = ['latticeParameters','latParamFlag','qUnits','yAxisVar']
  sxtalOnlyProps = [sxtalOnlyProps,'defaultIntensityFlag','maxIntensity','minIntensity','phiOffset']
  Self.sxtalonlypropsptr = Ptr_new(sxtalOnlyProps)
  Self.powderonlypropsptr = Ptr_new(['minBinWidth','useTempAverageFlag','constBinFlag','combVarVal'])
  Self.sxtalpowderpropsptr = Ptr_new(['fastFlag','fastValue','monCorFlag','resCorFlag','multipleMsliceWinFlag','logFlag']) ;'maskFlag','maskedDets',
  Self.rawonlypropsptr = Ptr_new(['minChan','maxChan','minDPnt','maxDPnt','dpntIndex','sharedSettingsFlag','settingIndex']);,'PSDDisplayAs'])

  ; PSD detector calibration init
  Self.chdela4 = 0.0  ; all channel a4 delta to 0
  Self.chdelef = 0.0  ; all channel Ef delta to 0
  Self.cheff = 1.0    ; all channel efficiency to 1.0

  Self.ekfac = 2.072194

  Return, 1

end


;-------------------------------------------------------------------------
; Bt7psdTool::SaveVisProps
;+
; Purpose:
;    Retrieve the curent vis properties and save them
;
; Parameters:
;    oVis     - The visualization whose properties are to be saved
;
;-
pro Bt7psdtool::SaveVisProps, oVis
  compile_opt idl2

  if (~Obj_valid(oVis)) then Return
  if (~Obj_isa(oVis,'IDLitVisualization')) then Return

  oUI = Self->Getui()
  oUI->Getproperty, group_leader=wTLB

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      ;;print, 'Error handled!'
      eTitle = 'Bt7psdTool::SaveVisProps: Error encountered'
      eMsg = 'An error or unusual condition was encountered!'
      eMsg = [eMsg,'Please, report the following to the DAVE team:']
      eMsg = [eMsg,!error_state.msg]
      void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
      Catch, /cancel
      Return
    endif
  endif

  oVis->Getproperty, description=plotDesc
  case Strupcase(plotDesc) of
    'SAMPPLOT': prefix = 's_'
    'BKGDPLOT': prefix = 'b_'
    ;   'FASTPLOT': prefix = 'f_'
    ;   'SAMPBKGDPLOT': prefix = 'sb_'
    ;   'FASTFITPLOT': prefix = 'ff_'
    else: Return
  endcase

  switch Strupcase(plotDesc) of
    'SAMPPLOT':
    'BKGDPLOT':
    'FASTPLOT': begin
      ;; store the vis props
      vTags = ['use_default_color','color','errorbar_color','sym_color','errorbar_capsize' $
        ,'sym_increment','sym_index','sym_size','sym_thick','y_errorbars','antialias' $
        ,'linestyle','nsum','thick','sym_filled','sym_fill_color','transparency']
      ;      vTags = ['errorbar_capsize','transparency','antialias','color','use_default_color' $
      ;              ,'sym_increment','sym_index','sym_size','sym_color','sym_thick','y_errorbars' $
      ;              ,'linestyle','nsum','thick','sym_filled','sym_fill_color']
      tTags = prefix + vTags

      nTags = N_elements(vTags)
      etc = {dummy:''}
      for i=0, nTags-1 do begin
        status = oVis->Getpropertybyidentifier(vTags[i], value)
        if (status) then etc = Create_struct(etc,tTags[i],value)
      endfor
      Self->Setproperty, _EXTRA=etc

      ;; store the axes props
      vTags = ['font_name','font_size','text_color']
      tTags = prefix + vTags
      nTags = N_elements(vTags)
      oDataSpace = oVis->Getdataspace()
      oAxes = oDataSpace->Getaxes(count=naxes)
      etc = {dummy:''}
      for i=0, nTags-1 do begin
        status = oAxes[0]->Getpropertybyidentifier(vTags[i], value)
        if (status) then etc = Create_struct(etc,tTags[i],value)
      endfor
      Self->Setproperty, _EXTRA=etc

      break
    end

    ;   'SAMPBKGDPLOT':
    ;   'FASTFITPLOT': begin
    ;      ;; Set the vis props
    ;      vTags = ['transparency','antialias','color','use_default_color','sym_index' $
    ;              ,'linestyle','thick']
    ;      tTags = prefix + vTags
    ;
    ;      nTags = n_elements(vTags)
    ;      etc = {dummy:''}
    ;      for i=0, nTags-1 do begin
    ;         status = oVis->GetPropertyByIdentifier(vTags[i], value)
    ;         if (status) then etc = create_struct(etc,tTags[i],value)
    ;      endfor
    ;      Self->SetProperty, _EXTRA=etc
    ;
    ;      break
    ;   end

    else:
  endswitch

end




;-------------------------------------------------------------------------
; Bt7psdTool::customizeVis
;+
; Purpose:
;    Customize a newly created visualization using attributes obtained from the tool
;
; Parameters:
;    oVis     - The visualization to be customized
;
;    plotname - a string name to be used to identify the visualization
;-
pro Bt7psdtool::CustomizeVis, oVis, plotName, plotDesc
  compile_opt idl2

  if (~Obj_valid(oVis)) then Return
  if (~Obj_isa(oVis,'IDLitVisualization')) then Return

  oUI = Self->Getui()
  oUI->Getproperty, group_leader=wTLB

  ; Basic error Handler
  if (N_elements(!debug) && (!debug eq 0)) then begin
    Catch, catchError
    if (catchError ne 0) then begin
      ;;print, 'Error handled!'
      eTitle = 'wd_Bt7psdTool_customizeVis: Error encountered'
      eMsg = 'An error or unusual condition was encountered!'
      eMsg = [eMsg,'Please, report the following to the DAVE team:']
      eMsg = [eMsg,!error_state.msg]
      void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
      Catch, /cancel
      Return
    endif
  endif

  case Strupcase(plotDesc) of
    'SAMPPLOT': prefix = 's_'
    'BKGDPLOT': prefix = 'b_'
    ;   'FASTPLOT': prefix = 'f_'
    ;   'SAMPBKGDPLOT': prefix = 'sb_'
    ;   'FASTFITPLOT': prefix = 'ff_'
    else: Return
  endcase

  switch Strupcase(plotDesc) of
    'SAMPPLOT':
    'BKGDPLOT':
    'FASTPLOT': begin
      ;; Set the vis props
      vTags = ['use_default_color','color','errorbar_color','sym_color','errorbar_capsize' $
        ,'sym_increment','sym_index','sym_size','sym_thick','y_errorbars','antialias' $
        ,'linestyle','nsum','thick','sym_filled','sym_fill_color','transparency']
      tTags = prefix + vTags

      nTags = N_elements(vTags)
      etc = {dummy:''}
      for i=0, nTags-1 do begin
        status = Self->Getpropertybyidentifier(tTags[i], value)
        if (status) then etc = Create_struct(etc,vTags[i],value)
      endfor

      if (Float((strtok(!version.release,/extract))[0]) lt 8.0) then begin
        ; workaround for bug in IDL 7.1 or lower; use_default_color is not honoured for errorbar_color
        if (etc.use_default_color eq 1) then etc.errorbar_color = etc.color
      endif

      oVis->Setproperty, name=Strupcase(plotName)
      oVis->Setproperty, name=Strupcase(plotName), description=plotDesc, _EXTRA=etc
      oVis->Setpropertyattribute, 'NSUM', sensitive=0   ; disable point averaging/smoothing b/c errors are not taken into account

      ;; Set the axes props
      vTags = ['font_name','font_size','text_color']
      tTags = prefix + vTags
      nTags = N_elements(vTags)
      oDataSpace = oVis->Getdataspace()
      oAxes = oDataSpace->Getaxes(count=naxes)
      etc = {dummy:''}
      for i=0, nTags-1 do begin
        status = Self->Getpropertybyidentifier(tTags[i], value)
        if (status) then etc = Create_struct(etc,vTags[i],value)
      endfor
      for i=0,naxes-1 do oAxes[i]->Setproperty, _EXTRA=etc

      break
    end

    ;   'SAMPBKGDPLOT':
    ;   'FASTFITPLOT': begin
    ;      ;; Set the vis props
    ;      vTags = ['transparency','antialias','color','use_default_color','sym_index' $
    ;              ,'linestyle','thick']
    ;      tTags = prefix + vTags
    ;
    ;      nTags = n_elements(vTags)
    ;      etc = {dummy:''}
    ;      for i=0, nTags-1 do begin
    ;         status = Self->GetPropertyByIdentifier(tTags[i], value)
    ;         if (status) then etc = create_struct(etc,vTags[i],value)
    ;      endfor
    ;      oVis->SetProperty, name=strupcase(plotname), _EXTRA=etc
    ;      oVis->SetPropertyAttribute, 'NSUM', sensitive=0   ; disable point averaging/smoothing b/c errors are not taken into account
    ;
    ;      break
    ;   end

    else:
  endswitch



end



;---------------------------------------------------------------------------
; Bt7psdTool::InitPreferences
;
; Purpose:
;   This method
;
pro Bt7psdtool::InitPreferences
  compile_opt idl2

  ; Init working and data directory from the DAVETool values
  ;daveTool = Self.daveTool
  ;if (obj_valid(daveTool) and obj_isa(daveTool,'DAVETool')) then begin
  ;   daveTool->GetProperty, data_directory=datDir, working_directory=workDir
  ;   Self->SetProperty, data_directory=datDir, working_directory=workDir
  ;endif


  ; Retrieve user settings on disk and initialise current session
  status = Bt7psdreducpreferences(preferences)
  if (status) then Self->Setproperty, preferences=preferences

  Self->Getproperty, maskFlag=mF, fastFlag=fF, xAxisVar=xAxisVar $
    , binWidths=binWidths, defaultIntensityFlag=defIntFlag, sampTypeFlag=sampTypeFlag
  Self->Setproperty, minBinWidth = binwidths[xAxisVar]
  noHide = (defIntFlag eq 0) && (sampTypeFlag eq 1)  ; don't hide if not using default intensity and single crystal sample
  Self->Setpropertyattribute, 'maxIntensity', hide=~noHide
  Self->Setpropertyattribute, 'minIntensity', hide=~noHide
  Self->Setpropertyattribute, 'MASKEDDETS', sensitive=mF
  Self->Setpropertyattribute, 'FASTVALUE', sensitive=fF
  Self->Setpropertyattribute, 'MONCORFLAG', sensitive=fF
  ;Self->SetPropertyAttribute, 'RESCORFLAG', sensitive=mF
  ;Self->SetPropertyAttribute, 'DETAILEDBALANCEFLAG', sensitive=mF

  ; For safety, always initialise phiOffset to 0.0 b/c a user may not be fully aware
  ; about this setting. A value of 0.0 is harmless
  Self->Setproperty, phiOffset = 0.0

  Self->Refreshpropertysheet

  ; Update title to reflect session name
  ; setting tool_filename generates a callback on the registered UI callback
  Self->Setproperty, tool_filename=Self.projname

  ; Retrieve the graphics window
  ; and set auto-resize and zoom-on-resize to 1 so the graphics window behaves properly when its size is changed
  oWin = Self->Getcurrentwindow()
  oWin->Setproperty, auto_resize=1, zoom_on_resize=1

  ;if (float((strtok(!version.release,/extract))[0]) ge 8.0) then begin
  ;   ; For IDL 8.0 and newer, a title text is added to the graphics by default
  ;   ; Hide it!
  ;
  ;   idText = iGetID('*title*',tool=Self)
  ;   oText = Self->GetByIdentifier(idText[0])
  ;   if (isa(oText,'IDLitvisText')) then oText->setProperty, hide=1
  ;   Self->RefreshCurrentWindow
  ;endif

end


;---------------------------------------------------------------------------
; Bt7psdTool::resetPreferences
;
; Purpose:
;   This method
;
function Bt7psdtool::ResetPreferences
  compile_opt idl2


  ; Retrieve user settings on disk and initialise current session
  status = Bt7psdreducpreferences(preferences,/reset)
  if (status) then Self->Setproperty, preferences=preferences

  Self->Getproperty, maskFlag=mF, fastFlag=fF

  Self->Setpropertyattribute, 'MASKEDDETS', sensitive=mF
  Self->Setpropertyattribute, 'FASTVALUE', sensitive=fF
  Self->Setpropertyattribute, 'MONCORFLAG', sensitive=fF
  ;Self->SetPropertyAttribute, 'RESCORFLAG', sensitive=mF
  ;Self->SetPropertyAttribute, 'DETAILEDBALANCEFLAG', sensitive=mF

  Self->Refreshpropertysheet

end


;---------------------------------------------------------------------------
; Bt7psdTool::EditUserDefProperty
;
; Purpose:
;   This method
;
function Bt7psdtool::EditUserDefProperty, oTool, PropID
  compile_opt idl2

  ;; The API requires the oTool arg. It is redundant here since it is Self!

  oUI = Self->Getui()
  oUI->Getproperty, group_leader=wTLB
  wChild = Widget_info(wTLB, /child)
  Widget_control, wChild, get_uvalue=sPtr

  case PropID of
    'CALIBPARAMSBASEFILENAME': begin
      status = Self->Loadcalibparams()
    end

    ;  'CHDELEFBASEFILENAME': begin
    ;    status = Self->loadChEf()
    ;    break
    ;  end
    ;
    ;  'CHEFFBASEFILENAME': begin
    ;    status = Self->loadChEfficiency()
    ;    break
    ;  end

    'MASKEDDETS': begin
      ; The currently selected dataset is registered as (*sPtr).itemID
      noSelection = Strcmp(Strtrim((*sPtr).itemid),'')
      if (noselection) then begin
        ; retrieve the first loaded dataset, if any
        Self->Getproperty, sampContRef=oCont
        oItem = oCont->Get(position=0,count=nItem)
      endif else begin
        oItem = Self->Getbyidentifier((*sPtr).itemid)
        nItem = 1
      endelse
      if (nItem ne 1) then Return, 0

      Wd_bt7psdmaskchannels, oUI, oItem, Self.calibparamsisset, Self.cheff
    end

    else:
  endcase

  Self->Refreshpropertysheet

  Return, 1
end


;---------------------------------------------------------------------------
; Bt7psdTool__Define
;
; Purpose:
;   This method defines the Bt7psdTool class.
;
pro Bt7psdtool__define
  compile_opt idl2

  bkgdSubVars = ['Not Applicable','A1','A2','A3','A4','A5','A6','H','K','L','HKL','E','Ei','Ef','Temp','Magfield']
  void = { Bt7psdtool,                 $
    inherits Idlittool        $   ; Provides iTool interface
    ,datadir:''               $   ; data directory (Note: working_directory is defined by the base class
    ,nsamp:0                  $   ; nos of valid Sample datasets
    ,nbkgd:0                  $   ; nos of valid bkgd datasets
    ;         ,nFast:0                  $   ; nof of valid fast bkgd datasets
    ,sampcontref:Obj_new()    $   ; container for Sample datasets
    ,bkgdcontref:Obj_new()    $   ; container for bkgd datasets
    ;         ,fastContRef:obj_new()    $   ; container for fast bkgd datasets
    ,sampselected:Obj_new()   $   ; most recent selection from samp datasets
    ,bkgdselected:Obj_new()   $   ; most recent selection from bkgd datasets
    ;         ,fastSelected:obj_new()   $   ; most recent selection from fast datasets
    ,oplotbkgdflag:0          $
    ,davetool:Obj_new()       $   ; DAVETool object
    ,projname:''              $   ; name of current project
    ,nametag:''               $   ; Tag to be used for identification purposes
    ,prompt:1                 $
    ,prompttitle:''           $
    ,promptdesc:''            $
    ;         ,mev2wnos:8.065541        $   ; meV to wavenumber conversion factor
    ;         ,nActiveDetectors:50      $   ; nos of active detectors
    ;         ,energyUnitFlag:0         $   ; energy unit flag 0=meV, 1=cm-1
    ,sumsampflag:0            $   ; sum multiple sample files? 0=no, 1=yes
    ,sumbkgdflag:0            $   ; sum multiple bkgd files? 0=no, 1=yes
    ,maskflag:0               $
    ,maskeddets:''            $   ; masked detectors (stored as a string)
    ;         ,fastFuncs:strarr(4)      $   ; available functions to fit fast bkgd
    ;         ,fastFunc:0               $   ; function to be used to fit fast bkgd 0=arcsin, 1=linear, 2=quadratic, 3=cubic
    ,latparamflag:0           $   ; Use lattice parameter from: 0:raw data file 1:user specified
    ,qunits:0                 $   ; Units for QX, QY variables: 0->1/A, 1->r.l.u
    ,xaxisvar:0               $   ; Variable to plotted as the x-axis
    ,yaxisvar:0               $   ; variable to be plotted as the y-axis
    ,combvarval:0                $   ; Variable to be used as 2nd axis when combining data
    ,combvarlist:Ptr_new()    $   ; list of valid combVarVal values
    ,indepvars1ptr:Ptr_new()  $   ; list of valid sxtal independent variables ('QX','QY','E','|Q|','TEMP','MAGFIELD')
    ,indepvars2ptr:Ptr_new()  $   ; list of valid powder x-axis independent variables ('2THETA','Q','DSPACE','TEMP','MAGFIELD','DATAPOINT')
    ,indepvars3ptr:Ptr_new()  $   ; list of valid powder y-axis independent variables ('2THETA','Q','DSPACE')
    ,exportindex1ptr:Ptr_new() $   ; index specifying items in indepVars1Ptr to be exported
    ,exportindex2ptr:Ptr_new() $   ; index specifying items in indepVars2Ptr to be exported
    ,exportindex3ptr:Ptr_new() $   ; index specifying items in indepVars3Ptr to be exported
    ,rawmodesptr:Ptr_new()    $   ; list of possible viewing modes when Samp type is set to 'Raw Data'
    ,latticeparameters:''     $   ; lattice parameters
    ,monscalevalue:1.0        $   ; user specified mon scale factor
    ,detailedbalanceflag:0    $   ; apply detailed balance correction 1=yes, 0=no
    ,bkgdflag:0               $   ; subtract bkgd data  1=yes, 0=no
    ,bkgdsubvarflag:0        $   ; a key variable used to determine if a signal and bkgd dataset pair match for bkgd subtraction
    ,bkgdsubvars:bkgdSubVars   $   ; unum lists of vars that can be used for pairing signal ad bkgd datasets - used by bkgdSubVarsFlag
    ,bkgdsubvartol:0.0       $   ; a tolerance threshold used to determine if two bkgdSubVar values match
    ,fastflag:0               $   ; apply fast bkgd correction? 1=yes, 0=no
    ,fastvalue:0.0            $   ; fast bkgd level in cnts/min
    ,rescorflag:0             $   ; apply resolution volume correction ? 1=yes, 0=no
    ,moncorflag:0             $   ; apply monitor correction (due to energy dependent change to incident flux)? 1=yes, 0=no
    ,normalizeto:0            $   ; normalize counts to: 0: Monitor, 1:Counting Time, 2: Nothing
    ,samptypeflag:0           $   ; sample type: 1:single crystal, 0:powder
    ,samptyps:Ptr_new()      $   ; vector of sample types: [single crystal,powder,]
    ,prefsptr:Ptr_new()       $   ; points to preference structure
    ,historyptr:Ptr_new()     $
    ,modifiedflag:0B          $   ; determines modification state of tool - unsufficient control over _bDirty property!
    ,dataversion:0            $   ; current version number for dataset structure
    ,ftpobject:Obj_new()      $   ; DAVEftpURL() object used to access data on ftp://ftp.ncnr.nist.gov/pub/ncnrdata/
    ,calibparamsfilename:''   $
    ,calibparamsbasefilename:'' $
    ,PSDDisplayAs:0           $
    ,calibparamsisset:0       $
    ,chdela4:Fltarr(48)       $   ; Channel A4 deltas
    ,chdelef:Fltarr(48)       $   ; Channel Ef deltas (or maybe just Channel Ef)
    ,cheff:Fltarr(48)         $   ; Channel efficiencies
    ,effnormflag:0            $
    ,minbinwidth:0.01         $   ; user specified current bin width
    ,binwidths:Fltarr(7)      $   ; initial bin widths for various powder scan variables
    ,defaultintensityflag:0   $   ; use default intensity range 1 = yes, 0 = no
    ,maxintensity:0.0         $
    ,minintensity:0.0         $
    ,phioffset:0.0            $   ; A3 Correction or Phi Offset
    ,logflag:0                $   ; use linear (0) or log (1) intensity scale
    ;         ,lolim:0                  $   ; low limit of range to sum (raw mode)
    ;         ,hilim:0                  $   ; high limit of range to sum (raw mode)
    ,constbinflag:0           $   ; Enforce constant bin width for powder data when rebinning
    ,usetempaverageflag:0     $   ; when set, take the everage temperature of the scan as the temperature at each point in the scan
    ,minchan:0                $
    ,maxchan:0                $
    ,mindpnt:0                $
    ,maxdpnt:0                $
    ,dpntindex:0              $
    ,pmindpnt:Ptr_new()       $
    ,pmaxdpnt:Ptr_new()       $
    ,pdpntindex:Ptr_new()     $
    ,sharedsettingsflag:0     $
    ,settingindex:0           $
    ;         ,rawPlotType:0            $
    ;         ,chDelA4isSet:0           $
    ;         ,chDelA4baseFilename:''   $
    ;         ,chDelA4fullFilename:''   $
    ;         ,chDelEfisSet:0           $
    ;         ,chDelEfbaseFilename:''   $
    ;         ,chDelEffullFilename:''   $
    ;         ,chEffisSet:0             $
    ;         ,chEffbaseFilename:''     $
    ;         ,chEfffullFilename:''     $
    ,ekfac:2.072194           $   ; Energy = ekFac * k^2
    ,objmslice:Obj_new()      $   ; place holder for Mslice object
    ,multiplemslicewinflag:0  $   ; should multiple mslice windows be created?
    ,mergechannelsflag:0      $   ; (powder) whether (1) or not (0) to combine PSD channels
    ,sxtalonlypropsptr:Ptr_new() $   ;
    ,powderonlypropsptr:Ptr_new() $  ;
    ,sxtalpowderpropsptr:Ptr_new() $
    ,rawonlypropsptr:Ptr_new()    $
    ,cleardisplayflag:0       $   ; should the graphics display be cleared between plots
    ,s_errorbar_capsize:    0.1 $
    ,s_transparency:        50 $
    ,s_antialias:           3 $
    ,s_color:               [0,0,255] $
    ,s_errorbar_color:      [0,0,255] $
    ,s_use_default_color:   1   $
    ,s_sym_increment:       1   $
    ,s_sym_index:           4   $
    ,s_sym_size:            1.0   $          ;
    ,s_sym_color:           [0,0,255] $   ;
    ,s_sym_thick:           1.0 $            ;
    ,s_y_errorbars:         1 $              ; show y errors
    ,s_linestyle:           0 $              ;
    ,s_nsum:                1 $              ; no point everaging
    ,s_thick:               2.0 $            ; line thickness
    ,s_sym_filled:          1   $            ; use filled symbols
    ,s_sym_fill_color:      [0,0,255] $   ; symbol fill color
    ,s_font_name:           'Helvetica'  $   ;
    ,s_font_size:           13 $             ;
    ,s_text_color:          [0,0,0]  $    ;
    ;
    ,b_errorbar_capsize:    0.1 $
    ,b_transparency:        50 $
    ,b_antialias:           3 $
    ,b_color:               [0,255,255] $
    ,b_errorbar_color:      [0,255,255] $
    ,b_use_default_color:   1   $
    ,b_sym_increment:       1   $
    ,b_sym_index:           4   $
    ,b_sym_size:            1.0   $          ;
    ,b_sym_color:           [0,255,255] $   ;
    ,b_sym_thick:           1.0 $            ;
    ,b_y_errorbars:         1 $              ; show y errors
    ,b_linestyle:           6 $              ; no line
    ,b_nsum:                1 $              ; no point everaging
    ,b_thick:               1.0 $            ; line thickness
    ,b_sym_filled:          1   $            ; use filled symbols
    ,b_sym_fill_color:      [0,255,255] $   ; symbol fill color
    ,b_font_name:           'Helvetica'  $   ;
    ,b_font_size:           13 $             ;
    ,b_text_color:          [0,0,0]  $    ;
    ;
    ;         ,f_errorbar_capsize:    0.1 $
    ;         ,f_transparency:        50 $
    ;         ,f_antialias:           3 $
    ;         ,f_color:               [0,0,255] $
    ;         ,f_errorbar_color:      [0,0,255] $
    ;         ,f_use_default_color:   1   $
    ;         ,f_sym_increment:       1   $
    ;         ,f_sym_index:           4   $
    ;         ,f_sym_size:            1.0   $          ;
    ;         ,f_sym_color:           [0,0,255] $   ;
    ;         ,f_sym_thick:           1.0 $            ;
    ;         ,f_y_errorbars:         1 $              ; show y errors
    ;         ,f_linestyle:           6 $              ; no line
    ;         ,f_nsum:                1 $              ; no point everaging
    ;         ,f_thick:               1.0 $            ; line thickness
    ;         ,f_sym_filled:          1   $            ; use filled symbols
    ;         ,f_sym_fill_color:      [0,0,255] $   ; symbol fill color
    ;         ,f_font_name:           'Helvetica'  $   ;
    ;         ,f_font_size:           13 $             ;
    ;         ,f_text_color:          [0,0,0]  $    ;
    ;
    ;         ,sb_transparency:        60 $
    ;         ,sb_antialias:           3 $
    ;         ,sb_color:               [0,128,0] $
    ;         ,sb_use_default_color:   1   $
    ;         ,sb_sym_index:           0   $            ; no symbol
    ;         ,sb_linestyle:           0 $              ;
    ;         ,sb_thick:               5.0 $            ; line thickness
    ;
    ;         ,ff_transparency:        60 $
    ;         ,ff_antialias:           3 $
    ;         ,ff_color:               [0,128,0] $
    ;         ,ff_use_default_color:   1   $
    ;         ,ff_sym_index:           0   $            ; no symbol
    ;         ,ff_linestyle:           0 $              ;
    ;         ,ff_thick:               5.0 $            ; line thickness


  }
end
