; $Id$
;###############################################################################
;+
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for HFBSTool.
;
; CATEGORY:
;   HFBS Data Reduction

; PARAMETERS
;
; KEYWORDS:
;   identifier (out)   - The string identifier of the HFBSTool object
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; February 2012
;-
;###############################################################################





;===============================================================================
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for the HFBSTool.
;
; CATEGORY:
;   BT7 PSD Reduction

; PARAMETERS
;
; KEYWORDS:
;   identifier (out)   - The string identifier of HFBSTool object
;
pro hfbsfws,  identifier=identifier, group_leader=gl, workDir=workDir, dataDir=dataDir, DAVETool=oDAVETool, _EXTRA=etc
compile_opt idl2

;Okay, launch the Main Tool
title = "HFBS Fixed Window Scan Analysis"
identifier = IDLITSYS_CREATETOOL("HFBSFWSMain", name="Preferences" $
                                 ,title=title $ ;  ,/debug
                                 ,dimensions=[750,550] $
                                 ,USER_INTERFACE="HFBS FWS Main Interface" $
                                )

oSystem = oDaveTool->GetSystem()
oHFBSTool = oSystem->GetByIdentifier(identifier)

; Make widget hierarchy with this tool a child of the DAVETool
oHFBSUI = oHFBSTool->GetUI()
oHFBSUI->GetProperty, group_leader=wHFBSTLB
widget_control, wHFBSTLB, group_leader=gl

; Set system preferences
oHFBSTool->SetProperty, DAVETool=oDAVETool $
                      ,data_directory=dataDir $
                      ,working_directory=workDir $
                      ,name = 'Preferences'  ; b/c want the property sheet in main window to have this label
if (obj_valid(oHFBSTool)) then  oHFBSTool->InitPreferences

end
