; $Id$
;###############################################################################
;+
; CLASS_NAME:
;   DAVEopHelp
;
; PURPOSE:
;   This file implements an operation that can launch help information
;   about a selected item or subject initiated from a menu. It is
;   based on IDLitopHelpiTools
;
; CATEGORY:
;   DAVE Main Tool
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; Dec 2006
;-
;###############################################################################


;===============================================================================
; DAVEopHelp::init
; 
; PURPOSE:
;   Class initialization method
;
; PARAMETERS
;
; KEYWORDS:
;


;===============================================================================
; DAVEopHelp::GetProperty
; 
; PURPOSE:
;   Accessor method
;
; PARAMETERS:
;
; KEYWORDS:
;   helpTopic [out] - The keyword for the help information of interest.
;
; RETURN VALUE:
;
pro DAVEopHelp::GetProperty, helpTopic=helpTopic, _REF_EXTRA=etc
compile_opt idl2

if (arg_present(helpTopic)) then begin
    helpTopic =  self.helpTopic
endif

if(n_elements(etc) gt 0) then $
  self->IDLitOperation::GetProperty, _EXTRA=etc

end


;===============================================================================
; DAVEopHelp::SetProperty
; 
; PURPOSE:
;   Accessor method
;
; PARAMETERS:
;
; KEYWORDS:
;   helpTopic [in] - The keyword for the help information of interest.
;
; RETURN VALUE:
;
pro DAVEopHelp::SetProperty, helpTopic=helpTopic, _EXTRA=etc
compile_opt idl2

if (n_elements(helpTopic) gt 0) then begin
      self.helpTopic = helpTopic
endif

if(n_elements(etc) gt 0) then $
  self->IDLitOperation::SetProperty, _EXTRA=etc 

end



;===============================================================================
; DAVEopHelp::init
; 
; PURPOSE:
;   Class initialization method
;
; PARAMETERS
;
; KEYWORDS:
;
function DAVEopHelp::Init, _REF_EXTRA=_extra

compile_opt idl2

return, self->IDLitOperation::Init(_EXTRA=_extra)

end


;===============================================================================
; DAVEopHelp::doAction
; 
; PURPOSE:
;   Intantiate an independent application which has been previously
;   registered as a UI Service with the DAVE Main Tool.
;
; PARAMETER:
;   oTool   - The object ref of the tool from which this request originated
;
; KEYWORDS:
;
function DAVEopHelp::DoAction, oTool

compile_opt idl2

oHelp = oTool->GetService("DAVEHELP")
if (~OBJ_VALID(oHelp)) then $
  return, OBJ_NEW()

;; First, try retrieving helptopic from op
self->GetProperty, helptopic=helptopic

if (strtrim(helpTopic) eq '') then begin
    ;; If helptopic is undefined, determine the currently selected object
    ;; and try retrieving help from it

    ;; Retrieve the first selected item.
    oSelected = (oTool->GetSelectedItems(/ALL))[0]

    ;; If nothing selected, use our tool.
    if (~OBJ_VALID(oSelected)) then $
      oSelected = oTool

    ;; Retrieve the HELP property.
    oSelected->GetProperty, HELP=helpTopic
endif

;; If helptopic is still undefined, try using the classname.
if (strtrim(helpTopic) eq '') then $
  helpTopic = OBJ_CLASS(oTool)

oHelp->HelpTopic, oTool, helpTopic

return, obj_new()               ; no undo/redo
end


;===============================================================================
; DAVEopHelp::init
; 
; PURPOSE:
;   Class initialization method
;
; PARAMETERS
;
; KEYWORDS:
;
pro DAVEopHelp__define

compile_opt idl2

void = {DAVEopHelp, $
        inherits IDLitOperation $
        ,helpTopic:'' $
       }

end
