;$Id$
;
;###############################################################################
;
; NAME:
;  REFINE_SEL_RANGE
;
; PURPOSE:
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro refine_sel_range_event,event
compile_opt idl2,hidden
widget_control,event.top,get_uvalue = pstate
x_id = widget_info(event.top,find_by_uname = 'XINDICES')
y_id = widget_info(event.top,find_by_uname = 'YINDICES')
uname = widget_info(event.id,/uname)
case uname of
'ACCEPT':	$
	begin
		widget_control,x_id,get_value = xval & xval = xval[0]
		widget_control,y_id,get_value = yval & yval = yval[0]
		xindices = opan_selectgroups(xval)
		yindices = opan_selectgroups(yval)
		if min(xindices) lt min((*pstate).oxindex) then return
		if min(yindices) lt min((*pstate).oyindex) then return
		if max(xindices) gt max((*pstate).oxindex) then return
		if max(yindices) gt max((*pstate).oyindex) then return
		*(*(*pstate).ptr).xptr = xindices
		*(*(*pstate).ptr).yptr = yindices
	end
'DISMISS':	$
	begin
		widget_control,event.top,/destroy
	end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function refine_sel_range,	odata,orefine,	$
							group_leader = group_leader
compile_opt idl2,hidden
ret = orefine->get(xindex = xindex,yindex = yindex)
ret = odata->get(xvals = xvals,yvals = yvals)
nx = n_elements(xvals) & ny = n_elements(yvals)
xindex = indgen(nx) & yindex = indgen(ny)
miny = min(yindex) & minx = min(xindex) & maxx = max(xindex) & maxy = max(yindex)
init_x = strtrim(string(minx),2)+'-'+strtrim(string(maxx),2)
init_y = strtrim(string(miny),2)+'-'+strtrim(string(maxy),2)
this_title = 'Fitting Range Selection Dialog'
tlb = widget_base(group_leader = group_leader,/modal,title = this_title, $
	tlb_frame_attr = 9,/col)
row_base = lonarr(3)
row_base[0] = widget_base(tlb,/row)
void = cw_field(row_base[0],title = 'X-indices included in fit',value = init_x,	$
	/return_events,uname = 'XINDICES')
row_base[1] = widget_base(tlb,/row)
void = cw_field(row_base[1],title = 'Y-indices included in fit',value = init_y,	$
	/return_events,uname = 'YINDICES')
row_base[2] = widget_base(tlb,/row)
void = widget_button(row_base[2],value = 'ACCEPT',uname = 'ACCEPT')
void = widget_button(row_base[2],value = 'DISMISS',uname = 'DISMISS')

widget_control,tlb,/realize
ptr = ptr_new({xptr:ptr_new(xindex),yptr:ptr_new(yindex)})

state = {	orefine:orefine,	$
			odata:odata,		$
			oxindex:xindex,		$
			oyindex:yindex,		$
			ptr:ptr				}
pstate = ptr_new(state,/no_copy)

widget_control,tlb,set_uvalue = pstate
register_name = 'refine_sel_range'
xmanager,register_name,tlb,event_handler = 'refine_sel_range_event'

; Destroying the widget gets us to here. Extract the needed values and
; free up the heap memory.
info = *(*pstate).ptr
ptr_free,(*pstate).ptr
ptr_free,pstate
return,info
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;