; $Id$
;###############################################################################
;
; NAME:
;  REF_THREE_FOLD_TUNNELING
;
; PURPOSE:
;  Implementation of the 3-fold rotational tunneling model for use in fitting
;  data in RAINS.
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ref_three_fold_tunneling,xvals,parms,					$
                    	parmnames = parmnames,					$
                    	init_guess = init_guess,				$
                    	qty = qty,								$
                    	single_parmnames = single_parmnames,	$
                    	multi_parmnames = multi_parmnames,		$
                    	res_ptr = res_ptr,						$
                    	step = step,							$
                    	all_y = all_y,							$
                    	_Extra = extra
; all_y keyword is relevant for this model
if n_elements(all_y) eq 0 then all_y = 1
nx = extra.nx & ny = extra.ny
x = xvals[0:nx-1] & y = xvals[nx:nx+ny-1]
ux = 1+bytarr(nx) & uy = 1+bytarr(ny)
parmnames =	['Radius','Tunnel energy',$
			'Intensity:'+strtrim(string(indgen(ny)),2), $
			'Center:'+strtrim(string(indgen(ny)),2)]
single_parmnames = parmnames[0:1]
multi_parmnames = ['Intensity','Center']
if (n_params() eq 0) or (n_params() eq 1) then begin
	if arg_present(init_guess) then begin
		intensity = max(qty,dimension = 1,index)
		qty_size = size(qty)
		for i = 0,qty_size[2]-1 do begin
			qty_max = max(qty[*,i],index)
			if i eq 0 then index_array = index else $
				index_array = [index_array,index]
		endfor
		max_index = (moment(index_array))[0]
		npeaks = 3	; number of peaks (assumed known)
		for i = 0,qty_size[2]-1 do begin
			xpeaks = get_peak_pos(x,qty[*,i],npeaks)
			if i eq 0 then peak_array = max(xpeaks) else $
				peak_array = [peak_array,max(xpeaks)]
		endfor

		radius = 1.0 & et = (moment(peak_array))[0]
		center = x[index_array]
		init_guess = [radius,et,intensity,center]
	endif
	if arg_present(step) then begin
		dx = x[1]-x[0]
		step = [0D,dx,dblarr(ny),dx+dblarr(ny)]
	endif
	return,-1
endif

radius = (abs(parms[0]))#uy
et = (parms[1])
intensity = ux#(parms[2:2+ny-1])
;center = ux#(parms[2+ny:2+2*ny-1])
center = parms[2+ny:2+2*ny-1] 
eisf = ux#((5.0+4.0*sph_bessel(y*radius*sqrt(3.0),0))/9.0)
xhi = max(x,min = xlo)
dx = x[1]-x[0] & dy = y[1]-y[0]
nshift = fix(0.5*((abs(xhi)-abs(xlo)))/dx)
lineshape = eisf*ref_delta(xvals,center,*res_ptr,nx = nx,ny = ny)+$
		0.5*(1.0-eisf)*(ref_delta(xvals,center+et,*res_ptr,nx = nx,ny = ny)+$
		ref_delta(xvals,center-et,*res_ptr,nx = nx,ny = ny))

yout = intensity*lineshape
return,yout
end
