; $Id$
;###############################################################################
;
; NAME:
;  REF_CHUDLEY_ELLIOTT
;
; PURPOSE:
;  Implementation of the Chudley-Elliot diffusion model for use in fitting
;  data in RAINS.
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ref_chudley_elliott,xvals,parms,						$
                    	parmnames = parmnames,					$
                    	single_parmnames = single_parmnames,	$
                    	multi_parmnames = multi_parmnames,		$
                    	res_ptr = res_ptr,						$
                    	all_y = all_y,							$
                    	_Extra = extra
; all_y keyword is relevant for this model
if n_elements(all_y) eq 0 then all_y = 1
nx = extra.nx & ny = extra.ny
x = xvals[0:nx-1] & y = xvals[nx:nx+ny-1]
ux = 1+bytarr(nx) & uy = 1+bytarr(ny)
parmnames =	['Residence time','Jump distance','Center', $
			'Intensity:'+strtrim(string(indgen(ny)),2)]

single_parmnames = parmnames[0:2]
multi_parmnames = 'Intensity:'
if (n_params() eq 0) or (n_params() eq 1) then begin
  return,-1
endif

tau = parms[0]
l = parms[1]
gam = ux#((0.6528/tau)*(1.0-(sin(y*l))/(y*l)))
center = ux#(parms[2])#uy
intensity = ux#(parms[3:3+ny-1])


lorentzian = ((gam/!dpi))/((x#uy-center)^2+(gam)^2)
;lineshape = scat_convolve(x,y,lorentzian,*res_ptr)
lineshape = scat_convolute(x,y,lorentzian,*res_ptr) ; RTA
yout = intensity*lineshape
return,yout
end
